/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.metric.service;

import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.data.IOD;
import org.aoju.bus.image.galaxy.data.VR;
import org.aoju.bus.image.galaxy.data.ValidationResult;
import org.aoju.bus.image.metric.ImageException;

public enum Level {
    PATIENT{

        @Override
        protected IOD queryKeysIOD(Level rootLevel, boolean relational) {
            IOD iod = new IOD();
            iod.add(new IOD.DataElement(0x20000D, VR.UI, IOD.DataElementType.TYPE_0, -1, -1, 0));
            iod.add(new IOD.DataElement(0x20000E, VR.UI, IOD.DataElementType.TYPE_0, -1, -1, 0));
            iod.add(new IOD.DataElement(524312, VR.UI, IOD.DataElementType.TYPE_0, -1, -1, 0));
            return iod;
        }

        @Override
        protected IOD retrieveKeysIOD(Level rootLevel, boolean relational) {
            IOD iod = this.queryKeysIOD(rootLevel, relational);
            iod.add(new IOD.DataElement(0x100020, VR.LO, IOD.DataElementType.TYPE_1, 1, 1, 0));
            return iod;
        }
    }
    ,
    STUDY{

        @Override
        protected IOD queryKeysIOD(Level rootLevel, boolean relational) {
            IOD iod = new IOD();
            iod.add(new IOD.DataElement(0x100020, VR.LO, !relational && rootLevel == PATIENT ? IOD.DataElementType.TYPE_1 : IOD.DataElementType.TYPE_3, 1, 1, 0));
            iod.add(new IOD.DataElement(0x20000E, VR.UI, IOD.DataElementType.TYPE_0, -1, -1, 0));
            iod.add(new IOD.DataElement(524312, VR.UI, IOD.DataElementType.TYPE_0, -1, -1, 0));
            return iod;
        }

        @Override
        protected IOD retrieveKeysIOD(Level rootLevel, boolean relational) {
            IOD iod = this.queryKeysIOD(rootLevel, relational);
            iod.add(new IOD.DataElement(0x20000D, VR.UI, IOD.DataElementType.TYPE_1, -1, -1, 0));
            return iod;
        }
    }
    ,
    SERIES{

        @Override
        protected IOD queryKeysIOD(Level rootLevel, boolean relational) {
            IOD iod = new IOD();
            iod.add(new IOD.DataElement(0x100020, VR.LO, !relational && rootLevel == PATIENT ? IOD.DataElementType.TYPE_1 : IOD.DataElementType.TYPE_3, 1, 1, 0));
            iod.add(new IOD.DataElement(0x20000D, VR.UI, !relational ? IOD.DataElementType.TYPE_1 : IOD.DataElementType.TYPE_3, 1, 1, 0));
            iod.add(new IOD.DataElement(524312, VR.UI, IOD.DataElementType.TYPE_0, -1, -1, 0));
            return iod;
        }

        @Override
        protected IOD retrieveKeysIOD(Level rootLevel, boolean relational) {
            IOD iod = this.queryKeysIOD(rootLevel, relational);
            iod.add(new IOD.DataElement(0x20000E, VR.UI, IOD.DataElementType.TYPE_1, -1, -1, 0));
            return iod;
        }
    }
    ,
    IMAGE{

        @Override
        protected IOD queryKeysIOD(Level rootLevel, boolean relational) {
            IOD iod = new IOD();
            iod.add(new IOD.DataElement(0x100020, VR.LO, !relational && rootLevel == PATIENT ? IOD.DataElementType.TYPE_1 : IOD.DataElementType.TYPE_3, 1, 1, 0));
            iod.add(new IOD.DataElement(0x20000D, VR.UI, !relational ? IOD.DataElementType.TYPE_1 : IOD.DataElementType.TYPE_3, 1, 1, 0));
            iod.add(new IOD.DataElement(0x20000E, VR.UI, !relational ? IOD.DataElementType.TYPE_1 : IOD.DataElementType.TYPE_3, 1, 1, 0));
            return iod;
        }

        @Override
        protected IOD retrieveKeysIOD(Level rootLevel, boolean relational) {
            IOD iod = this.queryKeysIOD(rootLevel, relational);
            iod.add(new IOD.DataElement(524312, VR.UI, IOD.DataElementType.TYPE_1, -1, -1, 0));
            return iod;
        }
    }
    ,
    FRAME{

        @Override
        protected IOD queryKeysIOD(Level rootLevel, boolean relational) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected IOD retrieveKeysIOD(Level rootLevel, boolean relational) {
            return IMAGE.retrieveKeysIOD(rootLevel, relational);
        }
    };


    public static Level valueOf(Attributes attrs, String[] qrLevels) throws ImageException {
        ValidationResult result = new ValidationResult();
        attrs.validate(new IOD.DataElement(524370, VR.LO, IOD.DataElementType.TYPE_1, 1, 1, 0).setValues(qrLevels), result);
        Level.check(result);
        return Level.valueOf(attrs.getString(524370));
    }

    private static void check(ValidationResult result) throws ImageException {
        if (!result.isValid()) {
            throw new ImageException(43264, result.getErrorComment()).setOffendingElements(result.getOffendingElements());
        }
    }

    public void validateQueryKeys(Attributes attrs, Level rootLevel, boolean relational) throws ImageException {
        Level.check(attrs.validate(this.queryKeysIOD(rootLevel, relational)));
    }

    public void validateRetrieveKeys(Attributes attrs, Level rootLevel, boolean relational) throws ImageException {
        Level.check(attrs.validate(this.retrieveKeysIOD(rootLevel, relational)));
    }

    protected abstract IOD queryKeysIOD(Level var1, boolean var2);

    protected abstract IOD retrieveKeysIOD(Level var1, boolean var2);
}

