/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.nimble.reader;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;
import org.aoju.bus.core.toolkit.ByteKit;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.data.BulkData;
import org.aoju.bus.image.galaxy.data.Fragments;
import org.aoju.bus.image.galaxy.data.Sequence;
import org.aoju.bus.image.galaxy.data.VR;
import org.aoju.bus.image.galaxy.io.BulkDataDescriptor;
import org.aoju.bus.image.galaxy.io.ImageInputStream;
import org.aoju.bus.image.nimble.DicomMetaData;
import org.aoju.bus.image.nimble.LookupTable;
import org.aoju.bus.image.nimble.LookupTableFactory;
import org.aoju.bus.image.nimble.Overlays;
import org.aoju.bus.image.nimble.Photometric;
import org.aoju.bus.image.nimble.StoredValue;
import org.aoju.bus.image.nimble.codec.ImageDescriptor;
import org.aoju.bus.image.nimble.codec.ImageReaderFactory;
import org.aoju.bus.image.nimble.codec.TransferSyntaxType;
import org.aoju.bus.image.nimble.codec.jpeg.PatchJPEGLS;
import org.aoju.bus.image.nimble.codec.jpeg.PatchJPEGLSImageInputStream;
import org.aoju.bus.image.nimble.stream.ImageInputStreamAdapter;
import org.aoju.bus.image.nimble.stream.ImagePixelInputStream;
import org.aoju.bus.image.nimble.stream.SegmentedImageStream;
import org.aoju.bus.logger.Logger;

public class NativeDCMImageReader
extends ImageReader
implements Closeable {
    public static final String POST_PIXEL_DATA = "postPixelData";
    private ImageInputStream iis;
    private org.aoju.bus.image.galaxy.io.ImageInputStream dis;
    private ImagePixelInputStream epdiis;
    private DicomMetaData metadata;
    private BulkData pixelData;
    private Fragments pixelDataFragments;
    private byte[] pixeldataBytes;
    private int pixelDataLength;
    private VR pixelDataVR;
    private File pixelDataFile;
    private int frames;
    private int flushedFrames;
    private int width;
    private int height;
    private ImageReader decompressor;
    private boolean rle;
    private PatchJPEGLS patchJpegLS;
    private int samples;
    private boolean banded;
    private int bitsStored;
    private int bitsAllocated;
    private int dataType;
    private int frameLength;
    private Photometric pmi;
    private Photometric pmiAfterDecompression;
    private ImageDescriptor imageDescriptor;

    public NativeDCMImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    public static void generateOffsetLengths(Fragments pixelData, int frames, byte[] basicOffsetTable, long start) {
        long lastOffset = 0L;
        BulkData lastFrag = null;
        for (int frame = 0; frame < frames; ++frame) {
            long offset = frame > 0 ? 1L : 0L;
            int offsetStart = frame * 4;
            if (basicOffsetTable.length >= offsetStart + 4 && (offset = (long)ByteKit.bytesToIntLE((byte[])basicOffsetTable, (int)offsetStart)) != 1L) {
                if ((offset |= lastOffset & 0xFFFFFF00000000L) < lastOffset) {
                    offset += 0x100000000L;
                }
                lastOffset = offset;
                Logger.trace((String)"Found offset {} for frame {}", (Object[])new Object[]{offset, frame});
            }
            long position = -1L;
            if (offset != 1L) {
                position = start + offset + 8L;
            }
            BulkData frag = new BulkData("compressedPixelData://", position, -1, false);
            if (lastFrag != null && position != -1L) {
                lastFrag.setLength(position - 8L - lastFrag.offset());
            }
            lastFrag = frag;
            pixelData.add(frag);
            if (offset != 0L || frame <= 0) continue;
            start = -1L;
        }
    }

    @Override
    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        super.setInput(input, seekForwardOnly, ignoreMetadata);
        this.resetInternalState();
        if (input instanceof InputStream) {
            try {
                this.dis = input instanceof org.aoju.bus.image.galaxy.io.ImageInputStream ? (org.aoju.bus.image.galaxy.io.ImageInputStream)input : new org.aoju.bus.image.galaxy.io.ImageInputStream((InputStream)input);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        } else if (input instanceof DicomMetaData) {
            DicomMetaData metadata = (DicomMetaData)input;
            this.initPixelDataFromAttributes(metadata.getAttributes());
            this.initPixelDataFile();
            this.setMetadata(metadata);
        } else {
            this.iis = (ImageInputStream)input;
        }
    }

    private void initPixelDataFromAttributes(Attributes ds) {
        VR.Holder holder = new VR.Holder();
        Object value = ds.getValue(2145386512, holder);
        if (value != null) {
            this.imageDescriptor = new ImageDescriptor(ds);
            this.pixelDataVR = holder.vr;
            if (value instanceof BulkData) {
                this.pixelData = (BulkData)value;
                this.pixelDataLength = this.pixelData.length();
            } else if (value instanceof byte[]) {
                this.pixeldataBytes = (byte[])value;
                this.pixelDataLength = this.pixeldataBytes.length;
            } else {
                this.pixelDataFragments = (Fragments)value;
                this.pixelDataLength = -1;
            }
        }
    }

    private void initPixelDataFile() {
        if (this.pixelData != null) {
            this.pixelDataFile = this.pixelData.getFile();
        } else if (this.pixelDataFragments != null) {
            this.pixelDataFile = this.pixelDataFragmentsFile(this.pixelDataFragments);
        }
    }

    private File pixelDataFragmentsFile(Fragments pixelDataFragments) {
        File f = null;
        for (Object frag : pixelDataFragments) {
            if (!(frag instanceof BulkData)) continue;
            if (f == null) {
                f = ((BulkData)frag).getFile();
                continue;
            }
            if (f.equals(((BulkData)frag).getFile())) continue;
            throw new UnsupportedOperationException("data fragments in individual bulk data files not supported");
        }
        return f;
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IOException {
        this.readMetadata();
        return this.frames;
    }

    @Override
    public int getWidth(int frameIndex) throws IOException {
        this.readMetadata();
        this.checkIndex(frameIndex);
        return this.width;
    }

    @Override
    public int getHeight(int frameIndex) throws IOException {
        this.readMetadata();
        this.checkIndex(frameIndex);
        return this.height;
    }

    @Override
    public ImageTypeSpecifier getRawImageType(int frameIndex) throws IOException {
        this.readMetadata();
        this.checkIndex(frameIndex);
        if (this.decompressor == null) {
            return this.createImageType(this.bitsStored, this.dataType, this.banded);
        }
        if (this.rle) {
            return this.createImageType(this.bitsStored, this.dataType, true);
        }
        this.openiis();
        try {
            this.decompressor.setInput(this.iisOfFrame(0));
            ImageTypeSpecifier imageTypeSpecifier = this.decompressor.getRawImageType(0);
            return imageTypeSpecifier;
        }
        finally {
            this.closeiis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int frameIndex) throws IOException {
        ImageTypeSpecifier imageType;
        this.readMetadata();
        this.checkIndex(frameIndex);
        if (this.pmi.isMonochrome()) {
            imageType = this.createImageType(8, 0, false);
        } else if (this.decompressor == null) {
            imageType = this.createImageType(this.bitsStored, this.dataType, this.banded);
        } else if (this.rle) {
            imageType = this.createImageType(this.bitsStored, this.dataType, true);
        } else {
            this.openiis();
            try {
                this.decompressor.setInput(this.iisOfFrame(0));
                Iterator<ImageTypeSpecifier> iterator = this.decompressor.getImageTypes(0);
                return iterator;
            }
            finally {
                this.closeiis();
            }
        }
        return Collections.singletonList(imageType).iterator();
    }

    private void openiis() throws IOException {
        if (this.iis == null) {
            if (this.pixelDataFile != null) {
                this.iis = new FileImageInputStream(this.pixelDataFile);
            } else if (this.pixeldataBytes != null) {
                this.iis = new SegmentedImageStream(this.pixeldataBytes);
            }
        }
    }

    private void closeiis() throws IOException {
        if ((this.pixelDataFile != null || this.pixeldataBytes != null) && this.iis != null) {
            this.iis.close();
            this.iis = null;
        }
    }

    @Override
    public ImageReadParam getDefaultReadParam() {
        return new NativeDCMImageReadParam();
    }

    @Override
    public DicomMetaData getStreamMetadata() throws IOException {
        this.readMetadata();
        return this.metadata;
    }

    @Override
    public DicomMetaData getStreamMetadata(String formatName, Set<String> nodeNames) throws IOException {
        DicomMetaData ret = this.getStreamMetadata();
        if (nodeNames != null && nodeNames.contains(POST_PIXEL_DATA)) {
            this.readPostPixeldata();
            return this.getStreamMetadata();
        }
        return ret;
    }

    @Override
    public IIOMetadata getImageMetadata(int frameIndex) {
        return null;
    }

    @Override
    public boolean canReadRaster() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Raster readRaster(int frameIndex, ImageReadParam param) throws IOException {
        this.readMetadata();
        this.checkIndex(frameIndex);
        this.openiis();
        try {
            Object data;
            if (this.decompressor != null) {
                this.decompressor.setInput(this.iisOfFrame(frameIndex));
                Logger.debug((String)("Start decompressing frame #" + (frameIndex + 1)), (Object[])new Object[0]);
                WritableRaster wr = this.pmiAfterDecompression == this.pmi && this.decompressor.canReadRaster() ? this.decompressor.readRaster(0, this.decompressParam(param)) : this.decompressor.read(0, this.decompressParam(param)).getRaster();
                Logger.debug((String)("Finished decompressing frame #" + (frameIndex + 1)), (Object[])new Object[0]);
                WritableRaster writableRaster = wr;
                return writableRaster;
            }
            WritableRaster wr = Raster.createWritableRaster(this.createSampleModel(this.dataType, this.banded), null);
            DataBuffer buf = wr.getDataBuffer();
            if (this.dis != null) {
                this.dis.skipFully((frameIndex - this.flushedFrames) * this.frameLength);
                this.flushedFrames = frameIndex + 1;
            } else if (this.pixeldataBytes != null) {
                this.iis.setByteOrder(this.bigEndian() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
                this.iis.seek(frameIndex * this.frameLength);
            } else {
                this.iis.setByteOrder(this.bigEndian() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
                this.iis.seek(this.pixelData.offset() + (long)(frameIndex * this.frameLength));
            }
            if (buf instanceof DataBufferByte) {
                for (byte[] bs : data = ((DataBufferByte)buf).getBankData()) {
                    if (this.dis != null) {
                        this.dis.readFully(bs);
                        continue;
                    }
                    this.iis.readFully(bs);
                }
                if (this.pixelDataVR == VR.OW && this.bigEndian()) {
                    ByteKit.swapShorts((byte[][])data);
                }
            } else {
                data = ((DataBufferUShort)buf).getData();
                if (this.dis != null) {
                    this.dis.readFully((short[])data, 0, ((byte[][])data).length);
                } else {
                    this.iis.readFully((short[])data, 0, ((byte[][])data).length);
                }
            }
            WritableRaster writableRaster = wr;
            return writableRaster;
        }
        finally {
            this.closeiis();
        }
    }

    private boolean bigEndian() {
        return this.metadata.bigEndian();
    }

    private String getTransferSyntaxUID() {
        return this.metadata.getTransferSyntaxUID();
    }

    private ImageReadParam decompressParam(ImageReadParam param) {
        ImageReadParam decompressParam = this.decompressor.getDefaultReadParam();
        ImageTypeSpecifier imageType = null;
        BufferedImage dest = null;
        if (param != null) {
            imageType = param.getDestinationType();
            dest = param.getDestination();
        }
        if (this.rle && imageType == null && dest == null) {
            imageType = this.createImageType(this.bitsStored, this.dataType, true);
        }
        decompressParam.setDestinationType(imageType);
        decompressParam.setDestination(dest);
        return decompressParam;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage read(int frameIndex, ImageReadParam param) throws IOException {
        ColorModel cm;
        WritableRaster raster;
        this.readMetadata();
        this.checkIndex(frameIndex);
        if (this.decompressor != null) {
            this.openiis();
            try {
                ImageInputStream iisOfFrame = this.iisOfFrame(frameIndex);
                iisOfFrame.length();
                this.decompressor.setInput(iisOfFrame);
                Logger.debug((String)"Start decompressing frame #{}", (Object[])new Object[]{frameIndex + 1});
                BufferedImage bi = this.decompressor.read(0, this.decompressParam(param));
                Logger.debug((String)"Finished decompressing frame #{}", (Object[])new Object[]{frameIndex + 1});
                if (this.samples > 1 && bi.getColorModel().getColorSpace().getType() == (this.pmiAfterDecompression.isYBR() ? 3 : 5)) {
                    BufferedImage bufferedImage = bi;
                    return bufferedImage;
                }
                raster = bi.getRaster();
            }
            finally {
                this.closeiis();
            }
        } else {
            raster = (WritableRaster)this.readRaster(frameIndex, param);
        }
        if (this.pmi.isMonochrome()) {
            int[] overlayGroupOffsets = this.getActiveOverlayGroupOffsets(param);
            byte[][] overlayData = new byte[overlayGroupOffsets.length][];
            for (int i = 0; i < overlayGroupOffsets.length; ++i) {
                overlayData[i] = this.extractOverlay(overlayGroupOffsets[i], raster);
            }
            cm = this.createColorModel(8, 0);
            SampleModel sm = this.createSampleModel(0, false);
            raster = this.applyLUTs(raster, frameIndex, param, sm, 8);
            for (int i = 0; i < overlayGroupOffsets.length; ++i) {
                this.applyOverlay(overlayGroupOffsets[i], raster, frameIndex, param, 8, overlayData[i]);
            }
        } else {
            cm = this.createColorModel(this.bitsStored, this.dataType);
        }
        return new BufferedImage(cm, raster, false, null);
    }

    private byte[] extractOverlay(int gg0000, WritableRaster raster) {
        Attributes attrs = this.metadata.getAttributes();
        if (attrs.getInt(0x60000100 | gg0000, 1) == 1) {
            return null;
        }
        int ovlyRows = attrs.getInt(0x60000010 | gg0000, 0);
        int ovlyColumns = attrs.getInt(0x60000011 | gg0000, 0);
        int bitPosition = attrs.getInt(0x60000102 | gg0000, 0);
        int mask = 1 << bitPosition;
        int length = ovlyRows * ovlyColumns;
        byte[] ovlyData = new byte[(length + 7 >>> 3) + 1 & 0xFFFFFFFE];
        if (bitPosition < this.bitsStored) {
            Logger.info((String)"Ignore embedded overlay #{} from bit #{} < bits stored: {}", (Object[])new Object[]{(gg0000 >>> 17) + 1, bitPosition, this.bitsStored});
        } else {
            Overlays.extractFromPixeldata(raster, mask, ovlyData, 0, length);
        }
        return ovlyData;
    }

    public ImageInputStream iisOfFrame(int frameIndex) throws IOException {
        ImageInputStreamImpl iisOfFrame;
        if (this.epdiis != null) {
            this.seekFrame(frameIndex);
            iisOfFrame = this.epdiis;
        } else {
            if (this.pixelDataFragments == null) {
                return null;
            }
            iisOfFrame = new SegmentedImageStream(this.iis, this.pixelDataFragments, this.frames == 1 ? -1 : frameIndex);
            ((SegmentedImageStream)iisOfFrame).setImageDescriptor(this.imageDescriptor);
        }
        return this.patchJpegLS != null ? new PatchJPEGLSImageInputStream(iisOfFrame, this.patchJpegLS) : iisOfFrame;
    }

    private void seekFrame(int frameIndex) throws IOException {
        assert (frameIndex >= this.flushedFrames);
        if (frameIndex == this.flushedFrames) {
            this.epdiis.seekCurrentFrame();
        } else {
            while (frameIndex > this.flushedFrames) {
                if (!this.epdiis.seekNextFrame()) {
                    throw new IOException("Data Fragments only contains " + (this.flushedFrames + 1) + " frames");
                }
                ++this.flushedFrames;
            }
        }
    }

    private void applyOverlay(int gg0000, WritableRaster raster, int frameIndex, ImageReadParam param, int outBits, byte[] ovlyData) {
        Attributes ovlyAttrs = this.metadata.getAttributes();
        int grayscaleValue = 65535;
        if (param instanceof NativeDCMImageReadParam) {
            NativeDCMImageReadParam dParam = (NativeDCMImageReadParam)param;
            Attributes psAttrs = dParam.getPresentationState();
            if (psAttrs != null) {
                if (psAttrs.containsValue(0x60003000 | gg0000)) {
                    ovlyAttrs = psAttrs;
                }
                grayscaleValue = Overlays.getRecommendedDisplayGrayscaleValue(psAttrs, gg0000);
            } else {
                grayscaleValue = dParam.getOverlayGrayscaleValue();
            }
        }
        Overlays.applyOverlay(ovlyData != null ? 0 : frameIndex, raster, ovlyAttrs, gg0000, grayscaleValue >>> 16 - outBits, ovlyData);
    }

    private int[] getActiveOverlayGroupOffsets(ImageReadParam param) {
        if (param instanceof NativeDCMImageReadParam) {
            NativeDCMImageReadParam dParam = (NativeDCMImageReadParam)param;
            Attributes psAttrs = dParam.getPresentationState();
            if (psAttrs != null) {
                return Overlays.getActiveOverlayGroupOffsets(psAttrs);
            }
            return Overlays.getActiveOverlayGroupOffsets(this.metadata.getAttributes(), dParam.getOverlayActivationMask());
        }
        return Overlays.getActiveOverlayGroupOffsets(this.metadata.getAttributes(), 65535);
    }

    private WritableRaster applyLUTs(WritableRaster raster, int frameIndex, ImageReadParam param, SampleModel sm, int outBits) {
        WritableRaster destRaster = sm.getDataType() == raster.getSampleModel().getDataType() ? raster : Raster.createWritableRaster(sm, null);
        Attributes imgAttrs = this.metadata.getAttributes();
        StoredValue sv = StoredValue.valueOf(imgAttrs);
        LookupTableFactory lutParam = new LookupTableFactory(sv);
        NativeDCMImageReadParam dParam = param instanceof NativeDCMImageReadParam ? (NativeDCMImageReadParam)param : new NativeDCMImageReadParam();
        Attributes psAttrs = dParam.getPresentationState();
        if (psAttrs != null) {
            lutParam.setModalityLUT(psAttrs);
            lutParam.setVOI(this.selectVOILUT(psAttrs, imgAttrs.getString(524312), frameIndex + 1), 0, 0, false);
            lutParam.setPresentationLUT(psAttrs);
        } else {
            Attributes sharedFctGroups = imgAttrs.getNestedDataset(1375769129);
            Attributes frameFctGroups = imgAttrs.getNestedDataset(1375769136, frameIndex);
            lutParam.setModalityLUT(this.selectFctGroup(imgAttrs, sharedFctGroups, frameFctGroups, 2658629));
            if (dParam.getWindowWidth() != 0.0f) {
                lutParam.setWindowCenter(dParam.getWindowCenter());
                lutParam.setWindowWidth(dParam.getWindowWidth());
            } else {
                lutParam.setVOI(this.selectFctGroup(imgAttrs, sharedFctGroups, frameFctGroups, 2658610), dParam.getWindowIndex(), dParam.getVOILUTIndex(), dParam.isPreferWindow());
            }
            if (dParam.isAutoWindowing()) {
                lutParam.autoWindowing(imgAttrs, raster);
            }
            lutParam.setPresentationLUT(imgAttrs);
        }
        LookupTable lut = lutParam.createLUT(outBits);
        lut.lookup(raster, destRaster);
        return destRaster;
    }

    private Attributes selectFctGroup(Attributes imgAttrs, Attributes sharedFctGroups, Attributes frameFctGroups, int tag) {
        if (frameFctGroups == null) {
            return imgAttrs;
        }
        Attributes group = frameFctGroups.getNestedDataset(tag);
        if (group == null && sharedFctGroups != null) {
            group = sharedFctGroups.getNestedDataset(tag);
        }
        return group != null ? group : imgAttrs;
    }

    private Attributes selectVOILUT(Attributes psAttrs, String iuid, int frame) {
        Sequence voiLUTs = psAttrs.getSequence(2634000);
        if (voiLUTs != null) {
            for (Attributes voiLUT : voiLUTs) {
                Sequence refImgs = voiLUT.getSequence(528704);
                if (refImgs == null || refImgs.isEmpty()) {
                    return voiLUT;
                }
                for (Attributes refImg : refImgs) {
                    if (!iuid.equals(refImg.getString(528725))) continue;
                    int[] refFrames = refImg.getInts(528736);
                    if (refFrames == null || refFrames.length == 0) {
                        return voiLUT;
                    }
                    for (int refFrame : refFrames) {
                        if (refFrame != frame) continue;
                        return voiLUT;
                    }
                }
            }
        }
        return null;
    }

    private void readMetadata() throws IOException {
        if (this.metadata != null) {
            return;
        }
        if (this.dis != null) {
            Attributes fmi = this.dis.readFileMetaInformation();
            Attributes ds = this.dis.readDataset(-1, 2145386512);
            if (this.dis.tag() == 2145386512) {
                this.imageDescriptor = new ImageDescriptor(ds);
                this.pixelDataVR = this.dis.vr();
                this.pixelDataLength = this.dis.length();
                if (this.pixelDataLength == -1) {
                    this.epdiis = new ImagePixelInputStream(this.dis, this.imageDescriptor);
                }
            } else {
                try {
                    this.dis.readAttributes(ds, -1, -1);
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
            }
            this.setMetadata(new DicomMetaData(fmi, ds));
            return;
        }
        if (this.iis == null) {
            throw new IllegalStateException("Input not set");
        }
        org.aoju.bus.image.galaxy.io.ImageInputStream dis = new org.aoju.bus.image.galaxy.io.ImageInputStream(new ImageInputStreamAdapter(this.iis));
        dis.setIncludeBulkData(ImageInputStream.IncludeBulkData.URI);
        dis.setBulkDataDescriptor(BulkDataDescriptor.PIXELDATA);
        dis.setURI("java:iis");
        Attributes fmi = dis.readFileMetaInformation();
        Attributes ds = dis.readDataset(-1, 2145386512);
        if (dis.tag() == 2145386512) {
            this.imageDescriptor = new ImageDescriptor(ds);
            this.pixelDataVR = dis.vr();
            this.pixelDataLength = dis.length();
        } else {
            try {
                dis.readAttributes(ds, -1, -1);
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }
        this.setMetadata(new DicomMetaData(fmi, ds));
        this.initPixelDataIIS(dis);
    }

    private void initPixelDataIIS(org.aoju.bus.image.galaxy.io.ImageInputStream dis) throws IOException {
        if (this.pixelDataLength == 0) {
            return;
        }
        if (this.pixelDataLength > 0) {
            this.pixelData = new BulkData("pixeldata://", dis.getPosition(), dis.length(), dis.bigEndian());
            this.metadata.getAttributes().setValue(2145386512, this.pixelDataVR, this.pixelData);
            return;
        }
        dis.readItemHeader();
        byte[] b = new byte[dis.length()];
        dis.readFully(b);
        long start = dis.getPosition();
        this.pixelDataFragments = new Fragments(this.pixelDataVR, dis.bigEndian(), this.frames);
        this.pixelDataFragments.add(b);
        NativeDCMImageReader.generateOffsetLengths(this.pixelDataFragments, this.frames, b, start);
    }

    private void setMetadata(DicomMetaData metadata) {
        this.metadata = metadata;
        Attributes ds = metadata.getAttributes();
        if (this.pixelDataLength != 0) {
            this.frames = ds.getInt(0x280008, 1);
            this.width = ds.getInt(2621457, 0);
            this.height = ds.getInt(2621456, 0);
            this.samples = ds.getInt(0x280002, 1);
            this.banded = this.samples > 1 && ds.getInt(2621446, 0) != 0;
            this.bitsAllocated = ds.getInt(2621696, 8);
            this.bitsStored = ds.getInt(2621697, this.bitsAllocated);
            this.dataType = this.bitsAllocated <= 8 ? 0 : 1;
            this.pmi = Photometric.fromString(ds.getString(2621444, "MONOCHROME2"));
            if (this.pixelDataLength != -1) {
                this.pmiAfterDecompression = this.pmi;
                this.frameLength = this.pmi.frameLength(this.width, this.height, this.samples, this.bitsAllocated);
            } else {
                Attributes fmi = metadata.getFileMetaInformation();
                if (fmi == null) {
                    throw new IllegalArgumentException("Missing File Meta Information for Data Set with compressed Pixel Data");
                }
                String tsuid = fmi.getString(131088);
                ImageReaderFactory.ImageReaderParam param = ImageReaderFactory.getImageReaderParam(tsuid);
                if (param == null) {
                    throw new UnsupportedOperationException("Unsupported Transfer Syntax: " + tsuid);
                }
                this.pmiAfterDecompression = this.pmi.isYBR() && TransferSyntaxType.isYBRCompression(tsuid) ? Photometric.RGB : this.pmi;
                this.rle = tsuid.equals("1.2.840.10008.1.2.5");
                this.decompressor = ImageReaderFactory.getImageReader(param);
                Logger.debug((String)"Decompressor: {}", (Object[])new Object[]{this.decompressor.getClass().getName()});
                this.patchJpegLS = param.patchJPEGLS;
            }
        }
    }

    private SampleModel createSampleModel(int dataType, boolean banded) {
        return this.pmi.createSampleModel(dataType, this.width, this.height, this.samples, banded);
    }

    private ImageTypeSpecifier createImageType(int bits, int dataType, boolean banded) {
        return new ImageTypeSpecifier(this.createColorModel(bits, dataType), this.createSampleModel(dataType, banded));
    }

    private ColorModel createColorModel(int bits, int dataType) {
        return this.pmiAfterDecompression.createColorModel(bits, dataType, this.metadata.getAttributes());
    }

    private void resetInternalState() {
        this.dis = null;
        this.metadata = null;
        this.pixelData = null;
        this.pixelDataFragments = null;
        this.pixelDataVR = null;
        this.pixelDataLength = 0;
        this.pixeldataBytes = null;
        this.pixelDataFile = null;
        this.frames = 0;
        this.flushedFrames = 0;
        this.width = 0;
        this.height = 0;
        if (this.decompressor != null) {
            this.decompressor.dispose();
            this.decompressor = null;
        }
        this.patchJpegLS = null;
        this.pmi = null;
    }

    private void checkIndex(int frameIndex) {
        if (this.frames == 0) {
            throw new IllegalStateException("Missing Pixel Data");
        }
        if (frameIndex < 0 || frameIndex >= this.frames) {
            throw new IndexOutOfBoundsException("imageIndex: " + frameIndex);
        }
        if (this.dis != null && frameIndex < this.flushedFrames) {
            throw new IllegalStateException("input stream position already after requested frame #" + (frameIndex + 1));
        }
    }

    public Attributes readPostPixeldata() throws IOException {
        long offset;
        if (this.frames == 0) {
            return this.metadata.getAttributes();
        }
        if (this.dis != null) {
            if (this.flushedFrames > this.frames) {
                return this.metadata.getAttributes();
            }
            this.dis.skipFully((this.frames - this.flushedFrames) * this.frameLength);
            this.flushedFrames = this.frames + 1;
            return this.readPostAttr(this.dis);
        }
        if (this.pixelData != null) {
            offset = this.pixelData.offset() + this.pixelData.longLength();
        } else {
            SegmentedImageStream siis = (SegmentedImageStream)this.iisOfFrame(-1);
            offset = siis.getOffsetPostPixelData();
        }
        this.iis.seek(offset);
        org.aoju.bus.image.galaxy.io.ImageInputStream dis = new org.aoju.bus.image.galaxy.io.ImageInputStream(new ImageInputStreamAdapter(this.iis), this.getTransferSyntaxUID());
        return this.readPostAttr(dis);
    }

    private Attributes readPostAttr(org.aoju.bus.image.galaxy.io.ImageInputStream dis) throws IOException {
        Attributes postAttr = dis.readDataset(-1, -1);
        postAttr.addAll(this.metadata.getAttributes());
        this.metadata = new DicomMetaData(this.metadata.getFileMetaInformation(), postAttr);
        return postAttr;
    }

    @Override
    public void dispose() {
        this.resetInternalState();
    }

    @Override
    public void close() {
        this.dispose();
    }

    public static class NativeDCMImageReadParam
    extends ImageReadParam {
        private float windowCenter;
        private float windowWidth;
        private boolean autoWindowing = true;
        private boolean preferWindow = true;
        private int windowIndex;
        private int voiLUTIndex;
        private int overlayActivationMask = 15;
        private int overlayGrayscaleValue = 65535;
        private Attributes presentationState;

        public float getWindowCenter() {
            return this.windowCenter;
        }

        public void setWindowCenter(float windowCenter) {
            this.windowCenter = windowCenter;
        }

        public float getWindowWidth() {
            return this.windowWidth;
        }

        public void setWindowWidth(float windowWidth) {
            this.windowWidth = windowWidth;
        }

        public boolean isAutoWindowing() {
            return this.autoWindowing;
        }

        public void setAutoWindowing(boolean autoWindowing) {
            this.autoWindowing = autoWindowing;
        }

        public boolean isPreferWindow() {
            return this.preferWindow;
        }

        public void setPreferWindow(boolean preferWindow) {
            this.preferWindow = preferWindow;
        }

        public int getWindowIndex() {
            return this.windowIndex;
        }

        public void setWindowIndex(int windowIndex) {
            this.windowIndex = Math.max(windowIndex, 0);
        }

        public int getVOILUTIndex() {
            return this.voiLUTIndex;
        }

        public void setVOILUTIndex(int voiLUTIndex) {
            this.voiLUTIndex = Math.max(voiLUTIndex, 0);
        }

        public Attributes getPresentationState() {
            return this.presentationState;
        }

        public void setPresentationState(Attributes presentationState) {
            this.presentationState = presentationState;
        }

        public int getOverlayActivationMask() {
            return this.overlayActivationMask;
        }

        public void setOverlayActivationMask(int overlayActivationMask) {
            this.overlayActivationMask = overlayActivationMask;
        }

        public int getOverlayGrayscaleValue() {
            return this.overlayGrayscaleValue;
        }

        public void setOverlayGrayscaleValue(int overlayGrayscaleValue) {
            this.overlayGrayscaleValue = overlayGrayscaleValue;
        }
    }
}

