/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.nimble.reader;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.aoju.bus.image.galaxy.data.Implementation;
import org.aoju.bus.image.nimble.DicomMetaData;
import org.aoju.bus.image.nimble.reader.NativeDCMImageReader;

public class NativeDCMImageReaderSpi
extends ImageReaderSpi {
    private static final String vendorName = "org.aoju.bus.image";
    private static final String version = Implementation.getVersionName();
    private static final String[] formatNames = new String[]{"dicom", "DICOM"};
    private static final String[] suffixes = new String[]{"dcm", "dic", "dicm", "dicom"};
    private static final String[] MIMETypes = new String[]{"application/dicom"};
    private static final Class<?>[] inputTypes = new Class[]{ImageInputStream.class, InputStream.class, DicomMetaData.class};

    public NativeDCMImageReaderSpi() {
        super(vendorName, version, formatNames, suffixes, MIMETypes, NativeDCMImageReader.class.getName(), inputTypes, null, false, null, null, null, null, false, null, null, null, null);
    }

    @Override
    public String getDescription(Locale locale) {
        return "DICOM Image Reader";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canDecodeInput(Object source) throws IOException {
        ImageInputStream iis = (ImageInputStream)source;
        iis.mark();
        try {
            int tag = iis.read() | iis.read() << 8 | iis.read() << 16 | iis.read() << 24;
            boolean bl = tag >= 524288 && tag <= 524310 || iis.skipBytes(124) == 124 && iis.read() == 68 && iis.read() == 73 && iis.read() == 67 && iis.read() == 77;
            return bl;
        }
        finally {
            iis.reset();
        }
    }

    @Override
    public ImageReader createReaderInstance(Object extension) {
        return new NativeDCMImageReader(this);
    }
}

