/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.metric;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamReader;
import org.aoju.bus.image.metric.Readable;
import org.aoju.bus.image.metric.TagCamel;
import org.aoju.bus.logger.Logger;

public final class TagValue {
    public static String formatDateTime(TemporalAccessor date) {
        Locale locale = Locale.getDefault();
        if (date instanceof LocalDate) {
            return DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM).withLocale(locale).format(date);
        }
        if (date instanceof LocalTime) {
            return DateTimeFormatter.ofLocalizedTime(FormatStyle.MEDIUM).withLocale(locale).format(date);
        }
        if (date instanceof LocalDateTime) {
            return DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM).withLocale(locale).format(date);
        }
        if (date instanceof Instant) {
            return DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM).withLocale(locale).format(((Instant)date).atZone(ZoneId.systemDefault()));
        }
        return "";
    }

    public static String getTagAttribute(XMLStreamReader xmler, String attribute, String defaultValue) {
        String val;
        if (attribute != null && (val = xmler.getAttributeValue(null, attribute)) != null) {
            return val;
        }
        return defaultValue;
    }

    public static String[] getStringArrayTagAttribute(XMLStreamReader xmler, String attribute, String[] defaultValue) {
        return TagValue.getStringArrayTagAttribute(xmler, attribute, defaultValue, "\\");
    }

    public static String[] getStringArrayTagAttribute(XMLStreamReader xmler, String attribute, String[] defaultValue, String separator) {
        String val;
        if (attribute != null && (val = xmler.getAttributeValue(null, attribute)) != null) {
            return val.split(Pattern.quote(separator));
        }
        return defaultValue;
    }

    public static Integer getIntegerTagAttribute(XMLStreamReader xmler, String attribute, Integer defaultValue) {
        if (attribute != null) {
            String val = xmler.getAttributeValue(null, attribute);
            try {
                if (val != null) {
                    return Integer.valueOf(val);
                }
            }
            catch (NumberFormatException e) {
                Logger.error((String)"Cannot parse integer {} of {}", (Object[])new Object[]{val, attribute});
            }
        }
        return defaultValue;
    }

    public static int[] getIntArrayTagAttribute(XMLStreamReader xmler, String attribute, int[] defaultValue) {
        return TagValue.getIntArrayTagAttribute(xmler, attribute, defaultValue, "\\");
    }

    public static int[] getIntArrayTagAttribute(XMLStreamReader xmler, String attribute, int[] defaultValue, String separator) {
        String val;
        if (attribute != null && (val = xmler.getAttributeValue(null, attribute)) != null) {
            String[] strs = val.split(Pattern.quote(separator));
            int[] vals = new int[strs.length];
            for (int i = 0; i < strs.length; ++i) {
                vals[i] = Integer.parseInt(strs[i], 10);
            }
            return vals;
        }
        return defaultValue;
    }

    public static Double getDoubleTagAttribute(XMLStreamReader xmler, String attribute, Double defaultValue) {
        if (attribute != null) {
            String val = xmler.getAttributeValue(null, attribute);
            try {
                if (val != null) {
                    return Double.valueOf(val);
                }
            }
            catch (NumberFormatException e) {
                Logger.error((String)"Cannot parse double {} of {}", (Object[])new Object[]{val, attribute});
            }
        }
        return defaultValue;
    }

    public static double[] getDoubleArrayTagAttribute(XMLStreamReader xmler, String attribute, double[] defaultValue) {
        return TagValue.getDoubleArrayTagAttribute(xmler, attribute, defaultValue, "\\");
    }

    public static double[] getDoubleArrayTagAttribute(XMLStreamReader xmler, String attribute, double[] defaultValue, String separator) {
        String val;
        if (attribute != null && (val = xmler.getAttributeValue(null, attribute)) != null) {
            String[] strs = val.split(Pattern.quote(separator));
            double[] vals = new double[strs.length];
            for (int i = 0; i < strs.length; ++i) {
                vals[i] = Double.parseDouble(strs[0]);
            }
            return vals;
        }
        return defaultValue;
    }

    public static Float getFloatTagAttribute(XMLStreamReader xmler, String attribute, Float defaultValue) {
        if (attribute != null) {
            String val = xmler.getAttributeValue(null, attribute);
            try {
                if (val != null) {
                    return Float.valueOf(val);
                }
            }
            catch (NumberFormatException e) {
                Logger.error((String)"Cannot parse float {} of {}", (Object[])new Object[]{val, attribute});
            }
        }
        return defaultValue;
    }

    public static float[] getFloatArrayTagAttribute(XMLStreamReader xmler, String attribute, float[] defaultValue) {
        return TagValue.getFloatArrayTagAttribute(xmler, attribute, defaultValue, "\\");
    }

    public static float[] getFloatArrayTagAttribute(XMLStreamReader xmler, String attribute, float[] defaultValue, String separator) {
        String val;
        if (attribute != null && (val = xmler.getAttributeValue(null, attribute)) != null) {
            String[] strs = val.split(Pattern.quote(separator));
            float[] vals = new float[strs.length];
            for (int i = 0; i < strs.length; ++i) {
                vals[i] = Float.parseFloat(strs[0]);
            }
            return vals;
        }
        return defaultValue;
    }

    public static TemporalAccessor getDateFromElement(XMLStreamReader xmler, String attribute, TagCamel.TagType type, TemporalAccessor defaultValue) {
        String val;
        if (attribute != null && (val = xmler.getAttributeValue(null, attribute)) != null) {
            try {
                if (TagCamel.TagType.TIME.equals((Object)type)) {
                    return LocalTime.parse(val);
                }
                if (TagCamel.TagType.DATETIME.equals((Object)type)) {
                    return LocalDateTime.parse(val);
                }
                return LocalDate.parse(val);
            }
            catch (Exception e) {
                Logger.error((String)"Parse date", (Object[])new Object[]{e});
            }
        }
        return defaultValue;
    }

    public static TemporalAccessor[] getDatesFromElement(XMLStreamReader xmler, String attribute, TagCamel.TagType type, TemporalAccessor[] defaultValue) {
        return TagValue.getDatesFromElement(xmler, attribute, type, defaultValue, "\\");
    }

    public static TemporalAccessor[] getDatesFromElement(XMLStreamReader xmler, String attribute, TagCamel.TagType type, TemporalAccessor[] defaultValue, String separator) {
        String val;
        if (attribute != null && (val = xmler.getAttributeValue(null, attribute)) != null) {
            String[] strs = val.split(Pattern.quote(separator));
            TemporalAccessor[] vals = new TemporalAccessor[strs.length];
            for (int i = 0; i < strs.length; ++i) {
                try {
                    if (TagCamel.TagType.TIME.equals((Object)type)) {
                        vals[i] = LocalTime.parse(strs[i]);
                        continue;
                    }
                    if (TagCamel.TagType.DATETIME.equals((Object)type)) {
                        vals[i] = LocalDateTime.parse(strs[i]);
                        continue;
                    }
                    vals[i] = LocalDate.parse(strs[i]);
                    continue;
                }
                catch (Exception e) {
                    Logger.error((String)"Parse date", (Object[])new Object[]{e});
                }
            }
            return vals;
        }
        return defaultValue;
    }

    public static Object getTagValue(TagCamel tag, Readable ... tagable) {
        for (Readable t : tagable) {
            Object val;
            if (t == null || (val = t.getTagValue(tag)) == null) continue;
            return val;
        }
        return null;
    }
}

