/*********************************************************************************
 *                                                                               *
 * The MIT License (MIT)                                                         *
 *                                                                               *
 * Copyright (c) 2015-2020 aoju.org and other contributors.                      *
 *                                                                               *
 * Permission is hereby granted, free of charge, to any person obtaining a copy  *
 * of this software and associated documentation files (the "Software"), to deal *
 * in the Software without restriction, including without limitation the rights  *
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell     *
 * copies of the Software, and to permit persons to whom the Software is         *
 * furnished to do so, subject to the following conditions:                      *
 *                                                                               *
 * The above copyright notice and this permission notice shall be included in    *
 * all copies or substantial portions of the Software.                           *
 *                                                                               *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR    *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,      *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE   *
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER        *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, *
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN     *
 * THE SOFTWARE.                                                                 *
 ********************************************************************************/
package org.aoju.bus.image.galaxy.data;

import org.aoju.bus.image.Tag;

/**
 * @author Kimi Liu
 * @version 6.0.0
 * @since JDK 1.8+
 */
public class StandardDictionary extends ElementDictionary {

    public static final ElementDictionary INSTANCE = new StandardDictionary();

    private StandardDictionary() {
        super(null, Tag.class);
    }

    public String keywordOf(int tag) {
        return Keyword.valueOf(tag);
    }

    public int tmTagOf(int daTag) {
        switch (daTag) {
            case 524306:
                return 524307;
            case 524320:
                return 524336;
            case 524321:
                return 524337;
            case 524322:
                return 524338;
            case 524323:
                return 524339;
            case 524324:
                return 524340;
            case 524325:
                return 524341;
            case 1048624:
                return 1048626;
            case 1576978:
                return 1576980;
            case 1577472:
                return 1577473;
            case 1601548:
                return 1601550;
            case 2110467:
                return 2110469;
            case 3276850:
                return 3276851;
            case 3276852:
                return 3276853;
            case 3280896:
                return 3280897;
            case 3280912:
                return 3280913;
            case 3280960:
                return 3280961;
            case 3280976:
                return 3280977;
            case 3670042:
                return 3670043;
            case 3670044:
                return 3670045;
            case 3670048:
                return 3670049;
            case 3670064:
                return 3670066;
            case 4194306:
                return 4194307;
            case 4194308:
                return 4194309;
            case 4194884:
                return 4194885;
            case 4194896:
                return 4194897;
            case 4202500:
                return 4202501;
            case 4235553:
                return 4235554;
            case 7340162:
                return 7340163;
            case 553648192:
                return 553648208;
            case 805699592:
                return 805699593;
            case 805830692:
                return 805830693;
            case 805831010:
                return 805831012;
            case 805831014:
                return 805831016;
            case 805831248:
                return 805831249;
            case 805961734:
                return 805961735;
            case 805962284:
                return 805962286;
            case 806223876:
                return 806223877;
            case 1074266368:
                return 1074266369;
            case 1074266376:
                return 1074266377;
            case 1074266386:
                return 1074266387;
        }
        return 0;
    }

    public int daTagOf(int tmTag) {
        switch (tmTag) {
            case 524307:
                return 524306;
            case 524336:
                return 524320;
            case 524337:
                return 524321;
            case 524338:
                return 524322;
            case 524339:
                return 524323;
            case 524340:
                return 524324;
            case 524341:
                return 524325;
            case 1048626:
                return 1048624;
            case 1576980:
                return 1576978;
            case 1577473:
                return 1577472;
            case 1601550:
                return 1601548;
            case 2110469:
                return 2110467;
            case 3276851:
                return 3276850;
            case 3276853:
                return 3276852;
            case 3280897:
                return 3280896;
            case 3280913:
                return 3280912;
            case 3280961:
                return 3280960;
            case 3280977:
                return 3280976;
            case 3670043:
                return 3670042;
            case 3670045:
                return 3670044;
            case 3670049:
                return 3670048;
            case 3670066:
                return 3670064;
            case 4194307:
                return 4194306;
            case 4194309:
                return 4194308;
            case 4194885:
                return 4194884;
            case 4194897:
                return 4194896;
            case 4202501:
                return 4202500;
            case 4235554:
                return 4235553;
            case 7340163:
                return 7340162;
            case 553648208:
                return 553648192;
            case 805699593:
                return 805699592;
            case 805830693:
                return 805830692;
            case 805831012:
                return 805831010;
            case 805831016:
                return 805831014;
            case 805831249:
                return 805831248;
            case 805961735:
                return 805961734;
            case 805962286:
                return 805962284;
            case 806223877:
                return 806223876;
            case 1074266369:
                return 1074266368;
            case 1074266377:
                return 1074266376;
            case 1074266387:
                return 1074266386;
        }
        return 0;
    }

    public VR vrOf(int tag) {
        if ((tag & 0xFFFF) == 0) {
            return VR.UL;
        }
        if ((tag & 0x10000) != 0) {
            return ((tag & 0xFF00) == 0) && ((tag & 0xF0) != 0) ?

                    VR.LO :
                    VR.UN;
        }
        if ((tag & 0xFF00) == 2109696) {
            return VR.CS;
        }
        int tmp = tag & 0xFFE00000;
        if ((tmp == 1342177280) || (tmp == 1610612736)) {
            tag &= 0xFFE0FFFF;
        } else if (((tag & 0xFF000000) == 2130706432) && ((tag & 0xFFFF0000) != 2145386496)) {
            tag &= 0xFF00FFFF;
        }
        switch (tag) {
            case 512:
            case 768:
            case 1024:
            case 1536:
            case 4144:
            case 131094:
            case 131095:
            case 131096:
            case 524372:
            case 524373:
            case 528384:
            case 3280929:
            case 4194305:
            case 4194881:
            case 7471198:
            case 7606836:
            case 7606838:
            case 553648240:
            case 553648448:
                return VR.AE;
            case 1052688:
            case 7471199:
                return VR.AS;
            case 2305:
            case 4101:
            case 2117632:
            case 2134373:
            case 2134375:
            case 2621449:
            case 2621450:
            case 2621542:
            case 2622468:
            case 2623234:
            case 2623265:
            case 2623491:
            case 2623496:
            case 7471142:
            case 7471186:
            case 7471200:
            case 7606354:
            case 67108896:
            case 570425358:
            case 805830753:
            case 805830754:
            case 805830757:
            case 1610612838:
            case 1610614787:
                return VR.AT;
            case 20784:
            case 20800:
            case 20816:
            case 20832:
            case 20864:
            case 20880:
            case 20896:
            case 266544:
            case 266561:
            case 266562:
            case 267312:
            case 267520:
            case 524293:
            case 524296:
            case 524354:
            case 524370:
            case 524371:
            case 524374:
            case 524384:
            case 524385:
            case 524388:
            case 524392:
            case 524549:
            case 524554:
            case 524555:
            case 524559:
            case 524833:
            case 525059:
            case 525063:
            case 525066:
            case 532752:
            case 532992:
            case 532996:
            case 533000:
            case 561159:
            case 561669:
            case 561670:
            case 561671:
            case 561672:
            case 561673:
            case 562272:
            case 1048610:
            case 1048629:
            case 1048640:
            case 1049088:
            case 1057184:
            case 1057283:
            case 1057296:
            case 1057432:
            case 1179731:
            case 1179746:
            case 1179780:
            case 1179781:
            case 1310800:
            case 1310802:
            case 1310977:
            case 1310983:
            case 1310984:
            case 1318938:
            case 1318940:
            case 1319432:
            case 1319436:
            case 1319438:
            case 1319464:
            case 1327108:
            case 1327114:
            case 1327123:
            case 1327142:
            case 1327154:
            case 1327158:
            case 1327233:
            case 1331461:
            case 1331465:
            case 1331486:
            case 1441889:
            case 1441905:
            case 1441907:
            case 1441913:
            case 1441914:
            case 1441916:
            case 1441918:
            case 1441920:
            case 1441923:
            case 1441925:
            case 1441927:
            case 1441929:
            case 1572885:
            case 1572896:
            case 1572897:
            case 1572898:
            case 1572899:
            case 1572901:
            case 1572919:
            case 1572920:
            case 1572921:
            case 1572930:
            case 1572977:
            case 1572979:
            case 1577032:
            case 1577066:
            case 1577088:
            case 1577268:
            case 1577274:
            case 1577280:
            case 1577287:
            case 1577301:
            case 1577302:
            case 1577306:
            case 1577318:
            case 1577345:
            case 1577361:
            case 1577729:
            case 1577746:
            case 1577749:
            case 1577986:
            case 1577987:
            case 1578128:
            case 1578129:
            case 1578240:
            case 1578248:
            case 1578496:
            case 1578752:
            case 1579008:
            case 1579010:
            case 1581088:
            case 1585408:
            case 1593600:
            case 1593601:
            case 1597489:
            case 1601536:
            case 1601540:
            case 1601541:
            case 1601572:
            case 1601588:
            case 1601616:
            case 1601632:
            case 1601636:
            case 1609732:
            case 1609736:
            case 1609737:
            case 1609744:
            case 1609745:
            case 1609746:
            case 1609748:
            case 1609749:
            case 1609750:
            case 1609751:
            case 1609752:
            case 1609760:
            case 1609761:
            case 1609762:
            case 1609764:
            case 1609765:
            case 1609766:
            case 1609767:
            case 1609768:
            case 1609769:
            case 1609778:
            case 1609779:
            case 1609780:
            case 1609782:
            case 1609783:
            case 1609795:
            case 1609796:
            case 1609800:
            case 1609809:
            case 1609812:
            case 1609817:
            case 1609824:
            case 1609826:
            case 1609828:
            case 1609829:
            case 1609831:
            case 1609845:
            case 1609847:
            case 1609848:
            case 1609857:
            case 1609861:
            case 1609876:
            case 1609984:
            case 1609985:
            case 1610055:
            case 1610086:
            case 1610089:
            case 1610096:
            case 1610097:
            case 1610098:
            case 1610099:
            case 1610100:
            case 1610103:
            case 1610104:
            case 1610105:
            case 1610112:
            case 1610115:
            case 1610136:
            case 1610137:
            case 1610240:
            case 1610260:
            case 1610294:
            case 1610320:
            case 1610327:
            case 1610329:
            case 1610332:
            case 1610391:
            case 1610498:
            case 1610517:
            case 1610518:
            case 1610531:
            case 1610547:
            case 1610548:
            case 1610562:
            case 1610563:
            case 1610564:
            case 1610593:
            case 1610600:
            case 1610610:
            case 1610622:
            case 1610768:
            case 1610784:
            case 1610789:
            case 1610791:
            case 1610805:
            case 1610839:
            case 1610868:
            case 1611047:
            case 1611097:
            case 1611298:
            case 1611300:
            case 1611557:
            case 1611576:
            case 1611605:
            case 1611606:
            case 1611608:
            case 1611609:
            case 1611616:
            case 1611617:
            case 1611618:
            case 1611619:
            case 1611620:
            case 1611621:
            case 1611622:
            case 1611623:
            case 1611624:
            case 1611625:
            case 1611632:
            case 1611784:
            case 1611787:
            case 1611788:
            case 1612037:
            case 1612056:
            case 1612080:
            case 1612100:
            case 1612103:
            case 2097184:
            case 2097248:
            case 2097250:
            case 2097280:
            case 2110465:
            case 2110466:
            case 2134130:
            case 2134599:
            case 2134601:
            case 2134608:
            case 2134791:
            case 2134795:
            case 2134796:
            case 2134801:
            case 2228229:
            case 2228237:
            case 2228264:
            case 2228281:
            case 2232329:
            case 2232336:
            case 2232377:
            case 2232390:
            case 2232393:
            case 2232619:
            case 2232640:
            case 2233365:
            case 2233446:
            case 2233621:
            case 2233890:
            case 2359314:
            case 2359351:
            case 2359353:
            case 2359360:
            case 2359365:
            case 2359377:
            case 2359378:
            case 2359379:
            case 2359381:
            case 2359383:
            case 2359385:
            case 2359393:
            case 2359394:
            case 2359395:
            case 2359410:
            case 2359412:
            case 2359414:
            case 2359416:
            case 2359424:
            case 2359430:
            case 2359443:
            case 2359445:
            case 2359554:
            case 2359558:
            case 2359571:
            case 2359575:
            case 2359584:
            case 2359588:
            case 2360120:
            case 2621444:
            case 2621504:
            case 2621521:
            case 2621536:
            case 2621541:
            case 2621584:
            case 2622208:
            case 2622209:
            case 2622210:
            case 2622211:
            case 2623233:
            case 2623488:
            case 2624002:
            case 2625600:
            case 2625622:
            case 2625664:
            case 2625680:
            case 2626304:
            case 2626384:
            case 2626394:
            case 2626562:
            case 2626565:
            case 2626573:
            case 2626574:
            case 2626575:
            case 2626576:
            case 2629634:
            case 2629904:
            case 2629908:
            case 2646051:
            case 2646273:
            case 2650118:
            case 2650131:
            case 2650132:
            case 2650137:
            case 2650145:
            case 2650149:
            case 2650150:
            case 2650153:
            case 2650155:
            case 2658307:
            case 2658568:
            case 2658869:
            case 2659396:
            case 2659398:
            case 2659412:
            case 2659444:
            case 2659639:
            case 3276810:
            case 3276812:
            case 3280981:
            case 3670024:
            case 3801092:
            case 3801605:
            case 3801670:
            case 3801858:
            case 4194336:
            case 4194355:
            case 4194357:
            case 4194898:
            case 4194913:
            case 4195096:
            case 4210689:
            case 4210690:
            case 4210691:
            case 4210694:
            case 4210720:
            case 4210752:
            case 4210753:
            case 4227843:
            case 4235271:
            case 4235280:
            case 4235328:
            case 4235344:
            case 4235351:
            case 4235392:
            case 4235396:
            case 4235557:
            case 4235568:
            case 4235635:
            case 4235636:
            case 4235668:
            case 4235920:
            case 4236291:
            case 4236433:
            case 4236435:
            case 4236436:
            case 4236438:
            case 4236800:
            case 4236801:
            case 4236803:
            case 4250368:
            case 4250379:
            case 4251680:
            case 4456450:
            case 4587570:
            case 4587574:
            case 4587576:
            case 4587666:
            case 4587668:
            case 4587669:
            case 4587813:
            case 4588033:
            case 4588098:
            case 4588104:
            case 4718608:
            case 4718609:
            case 4718610:
            case 4719361:
            case 5242884:
            case 5242903:
            case 5242906:
            case 5373958:
            case 5373990:
            case 5374001:
            case 5374009:
            case 5374010:
            case 5505081:
            case 5505538:
            case 5506304:
            case 5506305:
            case 5509120:
            case 5509121:
            case 5509122:
            case 5509124:
            case 5509126:
            case 5509376:
            case 5509378:
            case 5509664:
            case 5510144:
            case 5510145:
            case 6422529:
            case 6422536:
            case 6422544:
            case 6422547:
            case 6684681:
            case 6684685:
            case 6684686:
            case 6684688:
            case 6840867:
            case 6841376:
            case 6844417:
            case 6844418:
            case 7340034:
            case 7340035:
            case 7340036:
            case 7340037:
            case 7340050:
            case 7340053:
            case 7340067:
            case 7340068:
            case 7340097:
            case 7340160:
            case 7340288:
            case 7340584:
            case 7340610:
            case 7340611:
            case 7340612:
            case 7340616:
            case 7340617:
            case 7340624:
            case 7340628:
            case 7340631:
            case 7340660:
            case 7340664:
            case 7340665:
            case 7340674:
            case 7340692:
            case 7340806:
            case 7340812:
            case 7341061:
            case 7344642:
            case 7344644:
            case 7344646:
            case 7344648:
            case 7344651:
            case 7344653:
            case 7344898:
            case 7345409:
            case 7345410:
            case 7345666:
            case 7345921:
            case 7346178:
            case 7346439:
            case 7346689:
            case 7346950:
            case 7346951:
            case 7346952:
            case 7346963:
            case 7471110:
            case 7471140:
            case 7471156:
            case 7471162:
            case 7471184:
            case 7471202:
            case 7471624:
            case 7471876:
            case 7471888:
            case 7471890:
            case 7471894:
            case 7472130:
            case 7472132:
            case 7472134:
            case 7472180:
            case 7472384:
            case 7472400:
            case 7472406:
            case 7472416:
            case 7472642:
            case 7472644:
            case 7472896:
            case 7472898:
            case 7472900:
            case 7472902:
            case 7472912:
            case 7472914:
            case 7472916:
            case 7472918:
            case 7472919:
            case 7472920:
            case 7606272:
            case 7606306:
            case 7606309:
            case 7606322:
            case 7606324:
            case 7606326:
            case 7606784:
            case 7606850:
            case 7606852:
            case 7606854:
            case 7607306:
            case 7733258:
            case 7733302:
            case 7733304:
            case 8519681:
            case 8519688:
            case 8519730:
            case 8519734:
            case 8519736:
            case 16778256:
            case 67108885:
            case 67109136:
            case 67109637:
            case 67110245:
            case 67110400:
            case 536870944:
            case 536870960:
            case 536870976:
            case 536871010:
            case 536871011:
            case 536871013:
            case 536871015:
            case 536871017:
            case 536871018:
            case 537919536:
            case 537919552:
            case 537919568:
            case 537919570:
            case 537919572:
            case 537919584:
            case 537919616:
            case 537919654:
            case 537919655:
            case 537919656:
            case 537919657:
            case 537919744:
            case 537919760:
            case 537919808:
            case 538968096:
            case 538968128:
            case 538968144:
            case 538968224:
            case 538968226:
            case 541065312:
            case 541065328:
            case 541065330:
            case 541065344:
            case 541065346:
            case 541065360:
            case 541065472:
            case 542113824:
            case 553648160:
            case 553648176:
            case 554696720:
            case 554696736:
            case 555745296:
            case 570425345:
            case 570425347:
            case 570425350:
            case 570425351:
            case 570425352:
            case 570425353:
            case 570425354:
            case 570425359:
            case 570425376:
            case 805437450:
            case 805437452:
            case 805437505:
            case 805437521:
            case 805568513:
            case 805568514:
            case 805568516:
            case 805568517:
            case 805568522:
            case 805568532:
            case 805568596:
            case 805568610:
            case 805699635:
            case 805699638:
            case 805699650:
            case 805699748:
            case 805699762:
            case 805699780:
            case 805830676:
            case 805830698:
            case 805830700:
            case 805830934:
            case 805831168:
            case 805831204:
            case 805831216:
            case 805961738:
            case 805961740:
            case 805961748:
            case 805961749:
            case 805961760:
            case 805961813:
            case 805961867:
            case 805961872:
            case 805961874:
            case 805961875:
            case 805961907:
            case 805961912:
            case 805961924:
            case 805961926:
            case 805961927:
            case 805961934:
            case 805961939:
            case 805961966:
            case 805961976:
            case 805961978:
            case 805961979:
            case 805961993:
            case 805962008:
            case 805962015:
            case 805962017:
            case 805962019:
            case 805962022:
            case 805962050:
            case 805962054:
            case 805962060:
            case 805962064:
            case 805962130:
            case 805962146:
            case 805962160:
            case 805962166:
            case 805962240:
            case 805962242:
            case 805962260:
            case 805962281:
            case 805962290:
            case 805962340:
            case 805962376:
            case 805962386:
            case 805962464:
            case 805962465:
            case 805962504:
            case 805962505:
            case 805962528:
            case 805962552:
            case 805962568:
            case 805962576:
            case 805962643:
            case 805962645:
            case 805962787:
            case 805962802:
            case 805962833:
            case 805962834:
            case 805963025:
            case 805963026:
            case 806093074:
            case 806223874:
            case 806354946:
            case 806354958:
            case 806354960:
            case 806354972:
            case 806355013:
            case 806355014:
            case 806355015:
            case 806355016:
            case 806355023:
            case 806355033:
            case 806355043:
            case 806355048:
            case 806355059:
            case 806355061:
            case 806355075:
            case 1074266367:
            case 1074266640:
            case 1074266642:
            case 1074790401:
            case 1074790402:
            case 1074794504:
            case 1074794505:
            case 1074794514:
            case 1074794516:
            case 1074794517:
            case 1074794528:
            case 1074794529:
            case 1074794532:
            case 1074794535:
            case 1074794536:
            case 1074794545:
            case 1074794553:
            case 1074794554:
            case 1074794562:
            case 1074794564:
            case 1074794566:
            case 1074794568:
            case 1074794582:
            case 1074794585:
            case 1074794599:
            case 1074794605:
            case 1074794606:
            case 1074794608:
            case 1074794620:
            case 1342177312:
            case 1342181377:
            case 1409290246:
            case 1610612800:
            case 1610612832:
            case 1610612835:
            case 1610613008:
            case 1610614784:
            case 1610616833:
                return VR.CS;
            case 524306:
            case 524320:
            case 524321:
            case 524322:
            case 524323:
            case 524324:
            case 524325:
            case 1048624:
            case 1057232:
            case 1179782:
            case 1179783:
            case 1310978:
            case 1314848:
            case 1323126:
            case 1327222:
            case 1327224:
            case 1327226:
            case 1327230:
            case 1576978:
            case 1577472:
            case 1601548:
            case 2110467:
            case 3276850:
            case 3276852:
            case 3280896:
            case 3280912:
            case 3280960:
            case 3280976:
            case 3670042:
            case 3670044:
            case 3670048:
            case 3670064:
            case 4194306:
            case 4194308:
            case 4194884:
            case 4194896:
            case 4202500:
            case 4235299:
            case 4235536:
            case 4235553:
            case 4235666:
            case 7340162:
            case 7471201:
            case 553648192:
            case 805699592:
            case 805830692:
            case 805830740:
            case 805830742:
            case 805831010:
            case 805831014:
            case 805831248:
            case 805961734:
            case 805962284:
            case 806223876:
            case 806355020:
            case 806355021:
            case 1074266368:
            case 1074266376:
            case 1074266386:
                return VR.DA;
            case 532784:
            case 1052704:
            case 1052706:
            case 1052707:
            case 1052708:
            case 1052720:
            case 1310768:
            case 1310770:
            case 1310772:
            case 1310804:
            case 1310806:
            case 1319466:
            case 1319468:
            case 1323025:
            case 1323026:
            case 1323044:
            case 1323046:
            case 1323048:
            case 1323121:
            case 1323122:
            case 1323123:
            case 1323125:
            case 1327124:
            case 1327125:
            case 1327126:
            case 1327127:
            case 1327128:
            case 1327129:
            case 1327130:
            case 1327131:
            case 1327132:
            case 1327133:
            case 1327138:
            case 1327140:
            case 1327144:
            case 1327153:
            case 1327156:
            case 1327160:
            case 1327162:
            case 1327164:
            case 1327186:
            case 1327191:
            case 1327192:
            case 1327193:
            case 1327194:
            case 1327202:
            case 1327204:
            case 1327236:
            case 1327237:
            case 1327240:
            case 1327241:
            case 1327243:
            case 1327244:
            case 1327245:
            case 1327246:
            case 1327250:
            case 1327260:
            case 1327261:
            case 1327263:
            case 1331457:
            case 1331458:
            case 1331459:
            case 1331460:
            case 1331463:
            case 1331464:
            case 1331466:
            case 1331468:
            case 1331469:
            case 1331470:
            case 1331474:
            case 1331475:
            case 1331476:
            case 1331477:
            case 1331478:
            case 1331479:
            case 1331480:
            case 1331481:
            case 1331482:
            case 1331483:
            case 1331484:
            case 1331485:
            case 1331487:
            case 1441793:
            case 1441794:
            case 1441796:
            case 1441797:
            case 1441801:
            case 1441805:
            case 1441808:
            case 1441825:
            case 1441826:
            case 1441827:
            case 1441828:
            case 1441829:
            case 1441830:
            case 1441833:
            case 1441840:
            case 1441841:
            case 1441842:
            case 1441843:
            case 1441844:
            case 1441845:
            case 1441846:
            case 1441848:
            case 1441860:
            case 1441870:
            case 1441906:
            case 1441908:
            case 1441910:
            case 1441915:
            case 1441917:
            case 1441919:
            case 1441921:
            case 1441924:
            case 1441926:
            case 1441928:
            case 1441930:
            case 1572904:
            case 1572914:
            case 1572915:
            case 1572944:
            case 1572960:
            case 1572978:
            case 1572992:
            case 1572993:
            case 1572994:
            case 1572995:
            case 1572996:
            case 1572999:
            case 1573000:
            case 1573008:
            case 1573011:
            case 1573012:
            case 1573013:
            case 1577025:
            case 1577028:
            case 1577030:
            case 1577031:
            case 1577033:
            case 1577040:
            case 1577056:
            case 1577059:
            case 1577061:
            case 1577062:
            case 1577063:
            case 1577064:
            case 1577065:
            case 1577073:
            case 1577076:
            case 1577077:
            case 1577078:
            case 1577079:
            case 1577216:
            case 1577232:
            case 1577233:
            case 1577236:
            case 1577248:
            case 1577249:
            case 1577264:
            case 1577265:
            case 1577269:
            case 1577270:
            case 1577271:
            case 1577272:
            case 1577281:
            case 1577282:
            case 1577283:
            case 1577284:
            case 1577285:
            case 1577286:
            case 1577300:
            case 1577310:
            case 1577314:
            case 1577316:
            case 1577347:
            case 1577348:
            case 1577360:
            case 1577376:
            case 1577378:
            case 1577379:
            case 1577381:
            case 1577728:
            case 1577748:
            case 1577750:
            case 1577752:
            case 1578001:
            case 1578002:
            case 1578003:
            case 1578064:
            case 1578080:
            case 1578096:
            case 1578112:
            case 1578256:
            case 1578257:
            case 1578272:
            case 1578273:
            case 1578288:
            case 1578289:
            case 1581059:
            case 1581060:
            case 1581061:
            case 1581072:
            case 1581104:
            case 1585409:
            case 1585410:
            case 1593362:
            case 1593378:
            case 1593380:
            case 1593382:
            case 1593383:
            case 1593384:
            case 1593385:
            case 1593392:
            case 1593408:
            case 1593872:
            case 1593874:
            case 1597440:
            case 1601537:
            case 1601554:
            case 1601556:
            case 1601558:
            case 1601562:
            case 1601568:
            case 1601570:
            case 1601574:
            case 1601576:
            case 1601584:
            case 1601586:
            case 1601602:
            case 1601604:
            case 1601608:
            case 1601612:
            case 1601618:
            case 1601620:
            case 1601637:
            case 1605968:
            case 1605969:
            case 1610604:
            case 1610605:
            case 1610606:
            case 1610612:
            case 1610613:
            case 1610627:
            case 1610628:
            case 1612036:
            case 2097200:
            case 2097202:
            case 2097205:
            case 2097207:
            case 2097232:
            case 2097424:
            case 2101313:
            case 2228302:
            case 2233904:
            case 2621488:
            case 2621489:
            case 2621490:
            case 2625616:
            case 2625617:
            case 2625618:
            case 2625619:
            case 2629906:
            case 2659616:
            case 3801114:
            case 3801616:
            case 3801618:
            case 3801619:
            case 3801620:
            case 3801621:
            case 3801624:
            case 3801632:
            case 3801633:
            case 3801634:
            case 3801635:
            case 4194964:
            case 4195078:
            case 4195079:
            case 4195090:
            case 4195092:
            case 4195094:
            case 4196138:
            case 4196154:
            case 4196170:
            case 4227842:
            case 4235576:
            case 4236042:
            case 4718850:
            case 4718865:
            case 4718866:
            case 4718867:
            case 5242900:
            case 5242902:
            case 5242904:
            case 5242905:
            case 5505044:
            case 5505045:
            case 5505139:
            case 5505536:
            case 5509632:
            case 5509635:
            case 5509648:
            case 5509888:
            case 5509920:
            case 5509921:
            case 5509922:
            case 5509923:
            case 5509924:
            case 7340289:
            case 7471218:
            case 7606276:
            case 7606328:
            case 7606330:
            case 7607298:
            case 7607299:
            case 7607303:
            case 7607304:
            case 537920374:
            case 538968112:
            case 805437453:
            case 805437454:
            case 805437456:
            case 805437457:
            case 805437458:
            case 805437474:
            case 805437476:
            case 805437478:
            case 805437480:
            case 805437490:
            case 805437492:
            case 805437506:
            case 805568520:
            case 805568524:
            case 805568526:
            case 805568530:
            case 805568576:
            case 805568578:
            case 805568594:
            case 805568600:
            case 805568624:
            case 805568626:
            case 805568628:
            case 805699628:
            case 805699652:
            case 805699653:
            case 805699664:
            case 805699764:
            case 805699782:
            case 805830678:
            case 805830706:
            case 805830707:
            case 805830710:
            case 805830711:
            case 805830714:
            case 805830715:
            case 805830722:
            case 805830724:
            case 805830728:
            case 805830738:
            case 805830774:
            case 805830776:
            case 805830778:
            case 805830962:
            case 805830964:
            case 805830970:
            case 805830972:
            case 805961752:
            case 805961754:
            case 805961761:
            case 805961762:
            case 805961763:
            case 805961765:
            case 805961766:
            case 805961767:
            case 805961768:
            case 805961770:
            case 805961771:
            case 805961772:
            case 805961773:
            case 805961796:
            case 805961798:
            case 805961802:
            case 805961804:
            case 805961806:
            case 805961809:
            case 805961810:
            case 805961811:
            case 805961858:
            case 805961860:
            case 805961862:
            case 805961873:
            case 805961876:
            case 805961890:
            case 805961892:
            case 805961908:
            case 805961914:
            case 805961918:
            case 805961942:
            case 805961944:
            case 805961946:
            case 805961950:
            case 805961954:
            case 805961958:
            case 805961961:
            case 805961962:
            case 805961963:
            case 805961964:
            case 805961970:
            case 805961974:
            case 805961984:
            case 805961986:
            case 805961990:
            case 805961996:
            case 805961998:
            case 805962004:
            case 805962005:
            case 805962012:
            case 805962014:
            case 805962016:
            case 805962018:
            case 805962020:
            case 805962021:
            case 805962024:
            case 805962025:
            case 805962026:
            case 805962028:
            case 805962030:
            case 805962032:
            case 805962036:
            case 805962065:
            case 805962066:
            case 805962067:
            case 805962068:
            case 805962069:
            case 805962172:
            case 805962194:
            case 805962196:
            case 805962198:
            case 805962264:
            case 805962266:
            case 805962274:
            case 805962276:
            case 805962280:
            case 805962282:
            case 805962283:
            case 805962320:
            case 805962346:
            case 805962348:
            case 805962353:
            case 805962354:
            case 805962356:
            case 805962372:
            case 805962374:
            case 805962380:
            case 805962390:
            case 805962396:
            case 805962398:
            case 805962400:
            case 805962404:
            case 805962424:
            case 805962426:
            case 805962440:
            case 805962450:
            case 805962452:
            case 805962454:
            case 805962466:
            case 805962818:
            case 806092808:
            case 806092809:
            case 1074794613:
            case 1074794622:
            case 1610617602:
            case 1610617603:
                return VR.DS;
            case 524309:
            case 524330:
            case 524550:
            case 524551:
            case 1441911:
            case 1441933:
            case 1577080:
            case 1577081:
            case 1577474:
            case 1609844:
            case 1610065:
            case 1610601:
            case 1610602:
            case 1611030:
            case 1611031:
            case 1611299:
            case 1611521:
            case 1611780:
            case 1612057:
            case 1613826:
            case 4210693:
            case 4210696:
            case 4210704:
            case 4210705:
            case 4210768:
            case 4210769:
            case 4210770:
            case 4235312:
            case 4235314:
            case 4235394:
            case 4235552:
            case 4235578:
            case 4250374:
            case 4250375:
            case 4251652:
            case 4456452:
            case 4456459:
            case 4456464:
            case 4456708:
            case 4456709:
            case 6840870:
            case 6840944:
            case 7471114:
            case 7471203:
            case 16778272:
            case 67109125:
            case 67110242:
            case 1074794533:
            case 1074794534:
            case 1074794539:
            case 1074794561:
                return VR.DT;
            case 562265:
            case 1086513:
            case 1572883:
            case 1577760:
            case 1581123:
            case 1581124:
            case 1581126:
            case 1597530:
            case 1597536:
            case 1601590:
            case 1601592:
            case 1601622:
            case 1601624:
            case 1610577:
            case 1610578:
            case 1610579:
            case 1610754:
            case 1610755:
            case 1610756:
            case 1610790:
            case 1610792:
            case 1610793:
            case 1610800:
            case 1610823:
            case 1610825:
            case 1610834:
            case 1610849:
            case 1610851:
            case 1610852:
            case 1610853:
            case 1610854:
            case 1610855:
            case 1610856:
            case 1610857:
            case 1610864:
            case 1610865:
            case 1610867:
            case 1611016:
            case 1611017:
            case 1611024:
            case 1611025:
            case 1611028:
            case 1611029:
            case 2134356:
            case 2134357:
            case 2134593:
            case 2134597:
            case 2134598:
            case 2134600:
            case 2228231:
            case 2228232:
            case 2228233:
            case 2228234:
            case 2228235:
            case 2228236:
            case 2228238:
            case 2228240:
            case 2228241:
            case 2228242:
            case 2228243:
            case 2228244:
            case 2228254:
            case 2228272:
            case 2228274:
            case 2228277:
            case 2228278:
            case 2228279:
            case 2228280:
            case 2228289:
            case 2228296:
            case 2228297:
            case 2228309:
            case 2228310:
            case 2228311:
            case 2232345:
            case 2232371:
            case 2232375:
            case 2232403:
            case 2232404:
            case 2232409:
            case 2232609:
            case 2232610:
            case 2232624:
            case 2232625:
            case 2232661:
            case 2233440:
            case 2233443:
            case 2233447:
            case 2233448:
            case 2233623:
            case 2233639:
            case 2233640:
            case 2233641:
            case 2233892:
            case 2233894:
            case 2233923:
            case 2233924:
            case 2233925:
            case 2233926:
            case 2233929:
            case 2233936:
            case 2359312:
            case 2359313:
            case 2359320:
            case 2359328:
            case 2359333:
            case 2359336:
            case 2359366:
            case 2359380:
            case 2359398:
            case 2359400:
            case 2359408:
            case 2359409:
            case 2359411:
            case 2359413:
            case 2359415:
            case 2359417:
            case 2359425:
            case 2359431:
            case 2359432:
            case 2359440:
            case 2359441:
            case 2359442:
            case 2359444:
            case 2359446:
            case 2359448:
            case 2359552:
            case 2359555:
            case 2359556:
            case 2359557:
            case 2359559:
            case 2359560:
            case 2359576:
            case 2359590:
            case 2360129:
            case 2621730:
            case 2621732:
            case 2646292:
            case 2650136:
            case 2650138:
            case 2650141:
            case 2650142:
            case 2650143:
            case 2659345:
            case 2659397:
            case 2659448:
            case 3801648:
            case 3801669:
            case 3801671:
            case 3801672:
            case 4587799:
            case 4587800:
            case 4588034:
            case 4588035:
            case 4588036:
            case 4588037:
            case 4588050:
            case 4588051:
            case 4588064:
            case 4588068:
            case 4588071:
            case 4588080:
            case 4588082:
            case 4588084:
            case 4588086:
            case 4588088:
            case 4588103:
            case 4588105:
            case 4588112:
            case 4588113:
            case 4588114:
            case 4588115:
            case 4718593:
            case 4718594:
            case 4718595:
            case 4718612:
            case 5373953:
            case 6684682:
            case 6684684:
            case 6684695:
            case 6684696:
            case 6684697:
            case 6684698:
            case 6684699:
            case 6684700:
            case 6684704:
            case 6684727:
            case 6684728:
            case 7340048:
            case 7340049:
            case 7340052:
            case 7340066:
            case 7340291:
            case 7340613:
            case 7340614:
            case 7340627:
            case 7340632:
            case 7340641:
            case 7340642:
            case 7340659:
            case 7340676:
            case 7340677:
            case 7340680:
            case 7341059:
            case 7471222:
            case 805699768:
            case 805830725:
            case 805830726:
            case 805830727:
            case 805830762:
            case 805961803:
            case 805961807:
            case 805961808:
            case 805961864:
            case 805961865:
            case 805961866:
            case 805961869:
            case 805961870:
            case 805961871:
            case 805961915:
            case 805961943:
            case 805961945:
            case 805961947:
            case 805961971:
            case 805961975:
            case 805962033:
            case 805962034:
            case 805962035:
            case 805962048:
            case 805962052:
            case 805962056:
            case 805962058:
            case 805962062:
            case 805962137:
            case 805962138:
            case 805962467:
            case 805962468:
            case 805962469:
            case 805962470:
            case 805962471:
            case 805962472:
            case 805962506:
            case 805962509:
            case 805962556:
            case 805962582:
            case 805962584:
            case 805962586:
            case 805962596:
            case 805962598:
            case 805962612:
            case 805962626:
            case 805962628:
            case 805962630:
            case 805962632:
            case 805962634:
            case 805962639:
            case 805962644:
            case 805962646:
            case 805962648:
            case 805962770:
            case 805962789:
            case 805962803:
            case 805962804:
            case 805962805:
            case 805962806:
            case 805963009:
            case 805963010:
            case 805963011:
            case 805963012:
            case 805963015:
            case 805963016:
            case 805963017:
            case 805963024:
            case 1074794500:
            case 1074794501:
            case 1074794518:
            case 1074794519:
            case 1074794520:
            case 1074794521:
            case 1074794523:
            case 1074794524:
            case 1074794525:
            case 1074794531:
            case 1074794563:
            case 1074794592:
            case 1074794593:
            case 1074794594:
            case 1074794601:
            case 1074794618:
                return VR.FL;
            case 528739:
            case 532788:
            case 1179730:
            case 1577585:
            case 1597480:
            case 1597482:
            case 1597484:
            case 1597486:
            case 1597492:
            case 1597494:
            case 1597524:
            case 1609753:
            case 1609776:
            case 1609781:
            case 1609810:
            case 1609811:
            case 1609825:
            case 1609827:
            case 1609833:
            case 1609840:
            case 1609843:
            case 1609849:
            case 1609858:
            case 1609863:
            case 1609865:
            case 1609872:
            case 1609873:
            case 1609878:
            case 1609880:
            case 1609988:
            case 1609989:
            case 1609990:
            case 1610069:
            case 1610088:
            case 1610113:
            case 1610114:
            case 1610116:
            case 1610133:
            case 1610134:
            case 1610263:
            case 1610264:
            case 1610272:
            case 1610324:
            case 1610325:
            case 1610326:
            case 1610330:
            case 1610389:
            case 1610390:
            case 1610499:
            case 1610501:
            case 1610502:
            case 1610503:
            case 1610505:
            case 1610512:
            case 1610513:
            case 1610515:
            case 1610519:
            case 1610520:
            case 1610521:
            case 1610530:
            case 1610532:
            case 1610535:
            case 1610536:
            case 1610544:
            case 1610546:
            case 1610549:
            case 1610565:
            case 1610620:
            case 1611075:
            case 1611076:
            case 1611077:
            case 1611078:
            case 1611079:
            case 1611080:
            case 1611081:
            case 1611088:
            case 1611089:
            case 1611090:
            case 1611091:
            case 1611092:
            case 1611095:
            case 1611096:
            case 1611266:
            case 1611267:
            case 1611268:
            case 1611269:
            case 1611270:
            case 1611271:
            case 1611541:
            case 1611542:
            case 1611543:
            case 1611544:
            case 1611545:
            case 1611552:
            case 1611553:
            case 1611554:
            case 1611555:
            case 1611556:
            case 1611558:
            case 1611559:
            case 1611777:
            case 1611781:
            case 1612098:
            case 1612099:
            case 1612101:
            case 1612102:
            case 2134355:
            case 2134609:
            case 2134610:
            case 2134612:
            case 2134613:
            case 2134614:
            case 2134615:
            case 2134785:
            case 2134786:
            case 2134792:
            case 2134793:
            case 2134794:
            case 2134797:
            case 2621731:
            case 2621733:
            case 2626097:
            case 2626098:
            case 2626566:
            case 4231698:
            case 4231699:
            case 4231700:
            case 4231716:
            case 4231717:
            case 4235617:
            case 4587568:
            case 4587572:
            case 4587584:
            case 4587586:
            case 4587588:
            case 4587590:
            case 4587616:
            case 4587618:
            case 4587619:
            case 4587620:
            case 4587637:
            case 4587638:
            case 4587639:
            case 4587780:
            case 4587782:
            case 4587796:
            case 4587797:
            case 4587831:
            case 4587846:
            case 4587847:
            case 5242899:
            case 5242901:
            case 5242908:
            case 5242909:
            case 5373954:
            case 5373955:
            case 5373956:
            case 5373959:
            case 5373960:
            case 5373961:
            case 5373969:
            case 5373971:
            case 5373972:
            case 5373992:
            case 5374003:
            case 5374004:
            case 6553608:
            case 6840997:
            case 6841074:
            case 6841158:
            case 6841159:
            case 6841232:
            case 6841424:
            case 6841440:
            case 6841488:
            case 6841504:
            case 6841536:
            case 6841552:
            case 6841584:
            case 6841696:
            case 6841744:
            case 6841776:
            case 6841808:
            case 6841840:
            case 6841872:
            case 6841888:
            case 7340592:
            case 7340811:
            case 7340818:
            case 7344899:
            case 7344901:
            case 7344902:
            case 7345411:
            case 7345413:
            case 7345415:
            case 7345416:
            case 7345425:
            case 7345426:
            case 7345667:
            case 7345668:
            case 7345669:
            case 7345670:
            case 7345671:
            case 7345922:
            case 7345923:
            case 7345924:
            case 7345925:
            case 7345926:
            case 7346691:
            case 7346693:
            case 7346694:
            case 7346964:
            case 7471220:
            case 7471368:
            case 7471920:
            case 7472402:
            case 7472404:
            case 7602464:
            case 7602465:
            case 7606310:
            case 7606311:
            case 7606312:
            case 7606314:
            case 7606315:
            case 7606316:
            case 7606317:
            case 7607096:
            case 7607098:
            case 7864400:
            case 7864416:
            case 7864464:
            case 7864480:
            case 8388612:
            case 8388613:
            case 805961925:
            case 806355024:
            case 806355025:
            case 806355060:
            case 806355076:
            case 1074794611:
                return VR.FD;
            case 20848:
            case 528736:
            case 532770:
            case 532772:
            case 532776:
            case 532777:
            case 532778:
            case 532802:
            case 532803:
            case 532804:
            case 1318916:
            case 1318920:
            case 1318932:
            case 1319426:
            case 1319434:
            case 1319460:
            case 1319462:
            case 1327155:
            case 1331202:
            case 1331204:
            case 1441798:
            case 1441799:
            case 1441802:
            case 1441803:
            case 1441806:
            case 1441807:
            case 1441816:
            case 1441817:
            case 1441819:
            case 1441820:
            case 1441821:
            case 1441822:
            case 1441823:
            case 1441834:
            case 1441847:
            case 1441861:
            case 1441934:
            case 1572928:
            case 1572976:
            case 1572980:
            case 1572981:
            case 1572998:
            case 1573001:
            case 1573009:
            case 1577029:
            case 1577058:
            case 1577089:
            case 1577090:
            case 1577091:
            case 1577092:
            case 1577094:
            case 1577096:
            case 1577104:
            case 1577108:
            case 1577289:
            case 1577296:
            case 1577297:
            case 1577298:
            case 1577299:
            case 1577328:
            case 1577346:
            case 1577536:
            case 1577538:
            case 1577539:
            case 1577730:
            case 1577989:
            case 1578133:
            case 1578498:
            case 1578500:
            case 1578502:
            case 1578504:
            case 1578512:
            case 1578514:
            case 1578528:
            case 1578754:
            case 1578756:
            case 1578758:
            case 1578760:
            case 1578768:
            case 1578770:
            case 1578784:
            case 1581057:
            case 1585411:
            case 1585412:
            case 1585413:
            case 1593424:
            case 1601552:
            case 1601553:
            case 1601606:
            case 1610392:
            case 2097169:
            case 2097170:
            case 2097171:
            case 2097172:
            case 2097173:
            case 2097174:
            case 2097175:
            case 2097176:
            case 2097177:
            case 2097186:
            case 2097188:
            case 2097190:
            case 2097322:
            case 2097408:
            case 2097413:
            case 2101248:
            case 2101249:
            case 2101250:
            case 2101251:
            case 2101252:
            case 2101253:
            case 2101360:
            case 2101760:
            case 2101762:
            case 2101764:
            case 2101766:
            case 2101768:
            case 2101769:
            case 2621448:
            case 2621492:
            case 3801602:
            case 3801857:
            case 4588040:
            case 5505047:
            case 5505078:
            case 5505080:
            case 5505552:
            case 5509633:
            case 5509634:
            case 5509904:
            case 5509905:
            case 7340096:
            case 7340130:
            case 7340290:
            case 7471204:
            case 7606308:
            case 7606359:
            case 7607300:
            case 7607302:
            case 7607308:
            case 536870928:
            case 536871008:
            case 536871009:
            case 537919828:
            case 553648496:
            case 805437481:
            case 805568598:
            case 805699618:
            case 805699626:
            case 805699654:
            case 805699656:
            case 805699657:
            case 805699714:
            case 805699716:
            case 805830690:
            case 805830746:
            case 805830755:
            case 805830756:
            case 805830770:
            case 805830786:
            case 805830802:
            case 805830946:
            case 805830966:
            case 805830968:
            case 805830978:
            case 805830994:
            case 805831203:
            case 805961746:
            case 805961794:
            case 805961841:
            case 805961848:
            case 805961849:
            case 805961850:
            case 805961856:
            case 805961888:
            case 805961916:
            case 805961920:
            case 805961928:
            case 805961936:
            case 805961938:
            case 805961941:
            case 805961952:
            case 805961956:
            case 805961959:
            case 805961960:
            case 805961965:
            case 805961968:
            case 805961980:
            case 805961988:
            case 805962000:
            case 805962002:
            case 805962114:
            case 805962258:
            case 805962292:
            case 805962304:
            case 805962338:
            case 805962370:
            case 805962378:
            case 805962384:
            case 805962402:
            case 805962418:
            case 805962498:
            case 805962500:
            case 805962514:
            case 805962518:
            case 805962544:
            case 805962548:
            case 805962560:
            case 805962564:
            case 805962641:
            case 805962642:
            case 805962650:
            case 805962788:
            case 805962816:
            case 806092806:
            case 806092807:
            case 806092812:
            case 806092814:
            case 806092834:
            case 806092881:
            case 806092906:
            case 806092960:
            case 806092992:
            case 806093008:
            case 806093024:
            case 806093040:
            case 806093044:
            case 806093046:
            case 806093056:
            case 806093058:
            case 806093060:
            case 806355068:
            case 1610612757:
            case 1610617601:
                return VR.IS;
            case 2306:
            case 524353:
            case 524400:
            case 524416:
            case 524545:
            case 524548:
            case 524562:
            case 524578:
            case 524834:
            case 525058:
            case 528432:
            case 528446:
            case 528448:
            case 528512:
            case 528528:
            case 532786:
            case 1048608:
            case 1048609:
            case 1048627:
            case 1048628:
            case 1049107:
            case 1049108:
            case 1049111:
            case 1049123:
            case 1052672:
            case 1052736:
            case 1052752:
            case 1052800:
            case 1052801:
            case 1052816:
            case 1056768:
            case 1057040:
            case 1057104:
            case 1057106:
            case 1057264:
            case 1057281:
            case 1057426:
            case 1057429:
            case 1057433:
            case 1179664:
            case 1179680:
            case 1179681:
            case 1179696:
            case 1179697:
            case 1179712:
            case 1179714:
            case 1179728:
            case 1179744:
            case 1179747:
            case 1179761:
            case 1179762:
            case 1179777:
            case 1179778:
            case 1310976:
            case 1323124:
            case 1327264:
            case 1327265:
            case 1327266:
            case 1331473:
            case 1572880:
            case 1572912:
            case 1572913:
            case 1572916:
            case 1576960:
            case 1576963:
            case 1576964:
            case 1576965:
            case 1576966:
            case 1576967:
            case 1576968:
            case 1576976:
            case 1576977:
            case 1576982:
            case 1576983:
            case 1576984:
            case 1576985:
            case 1576986:
            case 1576987:
            case 1576992:
            case 1576995:
            case 1577008:
            case 1577024:
            case 1577057:
            case 1577060:
            case 1577072:
            case 1577093:
            case 1577313:
            case 1577380:
            case 1577569:
            case 1577984:
            case 1577985:
            case 1579011:
            case 1593360:
            case 1593376:
            case 1593377:
            case 1601578:
            case 1601579:
            case 1609793:
            case 1609798:
            case 1609808:
            case 1610101:
            case 1610322:
            case 1610331:
            case 1610334:
            case 1610787:
            case 1610803:
            case 1611044:
            case 1611045:
            case 1611046:
            case 1611048:
            case 1611057:
            case 1612032:
            case 1612054:
            case 1612066:
            case 1612087:
            case 2097264:
            case 2101280:
            case 2101311:
            case 2101312:
            case 2110468:
            case 2110470:
            case 2117634:
            case 2134547:
            case 2134584:
            case 2135073:
            case 2135123:
            case 2232361:
            case 2232421:
            case 2232422:
            case 2232467:
            case 2232468:
            case 2232469:
            case 2232471:
            case 2232665:
            case 2232947:
            case 2233428:
            case 2233878:
            case 2359401:
            case 2359810:
            case 2360070:
            case 2360071:
            case 2360072:
            case 2360073:
            case 2621520:
            case 2621535:
            case 2621538:
            case 2622464:
            case 2622465:
            case 2622467:
            case 2623232:
            case 2624004:
            case 2625620:
            case 2625621:
            case 2633731:
            case 2633732:
            case 2646050:
            case 2650117:
            case 2650119:
            case 2650125:
            case 2650144:
            case 2650154:
            case 3276818:
            case 3280928:
            case 3280944:
            case 3280947:
            case 3280992:
            case 3281008:
            case 3670032:
            case 3670033:
            case 3670038:
            case 3670046:
            case 3670080:
            case 3670096:
            case 3670112:
            case 3670113:
            case 3670114:
            case 3670274:
            case 3670784:
            case 3671040:
            case 3671296:
            case 3801612:
            case 4194311:
            case 4194322:
            case 4194900:
            case 4194901:
            case 4195594:
            case 4195602:
            case 4195610:
            case 4195665:
            case 4195840:
            case 4196090:
            case 4198402:
            case 4198404:
            case 4198405:
            case 4198408:
            case 4198496:
            case 4198659:
            case 4202497:
            case 4202518:
            case 4202519:
            case 4206593:
            case 4210742:
            case 4235303:
            case 4235335:
            case 4235360:
            case 4236116:
            case 4236434:
            case 4325394:
            case 4325396:
            case 4456456:
            case 4456458:
            case 4456465:
            case 4456466:
            case 4587538:
            case 4587833:
            case 5242907:
            case 5242910:
            case 5242912:
            case 5509377:
            case 5509379:
            case 5509380:
            case 5509381:
            case 6303760:
            case 6422533:
            case 6422537:
            case 6684683:
            case 6684721:
            case 6684726:
            case 6684934:
            case 6840848:
            case 6840865:
            case 6841045:
            case 6841152:
            case 6841216:
            case 6841296:
            case 6841664:
            case 7340136:
            case 7340161:
            case 7340551:
            case 7340583:
            case 7340585:
            case 7346697:
            case 7471108:
            case 7471112:
            case 7471120:
            case 7471168:
            case 7471188:
            case 7471190:
            case 7471206:
            case 7471619:
            case 7471622:
            case 7606284:
            case 7606358:
            case 7606786:
            case 7606788:
            case 7606818:
            case 7606832:
            case 7607307:
            case 7733249:
            case 7733251:
            case 7733254:
            case 7733296:
            case 7864321:
            case 7864352:
            case 7864356:
            case 7864498:
            case 8519702:
            case 8519704:
            case 8519705:
            case 8519715:
            case 8915204:
            case 8915216:
            case 8915218:
            case 16778278:
            case 67110243:
            case 67110244:
            case 536870992:
            case 540016672:
            case 554696752:
            case 570425356:
            case 805437443:
            case 805568518:
            case 805699588:
            case 805699622:
            case 805699640:
            case 805699784:
            case 805830917:
            case 805961731:
            case 805961737:
            case 805961739:
            case 805961750:
            case 805961842:
            case 805961922:
            case 805961932:
            case 805961977:
            case 805961982:
            case 805961994:
            case 805962115:
            case 805962116:
            case 805962262:
            case 805962268:
            case 805962278:
            case 805962294:
            case 805962296:
            case 805962308:
            case 805962342:
            case 805962388:
            case 805962392:
            case 805962420:
            case 805962530:
            case 805962554:
            case 805962570:
            case 805962580:
            case 805962581:
            case 805962594:
            case 805962610:
            case 806093075:
            case 806354949:
            case 806354970:
            case 806354974:
            case 806354989:
            case 806354996:
            case 806354998:
            case 806355000:
            case 806355028:
            case 806355030:
            case 806355063:
            case 1074266178:
            case 1074266371:
            case 1074266394:
            case 1074266626:
            case 1074794537:
            case 1074794577:
            case 1074794579:
            case 1342177314:
            case 1342186752:
            case 1610612770:
            case 1610612805:
            case 1610618112:
                return VR.LO;
            case 16384:
            case 16400:
            case 20752:
            case 20768:
            case 524552:
            case 540672:
            case 1057109:
            case 1057200:
            case 1064960:
            case 1310790:
            case 1323161:
            case 1327110:
            case 1327116:
            case 1327119:
            case 1327234:
            case 1589248:
            case 1601542:
            case 1601544:
            case 1601600:
            case 1601601:
            case 1601634:
            case 1610788:
            case 2113536:
            case 2134360:
            case 2232620:
            case 2359364:
            case 2637824:
            case 3293184:
            case 3686400:
            case 4195328:
            case 4198660:
            case 4199424:
            case 4202513:
            case 4203520:
            case 4456451:
            case 4456457:
            case 6684676:
            case 6684722:
            case 7471208:
            case 7606840:
            case 16778276:
            case 537919826:
            case 570425348:
            case 570425349:
            case 805961851:
            case 805962475:
            case 806354973:
            case 806355078:
            case 1073741840:
            case 1073758208:
            case 1074266389:
            case 1074794515:
            case 1074794600:
            case 1342185486:
            case 1610629120:
                return VR.LT;
            case -196612:
            case 131073:
            case 131330:
            case 1319440:
            case 1323136:
            case 1441835:
            case 1441867:
            case 1441890:
            case 1441904:
            case 1441931:
            case 1441932:
            case 2629632:
            case 4235380:
            case 4235401:
            case 4325393:
            case 6841088:
            case 7340630:
            case 7346184:
            case 7471205:
            case 67109141:
            case 67109152:
            case 67109648:
            case 67109892:
            case 67110176:
            case 67110226:
            case 1074794502:
            case 1074794604:
                return VR.OB;
            case 7345421:
            case 7346695:
            case 7471219:
            case 2145386505:
                return VR.OD;
            case 2233649:
            case 6553609:
            case 6684694:
            case 6684705:
            case 6684965:
            case 7471207:
            case 8388624:
            case 8388625:
            case 1442840592:
            case 1442840608:
            case 2145386504:
                return VR.OF;
            case 6684736:
            case 6684737:
            case 6684738:
            case 6684739:
            case 6684969:
            case 7471221:
                return VR.OL;
            case 1323088:
            case 1323120:
            case 2626048:
            case 2626049:
            case 2626050:
            case 2626051:
            case 2626052:
            case 2626065:
            case 2626066:
            case 2626067:
            case 2626081:
            case 2626082:
            case 2626083:
            case 2626084:
            case 2626568:
            case 2633734:
            case 6684707:
            case 6684708:
            case 6684709:
            case 6684713:
            case 6684931:
            case 7471209:
            case 1342185484:
            case 1342189568:
            case 1409286416:
            case 1409286418:
            case 1409290250:
            case 1409290256:
            case 1610625024:
            case 2130706448:
            case 2130706464:
            case 2130706480:
            case 2130706496:
            case 2145386512:
            case 2145386528:
            case 2145386544:
            case 2145386560:
                return VR.OW;
            case 524432:
            case 524444:
            case 528456:
            case 528464:
            case 528480:
            case 528496:
            case 1048592:
            case 1052673:
            case 1052677:
            case 1052768:
            case 1057431:
            case 1310980:
            case 1318918:
            case 3280946:
            case 4194310:
            case 4198416:
            case 4202504:
            case 4210743:
            case 4235367:
            case 4235381:
            case 4235555:
            case 4236039:
            case 4236114:
            case 7340164:
            case 7471210:
            case 805699750:
            case 806223880:
            case 1074266370:
            case 1074266378:
            case 1074266380:
            case 1074266388:
            case 1074266393:
                return VR.PN;
            case 16:
            case 20496:
            case 20512:
            case 131091:
            case 524304:
            case 524368:
            case 524436:
            case 524544:
            case 524546:
            case 524547:
            case 524801:
            case 528400:
            case 532768:
            case 532775:
            case 1057108:
            case 1057120:
            case 1057152:
            case 1318934:
            case 1318962:
            case 1327220:
            case 1331462:
            case 1331467:
            case 1331471:
            case 1331472:
            case 1572900:
            case 1572997:
            case 1576994:
            case 1577312:
            case 1577344:
            case 1577488:
            case 1577552:
            case 1577553:
            case 1577568:
            case 1579009:
            case 1581058:
            case 1581062:
            case 1581125:
            case 1593344:
            case 1601546:
            case 1609733:
            case 1609799:
            case 1610118:
            case 1610528:
            case 2097168:
            case 2134102:
            case 2621537:
            case 2621539:
            case 2650116:
            case 2650124:
            case 3801120:
            case 3801603:
            case 4194313:
            case 4194320:
            case 4194321:
            case 4194882:
            case 4194883:
            case 4194899:
            case 4198401:
            case 4198403:
            case 4198406:
            case 4198407:
            case 4198409:
            case 4202502:
            case 4202503:
            case 4202505:
            case 4202512:
            case 4231696:
            case 4718854:
            case 5505048:
            case 5506048:
            case 7340681:
            case 7340816:
            case 7471106:
            case 7471212:
            case 8388617:
            case 8913200:
            case 553648144:
            case 553648480:
            case 554696857:
            case 805437442:
            case 805437472:
            case 805437522:
            case 805699586:
            case 805699717:
            case 805830699:
            case 805961730:
            case 805961795:
            case 805961906:
            case 805961940:
            case 805961948:
            case 805961953:
            case 805961957:
            case 805961967:
            case 805961973:
            case 805961992:
            case 805962132:
            case 805962136:
            case 805962148:
            case 805962152:
            case 805962168:
            case 805962267:
            case 805962306:
            case 805962339:
            case 805962355:
            case 805962385:
            case 805962419:
            case 805962511:
            case 805962520:
            case 805962550:
            case 805962566:
            case 805962572:
            case 805962578:
            case 805962640:
            case 805962785:
            case 806354995:
            case 806354997:
            case 1074266176:
            case 1074266624:
            case 1074794503:
            case 1074794522:
            case 1074794526:
            case 1074794527:
            case 1074794538:
            case 1074794578:
            case 1074794580:
            case 1074794581:
            case 1074794584:
            case 1342177328:
            case 1342177344:
            case 1342177542:
            case 1610612833:
            case 1610612834:
                return VR.SH;
            case 1597472:
            case 1597474:
            case 1597497:
            case 1597499:
            case 1597501:
            case 1597503:
            case 1597505:
            case 1597507:
            case 4235618:
            case 4235930:
            case 4719134:
            case 4719135:
            case 7340114:
            case 7340115:
            case 7471228:
                return VR.SL;
            case -327686:
            case 266784:
            case 524294:
            case 524369:
            case 524387:
            case 524418:
            case 524438:
            case 524445:
            case 524553:
            case 524560:
            case 524577:
            case 524579:
            case 524580:
            case 524832:
            case 525056:
            case 525061:
            case 525072:
            case 528434:
            case 528447:
            case 528449:
            case 528457:
            case 528466:
            case 528482:
            case 528498:
            case 528516:
            case 528640:
            case 528656:
            case 528657:
            case 528661:
            case 528672:
            case 528677:
            case 528688:
            case 528692:
            case 528698:
            case 528704:
            case 528709:
            case 528714:
            case 528715:
            case 528726:
            case 528740:
            case 528792:
            case 528793:
            case 528794:
            case 528896:
            case 528976:
            case 532754:
            case 532787:
            case 532789:
            case 533016:
            case 533024:
            case 533032:
            case 533033:
            case 533040:
            case 533056:
            case 533058:
            case 533060:
            case 533062:
            case 533073:
            case 533075:
            case 533077:
            case 533079:
            case 533081:
            case 533082:
            case 533084:
            case 536577:
            case 536593:
            case 561298:
            case 561441:
            case 561444:
            case 561492:
            case 561685:
            case 561719:
            case 562192:
            case 562264:
            case 1048612:
            case 1048614:
            case 1048615:
            case 1048656:
            case 1048833:
            case 1048834:
            case 1049089:
            case 1049109:
            case 1049110:
            case 1049113:
            case 1049121:
            case 1049129:
            case 1052674:
            case 1052705:
            case 1052928:
            case 1057282:
            case 1057427:
            case 1057428:
            case 1057430:
            case 1179748:
            case 1179779:
            case 1310982:
            case 1318914:
            case 1318930:
            case 1318942:
            case 1318960:
            case 1319428:
            case 1319456:
            case 1323040:
            case 1323072:
            case 1323104:
            case 1327106:
            case 1327112:
            case 1327118:
            case 1327120:
            case 1327121:
            case 1327136:
            case 1327152:
            case 1327157:
            case 1327168:
            case 1327184:
            case 1327185:
            case 1327200:
            case 1327216:
            case 1327232:
            case 1327235:
            case 1327238:
            case 1327239:
            case 1327249:
            case 1327258:
            case 1572882:
            case 1572884:
            case 1572902:
            case 1572905:
            case 1572906:
            case 1572918:
            case 1576970:
            case 1577586:
            case 1581121:
            case 1593604:
            case 1597457:
            case 1609734:
            case 1609794:
            case 1609797:
            case 1609801:
            case 1609846:
            case 1609859:
            case 1609860:
            case 1609874:
            case 1609987:
            case 1609991:
            case 1610002:
            case 1610004:
            case 1610005:
            case 1610007:
            case 1610008:
            case 1610009:
            case 1610021:
            case 1610022:
            case 1610066:
            case 1610102:
            case 1610135:
            case 1610278:
            case 1610279:
            case 1610297:
            case 1610321:
            case 1610333:
            case 1610336:
            case 1610497:
            case 1610500:
            case 1610504:
            case 1610514:
            case 1610516:
            case 1610529:
            case 1610533:
            case 1610534:
            case 1610537:
            case 1610552:
            case 1610560:
            case 1610561:
            case 1610566:
            case 1610592:
            case 1610594:
            case 1610595:
            case 1610596:
            case 1610597:
            case 1610607:
            case 1610617:
            case 1610621:
            case 1610624:
            case 1610625:
            case 1610626:
            case 1610753:
            case 1610757:
            case 1610758:
            case 1610759:
            case 1610770:
            case 1610775:
            case 1610802:
            case 1610804:
            case 1610833:
            case 1610837:
            case 1610838:
            case 1610850:
            case 1610866:
            case 1610870:
            case 1610871:
            case 1611012:
            case 1611014:
            case 1611015:
            case 1611056:
            case 1611064:
            case 1611073:
            case 1611074:
            case 1611093:
            case 1611094:
            case 1611265:
            case 1611297:
            case 1611570:
            case 1611571:
            case 1611572:
            case 1611573:
            case 1611574:
            case 1611575:
            case 1611593:
            case 1611601:
            case 1611633:
            case 1611634:
            case 1611779:
            case 1611782:
            case 1611783:
            case 1611785:
            case 1611789:
            case 1611790:
            case 1611791:
            case 1612034:
            case 1612035:
            case 1612038:
            case 1612039:
            case 1612041:
            case 1612043:
            case 1612044:
            case 1612045:
            case 1612046:
            case 1612049:
            case 1612050:
            case 1612051:
            case 1612052:
            case 1612059:
            case 1612060:
            case 1612061:
            case 1612063:
            case 1612064:
            case 1612081:
            case 1612082:
            case 1612083:
            case 1612084:
            case 1612085:
            case 1612086:
            case 1612091:
            case 1612092:
            case 1612093:
            case 1612094:
            case 1613825:
            case 2134129:
            case 2134289:
            case 2134291:
            case 2134294:
            case 2134384:
            case 2134385:
            case 2134386:
            case 2134561:
            case 2134562:
            case 2134611:
            case 2134798:
            case 2134799:
            case 2134800:
            case 2135120:
            case 2135337:
            case 2228230:
            case 2228245:
            case 2228246:
            case 2228247:
            case 2228248:
            case 2228249:
            case 2228250:
            case 2228251:
            case 2228252:
            case 2228253:
            case 2228256:
            case 2228257:
            case 2228258:
            case 2228273:
            case 2228290:
            case 2228312:
            case 2232327:
            case 2232328:
            case 2232338:
            case 2232356:
            case 2232357:
            case 2232360:
            case 2232373:
            case 2232374:
            case 2232384:
            case 2232388:
            case 2232389:
            case 2232391:
            case 2232392:
            case 2232394:
            case 2232395:
            case 2232400:
            case 2232464:
            case 2232466:
            case 2232470:
            case 2232576:
            case 2232577:
            case 2232579:
            case 2232613:
            case 2232615:
            case 2232616:
            case 2232618:
            case 2232626:
            case 2232627:
            case 2232628:
            case 2232629:
            case 2232656:
            case 2232659:
            case 2232848:
            case 2232849:
            case 2232850:
            case 2232864:
            case 2232869:
            case 2232880:
            case 2232912:
            case 2232917:
            case 2232919:
            case 2232928:
            case 2232930:
            case 2232933:
            case 2233088:
            case 2233104:
            case 2233136:
            case 2233376:
            case 2233379:
            case 2233398:
            case 2233411:
            case 2233413:
            case 2233424:
            case 2233432:
            case 2233445:
            case 2233456:
            case 2233458:
            case 2233618:
            case 2233619:
            case 2233624:
            case 2233637:
            case 2233638:
            case 2233874:
            case 2233877:
            case 2233880:
            case 2233888:
            case 2233896:
            case 2233920:
            case 2359318:
            case 2359329:
            case 2359332:
            case 2359346:
            case 2359347:
            case 2359348:
            case 2359384:
            case 2359396:
            case 2359397:
            case 2359399:
            case 2359427:
            case 2359429:
            case 2359433:
            case 2359447:
            case 2359568:
            case 2359570:
            case 2359572:
            case 2359573:
            case 2359586:
            case 2360087:
            case 2360096:
            case 2360101:
            case 2360132:
            case 2626096:
            case 2626386:
            case 2626561:
            case 2626564:
            case 2626571:
            case 2626572:
            case 2633728:
            case 2633744:
            case 2634000:
            case 2641920:
            case 2646272:
            case 2650112:
            case 2650120:
            case 2650122:
            case 2650127:
            case 2650128:
            case 2650129:
            case 2650130:
            case 2650133:
            case 2650134:
            case 2650140:
            case 2650146:
            case 2650147:
            case 2650148:
            case 2650151:
            case 2650152:
            case 2650156:
            case 2650157:
            case 2650158:
            case 2658576:
            case 2658610:
            case 2658629:
            case 2659349:
            case 2659362:
            case 2659395:
            case 2659585:
            case 2659586:
            case 2659589:
            case 3280945:
            case 3280948:
            case 3280996:
            case 3280999:
            case 3670020:
            case 3670036:
            case 3670084:
            case 3670116:
            case 3670272:
            case 3670273:
            case 3671298:
            case 3801600:
            case 3801608:
            case 3801609:
            case 3801610:
            case 3801617:
            case 3801664:
            case 3801666:
            case 3801856:
            case 4194312:
            case 4194314:
            case 4194315:
            case 4194342:
            case 4194343:
            case 4194358:
            case 4194361:
            case 4194362:
            case 4194560:
            case 4194848:
            case 4194912:
            case 4194928:
            case 4194933:
            case 4194945:
            case 4194963:
            case 4194965:
            case 4194966:
            case 4195086:
            case 4195104:
            case 4195105:
            case 4195108:
            case 4195120:
            case 4195136:
            case 4195392:
            case 4195393:
            case 4195584:
            case 4195603:
            case 4195605:
            case 4195608:
            case 4195616:
            case 4195664:
            case 4195666:
            case 4195669:
            case 4195680:
            case 4195682:
            case 4195738:
            case 4195856:
            case 4195858:
            case 4195872:
            case 4196112:
            case 4196122:
            case 4196568:
            case 4196570:
            case 4196586:
            case 4196856:
            case 4198410:
            case 4198417:
            case 4198418:
            case 4198657:
            case 4210692:
            case 4210695:
            case 4210697:
            case 4210709:
            case 4210710:
            case 4210712:
            case 4210713:
            case 4210721:
            case 4210722:
            case 4210725:
            case 4210726:
            case 4210727:
            case 4210728:
            case 4210729:
            case 4210736:
            case 4210737:
            case 4210738:
            case 4210739:
            case 4210740:
            case 4210741:
            case 4210800:
            case 4210801:
            case 4210802:
            case 4210804:
            case 4231314:
            case 4231316:
            case 4231318:
            case 4231320:
            case 4231712:
            case 4235296:
            case 4235302:
            case 4235304:
            case 4235331:
            case 4235366:
            case 4235368:
            case 4235376:
            case 4235379:
            case 4235382:
            case 4235384:
            case 4235386:
            case 4235388:
            case 4235397:
            case 4235400:
            case 4235408:
            case 4235623:
            case 4235624:
            case 4235632:
            case 4235669:
            case 4235926:
            case 4236032:
            case 4236033:
            case 4236051:
            case 4236096:
            case 4236120:
            case 4236128:
            case 4236144:
            case 4236146:
            case 4236149:
            case 4236160:
            case 4236165:
            case 4236176:
            case 4236292:
            case 4236548:
            case 4236581:
            case 4237104:
            case 4237105:
            case 4237106:
            case 4237124:
            case 4239392:
            case 4251654:
            case 4251656:
            case 4251681:
            case 4251682:
            case 4251683:
            case 4251684:
            case 4251685:
            case 4325395:
            case 4456455:
            case 4456467:
            case 4456473:
            case 4456704:
            case 4456705:
            case 4456707:
            case 4456711:
            case 4456713:
            case 4456714:
            case 4587540:
            case 4587541:
            case 4587542:
            case 4587544:
            case 4587560:
            case 4587591:
            case 4587600:
            case 4587602:
            case 4587632:
            case 4587633:
            case 4587636:
            case 4587648:
            case 4587671:
            case 4587672:
            case 4587776:
            case 4587777:
            case 4587778:
            case 4587792:
            case 4587793:
            case 4587794:
            case 4587795:
            case 4587798:
            case 4587809:
            case 4587810:
            case 4587811:
            case 4587812:
            case 4587845:
            case 4588039:
            case 4588048:
            case 4588049:
            case 4588053:
            case 4588056:
            case 4588100:
            case 4718600:
            case 4718848:
            case 4718853:
            case 4718856:
            case 4718864:
            case 4718880:
            case 4719104:
            case 4719111:
            case 4719130:
            case 5242896:
            case 5242898:
            case 5373974:
            case 5373989:
            case 5373991:
            case 5373993:
            case 5505042:
            case 5505043:
            case 5505046:
            case 5505058:
            case 5505074:
            case 5505106:
            case 5505122:
            case 5505123:
            case 5505138:
            case 5505568:
            case 5505570:
            case 5505792:
            case 5505794:
            case 5505796:
            case 5505798:
            case 5506064:
            case 5506066:
            case 5506068:
            case 6303744:
            case 6422530:
            case 6422531:
            case 6422535:
            case 6422538:
            case 6422543:
            case 6422545:
            case 6422546:
            case 6553602:
            case 6553605:
            case 6553615:
            case 6553616:
            case 6684674:
            case 6684689:
            case 6684690:
            case 6684691:
            case 6684710:
            case 6684711:
            case 6684712:
            case 6684715:
            case 6684717:
            case 6684718:
            case 6684719:
            case 6684720:
            case 6684724:
            case 6684725:
            case 6684929:
            case 6684930:
            case 6684932:
            case 6684936:
            case 6684961:
            case 6684964:
            case 6684976:
            case 6684978:
            case 6684979:
            case 6684980:
            case 6840866:
            case 6840868:
            case 6840869:
            case 6840880:
            case 6840928:
            case 6840933:
            case 6840992:
            case 6841024:
            case 6841056:
            case 6841072:
            case 6841120:
            case 6841184:
            case 6841248:
            case 6841252:
            case 6841256:
            case 6841260:
            case 6841264:
            case 6841312:
            case 6841344:
            case 6841392:
            case 6841456:
            case 6841600:
            case 6841616:
            case 6841632:
            case 6841669:
            case 6841680:
            case 6841760:
            case 6841824:
            case 6844419:
            case 7340033:
            case 7340040:
            case 7340041:
            case 7340122:
            case 7340128:
            case 7340166:
            case 7340167:
            case 7340553:
            case 7340593:
            case 7340594:
            case 7340595:
            case 7340596:
            case 7340679:
            case 7340808:
            case 7340809:
            case 7340810:
            case 7340813:
            case 7340817:
            case 7340820:
            case 7340824:
            case 7340828:
            case 7340830:
            case 7340831:
            case 7341058:
            case 7341060:
            case 7344388:
            case 7344641:
            case 7344650:
            case 7344897:
            case 7344900:
            case 7346177:
            case 7346179:
            case 7346181:
            case 7346182:
            case 7346433:
            case 7346435:
            case 7346437:
            case 7346692:
            case 7346696:
            case 7346945:
            case 7346947:
            case 7346948:
            case 7346961:
            case 7346962:
            case 7471116:
            case 7471118:
            case 7471122:
            case 7471136:
            case 7471138:
            case 7471152:
            case 7471166:
            case 7471232:
            case 7471362:
            case 7471616:
            case 7471632:
            case 7471636:
            case 7471872:
            case 7472128:
            case 7472162:
            case 7472164:
            case 7472167:
            case 7472176:
            case 7472640:
            case 7472901:
            case 7606274:
            case 7606279:
            case 7606280:
            case 7606286:
            case 7606304:
            case 7606320:
            case 7606336:
            case 7606338:
            case 7606340:
            case 7606342:
            case 7606344:
            case 7606346:
            case 7606348:
            case 7606350:
            case 7606352:
            case 7606800:
            case 7606802:
            case 7606806:
            case 7606816:
            case 7606820:
            case 7607297:
            case 7607301:
            case 7607305:
            case 7607309:
            case 7607310:
            case 7733256:
            case 7733260:
            case 7733262:
            case 7733264:
            case 7733280:
            case 7733298:
            case 7733300:
            case 7733312:
            case 7733344:
            case 7864358:
            case 7864360:
            case 7864362:
            case 7864432:
            case 7864496:
            case 7864500:
            case 8388609:
            case 8388610:
            case 8388611:
            case 8388616:
            case 8388626:
            case 8388627:
            case 8519684:
            case 8519685:
            case 8519687:
            case 8519692:
            case 8519696:
            case 8519703:
            case 8519713:
            case 8519714:
            case 8519732:
            case 8519733:
            case 8913408:
            case 67109889:
            case 67109890:
            case 67109891:
            case 67110144:
            case 67110224:
            case 67110225:
            case 67110241:
            case 536870942:
            case 536871074:
            case 536871076:
            case 536871080:
            case 536872192:
            case 536872208:
            case 537920768:
            case 537920784:
            case 537920800:
            case 538968336:
            case 538968337:
            case 538968368:
            case 538968384:
            case 541065232:
            case 541065248:
            case 541066496:
            case 542113808:
            case 542115072:
            case 553649408:
            case 555745360:
            case 555745392:
            case 556793872:
            case 556793877:
            case 556793904:
            case 556793920:
            case 556793936:
            case 556793952:
            case 556793984:
            case 556794016:
            case 556794048:
            case 570425357:
            case 805437488:
            case 805437504:
            case 805437520:
            case 805568528:
            case 805568592:
            case 805568608:
            case 805699600:
            case 805699602:
            case 805699604:
            case 805699606:
            case 805699608:
            case 805699616:
            case 805699632:
            case 805699639:
            case 805699641:
            case 805699648:
            case 805699712:
            case 805699718:
            case 805699744:
            case 805699760:
            case 805699766:
            case 805699769:
            case 805699776:
            case 805830672:
            case 805830688:
            case 805830689:
            case 805830704:
            case 805830720:
            case 805830721:
            case 805830736:
            case 805830752:
            case 805830760:
            case 805830768:
            case 805830784:
            case 805830800:
            case 805830816:
            case 805830832:
            case 805830848:
            case 805830864:
            case 805830880:
            case 805830896:
            case 805830898:
            case 805830900:
            case 805830902:
            case 805830912:
            case 805830928:
            case 805830944:
            case 805830960:
            case 805830976:
            case 805830992:
            case 805831008:
            case 805831025:
            case 805831027:
            case 805831200:
            case 805831232:
            case 805961744:
            case 805961792:
            case 805961800:
            case 805961840:
            case 805961868:
            case 805961904:
            case 805961910:
            case 805961930:
            case 805961937:
            case 805961955:
            case 805961972:
            case 805961991:
            case 805962001:
            case 805962006:
            case 805962010:
            case 805962112:
            case 805962128:
            case 805962144:
            case 805962164:
            case 805962246:
            case 805962256:
            case 805962288:
            case 805962336:
            case 805962368:
            case 805962416:
            case 805962448:
            case 805962474:
            case 805962508:
            case 805962516:
            case 805962546:
            case 805962562:
            case 805962592:
            case 805962608:
            case 805962624:
            case 805962656:
            case 805962658:
            case 805962660:
            case 805962662:
            case 805962664:
            case 805962666:
            case 805962668:
            case 805962753:
            case 805962768:
            case 805962784:
            case 805962801:
            case 805962817:
            case 805962832:
            case 805962835:
            case 805963013:
            case 805963014:
            case 806092802:
            case 806092804:
            case 806092810:
            case 806092832:
            case 806092864:
            case 806092866:
            case 806092880:
            case 806092885:
            case 806092896:
            case 806092928:
            case 806092976:
            case 806093042:
            case 806093073:
            case 806354945:
            case 806354947:
            case 806354948:
            case 806354951:
            case 806354952:
            case 806354953:
            case 806354954:
            case 806354961:
            case 806354962:
            case 806354964:
            case 806354966:
            case 806354968:
            case 806354969:
            case 806354977:
            case 806354979:
            case 806354980:
            case 806354981:
            case 806354982:
            case 806354983:
            case 806354984:
            case 806354986:
            case 806354987:
            case 806354988:
            case 806354990:
            case 806354992:
            case 806354994:
            case 806355012:
            case 806355017:
            case 806355018:
            case 806355019:
            case 806355022:
            case 806355029:
            case 806355031:
            case 806355035:
            case 806355037:
            case 806355039:
            case 806355040:
            case 806355042:
            case 806355044:
            case 806355045:
            case 806355047:
            case 806355049:
            case 806355050:
            case 806355051:
            case 806355052:
            case 806355053:
            case 806355056:
            case 806355057:
            case 806355062:
            case 806355064:
            case 806355065:
            case 806355072:
            case 806355073:
            case 806355074:
            case 806355079:
            case 806355080:
            case 1074266192:
            case 1074266385:
            case 1074266391:
            case 1074266392:
            case 1074790404:
            case 1074794497:
            case 1074794506:
            case 1074794513:
            case 1074794551:
            case 1074794552:
            case 1074794565:
            case 1074794567:
            case 1074794596:
            case 1074794607:
            case 1074794609:
            case 1074794610:
            case 1074794614:
            case 1074794615:
            case 1074794617:
            case 1074794619:
            case 1074794621:
            case 1342046209:
            case 1342187008:
            case 1375769129:
            case 1375769136:
            case 1409286400:
                return VR.SQ;
            case 1610265:
            case 1610806:
            case 1610807:
            case 1610808:
            case 1610809:
            case 1610816:
            case 1610818:
            case 1611032:
            case 1611033:
            case 1611792:
            case 2233426:
            case 2621553:
            case 2621700:
            case 2621701:
            case 2621702:
            case 2621703:
            case 2621704:
            case 2621705:
            case 2621712:
            case 2621713:
            case 2621728:
            case 2621729:
            case 2625601:
            case 2625792:
            case 2625793:
            case 2625794:
            case 2625795:
            case 2625809:
            case 2625810:
            case 2625811:
            case 2633730:
            case 2646304:
            case 2659587:
            case 4231697:
            case 4231702:
            case 4587829:
            case 5374000:
            case 6303748:
            case 6303750:
            case 7471164:
            case 7471230:
            case 805962502:
            case 1610612816:
                return VR.SS;
            case 524417:
            case 524434:
            case 524564:
            case 524565:
            case 524566:
            case 532753:
            case 533078:
            case 533080:
            case 1179729:
            case 1310755:
            case 1310756:
            case 1310757:
            case 1310760:
            case 1310786:
            case 1310788:
            case 1310789:
            case 1310981:
            case 1314832:
            case 1314880:
            case 1318936:
            case 1319430:
            case 1319458:
            case 1323042:
            case 1327188:
            case 1327190:
            case 1327196:
            case 1327218:
            case 1327259:
            case 1572922:
            case 1609856:
            case 1610117:
            case 1610611:
            case 1613827:
            case 2626385:
            case 2646416:
            case 4194944:
            case 4195088:
            case 4195667:
            case 4195670:
            case 4198658:
            case 4235626:
            case 4235812:
            case 4235927:
            case 4236090:
            case 4236115:
            case 4237714:
            case 4251649:
            case 4325392:
            case 4456449:
            case 4718855:
            case 5242913:
            case 6422534:
            case 6840960:
            case 6841157:
            case 7340038:
            case 7340552:
            case 7340815:
            case 7471214:
            case 7606278:
            case 7864336:
            case 8915206:
            case 537919504:
            case 537919824:
            case 805437444:
            case 805699590:
            case 805699624:
            case 805699720:
            case 805830674:
            case 805830758:
            case 805830772:
            case 805831170:
            case 805961732:
            case 805961742:
            case 805961923:
            case 805961949:
            case 805962134:
            case 805962150:
            case 805962162:
            case 805962170:
            case 805962192:
            case 805962754:
            case 805962786:
            case 806354959:
            case 806354967:
            case 806354999:
            case 806355011:
            case 806355036:
            case 1074266379:
            case 1074266880:
            case 1074282496:
            case 1074794616:
                return VR.ST;
            case 524307:
            case 524336:
            case 524337:
            case 524338:
            case 524339:
            case 524340:
            case 524341:
            case 1048626:
            case 1310979:
            case 1323127:
            case 1327228:
            case 1572903:
            case 1572917:
            case 1576980:
            case 1577026:
            case 1577027:
            case 1577074:
            case 1577075:
            case 1577473:
            case 1601550:
            case 2110469:
            case 3276851:
            case 3276853:
            case 3280897:
            case 3280913:
            case 3280961:
            case 3280977:
            case 3670043:
            case 3670045:
            case 3670049:
            case 3670066:
            case 4194307:
            case 4194309:
            case 4194885:
            case 4194897:
            case 4202501:
            case 4235300:
            case 4235538:
            case 4235554:
            case 4235667:
            case 7340163:
            case 7471211:
            case 553648208:
            case 805699593:
            case 805830693:
            case 805831012:
            case 805831016:
            case 805831249:
            case 805961735:
            case 805962286:
            case 806223877:
            case 806355077:
            case 1074266369:
            case 1074266377:
            case 1074266387:
                return VR.TM;
            case 524569:
            case 525068:
            case 525069:
            case 1049106:
            case 1049122:
            case 1441800:
            case 1441804:
            case 1610599:
            case 1610609:
            case 1612040:
            case 1612042:
            case 7471215:
            case 806354971:
                return VR.UC;
            case 2:
            case 3:
            case 4096:
            case 4097:
            case 131074:
            case 131075:
            case 131088:
            case 131090:
            case 131328:
            case 267314:
            case 267536:
            case 267537:
            case 267538:
            case 267546:
            case 524308:
            case 524310:
            case 524312:
            case 524314:
            case 524315:
            case 524376:
            case 524386:
            case 524556:
            case 524557:
            case 524567:
            case 524568:
            case 528720:
            case 528725:
            case 528730:
            case 528743:
            case 528789:
            case 536592:
            case 536594:
            case 561443:
            case 1576962:
            case 1581122:
            case 1612062:
            case 2097165:
            case 2097166:
            case 2097234:
            case 2097664:
            case 2097730:
            case 2134369:
            case 2134372:
            case 2134802:
            case 2134803:
            case 2622212:
            case 2625945:
            case 2626068:
            case 4195668:
            case 4210723:
            case 4235297:
            case 4235298:
            case 4235556:
            case 4235633:
            case 4235634:
            case 4236290:
            case 4250380:
            case 4250381:
            case 4251665:
            case 4251696:
            case 4251697:
            case 4456706:
            case 4456712:
            case 6422561:
            case 6553603:
            case 7340826:
            case 7340827:
            case 7344385:
            case 7344386:
            case 7344649:
            case 7346436:
            case 7471231:
            case 8913216:
            case 67108880:
            case 67109120:
            case 67110160:
            case 805699620:
            case 805699778:
            case 805961747:
            case 805961859:
            case 806354950:
            case 806354955:
            case 806354963:
            case 806354965:
            case 806354975:
            case 806354993:
            case 806355003:
            case 806355026:
            case 806355027:
            case 806355054:
            case 806355055:
                return VR.UI;
            case 0:
            case 1:
            case 131072:
            case 266752:
            case 266754:
            case 267264:
            case 267296:
            case 267524:
            case 267776:
            case 524289:
            case 525065:
            case 525067:
            case 528737:
            case 528738:
            case 1577070:
            case 1597462:
            case 1597464:
            case 1597466:
            case 1597468:
            case 1597470:
            case 1597488:
            case 1597490:
            case 1597496:
            case 1597498:
            case 1597500:
            case 1597502:
            case 1597504:
            case 1597506:
            case 1597510:
            case 1597512:
            case 1597514:
            case 1597520:
            case 1597522:
            case 1597526:
            case 1597528:
            case 1609877:
            case 1610023:
            case 1610073:
            case 1610292:
            case 1610328:
            case 1610335:
            case 2134103:
            case 2134312:
            case 2134359:
            case 2134568:
            case 2233648:
            case 2233922:
            case 2233944:
            case 2658305:
            case 2658306:
            case 3801104:
            case 4235570:
            case 4235619:
            case 4250483:
            case 4325397:
            case 4718598:
            case 4718599:
            case 4719362:
            case 4719363:
            case 6303776:
            case 6553607:
            case 6684673:
            case 6684675:
            case 6684693:
            case 6684702:
            case 6684714:
            case 6684716:
            case 6684933:
            case 7340582:
            case 7340629:
            case 7340693:
            case 7345420:
            case 7471224:
            case 7606356:
            case 7607076:
            case 8519686:
            case 1342185478:
            case 1342185480:
            case 1342185482:
                return VR.UL;
            case 524558:
            case 524576:
            case 528784:
            case 2654176:
            case 4210803:
            case 4251664:
            case 7471217:
            case 7606282:
                return VR.UR;
            case 256:
            case 272:
            case 288:
            case 1792:
            case 2048:
            case 2128:
            case 2144:
            case 2304:
            case 2307:
            case 4098:
            case 4104:
            case 4128:
            case 4129:
            case 4130:
            case 4131:
            case 4145:
            case 20912:
            case 266770:
            case 267280:
            case 524352:
            case 525057:
            case 525060:
            case 525062:
            case 525064:
            case 528790:
            case 528791:
            case 1048616:
            case 1057216:
            case 1327122:
            case 1331456:
            case 1441809:
            case 1441810:
            case 1441811:
            case 1441812:
            case 1441813:
            case 1441814:
            case 1441818:
            case 1441831:
            case 1441832:
            case 1441849:
            case 1441850:
            case 1441851:
            case 1441857:
            case 1441858:
            case 1441859:
            case 1441862:
            case 1441863:
            case 1441864:
            case 1441865:
            case 1441866:
            case 1441868:
            case 1441909:
            case 1577068:
            case 1577540:
            case 1577744:
            case 1577988:
            case 1578530:
            case 1578531:
            case 1578532:
            case 1597458:
            case 1597460:
            case 1597476:
            case 1597478:
            case 1597508:
            case 1597516:
            case 1597518:
            case 1609816:
            case 1609830:
            case 1609875:
            case 1610289:
            case 1610290:
            case 1610304:
            case 1610305:
            case 1610323:
            case 1610551:
            case 1610598:
            case 1610603:
            case 1610608:
            case 1610614:
            case 1610615:
            case 1610616:
            case 1610618:
            case 1610817:
            case 1611561:
            case 1611577:
            case 1611584:
            case 1612053:
            case 1612065:
            case 1612088:
            case 1612089:
            case 1612090:
            case 2134358:
            case 2134370:
            case 2134371:
            case 2135320:
            case 2135350:
            case 2228225:
            case 2228226:
            case 2228227:
            case 2228228:
            case 2359349:
            case 2359350:
            case 2359352:
            case 2359362:
            case 2359368:
            case 2359376:
            case 2359382:
            case 2359392:
            case 2621442:
            case 2621443:
            case 2621445:
            case 2621446:
            case 2621456:
            case 2621457:
            case 2621458:
            case 2621460:
            case 2621544:
            case 2621545:
            case 2621552:
            case 2621568:
            case 2621569:
            case 2621570:
            case 2621585:
            case 2621586:
            case 2621587:
            case 2621588:
            case 2621696:
            case 2621697:
            case 2621698:
            case 2621699:
            case 2621952:
            case 2622466:
            case 2623248:
            case 2623264:
            case 2623266:
            case 2623280:
            case 2623296:
            case 2623490:
            case 2623492:
            case 2625796:
            case 2626563:
            case 2626567:
            case 2646032:
            case 2646048:
            case 2646064:
            case 2646080:
            case 2646274:
            case 2646288:
            case 2646290:
            case 2650113:
            case 2650114:
            case 2650115:
            case 2650121:
            case 2650123:
            case 2650126:
            case 2650135:
            case 2650139:
            case 2658457:
            case 2659350:
            case 2659590:
            case 2659591:
            case 3801093:
            case 3801626:
            case 3801649:
            case 3801665:
            case 3801668:
            case 4195072:
            case 4195073:
            case 4195074:
            case 4195075:
            case 4235440:
            case 4235574:
            case 4235648:
            case 4718611:
            case 4718613:
            case 4719105:
            case 4719106:
            case 5373970:
            case 5374006:
            case 5374008:
            case 5505040:
            case 5505041:
            case 5505056:
            case 5505057:
            case 5505072:
            case 5505073:
            case 5505075:
            case 5505104:
            case 5505105:
            case 5505107:
            case 5505120:
            case 5505121:
            case 5505136:
            case 5505137:
            case 5505152:
            case 5505153:
            case 5505168:
            case 5505280:
            case 5505281:
            case 5505553:
            case 5505800:
            case 5509936:
            case 6303746:
            case 6303752:
            case 6422532:
            case 6422539:
            case 6422540:
            case 6422541:
            case 6422542:
            case 6684703:
            case 6841040:
            case 6841104:
            case 6841136:
            case 6841168:
            case 6841280:
            case 6841328:
            case 6841360:
            case 6841408:
            case 6841648:
            case 7340064:
            case 7340065:
            case 7340098:
            case 7340112:
            case 7340113:
            case 7340134:
            case 7340135:
            case 7340609:
            case 7340615:
            case 7340625:
            case 7340626:
            case 7341057:
            case 7344387:
            case 7344643:
            case 7344645:
            case 7344647:
            case 7344652:
            case 7344905:
            case 7346180:
            case 7346183:
            case 7346946:
            case 7471124:
            case 7471144:
            case 7471154:
            case 7471160:
            case 7471226:
            case 7471360:
            case 7471364:
            case 7471366:
            case 7471370:
            case 7471372:
            case 7471374:
            case 7471618:
            case 7471620:
            case 7471634:
            case 7471638:
            case 7471640:
            case 7471874:
            case 7471878:
            case 7471880:
            case 7471892:
            case 7471896:
            case 7471904:
            case 7472160:
            case 7472161:
            case 7472178:
            case 7733333:
            case 7733360:
            case 7733376:
            case 7733392:
            case 7733408:
            case 7733424:
            case 7733440:
            case 7864366:
            case 7864502:
            case 7864504:
            case 8388614:
            case 8388615:
            case 67108869:
            case 268435456:
            case 268435457:
            case 268435458:
            case 268435459:
            case 268435460:
            case 268435461:
            case 269484032:
            case 536871072:
            case 536871073:
            case 537919776:
            case 537919792:
            case 537919838:
            case 537919840:
            case 538968080:
            case 540016656:
            case 541065233:
            case 541065332:
            case 570425355:
            case 805699767:
            case 805830759:
            case 805831026:
            case 805962819:
            case 806354957:
            case 806354976:
            case 806354978:
            case 806354985:
            case 806355001:
            case 806355002:
            case 806355004:
            case 806355005:
            case 806355006:
            case 806355007:
            case 806355008:
            case 806355009:
            case 806355010:
            case 806355032:
            case 806355038:
            case 806355046:
            case 806355069:
            case 806355070:
            case 1074794512:
            case 1074794547:
            case 1074794548:
            case 1342177285:
            case 1342177296:
            case 1342177539:
            case 1342177540:
            case 1342177541:
            case 1342177552:
            case 1342177554:
            case 1342177556:
            case 1342185472:
            case 1342185474:
            case 1342185476:
            case 1342187024:
            case 1409290244:
            case 1610612752:
            case 1610612753:
            case 1610612754:
            case 1610612817:
            case 1610612818:
            case 1610612840:
            case 1610612841:
            case 1610612992:
            case 1610612994:
            case 1610613248:
            case 1610614786:
            case 1610614788:
            case 1610617088:
            case 1610617089:
            case 1610617090:
            case 1610617091:
            case 1610617344:
            case 1610617345:
            case 1610617346:
            case 1610617347:
            case 2130706449:
                return VR.US;
            case 525070:
            case 525071:
            case 1049112:
            case 1441795:
            case 1441815:
            case 1441824:
            case 1441869:
            case 1441871:
            case 1441872:
            case 1441873:
            case 1441912:
            case 1441922:
            case 1576969:
            case 1610619:
            case 1610623:
            case 1612033:
            case 1612047:
            case 1612048:
            case 1612055:
            case 1612058:
            case 1612067:
            case 1612068:
            case 1612097:
            case 3280998:
            case 4194353:
            case 4194354:
            case 4195842:
            case 4235616:
            case 4456710:
            case 6422560:
            case 6684935:
            case 7471216:
            case 8519683:
            case 8519690:
            case 8519731:
            case 8519735:
            case 570425346:
            case 806354956:
            case 806355034:
            case 806355041:
            case 806355066:
            case 806355067:
            case 806355071:
                return VR.UT;
        }
        switch (tag & 0xFF0F) {
            case 2622467:
                return VR.AT;
            case 2622466:
                return VR.LO;
            case 2622464:
            case 2622465:
                return VR.US;
        }
        return VR.UN;
    }
}
