/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.aoju.bus.image.Tag;
import org.aoju.bus.image.UID;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.data.DatePrecision;

public class Format
extends java.text.Format {
    public static final Date[] EMPTY_DATES = new Date[0];
    private static final char[] CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v'};
    private static final int LONG_BYTES = 8;
    private static TimeZone cachedTimeZone;
    private final String pattern;
    private final int[][] tagPaths;
    private final int[] index;
    private final Type[] types;
    private final MessageFormat format;

    public Format(String pattern) {
        List<String> tokens = this.tokenize(pattern);
        int n = tokens.size() / 2;
        this.pattern = pattern;
        this.tagPaths = new int[n][];
        this.index = new int[n];
        this.types = new Type[n];
        this.format = this.buildMessageFormat(tokens);
    }

    public static Format valueOf(String s) {
        return s != null ? new Format(s) : null;
    }

    private static Calendar cal(TimeZone tz) {
        GregorianCalendar cal = tz != null ? new GregorianCalendar(tz) : new GregorianCalendar();
        cal.clear();
        return cal;
    }

    private static Calendar cal(TimeZone tz, Date date) {
        GregorianCalendar cal = tz != null ? new GregorianCalendar(tz) : new GregorianCalendar();
        cal.setTime(date);
        return cal;
    }

    private static void ceil(Calendar cal, int field) {
        cal.add(field, 1);
        cal.add(14, -1);
    }

    public static String formatDA(TimeZone tz, Date date) {
        return Format.formatDA(tz, date, new StringBuilder(8)).toString();
    }

    public static StringBuilder formatDA(TimeZone tz, Date date, StringBuilder toAppendTo) {
        return Format.formatDT(Format.cal(tz, date), toAppendTo, 5);
    }

    public static String formatTM(TimeZone tz, Date date) {
        return Format.formatTM(tz, date, new DatePrecision());
    }

    public static String formatTM(TimeZone tz, Date date, DatePrecision precision) {
        return Format.formatTM(Format.cal(tz, date), new StringBuilder(10), precision.lastField).toString();
    }

    private static StringBuilder formatTM(Calendar cal, StringBuilder toAppendTo, int lastField) {
        Format.appendXX(cal.get(11), toAppendTo);
        if (lastField > 11) {
            Format.appendXX(cal.get(12), toAppendTo);
            if (lastField > 12) {
                Format.appendXX(cal.get(13), toAppendTo);
                if (lastField > 13) {
                    toAppendTo.append('.');
                    Format.appendXXX(cal.get(14), toAppendTo);
                }
            }
        }
        return toAppendTo;
    }

    public static String formatDT(TimeZone tz, Date date) {
        return Format.formatDT(tz, date, new DatePrecision());
    }

    public static String formatDT(TimeZone tz, Date date, DatePrecision precision) {
        return Format.formatDT(tz, date, new StringBuilder(23), precision).toString();
    }

    public static StringBuilder formatDT(TimeZone tz, Date date, StringBuilder toAppendTo, DatePrecision precision) {
        Calendar cal = Format.cal(tz, date);
        Format.formatDT(cal, toAppendTo, precision.lastField);
        if (precision.includeTimezone) {
            int offset = cal.get(15) + cal.get(16);
            Format.appendZZZZZ(offset, toAppendTo);
        }
        return toAppendTo;
    }

    private static StringBuilder appendZZZZZ(int offset, StringBuilder sb) {
        if (offset < 0) {
            offset = -offset;
            sb.append('-');
        } else {
            sb.append('+');
        }
        int min = offset / 60000;
        Format.appendXX(min / 60, sb);
        Format.appendXX(min % 60, sb);
        return sb;
    }

    public static String formatTimezoneOffsetFromUTC(TimeZone tz) {
        return Format.appendZZZZZ(tz.getRawOffset(), new StringBuilder(5)).toString();
    }

    public static String formatTimezoneOffsetFromUTC(TimeZone tz, Date date) {
        return Format.appendZZZZZ(tz.getOffset(date == null ? System.currentTimeMillis() : date.getTime()), new StringBuilder(5)).toString();
    }

    private static StringBuilder formatDT(Calendar cal, StringBuilder toAppendTo, int lastField) {
        Format.appendXXXX(cal.get(1), toAppendTo);
        if (lastField > 1) {
            Format.appendXX(cal.get(2) + 1, toAppendTo);
            if (lastField > 2) {
                Format.appendXX(cal.get(5), toAppendTo);
                if (lastField > 5) {
                    Format.formatTM(cal, toAppendTo, lastField);
                }
            }
        }
        return toAppendTo;
    }

    private static void appendXXXX(int i, StringBuilder toAppendTo) {
        if (i < 1000) {
            toAppendTo.append('0');
        }
        Format.appendXXX(i, toAppendTo);
    }

    private static void appendXXX(int i, StringBuilder toAppendTo) {
        if (i < 100) {
            toAppendTo.append('0');
        }
        Format.appendXX(i, toAppendTo);
    }

    private static void appendXX(int i, StringBuilder toAppendTo) {
        if (i < 10) {
            toAppendTo.append('0');
        }
        toAppendTo.append(i);
    }

    public static Date parseDA(TimeZone tz, String s) {
        return Format.parseDA(tz, s, false);
    }

    public static Date parseDA(TimeZone tz, String s, boolean ceil) {
        Calendar cal = Format.cal(tz);
        int length = s.length();
        if (length != 8 && (length != 10 || Character.isDigit(s.charAt(4)))) {
            throw new IllegalArgumentException(s);
        }
        try {
            int pos = 0;
            cal.set(1, Integer.parseInt(s.substring(pos, pos + 4)));
            if (!Character.isDigit(s.charAt(pos += 4))) {
                ++pos;
            }
            cal.set(2, Integer.parseInt(s.substring(pos, pos + 2)) - 1);
            if (!Character.isDigit(s.charAt(pos += 2))) {
                ++pos;
            }
            cal.set(5, Integer.parseInt(s.substring(pos)));
            if (ceil) {
                Format.ceil(cal, 5);
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(s);
        }
        return cal.getTime();
    }

    public static Date parseTM(TimeZone tz, String s, DatePrecision precision) {
        return Format.parseTM(tz, s, false, precision);
    }

    public static Date parseTM(TimeZone tz, String s, boolean ceil, DatePrecision precision) {
        return Format.parseTM(Format.cal(tz), s, ceil, precision);
    }

    private static Date parseTM(Calendar cal, String s, boolean ceil, DatePrecision precision) {
        int pos = 0;
        int length = s.length();
        if (pos + 2 > length) {
            throw new IllegalArgumentException(s);
        }
        try {
            precision.lastField = 11;
            cal.set(11, Integer.parseInt(s.substring(pos, pos + 2)));
            if ((pos += 2) < length) {
                if (!Character.isDigit(s.charAt(pos))) {
                    ++pos;
                }
                if (pos + 2 > length) {
                    throw new IllegalArgumentException(s);
                }
                precision.lastField = 12;
                cal.set(12, Integer.parseInt(s.substring(pos, pos + 2)));
                if ((pos += 2) < length) {
                    if (!Character.isDigit(s.charAt(pos))) {
                        ++pos;
                    }
                    if (pos + 2 > length) {
                        throw new IllegalArgumentException(s);
                    }
                    precision.lastField = 13;
                    cal.set(13, Integer.parseInt(s.substring(pos, pos + 2)));
                    if ((pos += 2) < length) {
                        float f = Float.parseFloat(s.substring(pos));
                        if (f >= 1.0f || f < 0.0f) {
                            throw new IllegalArgumentException(s);
                        }
                        precision.lastField = 14;
                        cal.set(14, (int)(f * 1000.0f));
                        return cal.getTime();
                    }
                }
            }
            if (ceil) {
                Format.ceil(cal, precision.lastField);
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(s);
        }
        return cal.getTime();
    }

    public static Date parseDT(TimeZone tz, String s, DatePrecision precision) {
        return Format.parseDT(tz, s, false, precision);
    }

    public static TimeZone timeZone(String s) {
        TimeZone tz;
        if (s.length() != 5 || (tz = Format.safeTimeZone(s)) == null) {
            throw new IllegalArgumentException("Illegal Timezone Offset: " + s);
        }
        return tz;
    }

    private static TimeZone safeTimeZone(String s) {
        String tzid = Format.tzid(s);
        if (tzid == null) {
            return null;
        }
        TimeZone tz = cachedTimeZone;
        if (tz == null || !tz.getID().equals(tzid)) {
            cachedTimeZone = tz = TimeZone.getTimeZone(tzid);
        }
        return tz;
    }

    private static String tzid(String s) {
        int length = s.length();
        if (length > 4) {
            char[] tzid = new char[]{'G', 'M', 'T', '\u0000', '\u0000', '\u0000', ':', '\u0000', '\u0000'};
            s.getChars(length - 5, length - 2, tzid, 3);
            s.getChars(length - 2, length, tzid, 7);
            if ((tzid[3] == '+' || tzid[3] == '-') && Character.isDigit(tzid[4]) && Character.isDigit(tzid[5]) && Character.isDigit(tzid[7]) && Character.isDigit(tzid[8])) {
                return new String(tzid);
            }
        }
        return null;
    }

    public static Date parseDT(TimeZone tz, String s, boolean ceil, DatePrecision precision) {
        int length = s.length();
        TimeZone tz1 = Format.safeTimeZone(s);
        precision.includeTimezone = tz1 != null;
        if (precision.includeTimezone) {
            length -= 5;
            tz = tz1;
        }
        Calendar cal = Format.cal(tz);
        try {
            int pos = 0;
            if (pos + 4 > length) {
                throw new IllegalArgumentException(s);
            }
            precision.lastField = 1;
            cal.set(1, Integer.parseInt(s.substring(pos, pos + 4)));
            if ((pos += 4) < length) {
                if (!Character.isDigit(s.charAt(pos))) {
                    ++pos;
                }
                if (pos + 2 > length) {
                    throw new IllegalArgumentException(s);
                }
                precision.lastField = 2;
                cal.set(2, Integer.parseInt(s.substring(pos, pos + 2)) - 1);
                if ((pos += 2) < length) {
                    if (!Character.isDigit(s.charAt(pos))) {
                        ++pos;
                    }
                    if (pos + 2 > length) {
                        throw new IllegalArgumentException(s);
                    }
                    precision.lastField = 5;
                    cal.set(5, Integer.parseInt(s.substring(pos, pos + 2)));
                    if ((pos += 2) < length) {
                        return Format.parseTM(cal, s.substring(pos, length), ceil, precision);
                    }
                }
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(s);
        }
        if (ceil) {
            Format.ceil(cal, precision.lastField);
        }
        return cal.getTime();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<String> tokenize(String s) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer stk = new StringTokenizer(s, "{}", true);
        int prevDelim = 125;
        int level = 0;
        StringBuilder sb = new StringBuilder();
        while (stk.hasMoreTokens()) {
            String tk = stk.nextToken();
            char delim = tk.charAt(0);
            if (delim == '{') {
                if (level++ == 0) {
                    if (prevDelim == 125) {
                        result.add("");
                    }
                } else {
                    sb.append(delim);
                }
            } else if (delim == '}') {
                if (--level == 0) {
                    result.add(sb.toString());
                    sb.setLength(0);
                } else {
                    if (level <= 0) throw new IllegalArgumentException(s);
                    sb.append(delim);
                }
            } else if (level == 0) {
                result.add(tk);
            } else {
                sb.append(tk);
            }
            prevDelim = delim;
        }
        return result;
    }

    private MessageFormat buildMessageFormat(List<String> tokens) {
        StringBuilder formatBuilder = new StringBuilder(this.pattern.length());
        int j = 0;
        for (int i = 0; i < this.tagPaths.length; ++i) {
            formatBuilder.append(tokens.get(j++)).append('{').append(i);
            String tagStr = tokens.get(j++);
            int typeStart = tagStr.indexOf(44) + 1;
            boolean rnd = tagStr.startsWith("rnd");
            if (!rnd && !tagStr.startsWith("now")) {
                int tagStrLen = typeStart != 0 ? typeStart - 1 : tagStr.length();
                int indexStart = tagStr.charAt(tagStrLen - 1) == ']' ? tagStr.lastIndexOf(91, tagStrLen - 3) + 1 : 0;
                try {
                    this.tagPaths[i] = Tag.parseTagPath(tagStr.substring(0, indexStart != 0 ? indexStart - 1 : tagStrLen));
                    if (indexStart != 0) {
                        this.index[i] = Integer.parseInt(tagStr.substring(indexStart, tagStrLen - 1));
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(this.pattern);
                }
            }
            if (typeStart != 0) {
                int typeEnd = tagStr.indexOf(44, typeStart);
                try {
                    this.types[i] = Type.valueOf(tagStr.substring(typeStart, typeEnd < 0 ? tagStr.length() : typeEnd));
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(this.pattern);
                }
                switch (this.types[i]) {
                    case number: 
                    case date: 
                    case time: 
                    case choice: {
                        formatBuilder.append(typeStart > 0 ? tagStr.substring(typeStart - 1) : tagStr);
                    }
                }
            } else {
                this.types[i] = Type.none;
            }
            if (rnd) {
                switch (this.types[i]) {
                    case none: {
                        this.types[i] = Type.rnd;
                    }
                    case uuid: 
                    case uid: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(this.pattern);
                    }
                }
            }
            formatBuilder.append('}');
        }
        if (j < tokens.size()) {
            formatBuilder.append(tokens.get(j));
        }
        try {
            return new MessageFormat(formatBuilder.toString());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(this.pattern);
        }
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer result, FieldPosition pos) {
        return this.format.format(this.toArgs((Attributes)obj), result, pos);
    }

    private Object[] toArgs(Attributes attrs) {
        Object[] args = new Object[this.tagPaths.length];
        for (int i = 0; i < args.length; ++i) {
            int[] tagPath = this.tagPaths[i];
            if (tagPath == null) {
                args[i] = this.types[i].toArg(attrs, 0, this.index[i]);
                continue;
            }
            int last = tagPath.length - 1;
            Attributes item = attrs;
            for (int j = 0; j < last && item != null; item = item.getNestedDataset(tagPath[j]), ++j) {
            }
            args[i] = item != null ? this.types[i].toArg(item, tagPath[last], this.index[i]) : null;
        }
        return args;
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.pattern;
    }

    private static enum Type {
        none{

            @Override
            Object toArg(Attributes attrs, int tag, int index) {
                return attrs.getString(tag, index);
            }
        }
        ,
        number{

            @Override
            Object toArg(Attributes attrs, int tag, int index) {
                return attrs.getDouble(tag, index, 0.0);
            }
        }
        ,
        date{

            @Override
            Object toArg(Attributes attrs, int tag, int index) {
                return tag != 0 ? attrs.getDate(tag, index) : new Date();
            }
        }
        ,
        time{

            @Override
            Object toArg(Attributes attrs, int tag, int index) {
                return tag != 0 ? attrs.getDate(tag, index) : new Date();
            }
        }
        ,
        choice{

            @Override
            Object toArg(Attributes attrs, int tag, int index) {
                return attrs.getDouble(tag, index, 0.0);
            }
        }
        ,
        hash{

            @Override
            Object toArg(Attributes attrs, int tag, int index) {
                String s = attrs.getString(tag, index);
                return s != null ? Tag.toHexString(s.hashCode()) : null;
            }
        }
        ,
        md5{

            @Override
            Object toArg(Attributes attrs, int tag, int index) {
                String s = attrs.getString(tag, index);
                return s != null ? this.getMD5String(s) : null;
            }
        }
        ,
        urlencoded{

            @Override
            Object toArg(Attributes attrs, int tag, int index) {
                String s = attrs.getString(tag, index);
                try {
                    return s != null ? URLEncoder.encode(s, "UTF-8") : null;
                }
                catch (UnsupportedEncodingException e) {
                    throw new AssertionError((Object)e);
                }
            }
        }
        ,
        rnd{

            @Override
            Object toArg(Attributes attrs, int tag, int index) {
                return Tag.toHexString(ThreadLocalRandom.current().nextInt());
            }
        }
        ,
        uuid{

            @Override
            Object toArg(Attributes attrs, int tag, int index) {
                return UUID.randomUUID();
            }
        }
        ,
        uid{

            @Override
            Object toArg(Attributes attrs, int tag, int index) {
                return UID.createUID();
            }
        };


        static String toString32(byte[] ba) {
            int i;
            long l1 = Type.toLong(ba, 0);
            long l2 = Type.toLong(ba, 8);
            char[] ca = new char[26];
            for (i = 0; i < 12; ++i) {
                ca[i] = CHARS[(int)l1 & 0x1F];
                l1 >>>= 5;
            }
            ca[12] = CHARS[(int)(l1 |= (l2 & 1L) << 4) & 0x1F];
            l2 >>>= 1;
            for (i = 13; i < 26; ++i) {
                ca[i] = CHARS[(int)l2 & 0x1F];
                l2 >>>= 5;
            }
            return new String(ca);
        }

        static long toLong(byte[] ba, int offset) {
            long l = 0L;
            int len = offset + 8;
            for (int i = offset; i < len; ++i) {
                l |= (long)(ba[i] & 0xFF);
                l <<= 8;
            }
            return l;
        }

        abstract Object toArg(Attributes var1, int var2, int var3);

        String getMD5String(String s) {
            try {
                MessageDigest digest = MessageDigest.getInstance("MD5");
                digest.update(s == null ? new byte[]{} : s.getBytes(StandardCharsets.UTF_8));
                return Type.toString32(digest.digest());
            }
            catch (NoSuchAlgorithmException e) {
                return s;
            }
        }
    }
}

