/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.nimble;

import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import org.aoju.bus.core.toolkit.ByteKit;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.data.VR;
import org.aoju.bus.image.nimble.ByteLookupTable;
import org.aoju.bus.image.nimble.LookupTable;
import org.aoju.bus.image.nimble.ShortLookupTable;
import org.aoju.bus.image.nimble.StoredValue;

public class LookupTableFactory {
    private final StoredValue storedValue;
    private float rescaleSlope = 1.0f;
    private float rescaleIntercept = 0.0f;
    private LookupTable modalityLUT;
    private float windowCenter;
    private float windowWidth;
    private LookupTable voiLUT;
    private LookupTable presentationLUT;
    private boolean inverse;

    public LookupTableFactory(StoredValue storedValue) {
        this.storedValue = storedValue;
    }

    static byte[] halfLength(byte[] data, int hilo) {
        byte[] bs = new byte[data.length >> 1];
        for (int i = 0; i < bs.length; ++i) {
            bs[i] = data[i << 1 | hilo];
        }
        return bs;
    }

    private static int log2(int value) {
        int i = 0;
        while (value >>> i != 0) {
            ++i;
        }
        return i - 1;
    }

    public void setModalityLUT(Attributes attrs) {
        this.rescaleIntercept = attrs.getFloat(2625618, 0.0f);
        this.rescaleSlope = attrs.getFloat(2625619, 1.0f);
        this.modalityLUT = this.createLUT(this.storedValue, attrs.getNestedDataset(2633728));
    }

    public void setPresentationLUT(Attributes attrs) {
        Attributes pLUT = attrs.getNestedDataset(542113808);
        if (pLUT != null) {
            int[] desc = pLUT.getInts(2633730);
            if (desc != null && desc.length == 3) {
                int len = desc[0] == 0 ? 65536 : desc[0];
                this.presentationLUT = this.createLUT(new StoredValue.Unsigned(LookupTableFactory.log2(len)), this.resetOffset(desc), pLUT.getSafeBytes(2633734), pLUT.bigEndian());
            }
        } else {
            String pShape = attrs.getString(0x20500020);
            this.inverse = pShape != null ? "INVERSE".equals(pShape) : "MONOCHROME1".equals(attrs.getString(2621444));
        }
    }

    private int[] resetOffset(int[] desc) {
        if (desc[1] == 0) {
            return desc;
        }
        int[] copy = (int[])desc.clone();
        copy[1] = 0;
        return copy;
    }

    public void setWindowCenter(float windowCenter) {
        this.windowCenter = windowCenter;
    }

    public void setWindowWidth(float windowWidth) {
        this.windowWidth = windowWidth;
    }

    public void setVOI(Attributes img, int windowIndex, int voiLUTIndex, boolean preferWindow) {
        if (img == null) {
            return;
        }
        Attributes vLUT = img.getNestedDataset(2633744, voiLUTIndex);
        if (preferWindow || vLUT == null) {
            float[] wcs = img.getFloats(2625616);
            float[] wws = img.getFloats(2625617);
            if (wcs != null && wcs.length != 0 && wws != null && wws.length != 0) {
                int index = windowIndex < Math.min(wcs.length, wws.length) ? windowIndex : 0;
                this.windowCenter = wcs[index];
                this.windowWidth = wws[index];
                return;
            }
        }
        if (vLUT != null) {
            this.adjustVOILUTDescriptor(vLUT);
            this.voiLUT = this.createLUT(this.modalityLUT != null ? new StoredValue.Unsigned(this.modalityLUT.outBits) : this.storedValue, vLUT);
        }
    }

    private void adjustVOILUTDescriptor(Attributes vLUT) {
        byte[] data;
        int[] desc = vLUT.getInts(2633730);
        if (desc != null && desc.length == 3 && desc[2] == 16 && (data = vLUT.getSafeBytes(2633734)) != null) {
            int i;
            int hiByte = 0;
            int n = i = vLUT.bigEndian() ? 0 : 1;
            while (i < data.length) {
                hiByte |= data[i];
                ++i;
                ++i;
            }
            if ((hiByte & 0x80) == 0) {
                desc[2] = 40 - Integer.numberOfLeadingZeros(hiByte & 0xFF);
                vLUT.setInt(2633730, VR.SS, desc);
            }
        }
    }

    private LookupTable createLUT(StoredValue inBits, Attributes attrs) {
        if (attrs == null) {
            return null;
        }
        return this.createLUT(inBits, attrs.getInts(2633730), attrs.getSafeBytes(2633734), attrs.bigEndian());
    }

    private LookupTable createLUT(StoredValue inBits, int[] desc, byte[] data, boolean bigEndian) {
        if (desc == null) {
            return null;
        }
        if (desc.length != 3) {
            return null;
        }
        int len = desc[0] == 0 ? 65536 : desc[0];
        short offset = (short)desc[1];
        int outBits = desc[2];
        if (data == null) {
            return null;
        }
        if (data.length == len << 1) {
            if (outBits > 8) {
                if (outBits > 16) {
                    return null;
                }
                short[] ss = new short[len];
                if (bigEndian) {
                    for (int i = 0; i < ss.length; ++i) {
                        ss[i] = (short)ByteKit.bytesToShortBE((byte[])data, (int)(i << 1));
                    }
                } else {
                    for (int i = 0; i < ss.length; ++i) {
                        ss[i] = (short)ByteKit.bytesToShortLE((byte[])data, (int)(i << 1));
                    }
                }
                return new ShortLookupTable(inBits, outBits, offset, ss);
            }
            data = LookupTableFactory.halfLength(data, bigEndian ? 1 : 0);
        }
        if (data.length != len) {
            return null;
        }
        if (outBits > 8) {
            return null;
        }
        return new ByteLookupTable(inBits, outBits, offset, data);
    }

    public LookupTable createLUT(int outBits) {
        LookupTable lut = this.combineModalityVOILUT(this.presentationLUT != null ? LookupTableFactory.log2(this.presentationLUT.length()) : outBits);
        if (this.presentationLUT != null) {
            lut = lut.combine(this.presentationLUT.adjustOutBits(outBits));
        } else if (this.inverse) {
            lut.inverse();
        }
        return lut;
    }

    private LookupTable combineModalityVOILUT(int outBits) {
        float m = this.rescaleSlope;
        float b = this.rescaleIntercept;
        LookupTable modalityLUT = this.modalityLUT;
        LookupTable lut = this.voiLUT;
        if (lut == null) {
            int offset;
            int size;
            StoredValue inBits;
            float c = this.windowCenter;
            float w = this.windowWidth;
            if (w == 0.0f && modalityLUT != null) {
                return modalityLUT.adjustOutBits(outBits);
            }
            StoredValue storedValue = inBits = modalityLUT != null ? new StoredValue.Unsigned(modalityLUT.outBits) : this.storedValue;
            if (w != 0.0f) {
                size = Math.max(2, Math.abs(Math.round(w / m)));
                offset = Math.round((c - b) / m) - size / 2;
            } else {
                offset = inBits.minValue();
                size = inBits.maxValue() - inBits.minValue() + 1;
            }
            lut = outBits > 8 ? new ShortLookupTable(inBits, outBits, offset, size, m < 0.0f) : new ByteLookupTable(inBits, outBits, offset, size, m < 0.0f);
        } else {
            lut = lut.adjustOutBits(outBits);
        }
        return modalityLUT != null ? modalityLUT.combine(lut) : lut;
    }

    public boolean autoWindowing(Attributes img, Raster raster) {
        if (this.modalityLUT != null || this.voiLUT != null || this.windowWidth != 0.0f) {
            return false;
        }
        int min = img.getInt(2621702, 0);
        int max = img.getInt(2621703, 0);
        if (max == 0) {
            int[] min_max;
            ComponentSampleModel sm = (ComponentSampleModel)raster.getSampleModel();
            DataBuffer dataBuffer = raster.getDataBuffer();
            switch (dataBuffer.getDataType()) {
                case 0: {
                    min_max = this.calcMinMax(this.storedValue, sm, ((DataBufferByte)dataBuffer).getData());
                    break;
                }
                case 1: {
                    min_max = this.calcMinMax(this.storedValue, sm, ((DataBufferUShort)dataBuffer).getData());
                    break;
                }
                case 2: {
                    min_max = this.calcMinMax(this.storedValue, sm, ((DataBufferShort)dataBuffer).getData());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("DataBuffer: " + dataBuffer.getClass() + " not supported");
                }
            }
            min = min_max[0];
            max = min_max[1];
        }
        this.windowCenter = (float)((min + max + 1) / 2) * this.rescaleSlope + this.rescaleIntercept;
        this.windowWidth = Math.abs((float)(max + 1 - min) * this.rescaleSlope);
        return true;
    }

    private int[] calcMinMax(StoredValue storedValue, ComponentSampleModel sm, byte[] data) {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        int w = sm.getWidth();
        int h = sm.getHeight();
        int stride = sm.getScanlineStride();
        for (int y = 0; y < h; ++y) {
            int i = y * stride;
            int end = i + w;
            while (i < end) {
                int val;
                if ((val = storedValue.valueOf(data[i++])) < min) {
                    min = val;
                }
                if (val <= max) continue;
                max = val;
            }
        }
        return new int[]{min, max};
    }

    private int[] calcMinMax(StoredValue storedValue, ComponentSampleModel sm, short[] data) {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        int w = sm.getWidth();
        int h = sm.getHeight();
        int stride = sm.getScanlineStride();
        for (int y = 0; y < h; ++y) {
            int i = y * stride;
            int end = i + w;
            while (i < end) {
                int val;
                if ((val = storedValue.valueOf(data[i++])) < min) {
                    min = val;
                }
                if (val <= max) continue;
                max = val;
            }
        }
        return new int[]{min, max};
    }
}

