/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.nimble.codec;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.image.galaxy.Property;
import org.aoju.bus.image.nimble.codec.FormatNameFilterIterator;
import org.aoju.bus.image.nimble.codec.jpeg.PatchJPEGLS;
import org.aoju.bus.logger.Logger;

public class ImageWriterFactory
implements Serializable {
    private static volatile ImageWriterFactory defaultFactory;
    private final TreeMap<String, ImageWriterParam> map = new TreeMap();
    private PatchJPEGLS patchJPEGLS;

    private static String nullify(String s) {
        return s == null || s.isEmpty() || s.equals("*") ? null : s;
    }

    public static ImageWriterFactory getDefault() {
        if (defaultFactory == null) {
            defaultFactory = ImageWriterFactory.initDefault();
        }
        return defaultFactory;
    }

    public static void setDefault(ImageWriterFactory factory) {
        if (factory == null) {
            throw new NullPointerException();
        }
        defaultFactory = factory;
    }

    public static void resetDefault() {
        defaultFactory = null;
    }

    private static ImageWriterFactory initDefault() {
        ImageWriterFactory factory = new ImageWriterFactory();
        URL url = FileKit.getResource((String)"ImageWriterFactory.properties", ImageWriterFactory.class);
        try {
            factory.load(url.openStream());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load Image Reader Factory configuration from: " + url.toString(), e);
        }
        return factory;
    }

    public static ImageWriterParam getImageWriterParam(String tsuid) {
        return ImageWriterFactory.getDefault().get(tsuid);
    }

    public static ImageWriter getImageWriter(ImageWriterParam param) {
        return Boolean.getBoolean("org.aoju.bus.image.nimble.codec.UseServiceLoader") ? ImageWriterFactory.getImageWriterFromServiceLoader(param) : ImageWriterFactory.getImageWriterFromImageIOServiceRegistry(param);
    }

    public static ImageWriter getImageWriterFromImageIOServiceRegistry(ImageWriterParam param) {
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(param.formatName);
        if (!iter.hasNext()) {
            throw new RuntimeException("No Writer for format: " + param.formatName + " registered");
        }
        ImageWriter writer = iter.next();
        if (param.className != null) {
            while (!param.className.equals(writer.getClass().getName())) {
                if (iter.hasNext()) {
                    writer = iter.next();
                    continue;
                }
                Logger.warn((String)"No preferred Writer {} for format: {} - use {}", (Object[])new Object[]{param.className, param.formatName, writer.getClass().getName()});
                break;
            }
        }
        return writer;
    }

    public static ImageWriter getImageWriterFromServiceLoader(ImageWriterParam param) {
        try {
            return ImageWriterFactory.getImageWriterSpi(param).createWriterInstance();
        }
        catch (IOException e) {
            throw new RuntimeException("Error instantiating Writer for format: " + param.formatName, e);
        }
    }

    private static ImageWriterSpi getImageWriterSpi(ImageWriterParam param) {
        FormatNameFilterIterator<ImageWriterSpi> iter = new FormatNameFilterIterator<ImageWriterSpi>(ServiceLoader.load(ImageWriterSpi.class).iterator(), param.formatName);
        if (!iter.hasNext()) {
            throw new RuntimeException("No Writer for format: " + param.formatName + " registered");
        }
        ImageWriterSpi spi = (ImageWriterSpi)iter.next();
        if (param.className != null) {
            while (!param.className.equals(spi.getPluginClassName())) {
                if (iter.hasNext()) {
                    spi = (ImageWriterSpi)iter.next();
                    continue;
                }
                Logger.warn((String)"No preferred Writer {} for format: {} - use {}", (Object[])new Object[]{param.className, param.formatName, spi.getPluginClassName()});
                break;
            }
        }
        return spi;
    }

    public void load(InputStream in) throws IOException {
        Properties props = new Properties();
        props.load(in);
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String[] ss = Property.split((String)entry.getValue(), ':');
            this.map.put((String)entry.getKey(), new ImageWriterParam(ss[0], ss[1], ss[2], Property.split(ss[3], ';')));
        }
    }

    public final PatchJPEGLS getPatchJPEGLS() {
        return this.patchJPEGLS;
    }

    public final void setPatchJPEGLS(PatchJPEGLS patchJPEGLS) {
        this.patchJPEGLS = patchJPEGLS;
    }

    public ImageWriterParam get(String tsuid) {
        return this.map.get(tsuid);
    }

    public ImageWriterParam put(String tsuid, ImageWriterParam param) {
        return this.map.put(tsuid, param);
    }

    public ImageWriterParam remove(String tsuid) {
        return this.map.remove(tsuid);
    }

    public Set<Map.Entry<String, ImageWriterParam>> getEntries() {
        return Collections.unmodifiableMap(this.map).entrySet();
    }

    public void clear() {
        this.map.clear();
    }

    public static class ImageWriterParam
    implements Serializable {
        public final String formatName;
        public final String className;
        public final PatchJPEGLS patchJPEGLS;
        public final Property[] imageWriteParams;

        public ImageWriterParam(String formatName, String className, PatchJPEGLS patchJPEGLS, Property[] imageWriteParams) {
            this.formatName = formatName;
            this.className = ImageWriterFactory.nullify(className);
            this.patchJPEGLS = patchJPEGLS;
            this.imageWriteParams = imageWriteParams;
        }

        public ImageWriterParam(String formatName, String className, String patchJPEGLS, String[] imageWriteParams) {
            this(formatName, className, patchJPEGLS != null && !patchJPEGLS.isEmpty() ? PatchJPEGLS.valueOf(patchJPEGLS) : null, Property.valueOf(imageWriteParams));
        }

        public Property[] getImageWriteParams() {
            return this.imageWriteParams;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ImageWriterParam that = (ImageWriterParam)o;
            if (!this.formatName.equals(that.formatName)) {
                return false;
            }
            if (this.className != null ? !this.className.equals(that.className) : that.className != null) {
                return false;
            }
            if (this.patchJPEGLS != that.patchJPEGLS) {
                return false;
            }
            return Arrays.equals(this.imageWriteParams, that.imageWriteParams);
        }

        public int hashCode() {
            int result = this.formatName.hashCode();
            result = 31 * result + (this.className != null ? this.className.hashCode() : 0);
            result = 31 * result + (this.patchJPEGLS != null ? this.patchJPEGLS.hashCode() : 0);
            result = 31 * result + Arrays.hashCode(this.imageWriteParams);
            return result;
        }

        public String toString() {
            return "ImageWriterParam{formatName='" + this.formatName + '\'' + ", className='" + this.className + '\'' + ", patchJPEGLS=" + (Object)((Object)this.patchJPEGLS) + ", imageWriterParam=" + Arrays.toString(this.imageWriteParams) + '}';
        }
    }
}

