/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.nimble.opencv;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.FlatteningPathIterator;
import java.awt.image.BufferedImage;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.RenderedImage;
import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.aoju.bus.image.nimble.opencv.ImageCV;
import org.aoju.bus.image.nimble.opencv.ImageConversion;
import org.aoju.bus.image.nimble.opencv.PlanarImage;
import org.aoju.bus.logger.Logger;
import org.opencv.core.Core;
import org.opencv.core.CvException;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.MatOfDouble;
import org.opencv.core.MatOfInt;
import org.opencv.core.MatOfPoint;
import org.opencv.core.Point;
import org.opencv.core.Rect;
import org.opencv.core.RotatedRect;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.imgcodecs.Imgcodecs;
import org.opencv.imgproc.Imgproc;

public class ImageProcessor {
    public static ImageCV applyLUT(Mat source, byte[][] lut) {
        Mat lutMat;
        Mat srcImg = Objects.requireNonNull(source);
        int lutCh = Objects.requireNonNull(lut).length;
        if (lutCh > 1) {
            lutMat = new Mat();
            ArrayList<Mat> luts = new ArrayList<Mat>(lutCh);
            for (int i = 0; i < lutCh; ++i) {
                Mat l = new Mat(1, 256, 0);
                l.put(0, 0, lut[i]);
                luts.add(l);
            }
            Core.merge(luts, (Mat)lutMat);
            if (srcImg.channels() < lut.length) {
                Imgproc.cvtColor((Mat)srcImg.clone(), (Mat)srcImg, (int)8);
            }
        } else {
            lutMat = new Mat(1, 256, CvType.CV_8UC1);
            lutMat.put(0, 0, lut[0]);
        }
        ImageCV dstImg = new ImageCV();
        Core.LUT((Mat)srcImg, (Mat)lutMat, (Mat)dstImg);
        return dstImg;
    }

    public static ImageCV rescaleToByte(Mat source, double alpha, double beta) {
        ImageCV dstImg = new ImageCV();
        Objects.requireNonNull(source).convertTo((Mat)dstImg, 0, alpha, beta);
        return dstImg;
    }

    public static ImageCV invertLUT(ImageCV source) {
        Objects.requireNonNull(source);
        Core.bitwise_not((Mat)source, (Mat)source);
        return source;
    }

    public static ImageCV bitwiseAnd(Mat source, int src2Cst) {
        Objects.requireNonNull(source);
        ImageCV mask = new ImageCV(source.size(), source.type(), new Scalar((double)src2Cst));
        Core.bitwise_and((Mat)source, (Mat)mask, (Mat)mask);
        return mask;
    }

    public static ImageCV crop(Mat source, Rectangle area) {
        Objects.requireNonNull(source);
        Rectangle rect = Objects.requireNonNull(area).intersection(new Rectangle(0, 0, source.width(), source.height()));
        if (area.width > 1 && area.height > 1) {
            return ImageCV.toImageCV(source.submat(new Rect(rect.x, rect.y, rect.width, rect.height)));
        }
        return ImageCV.toImageCV(source);
    }

    public static Core.MinMaxLocResult minMaxLoc(RenderedImage source, Rectangle area) {
        ImageCV srcImg = ImageConversion.toMat(Objects.requireNonNull(source), area);
        return Core.minMaxLoc((Mat)srcImg);
    }

    public static List<MatOfPoint> transformShapeToContour(Shape shape, boolean keepImageCoordinates) {
        Rectangle b = shape.getBounds();
        if (keepImageCoordinates) {
            b.x = 0;
            b.y = 0;
        }
        ArrayList<MatOfPoint> points = new ArrayList<MatOfPoint>();
        ArrayList<Point> cvPts = new ArrayList<Point>();
        FlatteningPathIterator iterator = new FlatteningPathIterator(shape.getPathIterator(null), 2.0);
        double[] pts = new double[6];
        MatOfPoint p = null;
        while (!iterator.isDone()) {
            int segType = iterator.currentSegment(pts);
            switch (segType) {
                case 0: {
                    if (p != null) {
                        p.fromArray(cvPts.toArray(new Point[cvPts.size()]));
                        points.add(p);
                    }
                    p = new MatOfPoint();
                    cvPts.add(new Point(pts[0] - (double)b.x, pts[1] - (double)b.y));
                    break;
                }
                case 1: 
                case 4: {
                    cvPts.add(new Point(pts[0] - (double)b.x, pts[1] - (double)b.y));
                    break;
                }
            }
            iterator.next();
        }
        if (p != null) {
            p.fromArray(cvPts.toArray(new Point[cvPts.size()]));
            points.add(p);
        }
        return points;
    }

    public static double[][] meanStdDev(Mat source) {
        return ImageProcessor.meanStdDev(source, null, null, null);
    }

    public static double[][] meanStdDev(Mat source, Shape shape) {
        return ImageProcessor.meanStdDev(source, shape, null, null);
    }

    public static double[][] meanStdDev(Mat source, Shape shape, Integer paddingValue, Integer paddingLimit) {
        List<Mat> list = ImageProcessor.getMaskImage(source, shape, paddingValue, paddingLimit);
        if (list.size() < 2) {
            return null;
        }
        Mat srcImg = list.get(0);
        Mat mask = list.get(1);
        MatOfDouble mean = new MatOfDouble();
        MatOfDouble stddev = new MatOfDouble();
        if (mask == null) {
            Core.meanStdDev((Mat)srcImg, (MatOfDouble)mean, (MatOfDouble)stddev);
        } else {
            Core.meanStdDev((Mat)srcImg, (MatOfDouble)mean, (MatOfDouble)stddev, (Mat)mask);
        }
        ArrayList<Mat> channels = new ArrayList<Mat>();
        if (srcImg.channels() > 1) {
            Core.split((Mat)srcImg, channels);
        } else {
            channels.add(srcImg);
        }
        double[][] val = new double[5][channels.size()];
        for (int i = 0; i < channels.size(); ++i) {
            Core.MinMaxLocResult minMax = mask == null ? Core.minMaxLoc((Mat)((Mat)channels.get(i))) : Core.minMaxLoc((Mat)((Mat)channels.get(i)), (Mat)mask);
            val[0][i] = minMax.minVal;
            val[1][i] = minMax.maxVal;
        }
        val[2] = mean.toArray();
        val[3] = stddev.toArray();
        val[4][0] = mask == null ? (double)srcImg.width() * (double)srcImg.height() : (double)Core.countNonZero((Mat)mask);
        return val;
    }

    public static List<Mat> getMaskImage(Mat source, Shape shape, Integer paddingValue, Integer paddingLimit) {
        Mat srcImg;
        Objects.requireNonNull(source);
        Mat mask = null;
        if (shape == null) {
            srcImg = source;
        } else {
            Rectangle b = new Rectangle(0, 0, source.width(), source.height()).intersection(shape.getBounds());
            if (b.getWidth() < 1.0 || b.getHeight() < 1.0) {
                return Collections.emptyList();
            }
            srcImg = source.submat(new Rect(b.x, b.y, b.width, b.height));
            mask = Mat.zeros((Size)srcImg.size(), (int)CvType.CV_8UC1);
            List<MatOfPoint> pts = ImageProcessor.transformShapeToContour(shape, false);
            Imgproc.fillPoly((Mat)mask, pts, (Scalar)new Scalar(255.0));
        }
        if (paddingValue != null) {
            if (paddingLimit == null) {
                paddingLimit = paddingValue;
            } else if (paddingLimit < paddingValue) {
                int temp = paddingValue;
                paddingValue = paddingLimit;
                paddingLimit = temp;
            }
            Mat maskPix = new Mat(srcImg.size(), CvType.CV_8UC1, new Scalar(0.0));
            ImageProcessor.exludePaddingValue(srcImg, maskPix, paddingValue, paddingLimit);
            if (mask == null) {
                mask = maskPix;
            } else {
                Core.bitwise_and((Mat)mask, (Mat)maskPix, (Mat)mask);
            }
        }
        return Arrays.asList(srcImg, mask);
    }

    public static Core.MinMaxLocResult minMaxLoc(Mat srcImg, Mat mask) {
        ArrayList<Mat> channels = new ArrayList<Mat>(Objects.requireNonNull(srcImg).channels());
        if (srcImg.channels() > 1) {
            Core.split((Mat)srcImg, channels);
        } else {
            channels.add(srcImg);
        }
        Core.MinMaxLocResult result = new Core.MinMaxLocResult();
        result.minVal = Double.MAX_VALUE;
        result.maxVal = -1.7976931348623157E308;
        for (int i = 0; i < channels.size(); ++i) {
            Core.MinMaxLocResult minMax = Core.minMaxLoc((Mat)((Mat)channels.get(i)), (Mat)mask);
            result.minVal = Math.min(result.minVal, minMax.minVal);
            if (result.minVal == minMax.minVal) {
                result.minLoc = minMax.minLoc;
            }
            result.maxVal = Math.max(result.maxVal, minMax.maxVal);
            if (result.maxVal != minMax.maxVal) continue;
            result.maxLoc = minMax.maxLoc;
        }
        return result;
    }

    private static void exludePaddingValue(Mat src, Mat mask, int paddingValue, int paddingLimit) {
        Mat dst = new Mat();
        Core.inRange((Mat)src, (Scalar)new Scalar((double)paddingValue), (Scalar)new Scalar((double)paddingLimit), (Mat)dst);
        Core.bitwise_not((Mat)dst, (Mat)dst);
        Core.add((Mat)dst, (Mat)mask, (Mat)mask);
    }

    public static List<MatOfPoint> findContours(RenderedImage source, Rectangle area) {
        ImageCV srcImg = ImageConversion.toMat(Objects.requireNonNull(source), area);
        ArrayList<MatOfPoint> contours = new ArrayList<MatOfPoint>();
        Mat hierachy = new Mat();
        Imgproc.findContours((Mat)srcImg, contours, (Mat)hierachy, (int)2, (int)2);
        return contours;
    }

    public static ImageCV scale(Mat source, Dimension dim) {
        if (Objects.requireNonNull(dim).width < 1 || dim.height < 1) {
            throw new IllegalArgumentException("Unsupported size: " + dim);
        }
        ImageCV dstImg = new ImageCV();
        Imgproc.resize((Mat)Objects.requireNonNull(source), (Mat)dstImg, (Size)new Size(dim.getWidth(), dim.getHeight()));
        return dstImg;
    }

    public static ImageCV scale(Mat source, Dimension dim, Integer interpolation) {
        if (interpolation == null || interpolation < 0 || interpolation > 4) {
            return ImageProcessor.scale(source, dim);
        }
        if (Objects.requireNonNull(dim).width < 1 || dim.height < 1) {
            throw new IllegalArgumentException("Unsupported size: " + dim);
        }
        ImageCV dstImg = new ImageCV();
        Imgproc.resize((Mat)Objects.requireNonNull(source), (Mat)dstImg, (Size)new Size(dim.getWidth(), dim.getHeight()), (double)0.0, (double)0.0, (int)interpolation);
        return dstImg;
    }

    public static ImageCV combineTwoImages(Mat source, Mat imgOverlay, int transparency) {
        Mat srcImg = Objects.requireNonNull(source);
        Mat src2Img = Objects.requireNonNull(imgOverlay);
        ImageCV dstImg = new ImageCV();
        Core.addWeighted((Mat)srcImg, (double)1.0, (Mat)src2Img, (double)transparency, (double)0.0, (Mat)dstImg);
        return dstImg;
    }

    private static boolean isGray(Color color) {
        int r = color.getRed();
        return r == color.getGreen() && r == color.getBlue();
    }

    public static ImageCV overlay(Mat source, RenderedImage imgOverlay, Color color) {
        ImageCV srcImg = ImageCV.toImageCV(Objects.requireNonNull(source));
        ImageCV mask = ImageConversion.toMat(Objects.requireNonNull(imgOverlay));
        if (ImageProcessor.isGray(color) && srcImg.channels() == 1) {
            Mat grayImg = new Mat(srcImg.size(), CvType.CV_8UC1, new Scalar((double)color.getRed()));
            ImageCV dstImg = new ImageCV();
            srcImg.copyTo(dstImg);
            grayImg.copyTo((Mat)dstImg, (Mat)mask);
            return dstImg;
        }
        ImageCV dstImg = new ImageCV();
        if (srcImg.channels() < 3) {
            Imgproc.cvtColor((Mat)srcImg, (Mat)dstImg, (int)8);
        } else {
            srcImg.copyTo(dstImg);
        }
        Mat colorImg = new Mat(dstImg.size(), CvType.CV_8UC3, new Scalar((double)color.getBlue(), (double)color.getGreen(), (double)color.getRed()));
        colorImg.copyTo((Mat)dstImg, (Mat)mask);
        return dstImg;
    }

    public static BufferedImage drawShape(RenderedImage source, Shape shape, Color color) {
        ImageCV srcImg = ImageConversion.toMat(Objects.requireNonNull(source));
        List<MatOfPoint> pts = ImageProcessor.transformShapeToContour(shape, true);
        Imgproc.fillPoly((Mat)srcImg, pts, (Scalar)new Scalar((double)color.getBlue(), (double)color.getGreen(), (double)color.getRed()));
        return ImageConversion.toBufferedImage(srcImg);
    }

    public static ImageCV applyCropMask(Mat source, Rectangle b, double alpha) {
        Mat srcImg = Objects.requireNonNull(source);
        ImageCV dstImg = new ImageCV();
        source.copyTo((Mat)dstImg);
        if (b.getY() > 0.0) {
            Imgproc.rectangle((Mat)dstImg, (Point)new Point(0.0, 0.0), (Point)new Point((double)dstImg.width(), b.getMinY()), (Scalar)new Scalar(0.0), (int)-1);
        }
        if (b.getX() > 0.0) {
            Imgproc.rectangle((Mat)dstImg, (Point)new Point(0.0, b.getMinY()), (Point)new Point(b.getMinX(), b.getMaxY()), (Scalar)new Scalar(0.0), (int)-1);
        }
        if (b.getX() < (double)dstImg.width()) {
            Imgproc.rectangle((Mat)dstImg, (Point)new Point(b.getMaxX(), b.getMinY()), (Point)new Point((double)dstImg.width(), b.getMaxY()), (Scalar)new Scalar(0.0), (int)-1);
        }
        if (b.getY() < (double)dstImg.height()) {
            Imgproc.rectangle((Mat)dstImg, (Point)new Point(0.0, b.getMaxY()), (Point)new Point((double)dstImg.width(), (double)dstImg.height()), (Scalar)new Scalar(0.0), (int)-1);
        }
        Core.addWeighted((Mat)dstImg, (double)alpha, (Mat)srcImg, (double)(1.0 - alpha), (double)0.0, (Mat)dstImg);
        return dstImg;
    }

    public static ImageCV applyShutter(Mat source, Shape shape, Color color) {
        Mat srcImg = Objects.requireNonNull(source);
        Mat mask = Mat.zeros((Size)srcImg.size(), (int)CvType.CV_8UC1);
        List<MatOfPoint> pts = ImageProcessor.transformShapeToContour(shape, true);
        Imgproc.fillPoly((Mat)mask, pts, (Scalar)new Scalar(1.0));
        ImageCV dstImg = new ImageCV(srcImg.size(), srcImg.type(), new Scalar((double)color.getBlue(), (double)color.getGreen(), (double)color.getRed()));
        srcImg.copyTo((Mat)dstImg, mask);
        return dstImg;
    }

    public static ImageCV applyShutter(Mat source, RenderedImage imgOverlay, Color color) {
        ImageCV srcImg = ImageCV.toImageCV(Objects.requireNonNull(source));
        ImageCV mask = ImageConversion.toMat(Objects.requireNonNull(imgOverlay));
        if (ImageProcessor.isGray(color) && srcImg.channels() == 1) {
            Mat grayImg = new Mat(srcImg.size(), CvType.CV_8UC1, new Scalar((double)color.getRed()));
            ImageCV dstImg = new ImageCV();
            srcImg.copyTo(dstImg);
            grayImg.copyTo((Mat)dstImg, (Mat)mask);
            return dstImg;
        }
        ImageCV dstImg = new ImageCV();
        if (srcImg.channels() < 3) {
            Imgproc.cvtColor((Mat)srcImg, (Mat)dstImg, (int)8);
        } else {
            srcImg.copyTo(dstImg);
        }
        Mat colorImg = new Mat(dstImg.size(), CvType.CV_8UC3, new Scalar((double)color.getBlue(), (double)color.getGreen(), (double)color.getRed()));
        colorImg.copyTo((Mat)dstImg, (Mat)mask);
        return dstImg;
    }

    public static BufferedImage getAsImage(Area shape, RenderedImage source) {
        MultiPixelPackedSampleModel sm = new MultiPixelPackedSampleModel(0, source.getWidth(), source.getHeight(), 1);
        BufferedImage ti = new BufferedImage(source.getWidth(), source.getHeight(), sm.getDataType());
        Graphics2D g2d = ti.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.fill(shape);
        g2d.dispose();
        return ti;
    }

    public static ImageCV getRotatedImage(Mat source, int rotateCvType) {
        if (rotateCvType < 0) {
            return ImageCV.toImageCV(source);
        }
        Mat srcImg = Objects.requireNonNull(source);
        ImageCV dstImg = new ImageCV();
        Core.rotate((Mat)srcImg, (Mat)dstImg, (int)rotateCvType);
        return dstImg;
    }

    public static ImageCV flip(Mat source, int flipCvType) {
        if (flipCvType < 0) {
            return ImageCV.toImageCV(source);
        }
        Objects.requireNonNull(source);
        ImageCV dstImg = new ImageCV();
        Core.flip((Mat)source, (Mat)dstImg, (int)flipCvType);
        return dstImg;
    }

    private static boolean isEqualToZero(double val) {
        return Math.copySign(val, 1.0) < 1.0E-6;
    }

    public static ImageCV getRotatedImage(Mat source, double angle, double centerx, double centery) {
        if (ImageProcessor.isEqualToZero(angle)) {
            return ImageCV.toImageCV(source);
        }
        Mat srcImg = Objects.requireNonNull(source);
        Point ptCenter = new Point(centerx, centery);
        Mat rot = Imgproc.getRotationMatrix2D((Point)ptCenter, (double)(-angle), (double)1.0);
        ImageCV dstImg = new ImageCV();
        Rect bbox = new RotatedRect(ptCenter, srcImg.size(), -angle).boundingRect();
        Imgproc.warpAffine((Mat)srcImg, (Mat)dstImg, (Mat)rot, (Size)bbox.size());
        return dstImg;
    }

    public static ImageCV warpAffine(Mat source, Mat matrix, Size boxSize, Integer interpolation) {
        if (matrix == null) {
            return (ImageCV)source;
        }
        Mat srcImg = Objects.requireNonNull(source);
        ImageCV dstImg = new ImageCV();
        if (interpolation == null) {
            interpolation = 1;
        }
        Imgproc.warpAffine((Mat)srcImg, (Mat)dstImg, (Mat)matrix, (Size)boxSize, (int)interpolation);
        return dstImg;
    }

    public static Core.MinMaxLocResult findMinMaxValues(Mat source) {
        if (source != null) {
            return ImageProcessor.minMaxLoc(source, null);
        }
        return null;
    }

    public static Core.MinMaxLocResult findMinMaxValues(Mat source, Integer paddingValue, Integer paddingLimit) {
        if (source != null) {
            Mat mask = new Mat(source.size(), CvType.CV_8UC1, new Scalar(0.0));
            if (paddingValue != null) {
                if (paddingLimit == null) {
                    paddingLimit = paddingValue;
                } else if (paddingLimit < paddingValue) {
                    int temp = paddingValue;
                    paddingValue = paddingLimit;
                    paddingLimit = temp;
                }
                ImageProcessor.exludePaddingValue(source, mask, paddingValue, paddingLimit);
            }
            return ImageProcessor.minMaxLoc(source, mask);
        }
        return null;
    }

    public static ImageCV buildThumbnail(PlanarImage source, Dimension iconDim, boolean keepRatio) {
        Objects.requireNonNull(source);
        if (Objects.requireNonNull(iconDim).width < 1 || iconDim.height < 1) {
            throw new IllegalArgumentException("Unsupported size: " + iconDim);
        }
        double scale = Math.min(iconDim.getHeight() / (double)source.height(), iconDim.getWidth() / (double)source.width());
        if (scale >= 1.0) {
            return source.toImageCV();
        }
        if (scale < 0.005) {
            return null;
        }
        Size dim = keepRatio ? new Size((double)((int)(scale * (double)source.width())), (double)((int)(scale * (double)source.height()))) : new Size((double)iconDim.width, (double)iconDim.height);
        Mat srcImg = Objects.requireNonNull(source).toMat();
        ImageCV dstImg = new ImageCV();
        Imgproc.resize((Mat)srcImg, (Mat)dstImg, (Size)dim, (double)0.0, (double)0.0, (int)3);
        return dstImg;
    }

    public static boolean writeImage(Mat source, File file) {
        if (file.exists() && !file.canWrite()) {
            return false;
        }
        try {
            return Imgcodecs.imwrite((String)file.getPath(), (Mat)source);
        }
        catch (OutOfMemoryError | CvException e) {
            Logger.error((String)"Writing Image", (Object[])new Object[]{e});
            ImageProcessor.delete(file);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean writeThumbnail(Mat source, File file, int maxSize) {
        try {
            double scale = Math.min((double)maxSize / (double)source.height(), (double)maxSize / (double)source.width());
            if (!(scale < 1.0)) return false;
            Size dim = new Size((double)((int)(scale * (double)source.width())), (double)((int)(scale * (double)source.height())));
            try (ImageCV thumbnail = new ImageCV();){
                Imgproc.resize((Mat)source, (Mat)thumbnail, (Size)dim, (double)0.0, (double)0.0, (int)3);
                MatOfInt map = new MatOfInt(new int[]{1, 80});
                boolean bl = Imgcodecs.imwrite((String)file.getPath(), (Mat)thumbnail, (MatOfInt)map);
                return bl;
            }
        }
        catch (OutOfMemoryError | CvException e) {
            Logger.error((String)"Writing thumbnail", (Object[])new Object[]{e});
            ImageProcessor.delete(file);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writePNG(Mat source, File file) {
        int channels;
        if (file.exists() && !file.canWrite()) {
            return false;
        }
        Mat srcImg = Objects.requireNonNull(source);
        Mat dstImg = null;
        int type = srcImg.type();
        int elemSize = CvType.ELEM_SIZE((int)type);
        int bpp = elemSize * 8 / (channels = CvType.channels((int)type));
        if (bpp > 16 || !CvType.isInteger((int)type)) {
            dstImg = new Mat();
            srcImg.convertTo(dstImg, CvType.CV_16SC((int)channels));
            srcImg = dstImg;
        }
        try {
            boolean bl = Imgcodecs.imwrite((String)file.getPath(), (Mat)srcImg);
            return bl;
        }
        catch (OutOfMemoryError | CvException e) {
            Logger.error((String)"", (Object[])new Object[]{e});
            ImageProcessor.delete(file);
            boolean bl = false;
            return bl;
        }
        finally {
            ImageConversion.releaseMat(dstImg);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean writeImage(RenderedImage source, File file) {
        if (file.exists() && !file.canWrite()) {
            return false;
        }
        try (ImageCV dstImg = ImageConversion.toMat(source);){
            boolean bl = Imgcodecs.imwrite((String)file.getPath(), (Mat)dstImg);
            return bl;
        }
        catch (OutOfMemoryError | CvException e) {
            Logger.error((String)"", (Object[])new Object[]{e});
            return false;
        }
    }

    public static boolean writeImage(Mat source, File file, MatOfInt params) {
        if (file.exists() && !file.canWrite()) {
            return false;
        }
        try {
            return Imgcodecs.imwrite((String)file.getPath(), (Mat)source, (MatOfInt)params);
        }
        catch (OutOfMemoryError | CvException e) {
            Logger.error((String)"Writing image", (Object[])new Object[]{e});
            ImageProcessor.delete(file);
            return false;
        }
    }

    public static ImageCV readImage(File file) {
        try {
            return ImageProcessor.readImageWithCvException(file);
        }
        catch (OutOfMemoryError | CvException e) {
            Logger.error((String)"Reading image", (Object[])new Object[]{e});
            return null;
        }
    }

    public static ImageCV readImageWithCvException(File file) {
        if (!file.canRead()) {
            return null;
        }
        Mat img = Imgcodecs.imread((String)file.getPath());
        if (img.width() < 1 || img.height() < 1) {
            throw new CvException("OpenCV cannot read " + file.getPath());
        }
        return ImageCV.toImageCV(img);
    }

    private static boolean deleteFile(File fileOrDirectory) {
        try {
            Files.delete(fileOrDirectory.toPath());
        }
        catch (Exception e) {
            Logger.error((String)"Cannot delete", (Object[])new Object[]{e});
            return false;
        }
        return true;
    }

    private static boolean delete(File fileOrDirectory) {
        File[] files;
        if (fileOrDirectory == null || !fileOrDirectory.exists()) {
            return false;
        }
        if (fileOrDirectory.isDirectory() && (files = fileOrDirectory.listFiles()) != null) {
            for (File child : files) {
                ImageProcessor.delete(child);
            }
        }
        return ImageProcessor.deleteFile(fileOrDirectory);
    }

    public Mat blur(Mat input, int numberOfTimes) {
        Mat destImage = input.clone();
        for (int i = 0; i < numberOfTimes; ++i) {
            Mat sourceImage = destImage.clone();
            this.process(sourceImage, destImage, 256);
        }
        return destImage;
    }

    public void process(Mat sourceImage, Mat resultImage, int tileSize) {
        if (sourceImage.rows() != resultImage.rows() || sourceImage.cols() != resultImage.cols()) {
            throw new IllegalStateException("");
        }
        int rowTiles = sourceImage.rows() / tileSize + (sourceImage.rows() % tileSize != 0 ? 1 : 0);
        int colTiles = sourceImage.cols() / tileSize + (sourceImage.cols() % tileSize != 0 ? 1 : 0);
        Mat tileInput = new Mat(tileSize, tileSize, sourceImage.type());
        Mat tileOutput = new Mat(tileSize, tileSize, sourceImage.type());
        int boderType = 4;
        int mPadding = 3;
        for (int rowTile = 0; rowTile < rowTiles; ++rowTile) {
            for (int colTile = 0; colTile < colTiles; ++colTile) {
                Rect srcTile = new Rect(colTile * tileSize - mPadding, rowTile * tileSize - mPadding, tileSize + 2 * mPadding, tileSize + 2 * mPadding);
                Rect dstTile = new Rect(colTile * tileSize, rowTile * tileSize, tileSize, tileSize);
                this.copyTileFromSource(sourceImage, tileInput, srcTile, boderType);
                this.processTileImpl(tileInput, tileOutput);
                this.copyTileToResultImage(tileOutput, resultImage, new Rect(mPadding, mPadding, tileSize, tileSize), dstTile);
            }
        }
    }

    private void copyTileToResultImage(Mat tileOutput, Mat resultImage, Rect srcTile, Rect dstTile) {
        Point br = dstTile.br();
        if (br.x >= (double)resultImage.cols()) {
            dstTile.width = (int)((double)dstTile.width - (br.x - (double)resultImage.cols()));
            srcTile.width = (int)((double)srcTile.width - (br.x - (double)resultImage.cols()));
        }
        if (br.y >= (double)resultImage.rows()) {
            dstTile.height = (int)((double)dstTile.height - (br.y - (double)resultImage.rows()));
            srcTile.height = (int)((double)srcTile.height - (br.y - (double)resultImage.rows()));
        }
        Mat tileView = tileOutput.submat(srcTile);
        Mat dstView = resultImage.submat(dstTile);
        assert (tileView.rows() == dstView.rows());
        assert (tileView.cols() == dstView.cols());
        tileView.copyTo(dstView);
    }

    private void processTileImpl(Mat tileInput, Mat tileOutput) {
        Imgproc.blur((Mat)tileInput, (Mat)tileOutput, (Size)new Size(7.0, 7.0));
    }

    private void copyTileFromSource(Mat sourceImage, Mat tileInput, Rect tile, int mBorderType) {
        Point tl = tile.tl();
        Point br = tile.br();
        Point tloffset = new Point();
        Point broffset = new Point();
        if (tile.x < 0) {
            tloffset.x = -tile.x;
            tile.x = 0;
        }
        if (tile.y < 0) {
            tloffset.y = -tile.y;
            tile.y = 0;
        }
        if (br.x >= (double)sourceImage.cols()) {
            broffset.x = br.x - (double)sourceImage.cols() + 1.0;
            tile.width = (int)((double)tile.width - broffset.x);
        }
        if (br.y >= (double)sourceImage.rows()) {
            broffset.y = br.y - (double)sourceImage.rows() + 1.0;
            tile.height = (int)((double)tile.height - broffset.y);
        }
        if (tloffset.x > 0.0 || tloffset.y > 0.0 || broffset.x > 0.0 || broffset.y > 0.0) {
            Rect paddedTile = new Rect(tile.tl(), tile.br());
            assert (paddedTile.x >= 0);
            assert (paddedTile.y >= 0);
            assert (paddedTile.br().x < (double)sourceImage.cols());
            assert (paddedTile.br().y < (double)sourceImage.rows());
            Core.copyMakeBorder((Mat)sourceImage.submat(paddedTile), (Mat)tileInput, (int)((int)tloffset.y), (int)((int)broffset.y), (int)((int)tloffset.x), (int)((int)broffset.x), (int)mBorderType);
        } else {
            sourceImage.submat(tile).copyTo(tileInput);
        }
    }
}

