/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.plugin;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.nimble.BufferedImages;
import org.aoju.bus.image.nimble.reader.NativeDCMImageReader;
import org.aoju.bus.logger.Logger;

public class Dcm2Jpg {
    private final ImageReader imageReader = ImageIO.getImageReadersByFormatName("DICOM").next();
    private String suffix;
    private int frame = 1;
    private int windowIndex;
    private int voiLUTIndex;
    private boolean preferWindow = true;
    private float windowCenter;
    private float windowWidth;
    private boolean autoWindowing = true;
    private Attributes prState;
    private ImageWriter imageWriter;
    private ImageWriteParam imageWriteParam;
    private int overlayActivationMask = 65535;
    private int overlayGrayscaleValue = 65535;

    private static int parseHex(String s) throws InstrumentException {
        try {
            return Integer.parseInt(s, 16);
        }
        catch (NumberFormatException e) {
            throw new InstrumentException(e.getMessage());
        }
    }

    private static Attributes loadDicomObject(File f) throws IOException {
        if (f == null) {
            return null;
        }
        org.aoju.bus.image.galaxy.io.ImageInputStream dis = new org.aoju.bus.image.galaxy.io.ImageInputStream(f);
        try {
            Attributes attributes = dis.readDataset(-1, -1);
            return attributes;
        }
        finally {
            IoKit.close((Closeable)dis);
        }
    }

    public static void listSupportedImageWriters(String format) {
        Logger.info((String)MessageFormat.format("Supported Image Writers for format: {0}", format), (Object[])new Object[0]);
        Iterator<ImageWriter> it = ImageIO.getImageWritersByFormatName(format);
        while (it.hasNext()) {
            ImageWriter writer = it.next();
            ImageWriteParam param = writer.getDefaultWriteParam();
            Logger.info((String)MessageFormat.format("\\n{0}\\:\\\n\\n   canWriteCompressed\\: {1}\\\n\\n  canWriteProgressive\\: {2}\\\n\\n        canWriteTiles\\: {3}\\\n\\n       canOffsetTiles\\: {4}\\\n\\n    Compression Types\\: {5}", writer.getClass().getName(), param.canWriteCompressed(), param.canWriteProgressive(), param.canWriteTiles(), param.canOffsetTiles(), param.canWriteCompressed() ? Arrays.toString(param.getCompressionTypes()) : null), (Object[])new Object[0]);
        }
    }

    public static void listSupportedFormats() {
        Logger.info((String)MessageFormat.format("Supported output image formats: {0}", Arrays.toString(ImageIO.getWriterFormatNames())), (Object[])new Object[0]);
    }

    public void initImageWriter(String formatName, String suffix, String clazz, String compressionType, Number quality) {
        Iterator<ImageWriter> imageWriters = ImageIO.getImageWritersByFormatName(formatName);
        if (!imageWriters.hasNext()) {
            throw new IllegalArgumentException(MessageFormat.format("output image format: {0} not supported", formatName));
        }
        this.suffix = suffix != null ? suffix : formatName.toLowerCase();
        this.imageWriter = imageWriters.next();
        if (clazz != null) {
            while (!clazz.equals(this.imageWriter.getClass().getName())) {
                if (imageWriters.hasNext()) {
                    this.imageWriter = imageWriters.next();
                    continue;
                }
                throw new IllegalArgumentException(MessageFormat.format("no Image Writer: {0} for format {1} found", clazz, formatName));
            }
        }
        this.imageWriteParam = this.imageWriter.getDefaultWriteParam();
        if (compressionType != null || quality != null) {
            this.imageWriteParam.setCompressionMode(2);
            if (compressionType != null) {
                this.imageWriteParam.setCompressionType(compressionType);
            }
            if (quality != null) {
                this.imageWriteParam.setCompressionQuality(quality.floatValue());
            }
        }
    }

    public final void setFrame(int frame) {
        this.frame = frame;
    }

    public final void setWindowCenter(float windowCenter) {
        this.windowCenter = windowCenter;
    }

    public final void setWindowWidth(float windowWidth) {
        this.windowWidth = windowWidth;
    }

    public final void setWindowIndex(int windowIndex) {
        this.windowIndex = windowIndex;
    }

    public final void setVOILUTIndex(int voiLUTIndex) {
        this.voiLUTIndex = voiLUTIndex;
    }

    public final void setPreferWindow(boolean preferWindow) {
        this.preferWindow = preferWindow;
    }

    public final void setAutoWindowing(boolean autoWindowing) {
        this.autoWindowing = autoWindowing;
    }

    public final void setPresentationState(Attributes prState) {
        this.prState = prState;
    }

    public void setOverlayActivationMask(int overlayActivationMask) {
        this.overlayActivationMask = overlayActivationMask;
    }

    public void setOverlayGrayscaleValue(int overlayGrayscaleValue) {
        this.overlayGrayscaleValue = overlayGrayscaleValue;
    }

    private void mconvert(File src, File dest) {
        if (src.isDirectory()) {
            dest.mkdir();
            for (File file : src.listFiles()) {
                this.mconvert(file, new File(dest, file.isFile() ? this.suffix(file) : file.getName()));
            }
            return;
        }
        if (dest.isDirectory()) {
            dest = new File(dest, this.suffix(src));
        }
        try {
            this.convert(src, dest);
            Logger.info((String)MessageFormat.format("{0} -> {1}", src, dest), (Object[])new Object[0]);
        }
        catch (Exception e) {
            Logger.error((String)MessageFormat.format("Failed to convert {0}: {1}", src, e.getMessage()), (Object[])new Object[0]);
            throw new InstrumentException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convert(File src, File dest) throws IOException {
        ImageInputStream iis = ImageIO.createImageInputStream(src);
        try {
            BufferedImage bi = this.readImage(iis);
            bi = this.convert(bi);
            dest.delete();
            ImageOutputStream ios = ImageIO.createImageOutputStream(dest);
            try {
                this.writeImage(ios, bi);
            }
            finally {
                try {
                    ios.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                iis.close();
            }
            catch (IOException e) {
                throw new InstrumentException((Throwable)e);
            }
        }
    }

    private BufferedImage convert(BufferedImage bi) {
        ColorModel cm = bi.getColorModel();
        return cm.getNumComponents() == 3 ? BufferedImages.convertToIntRGB(bi) : bi;
    }

    private BufferedImage readImage(ImageInputStream iis) throws IOException {
        this.imageReader.setInput(iis);
        return this.imageReader.read(this.frame - 1, this.readParam());
    }

    private ImageReadParam readParam() {
        NativeDCMImageReader.NativeDCMImageReadParam param = (NativeDCMImageReader.NativeDCMImageReadParam)this.imageReader.getDefaultReadParam();
        param.setWindowCenter(this.windowCenter);
        param.setWindowWidth(this.windowWidth);
        param.setAutoWindowing(this.autoWindowing);
        param.setWindowIndex(this.windowIndex);
        param.setVOILUTIndex(this.voiLUTIndex);
        param.setPreferWindow(this.preferWindow);
        param.setPresentationState(this.prState);
        param.setOverlayActivationMask(this.overlayActivationMask);
        param.setOverlayGrayscaleValue(this.overlayGrayscaleValue);
        return param;
    }

    private void writeImage(ImageOutputStream ios, BufferedImage bi) throws IOException {
        this.imageWriter.setOutput(ios);
        this.imageWriter.write(null, new IIOImage(bi, null, null), this.imageWriteParam);
    }

    private String suffix(File src) {
        return src.getName() + '.' + this.suffix;
    }
}

