/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.galaxy.media;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.nio.file.Files;
import java.util.Map;
import javax.xml.transform.stream.StreamResult;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.data.BulkData;
import org.aoju.bus.image.galaxy.data.VR;
import org.aoju.bus.image.galaxy.io.ImageOutputStream;
import org.aoju.bus.image.galaxy.io.SAXTransformer;
import org.aoju.bus.image.galaxy.media.AbstractStowrs;
import org.aoju.bus.image.galaxy.media.MultipartParser;
import org.aoju.bus.image.galaxy.media.UploadSingleFile;

public class StowrsSingleFile
extends AbstractStowrs
implements UploadSingleFile {
    public StowrsSingleFile(String requestURL, String contentType) {
        this(requestURL, contentType, null, null);
    }

    public StowrsSingleFile(String requestURL, String contentType, String agentName, Map<String, String> headers) {
        super(requestURL, contentType, agentName, headers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uploadDicom(InputStream in, Attributes fmi, String tsuid, String iuid) throws IOException {
        HttpURLConnection httpPost = this.buildConnection();
        try (DataOutputStream out = new DataOutputStream(httpPost.getOutputStream());
             ImageOutputStream dos = new ImageOutputStream(out, tsuid);){
            int offset;
            this.writeContentMarkers(out);
            dos.writeFileMetaInformation(fmi);
            byte[] buf = new byte[4096];
            while ((offset = in.read(buf)) > 0) {
                dos.write(buf, 0, offset);
            }
            this.writeEndMarkers(httpPost, out, iuid);
        }
        finally {
            this.removeConnection(httpPost);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uploadDicom(Attributes metadata, String tsuid) throws IOException {
        HttpURLConnection httpPost = this.buildConnection();
        try (DataOutputStream out = new DataOutputStream(httpPost.getOutputStream());
             ImageOutputStream dos = new ImageOutputStream(out, tsuid);){
            this.writeContentMarkers(out);
            Attributes fmi = metadata.createFileMetaInformation(tsuid);
            dos.writeDataset(fmi, metadata);
            this.writeEndMarkers(httpPost, out, metadata.getString(524312));
        }
        finally {
            this.removeConnection(httpPost);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uploadEncapsulatedDocument(Attributes metadata, File bulkDataFile, String mimeType, String sopClassUID) throws Exception {
        HttpURLConnection httpPost = this.buildConnection();
        StowrsSingleFile.setEncapsulatedDocumentAttributes(bulkDataFile.toPath(), metadata, mimeType);
        if (metadata.getValue(4325393) == null) {
            metadata.setValue(4325393, VR.OB, new BulkData(null, "bulk", false));
        }
        metadata.setValue(524310, VR.UI, sopClassUID);
        StowrsSingleFile.ensureUID(metadata, 0x20000D);
        StowrsSingleFile.ensureUID(metadata, 0x20000E);
        StowrsSingleFile.ensureUID(metadata, 524312);
        try (ByteArrayOutputStream bOut = new ByteArrayOutputStream();
             DataOutputStream out = new DataOutputStream(httpPost.getOutputStream());){
            SAXTransformer.getSAXWriter(new StreamResult(bOut)).write(metadata);
            this.writeContentMarkers(out);
            out.write(bOut.toByteArray());
            out.write(MultipartParser.Separator.BOUNDARY.getType());
            out.writeBytes("mimeTypeBoundary");
            byte[] fsep = MultipartParser.Separator.FIELD.getType();
            out.write(fsep);
            out.writeBytes("Content-Type: ");
            out.writeBytes(mimeType);
            out.write(fsep);
            out.writeBytes("Content-Location: ");
            out.writeBytes(this.getContentLocation(metadata));
            out.write(MultipartParser.Separator.HEADER.getType());
            Files.copy(bulkDataFile.toPath(), out);
            this.writeEndMarkers(httpPost, out, metadata.getString(524312));
        }
        finally {
            this.removeConnection(httpPost);
        }
    }
}

