/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.plugin;

import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import java.util.Properties;
import org.aoju.bus.image.Args;
import org.aoju.bus.image.Builder;
import org.aoju.bus.image.Centre;
import org.aoju.bus.image.Device;
import org.aoju.bus.image.Node;
import org.aoju.bus.image.Status;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.metric.ApplicationEntity;
import org.aoju.bus.image.metric.Connection;
import org.aoju.bus.image.metric.Progress;
import org.aoju.bus.image.plugin.StoreSCU;
import org.aoju.bus.logger.Logger;

public class CStore {
    public static Status process(Node callingNode, Node calledNode, List<String> files) {
        return CStore.process(null, callingNode, calledNode, files);
    }

    public static Status process(Node callingNode, Node calledNode, List<String> files, Progress progress) {
        return CStore.process(null, callingNode, calledNode, files, progress);
    }

    public static Status process(Args args, Node callingNode, Node calledNode, List<String> files) {
        return CStore.process(args, callingNode, calledNode, files, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Status process(Args args, Node callingNode, Node calledNode, List<String> files, Progress progress) {
        Status dcmState;
        Centre centre;
        StoreSCU storeSCU;
        block14: {
            if (callingNode == null || calledNode == null) {
                throw new IllegalArgumentException("callingNode or calledNode cannot be null!");
            }
            storeSCU = null;
            Device device = new Device("storescu");
            Connection conn = new Connection();
            device.addConnection(conn);
            ApplicationEntity ae = new ApplicationEntity(callingNode.getAet());
            device.addApplicationEntity(ae);
            ae.addConnection(conn);
            storeSCU = new StoreSCU(ae, progress, args.getEditors());
            Connection remote = storeSCU.getRemoteConnection();
            centre = new Centre(device);
            args.configureBind(storeSCU.getAAssociateRQ(), remote, calledNode);
            args.configureBind(ae, conn, callingNode);
            args.configure(conn);
            args.configureTLS(conn, remote);
            storeSCU.setAttributes(new Attributes());
            if (args.isExtendNegociation()) {
                CStore.configureRelatedSOPClass(storeSCU, args.getExtendSopClassesURL());
            }
            storeSCU.setPriority(args.getPriority());
            storeSCU.scanFiles(files, false);
            dcmState = storeSCU.getState();
            int n = storeSCU.getFilesScanned();
            if (n != 0) break block14;
            Status status = new Status(49152, "No DICOM file has been found!", null);
            Builder.close(storeSCU);
            return status;
        }
        centre.start(true);
        long t1 = System.currentTimeMillis();
        storeSCU.open();
        long t2 = System.currentTimeMillis();
        storeSCU.sendFiles();
        Builder.forceGettingAttributes(dcmState, storeSCU);
        long t3 = System.currentTimeMillis();
        String timeMsg = MessageFormat.format("DICOM C-STORE connected in {2}ms from {0} to {1}. Stored files in {3}ms. Total size {4}", storeSCU.getAAssociateRQ().getCallingAET(), storeSCU.getAAssociateRQ().getCalledAET(), t2 - t1, t3 - t2, Builder.humanReadableByte(storeSCU.getTotalSize(), false));
        Status status = Status.build(dcmState, timeMsg, null);
        Builder.close(storeSCU);
        centre.stop();
        Builder.close(storeSCU);
        return status;
        {
            catch (Exception e) {
                Logger.error((String)"storescu", (Object[])new Object[]{e});
                Builder.forceGettingAttributes(storeSCU.getState(), storeSCU);
                Status status2 = Status.build(storeSCU.getState(), null, e);
                Builder.close(storeSCU);
                centre.stop();
                Builder.close(storeSCU);
                return status2;
                {
                    catch (Throwable throwable) {
                        try {
                            try {
                                Builder.close(storeSCU);
                                centre.stop();
                                throw throwable;
                            }
                            catch (Exception e2) {
                                Logger.error((String)"storescu", (Object[])new Object[]{e2});
                                Status status3 = new Status(49152, "DICOM Store failed : " + e2.getMessage(), null);
                                return status3;
                            }
                        }
                        catch (Throwable throwable2) {
                            throw throwable2;
                        }
                        finally {
                            Builder.close(storeSCU);
                        }
                    }
                }
            }
        }
    }

    private static void configureRelatedSOPClass(StoreSCU storescu, URL url) {
        storescu.enableSOPClassRelationshipExtNeg(true);
        Properties p = new Properties();
        try {
            if (url != null) {
                p.load(url.openStream());
            }
        }
        catch (Exception e) {
            Logger.error((String)"Read sop classes", (Object[])new Object[]{e});
        }
        storescu.relSOPClasses.init(p);
    }
}

