/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.nimble.codec;

import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.data.VR;

public enum TransferSyntaxType {
    NATIVE(false, false, true, 16, 0),
    JPEG_BASELINE(true, true, false, 8, 0),
    JPEG_EXTENDED(true, true, false, 12, 0),
    JPEG_SPECTRAL(true, true, false, 12, 0),
    JPEG_PROGRESSIVE(true, true, false, 12, 0),
    JPEG_LOSSLESS(true, true, true, 16, 0),
    JPEG_LS(true, true, true, 16, 0),
    JPEG_2000(true, true, true, 16, 0),
    RLE(true, false, true, 16, 1),
    JPIP(false, false, true, 16, 0),
    MPEG(true, false, false, 8, 0),
    DEFLATED(false, false, true, 16, 0),
    UNKNOWN(false, false, true, 16, 0);

    private final boolean pixeldataEncapsulated;
    private final boolean frameSpanMultipleFragments;
    private final boolean encodeSigned;
    private final int maxBitsStored;
    private final int planarConfiguration;

    private TransferSyntaxType(boolean pixeldataEncapsulated, boolean frameSpanMultipleFragments, boolean encodeSigned, int maxBitsStored, int planarConfiguration) {
        this.pixeldataEncapsulated = pixeldataEncapsulated;
        this.frameSpanMultipleFragments = frameSpanMultipleFragments;
        this.encodeSigned = encodeSigned;
        this.maxBitsStored = maxBitsStored;
        this.planarConfiguration = planarConfiguration;
    }

    public static TransferSyntaxType forUID(String uid) {
        switch (uid) {
            case "1.2.840.10008.1.2": 
            case "1.2.840.10008.1.2.1": 
            case "1.2.840.10008.1.2.2": {
                return NATIVE;
            }
            case "1.2.840.10008.1.2.1.99": {
                return DEFLATED;
            }
            case "1.2.840.10008.1.2.4.50": {
                return JPEG_BASELINE;
            }
            case "1.2.840.10008.1.2.4.51": {
                return JPEG_EXTENDED;
            }
            case "1.2.840.10008.1.2.4.53": {
                return JPEG_SPECTRAL;
            }
            case "1.2.840.10008.1.2.4.55": {
                return JPEG_PROGRESSIVE;
            }
            case "1.2.840.10008.1.2.4.57": 
            case "1.2.840.10008.1.2.4.70": {
                return JPEG_LOSSLESS;
            }
            case "1.2.840.10008.1.2.4.80": 
            case "1.2.840.10008.1.2.4.81": {
                return JPEG_LS;
            }
            case "1.2.840.10008.1.2.4.90": 
            case "1.2.840.10008.1.2.4.91": 
            case "1.2.840.10008.1.2.4.92": 
            case "1.2.840.10008.1.2.4.93": {
                return JPEG_2000;
            }
            case "1.2.840.10008.1.2.4.94": 
            case "1.2.840.10008.1.2.4.95": {
                return JPIP;
            }
            case "1.2.840.10008.1.2.4.100": 
            case "1.2.840.10008.1.2.4.101": 
            case "1.2.840.10008.1.2.4.102": 
            case "1.2.840.10008.1.2.4.103": 
            case "1.2.840.10008.1.2.4.104": 
            case "1.2.840.10008.1.2.4.105": 
            case "1.2.840.10008.1.2.4.106": 
            case "1.2.840.10008.1.2.4.107": 
            case "1.2.840.10008.1.2.4.108": {
                return MPEG;
            }
            case "1.2.840.10008.1.2.5": {
                return RLE;
            }
        }
        return UNKNOWN;
    }

    public static boolean isLossyCompression(String uid) {
        switch (uid) {
            case "1.2.840.10008.1.2.4.50": 
            case "1.2.840.10008.1.2.4.51": 
            case "1.2.840.10008.1.2.4.53": 
            case "1.2.840.10008.1.2.4.55": 
            case "1.2.840.10008.1.2.4.81": 
            case "1.2.840.10008.1.2.4.91": 
            case "1.2.840.10008.1.2.4.93": 
            case "1.2.840.10008.1.2.4.100": 
            case "1.2.840.10008.1.2.4.101": 
            case "1.2.840.10008.1.2.4.102": 
            case "1.2.840.10008.1.2.4.103": 
            case "1.2.840.10008.1.2.4.104": 
            case "1.2.840.10008.1.2.4.105": 
            case "1.2.840.10008.1.2.4.106": 
            case "1.2.840.10008.1.2.4.107": 
            case "1.2.840.10008.1.2.4.108": {
                return true;
            }
        }
        return false;
    }

    public static boolean isYBRCompression(String uid) {
        switch (uid) {
            case "1.2.840.10008.1.2.4.50": 
            case "1.2.840.10008.1.2.4.51": 
            case "1.2.840.10008.1.2.4.53": 
            case "1.2.840.10008.1.2.4.55": 
            case "1.2.840.10008.1.2.4.90": 
            case "1.2.840.10008.1.2.4.91": {
                return true;
            }
        }
        return false;
    }

    public boolean isPixeldataEncapsulated() {
        return this.pixeldataEncapsulated;
    }

    public boolean canEncodeSigned() {
        return this.encodeSigned;
    }

    public boolean mayFrameSpanMultipleFragments() {
        return this.frameSpanMultipleFragments;
    }

    public int getPlanarConfiguration() {
        return this.planarConfiguration;
    }

    public int getMaxBitsStored() {
        return this.maxBitsStored;
    }

    public boolean adjustBitsStoredTo12(Attributes attrs) {
        int bitsStored;
        if (this.maxBitsStored == 12 && (bitsStored = attrs.getInt(2621697, 8)) > 8 && bitsStored < 12) {
            attrs.setInt(2621697, VR.US, 12);
            attrs.setInt(2621698, VR.US, 11);
            return true;
        }
        return false;
    }
}

