/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.galaxy.io;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.aoju.bus.core.codec.Base64;
import org.aoju.bus.image.Tag;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.data.BulkData;
import org.aoju.bus.image.galaxy.data.ElementDictionary;
import org.aoju.bus.image.galaxy.data.Fragments;
import org.aoju.bus.image.galaxy.data.PersonName;
import org.aoju.bus.image.galaxy.data.Sequence;
import org.aoju.bus.image.galaxy.data.VR;
import org.xml.sax.helpers.DefaultHandler;

public class ContentHandlerAdapter
extends DefaultHandler {
    private final boolean bigEndian;
    private final LinkedList<Attributes> items = new LinkedList();
    private final LinkedList<Sequence> seqs = new LinkedList();
    private final ByteArrayOutputStream bout = new ByteArrayOutputStream(64);
    private final char[] carry = new char[4];
    private final StringBuilder sb = new StringBuilder(64);
    private final List<String> values = new ArrayList<String>();
    private Attributes fmi;
    private int carryLen;
    private PersonName pn;
    private PersonName.Group pnGroup;
    private int tag;
    private String privateCreator;
    private VR vr;
    private BulkData bulkData;
    private Fragments dataFragments;
    private boolean processCharacters;
    private boolean inlineBinary;

    public ContentHandlerAdapter(Attributes attrs) {
        if (attrs == null) {
            throw new NullPointerException();
        }
        this.items.add(attrs);
        this.bigEndian = attrs.bigEndian();
    }

    public Attributes getFileMetaInformation() {
        return this.fmi;
    }

    @Override
    public void startElement(String uri, String localName, String qName, org.xml.sax.Attributes atts) {
        switch (qName.charAt(0)) {
            case 'A': {
                if (!qName.equals("Alphabetic")) break;
                this.startPNGroup(PersonName.Group.Alphabetic);
                break;
            }
            case 'B': {
                if (!qName.equals("BulkData")) break;
                this.bulkData(atts.getValue("uuid"), atts.getValue("uri"));
                break;
            }
            case 'D': {
                if (qName.equals("DicomAttribute")) {
                    this.startDicomAttribute((int)Long.parseLong(atts.getValue("tag"), 16), atts.getValue("privateCreator"), atts.getValue("vr"));
                    break;
                }
                if (!qName.equals("DataFragment")) break;
                this.startDataFragment(Integer.parseInt(atts.getValue("number")));
                break;
            }
            case 'F': {
                if (!qName.equals("FamilyName")) break;
                this.startText();
                break;
            }
            case 'G': {
                if (!qName.equals("GivenName")) break;
                this.startText();
                break;
            }
            case 'I': {
                if (qName.equals("Item")) {
                    this.startItem(Integer.parseInt(atts.getValue("number")));
                    break;
                }
                if (qName.equals("InlineBinary")) {
                    this.startInlineBinary();
                    break;
                }
                if (!qName.equals("Ideographic")) break;
                this.startPNGroup(PersonName.Group.Ideographic);
                break;
            }
            case 'L': {
                if (!qName.equals("Length")) break;
                this.startText();
                break;
            }
            case 'M': {
                if (!qName.equals("MiddleName")) break;
                this.startText();
                break;
            }
            case 'N': {
                if (!qName.equals("NamePrefix") && !qName.equals("NameSuffix")) break;
                this.startText();
                break;
            }
            case 'O': {
                if (!qName.equals("Offset")) break;
                this.startText();
                break;
            }
            case 'P': {
                if (qName.equals("PersonName")) {
                    this.startPersonName(Integer.parseInt(atts.getValue("number")));
                    break;
                }
                if (!qName.equals("Phonetic")) break;
                this.startPNGroup(PersonName.Group.Phonetic);
                break;
            }
            case 'T': {
                if (!qName.equals("TransferSyntax")) break;
                this.startText();
                break;
            }
            case 'U': {
                if (!qName.equals("URI")) break;
                this.startText();
                break;
            }
            case 'V': {
                if (!qName.equals("Value")) break;
                this.startValue(Integer.parseInt(atts.getValue("number")));
                this.startText();
            }
        }
    }

    private void bulkData(String uuid, String uri) {
        this.bulkData = new BulkData(uuid, uri, this.items.getLast().bigEndian());
    }

    private void startInlineBinary() {
        this.processCharacters = true;
        this.inlineBinary = true;
        this.carryLen = 0;
        this.bout.reset();
    }

    private void startText() {
        this.processCharacters = true;
        this.inlineBinary = false;
        this.sb.setLength(0);
    }

    private void startDicomAttribute(int tag, String privateCreator, String vr) {
        this.tag = tag;
        this.privateCreator = privateCreator;
        VR vR = this.vr = vr != null ? VR.valueOf(vr) : ElementDictionary.vrOf(tag, privateCreator);
        if (this.vr == VR.SQ) {
            this.seqs.add(this.items.getLast().newSequence(privateCreator, tag, 10));
        }
    }

    private void startDataFragment(int number) {
        if (this.dataFragments == null) {
            this.dataFragments = this.items.getLast().newFragments(this.privateCreator, this.tag, this.vr, 10);
        }
        while (this.dataFragments.size() < number - 1) {
            this.dataFragments.add(new byte[0]);
        }
    }

    private void startItem(int number) {
        Sequence seq = this.seqs.getLast();
        while (seq.size() < number - 1) {
            seq.add(new Attributes(0));
        }
        Attributes item = new Attributes();
        seq.add(item);
        this.items.add(item);
    }

    private void startValue(int number) {
        while (this.values.size() < number - 1) {
            this.values.add(null);
        }
    }

    private void startPersonName(int number) {
        this.startValue(number);
        this.pn = new PersonName();
    }

    private void startPNGroup(PersonName.Group pnGroup) {
        this.pnGroup = pnGroup;
    }

    @Override
    public void characters(char[] ch, int offset, int len) {
        if (this.processCharacters) {
            if (this.inlineBinary) {
                if (this.carryLen != 0) {
                    int copy = Math.min(4 - this.carryLen, len);
                    System.arraycopy(ch, offset, this.carry, this.carryLen, copy);
                    this.carryLen += copy;
                    offset += copy;
                    len -= copy;
                    if (this.carryLen == 4) {
                        Base64.decode((char[])this.carry, (int)0, (int)4, (OutputStream)this.bout);
                    } else {
                        return;
                    }
                }
                if ((this.carryLen = len & 3) != 0) {
                    System.arraycopy(ch, offset + (len -= this.carryLen), this.carry, 0, this.carryLen);
                }
                Base64.decode((char[])ch, (int)offset, (int)len, (OutputStream)this.bout);
            } else {
                this.sb.append(ch, offset, len);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        switch (qName.charAt(0)) {
            case 'D': {
                if (qName.equals("DicomAttribute")) {
                    this.endDicomAttribute();
                    break;
                }
                if (!qName.equals("DataFragment")) break;
                this.endDataFragment();
                break;
            }
            case 'F': {
                if (!qName.equals("FamilyName")) break;
                this.endPNComponent(PersonName.Component.FamilyName);
                break;
            }
            case 'G': {
                if (!qName.equals("GivenName")) break;
                this.endPNComponent(PersonName.Component.GivenName);
                break;
            }
            case 'I': {
                if (!qName.equals("Item")) break;
                this.endItem();
                break;
            }
            case 'M': {
                if (!qName.equals("MiddleName")) break;
                this.endPNComponent(PersonName.Component.MiddleName);
                break;
            }
            case 'N': {
                if (qName.equals("NamePrefix")) {
                    this.endPNComponent(PersonName.Component.NamePrefix);
                    break;
                }
                if (!qName.equals("NameSuffix")) break;
                this.endPNComponent(PersonName.Component.NameSuffix);
                break;
            }
            case 'P': {
                if (!qName.equals("PersonName")) break;
                this.endPersonName();
                break;
            }
            case 'V': {
                if (!qName.equals("Value")) break;
                this.endValue();
            }
        }
        this.processCharacters = false;
    }

    @Override
    public void endDocument() {
        if (this.fmi != null) {
            this.fmi.trimToSize();
        }
        this.items.getFirst().trimToSize();
    }

    private void endDataFragment() {
        if (this.bulkData != null) {
            this.dataFragments.add(this.bulkData);
            this.bulkData = null;
        } else {
            this.dataFragments.add(this.getBytes());
        }
    }

    private void endDicomAttribute() {
        if (this.vr == VR.SQ) {
            this.seqs.removeLast().trimToSize();
            return;
        }
        if (this.dataFragments != null) {
            this.dataFragments.trimToSize();
            this.dataFragments = null;
            return;
        }
        Attributes attrs = this.items.getLast();
        if (Tag.isFileMetaInformation(this.tag)) {
            if (this.fmi == null) {
                this.fmi = new Attributes();
            }
            attrs = this.fmi;
        }
        if (this.bulkData != null) {
            attrs.setValue(this.privateCreator, this.tag, this.vr, this.bulkData);
            this.bulkData = null;
        } else if (this.inlineBinary) {
            attrs.setBytes(this.privateCreator, this.tag, this.vr, this.getBytes());
            this.inlineBinary = false;
        } else {
            attrs.setString(this.privateCreator, this.tag, this.vr, this.getStrings());
        }
    }

    private void endItem() {
        this.items.removeLast().trimToSize();
        this.vr = VR.SQ;
    }

    private void endPersonName() {
        this.values.add(this.pn.toString());
        this.pn = null;
    }

    private void endValue() {
        this.values.add(this.getString());
    }

    private void endPNComponent(PersonName.Component pnComp) {
        this.pn.set(this.pnGroup, pnComp, this.getString());
    }

    private String getString() {
        return this.sb.toString();
    }

    private byte[] getBytes() {
        byte[] b = this.bout.toByteArray();
        return this.bigEndian ? this.vr.toggleEndian(b, false) : b;
    }

    private String[] getStrings() {
        try {
            String[] stringArray = this.values.toArray(new String[this.values.size()]);
            return stringArray;
        }
        finally {
            this.values.clear();
        }
    }
}

