/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.galaxy.media;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class MultipartInputStream
extends FilterInputStream {
    private final byte[] boundary;
    private final byte[] buffer;
    private byte[] markBuffer;
    private int rpos;
    private int markpos;
    private boolean boundarySeen;
    private boolean markBoundarySeen;

    protected MultipartInputStream(InputStream in, String boundary) {
        super(in);
        this.boundary = boundary.getBytes();
        this.buffer = new byte[this.boundary.length];
        this.rpos = this.buffer.length;
    }

    private static void readFully(InputStream in, byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        while (len > 0) {
            int count = in.read(b, off, len);
            if (count < 0) {
                throw new EOFException();
            }
            off += count;
            len -= count;
        }
    }

    private static String unquote(String s) {
        char[] cs = s.toCharArray();
        boolean backslash = false;
        int count = 0;
        for (char c : cs) {
            if (c != '\"' && c != '\\' || backslash) {
                cs[count++] = c;
                backslash = false;
                continue;
            }
            backslash = c == '\\';
        }
        return new String(cs, 0, count);
    }

    @Override
    public int read() throws IOException {
        return this.isBoundary() ? -1 : this.buffer[this.rpos++];
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.isBoundary()) {
            return -1;
        }
        int l = Math.min(this.remaining(), len);
        System.arraycopy(this.buffer, this.rpos, b, off, l);
        this.rpos += l;
        return l;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.isBoundary()) {
            return 0L;
        }
        long l = Math.min((long)this.remaining(), n);
        this.rpos = (int)((long)this.rpos + l);
        return l;
    }

    @Override
    public synchronized void mark(int readlimit) {
        super.mark(readlimit);
        this.markBuffer = (byte[])this.buffer.clone();
        this.markpos = this.rpos;
        this.markBoundarySeen = this.boundarySeen;
    }

    @Override
    public synchronized void reset() throws IOException {
        super.reset();
        System.arraycopy(this.markBuffer, 0, this.buffer, 0, this.buffer.length);
        this.rpos = this.markpos;
        this.boundarySeen = this.markBoundarySeen;
    }

    @Override
    public void close() {
    }

    public void skipAll() throws IOException {
        while (!this.isBoundary()) {
            this.rpos += this.remaining();
        }
    }

    public boolean isZIP() throws IOException {
        return !this.isBoundary() && this.buffer[this.rpos] == 80 && this.buffer[this.rpos + 1] == 75;
    }

    private boolean isBoundary() throws IOException {
        if (this.boundarySeen) {
            return true;
        }
        if (this.rpos < this.buffer.length) {
            if (this.buffer[this.rpos] != this.boundary[0]) {
                return false;
            }
            System.arraycopy(this.buffer, this.rpos, this.buffer, 0, this.buffer.length - this.rpos);
        }
        MultipartInputStream.readFully(this.in, this.buffer, this.buffer.length - this.rpos, this.rpos);
        this.rpos = 0;
        for (int i = 0; i < this.buffer.length; ++i) {
            if (this.buffer[i] == this.boundary[i]) continue;
            return false;
        }
        this.boundarySeen = true;
        return true;
    }

    private int remaining() {
        for (int i = this.rpos + 1; i < this.buffer.length; ++i) {
            if (this.buffer[i] != this.boundary[0]) continue;
            return i - this.rpos;
        }
        return this.buffer.length - this.rpos;
    }

    public Map<String, List<String>> readHeaderParams() throws IOException {
        TreeMap<String, List<String>> map = new TreeMap<String, List<String>>((o1, o2) -> o1.compareToIgnoreCase((String)o2));
        Field field = new Field();
        while (this.readHeaderParam(field)) {
            ArrayList<String> list;
            String name = field.toString();
            String value = "";
            int endName = name.indexOf(58);
            if (endName != -1) {
                value = MultipartInputStream.unquote(name.substring(endName + 1)).trim();
                name = name.substring(0, endName);
            }
            if ((list = (ArrayList<String>)map.get(name)) == null) {
                list = new ArrayList<String>(1);
                map.put(name.toLowerCase(), list);
            }
            list.add(value);
        }
        return map;
    }

    private boolean readHeaderParam(Field field) throws IOException {
        field.reset();
        while (!this.isBoundary()) {
            field.growBuffer(this.buffer.length);
            while (this.rpos < this.buffer.length) {
                if (field.append(this.buffer[this.rpos++])) continue;
            }
        }
        return !field.isEmpty();
    }

    private static final class Field {
        byte[] buffer = new byte[256];
        int length;

        private Field() {
        }

        void reset() {
            this.length = 0;
        }

        boolean isEmpty() {
            return this.length == 0;
        }

        void growBuffer(int grow) {
            if (this.length + grow > this.buffer.length) {
                byte[] copy = new byte[this.length + grow];
                System.arraycopy(this.buffer, 0, copy, 0, this.length);
                this.buffer = copy;
            }
        }

        boolean append(byte b) {
            if (b == 10 && this.length > 0 && this.buffer[this.length - 1] == 13) {
                --this.length;
                return false;
            }
            this.buffer[this.length++] = b;
            return true;
        }

        public String toString() {
            return new String(this.buffer, 0, this.length);
        }
    }
}

