/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.nimble.opencv;

import java.io.ByteArrayInputStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.aoju.bus.image.nimble.codec.ImageDescriptor;
import org.aoju.bus.image.nimble.opencv.StreamSegment;
import org.aoju.bus.logger.Logger;

public class MemoryStreamSegment
extends StreamSegment {
    private final ByteBuffer cache;

    MemoryStreamSegment(ByteBuffer b, ImageDescriptor imageDescriptor) {
        super(new long[]{0L}, new long[]{b.limit()}, imageDescriptor);
        this.cache = b;
    }

    public static ByteArrayInputStream getByteArrayInputStream(MemoryCacheImageInputStream inputStream) {
        if (inputStream != null) {
            try {
                Field fid = MemoryCacheImageInputStream.class.getDeclaredField("stream");
                if (fid != null) {
                    fid.setAccessible(true);
                    return (ByteArrayInputStream)fid.get(inputStream);
                }
            }
            catch (Exception e) {
                Logger.error((String)"Cannot get inputstream", (Object[])new Object[]{e});
            }
        }
        return null;
    }

    public ByteBuffer getCache() {
        return this.cache;
    }
}

