/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.metric.internal.xdsi;

import org.aoju.bus.image.galaxy.data.Code;
import org.aoju.bus.image.metric.internal.xdsi.ClassificationType;
import org.aoju.bus.image.metric.internal.xdsi.InternationalStringBuilder;
import org.aoju.bus.image.metric.internal.xdsi.SlotBuilder;

public class ClassificationBuilder {
    private final ClassificationType result = new ClassificationType();

    public ClassificationBuilder(String id) {
        this.result.setId(id);
        this.result.setObjectType("urn:oasis:names:tc:ebxml-regrep:ObjectType:RegistryObject:Classification");
    }

    public ClassificationType build() {
        return this.result;
    }

    public ClassificationBuilder classificationScheme(String value) {
        this.result.setClassificationScheme(value);
        return this;
    }

    public ClassificationBuilder classifiedObject(String value) {
        this.result.setClassifiedObject(value);
        return this;
    }

    public ClassificationBuilder classificationNode(String value) {
        this.result.setClassificationNode(value);
        return this;
    }

    public ClassificationBuilder nodeRepresentation(String value) {
        this.result.setNodeRepresentation(value);
        return this;
    }

    public ClassificationBuilder code(Code code) {
        this.result.setNodeRepresentation(code.getCodeValue());
        this.result.setName(InternationalStringBuilder.build(code.getCodeMeaning()));
        this.result.getSlot().add(new SlotBuilder("codingScheme").valueList(code.getCodingSchemeDesignator()).build());
        return this;
    }
}

