/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.nimble.codec.jpeg;

public class JPEGLSCodingParam {
    private final int maxVal;
    private final int t1;
    private final int t2;
    private final int t3;
    private final int reset;
    private int offset;

    public JPEGLSCodingParam(int maxVal, int t1, int t2, int t3, int reset) {
        this.maxVal = maxVal;
        this.t1 = t1;
        this.t2 = t2;
        this.t3 = t3;
        this.reset = reset;
    }

    private static JPEGLSCodingParam getDefaultJPEGLSEncodingParam(int maxVal, int clampedMaxVal, int near) {
        int t3;
        int t2;
        int factor = clampedMaxVal + 128 >> 8;
        int t1 = factor + 2 + 3 * near;
        if (t1 > maxVal || t1 < near + 1) {
            t1 = near + 1;
        }
        if ((t2 = factor * 4 + 3 + 5 * near) > maxVal || t2 < t1) {
            t2 = t1;
        }
        if ((t3 = factor * 17 + 4 + 7 * near) > maxVal || t3 < t2) {
            t3 = t2;
        }
        return new JPEGLSCodingParam(maxVal, t1, t2, t3, 64);
    }

    public static JPEGLSCodingParam getDefaultJPEGLSCodingParam(int p, int near) {
        int maxVal = (1 << p) - 1;
        return JPEGLSCodingParam.getDefaultJPEGLSEncodingParam(maxVal, Math.min(maxVal, 4095), near);
    }

    public static JPEGLSCodingParam getJAIJPEGLSCodingParam(int p) {
        int maxVal = (1 << p) - 1;
        return JPEGLSCodingParam.getDefaultJPEGLSEncodingParam(maxVal, maxVal, 0);
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public final int getMaxVal() {
        return this.maxVal;
    }

    public final int getT1() {
        return this.t1;
    }

    public final int getT2() {
        return this.t2;
    }

    public final int getT3() {
        return this.t3;
    }

    public final int getReset() {
        return this.reset;
    }

    public byte[] getBytes() {
        return new byte[]{-1, -8, 0, 13, 1, (byte)(this.maxVal >> 8), (byte)this.maxVal, (byte)(this.t1 >> 8), (byte)this.t1, (byte)(this.t2 >> 8), (byte)this.t2, (byte)(this.t3 >> 8), (byte)this.t3, (byte)(this.reset >> 8), (byte)this.reset};
    }

    public String toString() {
        return "JPEGLSCodingParam[MAXVAL=" + this.maxVal + ", T1=" + this.t1 + ", T2=" + this.t2 + ", T3=" + this.t3 + ", RESET=" + this.reset + "]";
    }
}

