/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.galaxy.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.aoju.bus.core.toolkit.ByteKit;
import org.aoju.bus.image.Tag;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.data.BulkData;
import org.aoju.bus.image.galaxy.data.SpecificCharacterSet;
import org.aoju.bus.image.galaxy.data.VR;
import org.aoju.bus.image.galaxy.data.Value;
import org.aoju.bus.image.galaxy.io.ImageEncodingOptions;

public class ImageOutputStream
extends FilterOutputStream {
    private static final byte[] DICM = new byte[]{68, 73, 67, 77};
    private final byte[] buf = new byte[12];
    private byte[] preamble = new byte[128];
    private boolean explicitVR;
    private boolean bigEndian;
    private boolean deflated;
    private ImageEncodingOptions encOpts = ImageEncodingOptions.DEFAULT;

    public ImageOutputStream(OutputStream out, String tsuid) {
        super(out);
        this.switchTransferSyntax(tsuid);
    }

    public ImageOutputStream(File file) throws IOException {
        this(new BufferedOutputStream(new FileOutputStream(file)), "1.2.840.10008.1.2.1");
    }

    public final void setPreamble(byte[] preamble) {
        if (preamble.length != 128) {
            throw new IllegalArgumentException("preamble.length=" + preamble.length);
        }
        this.preamble = (byte[])preamble.clone();
    }

    public final boolean isExplicitVR() {
        return this.explicitVR;
    }

    public final boolean isBigEndian() {
        return this.bigEndian;
    }

    public final ImageEncodingOptions getEncodingOptions() {
        return this.encOpts;
    }

    public final void setEncodingOptions(ImageEncodingOptions encOpts) {
        if (encOpts == null) {
            throw new NullPointerException();
        }
        this.encOpts = encOpts;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    public void writeCommand(Attributes cmd) throws IOException {
        if (this.explicitVR || this.bigEndian) {
            throw new IllegalStateException("explicitVR=" + this.explicitVR + ", bigEndian=" + this.bigEndian);
        }
        cmd.writeGroupTo(this, 0);
    }

    public void writeFileMetaInformation(Attributes fmi) throws IOException {
        if (!this.explicitVR || this.bigEndian || this.deflated) {
            throw new IllegalStateException("explicitVR=" + this.explicitVR + ", bigEndian=" + this.bigEndian + ", deflated=" + this.deflated);
        }
        this.write(this.preamble);
        this.write(DICM);
        fmi.writeGroupTo(this, 131072);
    }

    public void writeDataset(Attributes fmi, Attributes dataset) throws IOException {
        if (fmi != null) {
            this.writeFileMetaInformation(fmi);
            this.switchTransferSyntax(fmi.getString(131088, null));
        }
        if (dataset.bigEndian() != this.bigEndian || this.encOpts.groupLength || !this.encOpts.undefSequenceLength || !this.encOpts.undefItemLength) {
            dataset = new Attributes(dataset, this.bigEndian);
        }
        if (this.encOpts.groupLength) {
            dataset.calcLength(this.encOpts, this.explicitVR);
        }
        dataset.writeTo(this);
    }

    private void switchTransferSyntax(String tsuid) {
        this.bigEndian = tsuid.equals("1.2.840.10008.1.2.2");
        boolean bl = this.explicitVR = !tsuid.equals("1.2.840.10008.1.2");
        if (tsuid.equals("1.2.840.10008.1.2.1.99") || tsuid.equals("1.2.840.10008.1.2.4.95")) {
            this.out = new DeflaterOutputStream(this.out, new Deflater(-1, true));
            this.deflated = true;
        }
    }

    public void writeHeader(int tag, VR vr, int len) throws IOException {
        int headerLen;
        byte[] b = this.buf;
        ByteKit.tagToBytes((int)tag, (byte[])b, (int)0, (boolean)this.bigEndian);
        if (!Tag.isItem(tag) && this.explicitVR) {
            if ((len & 0xFFFF0000) != 0 && vr.headerLength() == 8) {
                vr = VR.UN;
            }
            ByteKit.shortToBytesBE((int)vr.code(), (byte[])b, (int)4);
            headerLen = vr.headerLength();
            if (headerLen == 8) {
                ByteKit.shortToBytes((int)len, (byte[])b, (int)6, (boolean)this.bigEndian);
            } else {
                b[7] = 0;
                b[6] = 0;
                ByteKit.intToBytes((int)len, (byte[])b, (int)8, (boolean)this.bigEndian);
            }
        } else {
            ByteKit.intToBytes((int)len, (byte[])b, (int)4, (boolean)this.bigEndian);
            headerLen = 8;
        }
        this.out.write(b, 0, headerLen);
    }

    public void writeAttribute(int tag, VR vr, Object value, SpecificCharacterSet cs) throws IOException {
        if (value instanceof Value) {
            this.writeAttribute(tag, vr, (Value)value);
        } else {
            this.writeAttribute(tag, vr, value instanceof byte[] ? (byte[])value : vr.toBytes(value, cs));
        }
    }

    public void writeAttribute(int tag, VR vr, byte[] val) throws IOException {
        int padlen = val.length & 1;
        this.writeHeader(tag, vr, val.length + padlen);
        this.out.write(val);
        if (padlen > 0) {
            this.out.write(vr.paddingByte());
        }
    }

    public void writeAttribute(int tag, VR vr, Value val) throws IOException {
        if (val instanceof BulkData && this.out instanceof ObjectOutputStream) {
            this.writeHeader(tag, vr, 64507);
            ((BulkData)val).serializeTo((ObjectOutputStream)this.out);
        } else {
            int length = val.getEncodedLength(this.encOpts, this.explicitVR, vr);
            this.writeHeader(tag, vr, length);
            val.writeTo(this, vr);
            if (length == -1) {
                this.writeHeader(-73507, null, 0);
            }
        }
    }

    public void writeGroupLength(int tag, int len) throws IOException {
        byte[] b = this.buf;
        ByteKit.tagToBytes((int)tag, (byte[])b, (int)0, (boolean)this.bigEndian);
        if (this.explicitVR) {
            ByteKit.shortToBytesBE((int)VR.UL.code(), (byte[])b, (int)4);
            ByteKit.shortToBytes((int)4, (byte[])b, (int)6, (boolean)this.bigEndian);
        } else {
            ByteKit.intToBytes((int)4, (byte[])b, (int)4, (boolean)this.bigEndian);
        }
        ByteKit.intToBytes((int)len, (byte[])b, (int)8, (boolean)this.bigEndian);
        this.out.write(b, 0, 12);
    }

    public void finish() throws IOException {
        if (this.out instanceof DeflaterOutputStream) {
            ((DeflaterOutputStream)this.out).finish();
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.finish();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.close();
    }
}

