/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.metric.internal.pdu;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.aoju.bus.image.Dimse;
import org.aoju.bus.image.Status;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.io.ImageOutputStream;
import org.aoju.bus.image.metric.Association;
import org.aoju.bus.image.metric.DataWriter;
import org.aoju.bus.image.metric.PDVOutputStream;
import org.aoju.bus.image.metric.internal.pdu.AAbort;
import org.aoju.bus.image.metric.internal.pdu.AAssociateAC;
import org.aoju.bus.image.metric.internal.pdu.AAssociateRJ;
import org.aoju.bus.image.metric.internal.pdu.AAssociateRQ;
import org.aoju.bus.image.metric.internal.pdu.AAssociateRQAC;
import org.aoju.bus.image.metric.internal.pdu.CommonExtended;
import org.aoju.bus.image.metric.internal.pdu.ExtendedNegotiate;
import org.aoju.bus.image.metric.internal.pdu.IdentityAC;
import org.aoju.bus.image.metric.internal.pdu.IdentityRQ;
import org.aoju.bus.image.metric.internal.pdu.Presentation;
import org.aoju.bus.image.metric.internal.pdu.RoleSelection;
import org.aoju.bus.logger.Logger;

public class PDUEncoder
extends PDVOutputStream {
    private final Association as;
    private final OutputStream out;
    private final Object dimseLock = new Object();
    private byte[] buf = new byte[16384];
    private int pos;
    private int pdvpcid;
    private int pdvcmd;
    private int pdvpos;
    private int maxpdulen;
    private Thread th;

    public PDUEncoder(Association as, OutputStream out) {
        this.as = as;
        this.out = out;
    }

    public void write(AAssociateRQ rq) throws IOException {
        this.encode(rq, 1, 32);
        this.writePDU(this.pos - 6);
    }

    public void write(AAssociateAC ac) throws IOException {
        this.encode(ac, 2, 33);
        this.writePDU(this.pos - 6);
    }

    public void write(AAssociateRJ rj) throws IOException {
        this.write(3, rj.getResult(), rj.getSource(), rj.getReason());
    }

    public void writeAReleaseRQ() throws IOException {
        this.write(5, 0, 0, 0);
    }

    public void writeAReleaseRP() throws IOException {
        this.write(6, 0, 0, 0);
    }

    public void write(AAbort aa) throws IOException {
        this.write(7, 0, aa.getSource(), aa.getReason());
    }

    private synchronized void write(int Builder2, int result, int source, int reason) throws IOException {
        byte[] b = new byte[]{(byte)Builder2, 0, 0, 0, 0, 4, 0, (byte)result, (byte)source, (byte)reason};
        this.out.write(b);
        this.out.flush();
    }

    private synchronized void writePDU(int pdulen) throws IOException {
        try {
            this.out.write(this.buf, 0, 6 + pdulen);
            this.out.flush();
        }
        catch (IOException e) {
            this.as.onIOException(e);
            throw e;
        }
        this.pdvpos = 6;
        this.pos = 12;
    }

    private void encode(AAssociateRQAC rqac, int builder, int pcBuilder) {
        rqac.checkCallingAET();
        rqac.checkCalledAET();
        int pdulen = rqac.length();
        if (this.buf.length < 6 + pdulen) {
            this.buf = new byte[6 + pdulen];
        }
        this.pos = 0;
        this.put(builder);
        this.put(0);
        this.putInt(pdulen);
        this.putShort(rqac.getProtocolVersion());
        this.put(0);
        this.put(0);
        this.encodeAET(rqac.getCalledAET());
        this.encodeAET(rqac.getCallingAET());
        this.put(rqac.getReservedBytes(), 0, 32);
        this.encodeStringItem(16, rqac.getApplicationContext());
        for (Presentation pc : rqac.getPresentationContexts()) {
            this.encode(pc, pcBuilder);
        }
        this.encodeUserInfo(rqac);
    }

    private void put(int ch) {
        this.buf[this.pos++] = (byte)ch;
    }

    private void put(byte[] b) {
        this.put(b, 0, b.length);
    }

    private void put(byte[] b, int off, int len) {
        System.arraycopy(b, off, this.buf, this.pos, len);
        this.pos += len;
    }

    private void putShort(int v) {
        this.buf[this.pos++] = (byte)(v >> 8);
        this.buf[this.pos++] = (byte)v;
    }

    private void putInt(int v) {
        this.buf[this.pos++] = (byte)(v >> 24);
        this.buf[this.pos++] = (byte)(v >> 16);
        this.buf[this.pos++] = (byte)(v >> 8);
        this.buf[this.pos++] = (byte)v;
    }

    private void putString(String s) {
        int len = s.length();
        s.getBytes(0, len, this.buf, this.pos);
        this.pos += len;
    }

    private void encode(byte[] b) {
        this.putShort(b.length);
        this.put(b, 0, b.length);
    }

    private void encode(String s) {
        this.putShort(s.length());
        this.putString(s);
    }

    private void encodeAET(String aet) {
        int endpos = this.pos + 16;
        this.putString(aet);
        while (this.pos < endpos) {
            this.put(32);
        }
    }

    private void encodeItemHeader(int type, int len) {
        this.put(type);
        this.put(0);
        this.putShort(len);
    }

    private void encodeStringItem(int type, String s) {
        if (s == null) {
            return;
        }
        this.encodeItemHeader(type, s.length());
        this.putString(s);
    }

    private void encode(Presentation pc, int pcBuilder) {
        this.encodeItemHeader(pcBuilder, pc.length());
        this.put(pc.getPCID());
        this.put(0);
        this.put(pc.getResult());
        this.put(0);
        this.encodeStringItem(48, pc.getAbstractSyntax());
        for (String ts : pc.getTransferSyntaxes()) {
            this.encodeStringItem(64, ts);
        }
    }

    private void encodeUserInfo(AAssociateRQAC rqac) {
        this.encodeItemHeader(80, rqac.userInfoLength());
        this.encodeMaxPDULength(rqac.getMaxPDULength());
        this.encodeStringItem(82, rqac.getImplClassUID());
        if (rqac.isAsyncOps()) {
            this.encodeAsyncOpsWindow(rqac);
        }
        for (RoleSelection roleSelection : rqac.getRoleSelections()) {
            this.encode(roleSelection);
        }
        this.encodeStringItem(85, rqac.getImplVersionName());
        for (ExtendedNegotiate extendedNegotiate : rqac.getExtendedNegotiations()) {
            this.encode(extendedNegotiate);
        }
        for (CommonExtended commonExtended : rqac.getCommonExtendedNegotiations()) {
            this.encode(commonExtended);
        }
        this.encode(rqac.getIdentityRQ());
        this.encode(rqac.getIdentityAC());
    }

    private void encodeMaxPDULength(int maxPDULength) {
        this.encodeItemHeader(81, 4);
        this.putInt(maxPDULength);
    }

    private void encodeAsyncOpsWindow(AAssociateRQAC rqac) {
        this.encodeItemHeader(83, 4);
        this.putShort(rqac.getMaxOpsInvoked());
        this.putShort(rqac.getMaxOpsPerformed());
    }

    private void encode(RoleSelection rs) {
        this.encodeItemHeader(84, rs.length());
        this.encode(rs.getSOPClassUID());
        this.put(rs.isSCU() ? 1 : 0);
        this.put(rs.isSCP() ? 1 : 0);
    }

    private void encode(ExtendedNegotiate extNeg) {
        this.encodeItemHeader(86, extNeg.length());
        this.encode(extNeg.getSOPClassUID());
        this.put(extNeg.getInformation());
    }

    private void encode(CommonExtended extNeg) {
        this.encodeItemHeader(87, extNeg.length());
        this.encode(extNeg.getSOPClassUID());
        this.encode(extNeg.getServiceClassUID());
        this.putShort(extNeg.getRelatedGeneralSOPClassUIDsLength());
        for (String cuid : extNeg.getRelatedGeneralSOPClassUIDs()) {
            this.encode(cuid);
        }
    }

    private void encode(IdentityRQ userIdentity) {
        if (userIdentity == null) {
            return;
        }
        this.encodeItemHeader(88, userIdentity.length());
        this.put(userIdentity.getType());
        this.put(userIdentity.isPositiveResponseRequested() ? 1 : 0);
        this.encode(userIdentity.getPrimaryField());
        this.encode(userIdentity.getSecondaryField());
    }

    private void encode(IdentityAC userIdentity) {
        if (userIdentity == null) {
            return;
        }
        this.encodeItemHeader(89, userIdentity.length());
        this.encode(userIdentity.getServerResponse());
    }

    @Override
    public void write(int b) throws IOException {
        this.checkThread();
        this.flushPDataTF();
        this.put(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int write;
        this.checkThread();
        int pos = off;
        for (int remaining = len; remaining > 0; remaining -= write) {
            this.flushPDataTF();
            write = Math.min(remaining, this.free());
            this.put(b, pos, write);
            pos += write;
        }
    }

    @Override
    public void close() {
        this.checkThread();
        this.encodePDVHeader(2);
    }

    @Override
    public void copyFrom(InputStream in, int len) throws IOException {
        int copy;
        this.checkThread();
        for (int remaining = len; remaining > 0; remaining -= copy) {
            this.flushPDataTF();
            copy = in.read(this.buf, this.pos, Math.min(remaining, this.free()));
            if (copy == -1) {
                throw new EOFException();
            }
            this.pos += copy;
        }
    }

    @Override
    public void copyFrom(InputStream in) throws IOException {
        this.checkThread();
        while (true) {
            this.flushPDataTF();
            int copy = in.read(this.buf, this.pos, this.free());
            if (copy == -1) {
                return;
            }
            this.pos += copy;
        }
    }

    private void checkThread() {
        if (this.th != Thread.currentThread()) {
            throw new IllegalStateException("Entered by wrong thread");
        }
    }

    private int free() {
        return this.maxpdulen + 6 - this.pos;
    }

    private void flushPDataTF() throws IOException {
        if (this.free() > 0) {
            return;
        }
        this.encodePDVHeader(0);
        this.as.writePDataTF();
    }

    private void encodePDVHeader(int last) {
        int endpos = this.pos;
        int pdvlen = endpos - this.pdvpos - 4;
        this.pos = this.pdvpos;
        this.putInt(pdvlen);
        this.put(this.pdvpcid);
        this.put(this.pdvcmd | last);
        this.pos = endpos;
        Logger.trace((String)"{} << PDV[len={}, pcid={}, mch={}]", (Object[])new Object[]{this.as, pdvlen, this.pdvpcid, this.pdvcmd | last});
    }

    public void writePDataTF() throws IOException {
        int pdulen = this.pos - 6;
        this.pos = 0;
        this.put(4);
        this.put(0);
        this.putInt(pdulen);
        Logger.trace((String)"{} << P-DATA-TF[len={}]", (Object[])new Object[]{this.as, pdulen});
        this.writePDU(pdulen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDIMSE(Presentation pc, Attributes cmd, DataWriter dataWriter) throws IOException {
        Object object = this.dimseLock;
        synchronized (object) {
            int pcid = pc.getPCID();
            String tsuid = pc.getTransferSyntax();
            Dimse dimse = Dimse.valueOf(cmd.getInt(256, -1));
            if (!dimse.isRSP() || !Status.isPending(cmd.getInt(2304, -1))) {
                this.as.incSentCount(dimse);
            }
            Logger.debug((String)"{} << {} Command:\n{}", (Object[])new Object[]{this.as, dimse.toString(cmd), cmd});
            this.th = Thread.currentThread();
            this.maxpdulen = this.as.getMaxPDULengthSend();
            if (this.buf.length < this.maxpdulen + 6) {
                this.buf = new byte[this.maxpdulen + 6];
            }
            this.pdvpcid = pcid;
            this.pdvcmd = 1;
            ImageOutputStream cmdout = new ImageOutputStream(this, "1.2.840.10008.1.2");
            cmdout.writeCommand(cmd);
            cmdout.close();
            if (dataWriter != null) {
                if (!this.as.isPackPDV()) {
                    this.as.writePDataTF();
                } else {
                    this.pdvpos = this.pos;
                    this.pos += 6;
                }
                this.pdvcmd = 0;
                Logger.debug((String)"{} << {} Dataset sending...", (Object[])new Object[]{this.as, dimse.toString(cmd)});
                dataWriter.writeTo(this, tsuid);
                Logger.debug((String)"{} << {} Dataset sent", (Object[])new Object[]{this.as, dimse.toString(cmd)});
                this.close();
            }
            this.as.writePDataTF();
            this.th = null;
        }
    }
}

