/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.metric;

import java.io.IOException;
import org.aoju.bus.image.Status;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.metric.Association;
import org.aoju.bus.image.metric.Timeout;
import org.aoju.bus.image.metric.internal.pdu.Presentation;

public class DimseRSPHandler {
    private final int msgId;
    private Presentation pc;
    private volatile Timeout timeout;
    private boolean stopOnPending;

    public DimseRSPHandler(int msgId) {
        this.msgId = msgId;
    }

    final void setPC(Presentation pc) {
        this.pc = pc;
    }

    public final int getMessageID() {
        return this.msgId;
    }

    final void setTimeout(Timeout timeout, boolean stopOnPending) {
        this.timeout = timeout;
        this.stopOnPending = stopOnPending;
    }

    boolean isStopOnPending() {
        return this.stopOnPending;
    }

    public void cancel(Association as) throws IOException {
        as.cancel(this.pc, this.msgId);
    }

    public void onDimseRSP(Association as, Attributes cmd, Attributes data) {
        if (this.stopOnPending || !Status.isPending(cmd.getInt(2304, -1))) {
            this.stopTimeout(as);
        }
    }

    public void onClose(Association as) {
        this.stopTimeout(as);
    }

    private void stopTimeout(Association as) {
        if (this.timeout != null) {
            this.timeout.stop();
            this.timeout = null;
        }
    }
}

