/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.metric.service;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.aoju.bus.image.Dimse;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.metric.Association;
import org.aoju.bus.image.metric.DimseRQHandler;
import org.aoju.bus.image.metric.ImageException;
import org.aoju.bus.image.metric.PDVInputStream;
import org.aoju.bus.image.metric.internal.pdu.CommonExtended;
import org.aoju.bus.image.metric.internal.pdu.Presentation;
import org.aoju.bus.image.metric.service.ImageService;
import org.aoju.bus.logger.Logger;

public class ServiceHandler
implements DimseRQHandler {
    private final Map<String, DimseRQHandler> services = new HashMap<String, DimseRQHandler>();

    public void addService(ImageService service) {
        this.addDimseRQHandler(service, service.getSOPClasses());
    }

    public void removeService(ImageService service) {
        this.removeDimseRQHandler(service.getSOPClasses());
    }

    public synchronized void addDimseRQHandler(DimseRQHandler service, String ... sopClasses) {
        for (String uid : sopClasses) {
            this.services.put(uid, service);
        }
    }

    public synchronized void removeDimseRQHandler(String ... sopClasses) {
        for (String uid : sopClasses) {
            this.services.remove(uid);
        }
    }

    @Override
    public void onDimse(Association as, Presentation pc, Dimse dimse, Attributes cmd, PDVInputStream data) throws IOException {
        try {
            this.lookupService(as, dimse, cmd).onDimse(as, pc, dimse, cmd, data);
        }
        catch (ImageException e) {
            Logger.info((String)"{}: processing {} failed. Caused by:\t", (Object[])new Object[]{as, dimse.toString(cmd, pc.getPCID(), pc.getTransferSyntax()), e});
            Attributes rsp = e.mkRSP(dimse.commandFieldOfRSP(), cmd.getInt(272, 0));
            as.tryWriteDimseRSP(pc, rsp, e.getDataset());
        }
    }

    private DimseRQHandler lookupService(Association as, Dimse dimse, Attributes cmd) throws ImageException {
        String cuid = cmd.getString(dimse.tagOfSOPClassUID());
        if (cuid == null) {
            throw new ImageException(530);
        }
        DimseRQHandler service = this.services.get(cuid);
        if (service != null) {
            return service;
        }
        if (dimse == Dimse.C_STORE_RQ) {
            CommonExtended commonExtNeg = as.getCommonExtendedNegotiationFor(cuid);
            if (commonExtNeg != null) {
                for (String uid : commonExtNeg.getRelatedGeneralSOPClassUIDs()) {
                    service = this.services.get(uid);
                    if (service == null) continue;
                    return service;
                }
                service = this.services.get(commonExtNeg.getServiceClassUID());
                if (service != null) {
                    return service;
                }
            }
            if ((service = this.services.get("*")) != null) {
                return service;
            }
        }
        throw new ImageException(dimse.isCService() ? 290 : 280);
    }

    @Override
    public void onClose(Association as) {
        for (DimseRQHandler service : this.services.values()) {
            service.onClose(as);
        }
    }
}

