/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.nimble.opencv;

import java.util.Locale;
import javax.imageio.ImageWriteParam;

public class JPEGImageWriteParam
extends ImageWriteParam {
    private static final String[] COMPRESSION_TYPES = new String[]{"BASELINE", "EXTENDED", "SPECTRAL", "PROGRESSIVE", "LOSSLESS-1", "LOSSLESS-2", "LOSSLESS-3", "LOSSLESS-4", "LOSSLESS-5", "LOSSLESS-6", "LOSSLESS-7"};
    private int pointTransform;

    public JPEGImageWriteParam(Locale locale) {
        super(locale);
        this.canWriteCompressed = true;
        this.compressionMode = 2;
        this.compressionType = "BASELINE";
        this.compressionTypes = COMPRESSION_TYPES;
        this.compressionQuality = 0.75f;
        this.pointTransform = 0;
    }

    public int getMode() {
        switch (this.compressionType.charAt(0)) {
            case 'B': {
                return 0;
            }
            case 'E': {
                return 1;
            }
            case 'S': {
                return 2;
            }
            case 'P': {
                return 3;
            }
        }
        return 4;
    }

    public int getPrediction() {
        return this.isCompressionLossless() ? this.compressionType.charAt(9) - 48 : 0;
    }

    public int getPointTransform() {
        return this.pointTransform;
    }

    public void setPointTransform(int pointTransform) {
        this.pointTransform = pointTransform;
    }

    @Override
    public boolean isCompressionLossless() {
        return this.compressionType.charAt(0) == 'L';
    }
}

