/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image;

import java.io.IOException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.EnumSet;
import org.aoju.bus.image.Device;
import org.aoju.bus.image.Editors;
import org.aoju.bus.image.Node;
import org.aoju.bus.image.Option;
import org.aoju.bus.image.galaxy.data.ElementDictionary;
import org.aoju.bus.image.metric.ApplicationEntity;
import org.aoju.bus.image.metric.Connection;
import org.aoju.bus.image.metric.SSLManagerFactory;
import org.aoju.bus.image.metric.internal.pdu.AAssociateRQ;
import org.aoju.bus.image.metric.internal.pdu.IdentityRQ;

public class Args {
    public static String[] IVR_LE_FIRST = new String[]{"1.2.840.10008.1.2", "1.2.840.10008.1.2.1", "1.2.840.10008.1.2.2"};
    public static String[] EVR_LE_FIRST = new String[]{"1.2.840.10008.1.2.1", "1.2.840.10008.1.2.2", "1.2.840.10008.1.2"};
    public static String[] EVR_BE_FIRST = new String[]{"1.2.840.10008.1.2.2", "1.2.840.10008.1.2.1", "1.2.840.10008.1.2"};
    public static String[] IVR_LE_ONLY = new String[]{"1.2.840.10008.1.2"};
    private boolean bindCallingAet;
    private String[] acceptedCallingAETitles;
    private Object informationModel;
    private EnumSet<Option.Type> types = EnumSet.noneOf(Option.Type.class);
    private String[] tsuidOrder = IVR_LE_FIRST;
    private String proxy;
    private IdentityRQ identity;
    private int priority = 0;
    private Option option;
    private boolean extendNegociation;
    private URL extendSopClassesURL;
    private URL extendStorageSOPClass;
    private URL transferCapabilityFile;
    private int tag;
    private String[] values;
    private int[] parentSeqTags;
    private String storagePattern;
    private Editors editors;

    public Args() {
    }

    public Args(boolean bindCallingAet) {
        this(null, bindCallingAet, null, null, new String[0]);
    }

    public Args(int tag, String ... values) {
        this(null, tag, values);
    }

    public Args(Editors editors, boolean extendNegociation, URL extendSopClassesURL) {
        this.editors = editors;
        this.extendNegociation = extendNegociation;
        this.extendSopClassesURL = extendSopClassesURL;
    }

    public Args(int[] parentSeqTags, int tag, String ... values) {
        this.tag = tag;
        this.values = values;
        this.parentSeqTags = parentSeqTags;
    }

    public Args(Option option, boolean bindCallingAet, String storagePattern, URL transferCapabilityFile, String ... acceptedCallingAETitles) {
        this.bindCallingAet = bindCallingAet;
        this.storagePattern = storagePattern;
        this.transferCapabilityFile = transferCapabilityFile;
        String[] stringArray = this.acceptedCallingAETitles = acceptedCallingAETitles == null ? new String[]{} : acceptedCallingAETitles;
        if (option == null && this.option != null) {
            this.option.setMaxOpsInvoked(15);
            this.option.setMaxOpsPerformed(15);
        }
    }

    public String getTagName() {
        return ElementDictionary.keywordOf(this.tag, null);
    }

    public void configureBind(Connection connection, Node callingNode) {
        if (callingNode.getHostname() != null) {
            connection.setHostname(callingNode.getHostname());
        }
        if (callingNode.getPort() != null) {
            connection.setPort(callingNode.getPort());
        }
    }

    public void configureBind(AAssociateRQ aAssociateRQ, Connection remote, Node calledNode) {
        aAssociateRQ.setCalledAET(calledNode.getAet());
        if (this.identity != null) {
            aAssociateRQ.setIdentityRQ(this.identity);
        }
        remote.setHostname(calledNode.getHostname());
        remote.setPort(calledNode.getPort());
    }

    public void configureBind(ApplicationEntity applicationEntity, Connection connection, Node callingNode) {
        applicationEntity.setAETitle(callingNode.getAet());
        if (callingNode.getHostname() != null) {
            connection.setHostname(callingNode.getHostname());
        }
        if (callingNode.getPort() != null) {
            connection.setPort(callingNode.getPort());
        }
    }

    public void configure(Connection conn) {
        if (this.option != null) {
            conn.setBacklog(this.option.getBacklog());
            conn.setConnectTimeout(this.option.getConnectTimeout());
            conn.setRequestTimeout(this.option.getRequestTimeout());
            conn.setAcceptTimeout(this.option.getAcceptTimeout());
            conn.setReleaseTimeout(this.option.getReleaseTimeout());
            conn.setResponseTimeout(this.option.getResponseTimeout());
            conn.setRetrieveTimeout(this.option.getRetrieveTimeout());
            conn.setIdleTimeout(this.option.getIdleTimeout());
            conn.setSocketCloseDelay(this.option.getSocloseDelay());
            conn.setReceiveBufferSize(this.option.getSorcvBuffer());
            conn.setSendBufferSize(this.option.getSosndBuffer());
            conn.setReceivePDULength(this.option.getMaxPdulenRcv());
            conn.setSendPDULength(this.option.getMaxPdulenSnd());
            conn.setMaxOpsInvoked(this.option.getMaxOpsInvoked());
            conn.setMaxOpsPerformed(this.option.getMaxOpsPerformed());
            conn.setPackPDV(this.option.isPackPDV());
            conn.setTcpNoDelay(this.option.isTcpNoDelay());
        }
    }

    public void configureTLS(Connection conn, Connection remote) throws IOException {
        if (this.option != null) {
            conn.setTlsCipherSuites(this.option.getCipherSuites());
            conn.setTlsProtocols(this.option.getTlsProtocols());
            conn.setTlsNeedClientAuth(this.option.isTlsNeedClientAuth());
            Device device = conn.getDevice();
            try {
                device.setKeyManager(SSLManagerFactory.createKeyManager(this.option.getKeystoreType(), this.option.getKeystoreURL(), this.option.getKeystorePass(), this.option.getKeyPass()));
                device.setTrustManager(SSLManagerFactory.createTrustManager(this.option.getTruststoreType(), this.option.getTruststoreURL(), this.option.getTruststorePass()));
                if (remote != null) {
                    remote.setTlsProtocols(conn.getTlsProtocols());
                    remote.setTlsCipherSuites(conn.getTlsCipherSuites());
                }
            }
            catch (GeneralSecurityException e) {
                throw new IOException(e);
            }
        }
    }

    public boolean isBindCallingAet() {
        return this.bindCallingAet;
    }

    public String[] getAcceptedCallingAETitles() {
        return this.acceptedCallingAETitles;
    }

    public Object getInformationModel() {
        return this.informationModel;
    }

    public EnumSet<Option.Type> getTypes() {
        return this.types;
    }

    public String[] getTsuidOrder() {
        return this.tsuidOrder;
    }

    public String getProxy() {
        return this.proxy;
    }

    public IdentityRQ getIdentity() {
        return this.identity;
    }

    public int getPriority() {
        return this.priority;
    }

    public Option getOption() {
        return this.option;
    }

    public boolean isExtendNegociation() {
        return this.extendNegociation;
    }

    public URL getExtendSopClassesURL() {
        return this.extendSopClassesURL;
    }

    public URL getExtendStorageSOPClass() {
        return this.extendStorageSOPClass;
    }

    public URL getTransferCapabilityFile() {
        return this.transferCapabilityFile;
    }

    public int getTag() {
        return this.tag;
    }

    public String[] getValues() {
        return this.values;
    }

    public int[] getParentSeqTags() {
        return this.parentSeqTags;
    }

    public String getStoragePattern() {
        return this.storagePattern;
    }

    public Editors getEditors() {
        return this.editors;
    }

    public void setBindCallingAet(boolean bindCallingAet) {
        this.bindCallingAet = bindCallingAet;
    }

    public void setAcceptedCallingAETitles(String[] acceptedCallingAETitles) {
        this.acceptedCallingAETitles = acceptedCallingAETitles;
    }

    public void setInformationModel(Object informationModel) {
        this.informationModel = informationModel;
    }

    public void setTypes(EnumSet<Option.Type> types) {
        this.types = types;
    }

    public void setTsuidOrder(String[] tsuidOrder) {
        this.tsuidOrder = tsuidOrder;
    }

    public void setProxy(String proxy) {
        this.proxy = proxy;
    }

    public void setIdentity(IdentityRQ identity) {
        this.identity = identity;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setOption(Option option) {
        this.option = option;
    }

    public void setExtendNegociation(boolean extendNegociation) {
        this.extendNegociation = extendNegociation;
    }

    public void setExtendSopClassesURL(URL extendSopClassesURL) {
        this.extendSopClassesURL = extendSopClassesURL;
    }

    public void setExtendStorageSOPClass(URL extendStorageSOPClass) {
        this.extendStorageSOPClass = extendStorageSOPClass;
    }

    public void setTransferCapabilityFile(URL transferCapabilityFile) {
        this.transferCapabilityFile = transferCapabilityFile;
    }

    public void setTag(int tag) {
        this.tag = tag;
    }

    public void setValues(String[] values) {
        this.values = values;
    }

    public void setParentSeqTags(int[] parentSeqTags) {
        this.parentSeqTags = parentSeqTags;
    }

    public void setStoragePattern(String storagePattern) {
        this.storagePattern = storagePattern;
    }

    public void setEditors(Editors editors) {
        this.editors = editors;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Args)) {
            return false;
        }
        Args other = (Args)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isBindCallingAet() != other.isBindCallingAet()) {
            return false;
        }
        if (this.getPriority() != other.getPriority()) {
            return false;
        }
        if (this.isExtendNegociation() != other.isExtendNegociation()) {
            return false;
        }
        if (this.getTag() != other.getTag()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getAcceptedCallingAETitles(), other.getAcceptedCallingAETitles())) {
            return false;
        }
        Object this$informationModel = this.getInformationModel();
        Object other$informationModel = other.getInformationModel();
        if (this$informationModel == null ? other$informationModel != null : !this$informationModel.equals(other$informationModel)) {
            return false;
        }
        EnumSet<Option.Type> this$types = this.getTypes();
        EnumSet<Option.Type> other$types = other.getTypes();
        if (this$types == null ? other$types != null : !((Object)this$types).equals(other$types)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getTsuidOrder(), other.getTsuidOrder())) {
            return false;
        }
        String this$proxy = this.getProxy();
        String other$proxy = other.getProxy();
        if (this$proxy == null ? other$proxy != null : !this$proxy.equals(other$proxy)) {
            return false;
        }
        IdentityRQ this$identity = this.getIdentity();
        IdentityRQ other$identity = other.getIdentity();
        if (this$identity == null ? other$identity != null : !this$identity.equals(other$identity)) {
            return false;
        }
        Option this$option = this.getOption();
        Option other$option = other.getOption();
        if (this$option == null ? other$option != null : !((Object)this$option).equals(other$option)) {
            return false;
        }
        URL this$extendSopClassesURL = this.getExtendSopClassesURL();
        URL other$extendSopClassesURL = other.getExtendSopClassesURL();
        if (this$extendSopClassesURL == null ? other$extendSopClassesURL != null : !((Object)this$extendSopClassesURL).equals(other$extendSopClassesURL)) {
            return false;
        }
        URL this$extendStorageSOPClass = this.getExtendStorageSOPClass();
        URL other$extendStorageSOPClass = other.getExtendStorageSOPClass();
        if (this$extendStorageSOPClass == null ? other$extendStorageSOPClass != null : !((Object)this$extendStorageSOPClass).equals(other$extendStorageSOPClass)) {
            return false;
        }
        URL this$transferCapabilityFile = this.getTransferCapabilityFile();
        URL other$transferCapabilityFile = other.getTransferCapabilityFile();
        if (this$transferCapabilityFile == null ? other$transferCapabilityFile != null : !((Object)this$transferCapabilityFile).equals(other$transferCapabilityFile)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getValues(), other.getValues())) {
            return false;
        }
        if (!Arrays.equals(this.getParentSeqTags(), other.getParentSeqTags())) {
            return false;
        }
        String this$storagePattern = this.getStoragePattern();
        String other$storagePattern = other.getStoragePattern();
        if (this$storagePattern == null ? other$storagePattern != null : !this$storagePattern.equals(other$storagePattern)) {
            return false;
        }
        Editors this$editors = this.getEditors();
        Editors other$editors = other.getEditors();
        return !(this$editors == null ? other$editors != null : !this$editors.equals(other$editors));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Args;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isBindCallingAet() ? 79 : 97);
        result = result * 59 + this.getPriority();
        result = result * 59 + (this.isExtendNegociation() ? 79 : 97);
        result = result * 59 + this.getTag();
        result = result * 59 + Arrays.deepHashCode(this.getAcceptedCallingAETitles());
        Object $informationModel = this.getInformationModel();
        result = result * 59 + ($informationModel == null ? 43 : $informationModel.hashCode());
        EnumSet<Option.Type> $types = this.getTypes();
        result = result * 59 + ($types == null ? 43 : ((Object)$types).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getTsuidOrder());
        String $proxy = this.getProxy();
        result = result * 59 + ($proxy == null ? 43 : $proxy.hashCode());
        IdentityRQ $identity = this.getIdentity();
        result = result * 59 + ($identity == null ? 43 : $identity.hashCode());
        Option $option = this.getOption();
        result = result * 59 + ($option == null ? 43 : ((Object)$option).hashCode());
        URL $extendSopClassesURL = this.getExtendSopClassesURL();
        result = result * 59 + ($extendSopClassesURL == null ? 43 : ((Object)$extendSopClassesURL).hashCode());
        URL $extendStorageSOPClass = this.getExtendStorageSOPClass();
        result = result * 59 + ($extendStorageSOPClass == null ? 43 : ((Object)$extendStorageSOPClass).hashCode());
        URL $transferCapabilityFile = this.getTransferCapabilityFile();
        result = result * 59 + ($transferCapabilityFile == null ? 43 : ((Object)$transferCapabilityFile).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getValues());
        result = result * 59 + Arrays.hashCode(this.getParentSeqTags());
        String $storagePattern = this.getStoragePattern();
        result = result * 59 + ($storagePattern == null ? 43 : $storagePattern.hashCode());
        Editors $editors = this.getEditors();
        result = result * 59 + ($editors == null ? 43 : $editors.hashCode());
        return result;
    }

    public String toString() {
        return "Args(bindCallingAet=" + this.isBindCallingAet() + ", acceptedCallingAETitles=" + Arrays.deepToString(this.getAcceptedCallingAETitles()) + ", informationModel=" + this.getInformationModel() + ", types=" + this.getTypes() + ", tsuidOrder=" + Arrays.deepToString(this.getTsuidOrder()) + ", proxy=" + this.getProxy() + ", identity=" + this.getIdentity() + ", priority=" + this.getPriority() + ", option=" + this.getOption() + ", extendNegociation=" + this.isExtendNegociation() + ", extendSopClassesURL=" + this.getExtendSopClassesURL() + ", extendStorageSOPClass=" + this.getExtendStorageSOPClass() + ", transferCapabilityFile=" + this.getTransferCapabilityFile() + ", tag=" + this.getTag() + ", values=" + Arrays.deepToString(this.getValues()) + ", parentSeqTags=" + Arrays.toString(this.getParentSeqTags()) + ", storagePattern=" + this.getStoragePattern() + ", editors=" + this.getEditors() + ")";
    }
}

