/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image;

import java.util.Arrays;
import java.util.EnumSet;
import org.aoju.bus.image.metric.internal.pdu.ExtendedNegotiate;

public class Option {
    public static final String[] TLS = new String[]{"SSL_RSA_WITH_NULL_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA"};
    public static final String[] TLS_NULL = new String[]{"SSL_RSA_WITH_NULL_SHA"};
    public static final String[] TLS_3DES = new String[]{"SSL_RSA_WITH_3DES_EDE_CBC_SHA"};
    public static final String[] TLS_AES = new String[]{"TLS_RSA_WITH_AES_128_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA"};
    public static final String[] defaultProtocols = new String[]{"TLSv1", "SSLv3"};
    public static final String[] tls1 = new String[]{"TLSv1"};
    public static final String[] tls11 = new String[]{"TLSv1.1"};
    public static final String[] tls12 = new String[]{"TLSv1.2"};
    public static final String[] ssl3 = new String[]{"SSLv3"};
    public static final String[] ssl2Hello = new String[]{"SSLv2Hello", "SSLv3", "TLSv1", "TLSv1.1", "TLSv1.2"};
    private int maxOpsInvoked = 1;
    private int maxOpsPerformed = 1;
    private int maxPdulenRcv = 16378;
    private int maxPdulenSnd = 16378;
    private boolean packPDV = true;
    private int backlog = 50;
    private int connectTimeout = 0;
    private int requestTimeout = 0;
    private int acceptTimeout = 0;
    private int releaseTimeout = 0;
    private int responseTimeout = 0;
    private int retrieveTimeout = 0;
    private int idleTimeout = 0;
    private int socloseDelay = 50;
    private int sosndBuffer = 0;
    private int sorcvBuffer = 0;
    private boolean tcpNoDelay = true;
    private String[] cipherSuites;
    private String[] tlsProtocols;
    private boolean tlsNeedClientAuth;
    private String keystoreURL;
    private String keystoreType;
    private String keystorePass;
    private String keyPass;
    private String truststoreURL;
    private String truststoreType;
    private String truststorePass;

    public Option() {
    }

    public Option(boolean tlsNeedClientAuth, String keystoreURL, String keystoreType, String keystorePass, String keyPass, String truststoreURL, String truststoreType, String truststorePass) {
        this(TLS, defaultProtocols, tlsNeedClientAuth, keystoreURL, keystoreType, keystorePass, keyPass, truststoreURL, truststoreType, truststorePass);
    }

    public Option(String[] cipherSuites, String[] tlsProtocols, boolean tlsNeedClientAuth, String keystoreURL, String keystoreType, String keystorePass, String keyPass, String truststoreURL, String truststoreType, String truststorePass) {
        if (cipherSuites == null) {
            throw new IllegalArgumentException("cipherSuites cannot be null");
        }
        this.cipherSuites = cipherSuites;
        this.tlsProtocols = tlsProtocols;
        this.tlsNeedClientAuth = tlsNeedClientAuth;
        this.keystoreURL = keystoreURL;
        this.keystoreType = keystoreType;
        this.keystorePass = keystorePass;
        this.keyPass = keyPass;
        this.truststoreURL = truststoreURL;
        this.truststoreType = truststoreType;
        this.truststorePass = truststorePass;
    }

    public int getMaxOpsInvoked() {
        return this.maxOpsInvoked;
    }

    public int getMaxOpsPerformed() {
        return this.maxOpsPerformed;
    }

    public int getMaxPdulenRcv() {
        return this.maxPdulenRcv;
    }

    public int getMaxPdulenSnd() {
        return this.maxPdulenSnd;
    }

    public boolean isPackPDV() {
        return this.packPDV;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public int getAcceptTimeout() {
        return this.acceptTimeout;
    }

    public int getReleaseTimeout() {
        return this.releaseTimeout;
    }

    public int getResponseTimeout() {
        return this.responseTimeout;
    }

    public int getRetrieveTimeout() {
        return this.retrieveTimeout;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public int getSocloseDelay() {
        return this.socloseDelay;
    }

    public int getSosndBuffer() {
        return this.sosndBuffer;
    }

    public int getSorcvBuffer() {
        return this.sorcvBuffer;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public String[] getCipherSuites() {
        return this.cipherSuites;
    }

    public String[] getTlsProtocols() {
        return this.tlsProtocols;
    }

    public boolean isTlsNeedClientAuth() {
        return this.tlsNeedClientAuth;
    }

    public String getKeystoreURL() {
        return this.keystoreURL;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public String getKeystorePass() {
        return this.keystorePass;
    }

    public String getKeyPass() {
        return this.keyPass;
    }

    public String getTruststoreURL() {
        return this.truststoreURL;
    }

    public String getTruststoreType() {
        return this.truststoreType;
    }

    public String getTruststorePass() {
        return this.truststorePass;
    }

    public void setMaxOpsInvoked(int maxOpsInvoked) {
        this.maxOpsInvoked = maxOpsInvoked;
    }

    public void setMaxOpsPerformed(int maxOpsPerformed) {
        this.maxOpsPerformed = maxOpsPerformed;
    }

    public void setMaxPdulenRcv(int maxPdulenRcv) {
        this.maxPdulenRcv = maxPdulenRcv;
    }

    public void setMaxPdulenSnd(int maxPdulenSnd) {
        this.maxPdulenSnd = maxPdulenSnd;
    }

    public void setPackPDV(boolean packPDV) {
        this.packPDV = packPDV;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public void setAcceptTimeout(int acceptTimeout) {
        this.acceptTimeout = acceptTimeout;
    }

    public void setReleaseTimeout(int releaseTimeout) {
        this.releaseTimeout = releaseTimeout;
    }

    public void setResponseTimeout(int responseTimeout) {
        this.responseTimeout = responseTimeout;
    }

    public void setRetrieveTimeout(int retrieveTimeout) {
        this.retrieveTimeout = retrieveTimeout;
    }

    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public void setSocloseDelay(int socloseDelay) {
        this.socloseDelay = socloseDelay;
    }

    public void setSosndBuffer(int sosndBuffer) {
        this.sosndBuffer = sosndBuffer;
    }

    public void setSorcvBuffer(int sorcvBuffer) {
        this.sorcvBuffer = sorcvBuffer;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public void setCipherSuites(String[] cipherSuites) {
        this.cipherSuites = cipherSuites;
    }

    public void setTlsProtocols(String[] tlsProtocols) {
        this.tlsProtocols = tlsProtocols;
    }

    public void setTlsNeedClientAuth(boolean tlsNeedClientAuth) {
        this.tlsNeedClientAuth = tlsNeedClientAuth;
    }

    public void setKeystoreURL(String keystoreURL) {
        this.keystoreURL = keystoreURL;
    }

    public void setKeystoreType(String keystoreType) {
        this.keystoreType = keystoreType;
    }

    public void setKeystorePass(String keystorePass) {
        this.keystorePass = keystorePass;
    }

    public void setKeyPass(String keyPass) {
        this.keyPass = keyPass;
    }

    public void setTruststoreURL(String truststoreURL) {
        this.truststoreURL = truststoreURL;
    }

    public void setTruststoreType(String truststoreType) {
        this.truststoreType = truststoreType;
    }

    public void setTruststorePass(String truststorePass) {
        this.truststorePass = truststorePass;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Option)) {
            return false;
        }
        Option other = (Option)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxOpsInvoked() != other.getMaxOpsInvoked()) {
            return false;
        }
        if (this.getMaxOpsPerformed() != other.getMaxOpsPerformed()) {
            return false;
        }
        if (this.getMaxPdulenRcv() != other.getMaxPdulenRcv()) {
            return false;
        }
        if (this.getMaxPdulenSnd() != other.getMaxPdulenSnd()) {
            return false;
        }
        if (this.isPackPDV() != other.isPackPDV()) {
            return false;
        }
        if (this.getBacklog() != other.getBacklog()) {
            return false;
        }
        if (this.getConnectTimeout() != other.getConnectTimeout()) {
            return false;
        }
        if (this.getRequestTimeout() != other.getRequestTimeout()) {
            return false;
        }
        if (this.getAcceptTimeout() != other.getAcceptTimeout()) {
            return false;
        }
        if (this.getReleaseTimeout() != other.getReleaseTimeout()) {
            return false;
        }
        if (this.getResponseTimeout() != other.getResponseTimeout()) {
            return false;
        }
        if (this.getRetrieveTimeout() != other.getRetrieveTimeout()) {
            return false;
        }
        if (this.getIdleTimeout() != other.getIdleTimeout()) {
            return false;
        }
        if (this.getSocloseDelay() != other.getSocloseDelay()) {
            return false;
        }
        if (this.getSosndBuffer() != other.getSosndBuffer()) {
            return false;
        }
        if (this.getSorcvBuffer() != other.getSorcvBuffer()) {
            return false;
        }
        if (this.isTcpNoDelay() != other.isTcpNoDelay()) {
            return false;
        }
        if (this.isTlsNeedClientAuth() != other.isTlsNeedClientAuth()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getCipherSuites(), other.getCipherSuites())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getTlsProtocols(), other.getTlsProtocols())) {
            return false;
        }
        String this$keystoreURL = this.getKeystoreURL();
        String other$keystoreURL = other.getKeystoreURL();
        if (this$keystoreURL == null ? other$keystoreURL != null : !this$keystoreURL.equals(other$keystoreURL)) {
            return false;
        }
        String this$keystoreType = this.getKeystoreType();
        String other$keystoreType = other.getKeystoreType();
        if (this$keystoreType == null ? other$keystoreType != null : !this$keystoreType.equals(other$keystoreType)) {
            return false;
        }
        String this$keystorePass = this.getKeystorePass();
        String other$keystorePass = other.getKeystorePass();
        if (this$keystorePass == null ? other$keystorePass != null : !this$keystorePass.equals(other$keystorePass)) {
            return false;
        }
        String this$keyPass = this.getKeyPass();
        String other$keyPass = other.getKeyPass();
        if (this$keyPass == null ? other$keyPass != null : !this$keyPass.equals(other$keyPass)) {
            return false;
        }
        String this$truststoreURL = this.getTruststoreURL();
        String other$truststoreURL = other.getTruststoreURL();
        if (this$truststoreURL == null ? other$truststoreURL != null : !this$truststoreURL.equals(other$truststoreURL)) {
            return false;
        }
        String this$truststoreType = this.getTruststoreType();
        String other$truststoreType = other.getTruststoreType();
        if (this$truststoreType == null ? other$truststoreType != null : !this$truststoreType.equals(other$truststoreType)) {
            return false;
        }
        String this$truststorePass = this.getTruststorePass();
        String other$truststorePass = other.getTruststorePass();
        return !(this$truststorePass == null ? other$truststorePass != null : !this$truststorePass.equals(other$truststorePass));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Option;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxOpsInvoked();
        result = result * 59 + this.getMaxOpsPerformed();
        result = result * 59 + this.getMaxPdulenRcv();
        result = result * 59 + this.getMaxPdulenSnd();
        result = result * 59 + (this.isPackPDV() ? 79 : 97);
        result = result * 59 + this.getBacklog();
        result = result * 59 + this.getConnectTimeout();
        result = result * 59 + this.getRequestTimeout();
        result = result * 59 + this.getAcceptTimeout();
        result = result * 59 + this.getReleaseTimeout();
        result = result * 59 + this.getResponseTimeout();
        result = result * 59 + this.getRetrieveTimeout();
        result = result * 59 + this.getIdleTimeout();
        result = result * 59 + this.getSocloseDelay();
        result = result * 59 + this.getSosndBuffer();
        result = result * 59 + this.getSorcvBuffer();
        result = result * 59 + (this.isTcpNoDelay() ? 79 : 97);
        result = result * 59 + (this.isTlsNeedClientAuth() ? 79 : 97);
        result = result * 59 + Arrays.deepHashCode(this.getCipherSuites());
        result = result * 59 + Arrays.deepHashCode(this.getTlsProtocols());
        String $keystoreURL = this.getKeystoreURL();
        result = result * 59 + ($keystoreURL == null ? 43 : $keystoreURL.hashCode());
        String $keystoreType = this.getKeystoreType();
        result = result * 59 + ($keystoreType == null ? 43 : $keystoreType.hashCode());
        String $keystorePass = this.getKeystorePass();
        result = result * 59 + ($keystorePass == null ? 43 : $keystorePass.hashCode());
        String $keyPass = this.getKeyPass();
        result = result * 59 + ($keyPass == null ? 43 : $keyPass.hashCode());
        String $truststoreURL = this.getTruststoreURL();
        result = result * 59 + ($truststoreURL == null ? 43 : $truststoreURL.hashCode());
        String $truststoreType = this.getTruststoreType();
        result = result * 59 + ($truststoreType == null ? 43 : $truststoreType.hashCode());
        String $truststorePass = this.getTruststorePass();
        result = result * 59 + ($truststorePass == null ? 43 : $truststorePass.hashCode());
        return result;
    }

    public String toString() {
        return "Option(maxOpsInvoked=" + this.getMaxOpsInvoked() + ", maxOpsPerformed=" + this.getMaxOpsPerformed() + ", maxPdulenRcv=" + this.getMaxPdulenRcv() + ", maxPdulenSnd=" + this.getMaxPdulenSnd() + ", packPDV=" + this.isPackPDV() + ", backlog=" + this.getBacklog() + ", connectTimeout=" + this.getConnectTimeout() + ", requestTimeout=" + this.getRequestTimeout() + ", acceptTimeout=" + this.getAcceptTimeout() + ", releaseTimeout=" + this.getReleaseTimeout() + ", responseTimeout=" + this.getResponseTimeout() + ", retrieveTimeout=" + this.getRetrieveTimeout() + ", idleTimeout=" + this.getIdleTimeout() + ", socloseDelay=" + this.getSocloseDelay() + ", sosndBuffer=" + this.getSosndBuffer() + ", sorcvBuffer=" + this.getSorcvBuffer() + ", tcpNoDelay=" + this.isTcpNoDelay() + ", cipherSuites=" + Arrays.deepToString(this.getCipherSuites()) + ", tlsProtocols=" + Arrays.deepToString(this.getTlsProtocols()) + ", tlsNeedClientAuth=" + this.isTlsNeedClientAuth() + ", keystoreURL=" + this.getKeystoreURL() + ", keystoreType=" + this.getKeystoreType() + ", keystorePass=" + this.getKeystorePass() + ", keyPass=" + this.getKeyPass() + ", truststoreURL=" + this.getTruststoreURL() + ", truststoreType=" + this.getTruststoreType() + ", truststorePass=" + this.getTruststorePass() + ")";
    }

    public static enum Type {
        RELATIONAL,
        DATETIME,
        FUZZY,
        TIMEZONE;


        public static byte[] toExtendedNegotiationInformation(EnumSet<Type> opts) {
            byte[] info = new byte[opts.contains((Object)TIMEZONE) ? 4 : (opts.contains((Object)FUZZY) || opts.contains((Object)DATETIME) ? 3 : 1)];
            for (Type query : opts) {
                info[query.ordinal()] = 1;
            }
            return info;
        }

        public static EnumSet<Type> toOptions(ExtendedNegotiate extNeg) {
            EnumSet<Type> opts = EnumSet.noneOf(Type.class);
            if (extNeg != null) {
                Type.toOption(extNeg, RELATIONAL, opts);
                Type.toOption(extNeg, DATETIME, opts);
                Type.toOption(extNeg, FUZZY, opts);
                Type.toOption(extNeg, TIMEZONE, opts);
            }
            return opts;
        }

        private static void toOption(ExtendedNegotiate extNeg, Type opt, EnumSet<Type> opts) {
            if (extNeg.getField(opt.ordinal(), (byte)0) == 1) {
                opts.add(opt);
            }
        }
    }
}

