/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.nimble.codec;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.imageio.spi.ImageReaderWriterSpi;

final class FormatNameFilterIterator<T extends ImageReaderWriterSpi>
implements Iterator<T> {
    private final Iterator<T> iter;
    private final String formatName;
    private T next = null;

    FormatNameFilterIterator(Iterator<T> iter, String formatName) {
        this.iter = iter;
        this.formatName = formatName;
        this.advance();
    }

    private static boolean contains(String[] names, String name) {
        for (int i = 0; i < names.length; ++i) {
            if (!name.equalsIgnoreCase(names[i])) continue;
            return true;
        }
        return false;
    }

    private void advance() {
        while (this.iter.hasNext()) {
            ImageReaderWriterSpi elt = (ImageReaderWriterSpi)this.iter.next();
            if (!FormatNameFilterIterator.contains(elt.getFormatNames(), this.formatName)) continue;
            this.next = elt;
            return;
        }
        this.next = null;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public T next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        T o = this.next;
        this.advance();
        return o;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

