/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.nimble.opencv;

import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.util.Arrays;
import java.util.Objects;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.image.nimble.opencv.ImageCV;
import org.aoju.bus.image.nimble.opencv.ImageConversion;
import org.opencv.core.CvType;
import org.opencv.core.Mat;

public class LookupTableCV {
    private final int[] offsets;
    private final DataBuffer data;
    private final boolean forceReadingUnsigned;

    public LookupTableCV(byte[] data) {
        this(data, 0);
    }

    public LookupTableCV(byte[] data, int offset) {
        this(data, offset, false);
    }

    public LookupTableCV(byte[] data, int offset, boolean forceReadingUnsigned) {
        this.offsets = new int[1];
        Arrays.fill(this.offsets, offset);
        this.data = new DataBufferByte(Objects.requireNonNull(data), data.length);
        this.forceReadingUnsigned = forceReadingUnsigned;
    }

    public LookupTableCV(byte[][] data) {
        this(data, new int[data.length]);
    }

    public LookupTableCV(byte[][] data, int offset) {
        this(data, new int[data.length]);
        Arrays.fill(this.offsets, offset);
    }

    public LookupTableCV(byte[][] data, int[] offsets) {
        this(data, offsets, false);
    }

    public LookupTableCV(byte[][] data, int[] offsets, boolean forceReadingUnsigned) {
        this.offsets = Arrays.copyOf(offsets, data.length);
        this.data = new DataBufferByte(Objects.requireNonNull(data), data[0].length);
        this.forceReadingUnsigned = forceReadingUnsigned;
    }

    public LookupTableCV(short[] data, int offset, boolean isUShort) {
        this(data, offset, isUShort, false);
    }

    public LookupTableCV(short[] data, int offset, boolean isUShort, boolean forceReadingUnsigned) {
        this.offsets = new int[1];
        Arrays.fill(this.offsets, offset);
        this.data = isUShort ? new DataBufferUShort(Objects.requireNonNull(data), data.length) : new DataBufferShort(Objects.requireNonNull(data), data.length);
        this.forceReadingUnsigned = forceReadingUnsigned;
    }

    private static int index(int pixel, int offset, int length) {
        int val = pixel - offset;
        if (val < 0) {
            val = 0;
        } else if (val > length) {
            val = length;
        }
        return val;
    }

    public DataBuffer getData() {
        return this.data;
    }

    public byte[][] getByteData() {
        return this.data instanceof DataBufferByte ? ((DataBufferByte)this.data).getBankData() : (byte[][])null;
    }

    public byte[] getByteData(int band) {
        return this.data instanceof DataBufferByte ? ((DataBufferByte)this.data).getData(band) : null;
    }

    public short[][] getShortData() {
        if (this.data instanceof DataBufferUShort) {
            return ((DataBufferUShort)this.data).getBankData();
        }
        if (this.data instanceof DataBufferShort) {
            return ((DataBufferShort)this.data).getBankData();
        }
        return null;
    }

    public short[] getShortData(int band) {
        if (this.data instanceof DataBufferUShort) {
            return ((DataBufferUShort)this.data).getData(band);
        }
        if (this.data instanceof DataBufferShort) {
            return ((DataBufferShort)this.data).getData(band);
        }
        return null;
    }

    public int[] getOffsets() {
        return this.offsets;
    }

    public int getOffset() {
        return this.offsets[0];
    }

    public int getNumBands() {
        return this.data.getNumBanks();
    }

    public int getNumEntries() {
        return this.data.getSize();
    }

    public int getDataType() {
        return this.data.getDataType();
    }

    public int lookup(int band, int value) {
        return this.data.getElem(band, value - this.offsets[band]);
    }

    public int getOffset(int band) {
        return this.offsets[band];
    }

    public ImageCV lookup(Mat src) {
        boolean scrByte;
        Objects.requireNonNull(src);
        int width = src.width();
        int height = src.height();
        int cvType = src.type();
        int channels = CvType.channels((int)cvType);
        int srcDataType = ImageConversion.convertToDataType(cvType);
        byte[] bSrcData = null;
        short[] sSrcData = null;
        if (CvType.depth((int)cvType) == 0 || CvType.depth((int)cvType) == 1) {
            bSrcData = new byte[width * height * channels];
            src.get(0, 0, bSrcData);
        } else if (CvType.depth((int)cvType) == 2 || CvType.depth((int)cvType) == 3) {
            sSrcData = new short[width * height * channels];
            src.get(0, 0, sSrcData);
        } else {
            throw new IllegalArgumentException("Not suported dataType for LUT transformation:" + src.toString());
        }
        int lkbBands = this.getNumBands();
        int lkpDataType = this.getDataType();
        int[] tblOffsets = this.getOffsets();
        Object bTblData = this.getByteData();
        Object sTblData = this.getShortData();
        if (lkbBands < channels) {
            Object[] b;
            if (sTblData == null) {
                b = bTblData[0];
                bTblData = new byte[channels][];
                Arrays.fill((Object[])bTblData, b);
            } else {
                b = sTblData[0];
                sTblData = new short[channels][];
                Arrays.fill((Object[])sTblData, b);
            }
            int t = tblOffsets[0];
            tblOffsets = new int[channels];
            Arrays.fill(tblOffsets, t);
            lkbBands = channels;
        }
        if (lkpDataType == 0) {
            byte[] bDstData;
            scrByte = srcDataType == 0;
            byte[] byArray = bDstData = scrByte && channels >= lkbBands ? bSrcData : new byte[width * height * lkbBands];
            if (scrByte && bSrcData != null) {
                this.lookup(bSrcData, bDstData, tblOffsets, (byte[][])bTblData);
            } else if (srcDataType == 1 && sSrcData != null && bDstData != null) {
                this.lookupU(sSrcData, bDstData, tblOffsets, (byte[][])bTblData);
            } else if (srcDataType == 2 && sSrcData != null && bDstData != null) {
                this.lookup(sSrcData, bDstData, tblOffsets, (byte[][])bTblData);
            } else {
                throw new IllegalArgumentException("Not supported LUT conversion from source dataType " + srcDataType);
            }
            ImageCV dst = new ImageCV(height, width, CvType.CV_8UC((int)lkbBands));
            dst.put(0, 0, bDstData);
            return dst;
        }
        if (lkpDataType == 1 || lkpDataType == 2) {
            short[] sDstData;
            scrByte = srcDataType == 0;
            short[] sArray = sDstData = !scrByte && channels >= lkbBands ? sSrcData : new short[width * height * lkbBands];
            if (scrByte && ObjectKit.isNotNull((Object)bSrcData) && ObjectKit.isNotNull((Object)sTblData)) {
                this.lookup(bSrcData, sDstData, tblOffsets, (short[][])sTblData);
            } else if (srcDataType == 1 && ObjectKit.isNotNull((Object)sSrcData) && ObjectKit.isNotNull((Object)sTblData)) {
                this.lookupU(sSrcData, sDstData, tblOffsets, (short[][])sTblData);
            } else if (srcDataType == 2 && ObjectKit.isNotNull((Object)sSrcData) && ObjectKit.isNotNull((Object)sTblData)) {
                this.lookup(sSrcData, sDstData, tblOffsets, (short[][])sTblData);
            } else {
                throw new IllegalArgumentException("Not supported LUT conversion from source dataType " + srcDataType);
            }
            ImageCV dst = new ImageCV(height, width, lkpDataType == 1 ? CvType.CV_16UC((int)channels) : CvType.CV_16SC((int)channels));
            dst.put(0, 0, sDstData);
            return dst;
        }
        return null;
    }

    private void lookup(byte[] srcData, byte[] dstData, int[] tblOffsets, byte[][] tblData) {
        int bOffset = tblData.length;
        if (srcData.length < dstData.length) {
            for (int i = 0; i < srcData.length; ++i) {
                int val = srcData[i] & 0xFF;
                for (int b = 0; b < bOffset; ++b) {
                    dstData[i * bOffset + b] = tblData[b][LookupTableCV.index(val, tblOffsets[b], tblData[b].length - 1)];
                }
            }
        } else {
            for (int b = 0; b < bOffset; ++b) {
                byte[] t = tblData[b];
                int tblOffset = tblOffsets[b];
                int maxLength = t.length - 1;
                for (int i = b; i < srcData.length; i += bOffset) {
                    dstData[i] = t[LookupTableCV.index(srcData[i] & 0xFF, tblOffset, maxLength)];
                }
            }
        }
    }

    private void lookupU(short[] srcData, byte[] dstData, int[] tblOffsets, byte[][] tblData) {
        int bOffset = tblData.length;
        if (srcData.length < dstData.length) {
            for (int i = 0; i < srcData.length; ++i) {
                int val = srcData[i] & 0xFFFF;
                for (int b = 0; b < bOffset; ++b) {
                    dstData[i * bOffset + b] = tblData[b][LookupTableCV.index(val, tblOffsets[b], tblData[b].length - 1)];
                }
            }
        } else {
            for (int b = 0; b < bOffset; ++b) {
                byte[] t = tblData[b];
                int tblOffset = tblOffsets[b];
                int maxLength = t.length - 1;
                for (int i = b; i < srcData.length; i += bOffset) {
                    dstData[i] = t[LookupTableCV.index(srcData[i] & 0xFFFF, tblOffset, maxLength)];
                }
            }
        }
    }

    private void lookup(short[] srcData, byte[] dstData, int[] tblOffsets, byte[][] tblData) {
        int mask;
        int bOffset = tblData.length;
        int n = mask = this.forceReadingUnsigned ? 65535 : -1;
        if (srcData.length < dstData.length) {
            for (int i = 0; i < srcData.length; ++i) {
                int val = srcData[i] & mask;
                for (int b = 0; b < bOffset; ++b) {
                    dstData[i * bOffset + b] = tblData[b][LookupTableCV.index(val, tblOffsets[b], tblData[b].length - 1)];
                }
            }
        } else {
            for (int b = 0; b < bOffset; ++b) {
                byte[] t = tblData[b];
                int tblOffset = tblOffsets[b];
                int maxLength = t.length - 1;
                for (int i = b; i < srcData.length; i += bOffset) {
                    dstData[i] = t[LookupTableCV.index(srcData[i] & mask, tblOffset, maxLength)];
                }
            }
        }
    }

    private void lookup(byte[] srcData, short[] dstData, int[] tblOffsets, short[][] tblData) {
        int bOffset = tblData.length;
        if (srcData.length < dstData.length) {
            for (int i = 0; i < srcData.length; ++i) {
                int val = srcData[i] & 0xFF;
                for (int b = 0; b < bOffset; ++b) {
                    dstData[i * bOffset + b] = tblData[b][LookupTableCV.index(val, tblOffsets[b], tblData[b].length - 1)];
                }
            }
        } else {
            for (int b = 0; b < bOffset; ++b) {
                short[] t = tblData[b];
                int tblOffset = tblOffsets[b];
                int maxLength = t.length - 1;
                for (int i = b; i < srcData.length; i += bOffset) {
                    dstData[i] = t[LookupTableCV.index(srcData[i] & 0xFF, tblOffset, maxLength)];
                }
            }
        }
    }

    private void lookupU(short[] srcData, short[] dstData, int[] tblOffsets, short[][] tblData) {
        int bOffset = tblData.length;
        if (srcData.length < dstData.length) {
            for (int i = 0; i < srcData.length; ++i) {
                int val = srcData[i] & 0xFFFF;
                for (int b = 0; b < bOffset; ++b) {
                    dstData[i * bOffset + b] = tblData[b][LookupTableCV.index(val, tblOffsets[b], tblData[b].length - 1)];
                }
            }
        } else {
            for (int b = 0; b < bOffset; ++b) {
                short[] t = tblData[b];
                int tblOffset = tblOffsets[b];
                int maxLength = t.length - 1;
                for (int i = b; i < srcData.length; i += bOffset) {
                    dstData[i] = t[LookupTableCV.index(srcData[i] & 0xFFFF, tblOffset, maxLength)];
                }
            }
        }
    }

    private void lookup(short[] srcData, short[] dstData, int[] tblOffsets, short[][] tblData) {
        int mask;
        int bOffset = tblData.length;
        int n = mask = this.forceReadingUnsigned ? 65535 : -1;
        if (srcData.length < dstData.length) {
            for (int i = 0; i < srcData.length; ++i) {
                int val = srcData[i] & mask;
                for (int b = 0; b < bOffset; ++b) {
                    dstData[i * bOffset + b] = tblData[b][LookupTableCV.index(val, tblOffsets[b], tblData[b].length - 1)];
                }
            }
        } else {
            for (int b = 0; b < bOffset; ++b) {
                short[] t = tblData[b];
                int tblOffset = tblOffsets[b];
                int maxLength = t.length - 1;
                for (int i = b; i < srcData.length; i += bOffset) {
                    dstData[i] = t[LookupTableCV.index(srcData[i] & mask, tblOffset, maxLength)];
                }
            }
        }
    }
}

