/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.nimble.codec.jpeg;

import org.aoju.bus.core.toolkit.ByteKit;

public class SOFSegment {
    private final byte[] data;
    private final int offset;
    private final int numComponents;

    public SOFSegment(byte[] data, int offset) {
        this.data = data;
        this.offset = offset;
        this.numComponents = data[offset + 8] & 0xFF;
        this.getQTableSelector(this.numComponents - 1);
    }

    public int offset() {
        return this.offset;
    }

    public int getMarker() {
        return this.data[this.offset] & 0xFF;
    }

    public int getHeaderLength() {
        return ByteKit.bytesToUShortBE((byte[])this.data, (int)(this.offset + 1));
    }

    public int getPrecision() {
        return this.data[this.offset + 3] & 0xFF;
    }

    public int getY() {
        return ByteKit.bytesToUShortBE((byte[])this.data, (int)(this.offset + 4));
    }

    public int getX() {
        return ByteKit.bytesToUShortBE((byte[])this.data, (int)(this.offset + 6));
    }

    public int getNumComponents() {
        return this.numComponents;
    }

    public int getComponentID(int index) {
        return this.data[this.offset + 9 + index * 3] & 0xFF;
    }

    public int getXSubsampling(int index) {
        return this.data[this.offset + 10 + index * 3] >> 4 & 0xF;
    }

    public int getYSubsampling(int index) {
        return this.data[this.offset + 10 + index * 3] & 0xF;
    }

    public int getQTableSelector(int index) {
        return this.data[this.offset + 11 + index * 3] & 0xFF;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SOF").append(this.getMarker() - 192).append("[Lf=").append(this.getHeaderLength()).append(", P=").append(this.getPrecision()).append(", Y=").append(this.getY()).append(", X=").append(this.getX()).append(", Nf=").append(this.numComponents);
        for (int i = 0; i < this.numComponents; ++i) {
            sb.append(", C").append(i + 1).append('=').append(this.getComponentID(i)).append(", H").append(i + 1).append('=').append(this.getXSubsampling(i)).append(", V").append(i + 1).append('=').append(this.getYSubsampling(i)).append(", Tq").append(i + 1).append('=').append(this.getQTableSelector(i));
        }
        sb.append(']');
        return sb.toString();
    }
}

