/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.galaxy.media;

import java.io.DataOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import javax.xml.parsers.ParserConfigurationException;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.image.UID;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.data.BulkData;
import org.aoju.bus.image.galaxy.data.DatePrecision;
import org.aoju.bus.image.galaxy.data.VR;
import org.aoju.bus.image.galaxy.io.SAXReader;
import org.aoju.bus.image.galaxy.media.MultipartParser;
import org.aoju.bus.logger.Logger;
import org.xml.sax.SAXException;

public class AbstractStowrs
implements AutoCloseable {
    protected static final String MULTIPART_BOUNDARY = "mimeTypeBoundary";
    private final List<HttpURLConnection> connections;
    private final String contentType;
    private final String requestURL;
    private final String agentName;
    private final Map<String, String> headers;

    public AbstractStowrs(String requestURL, String contentType, String agentName, Map<String, String> headers) {
        this.contentType = Objects.requireNonNull(contentType);
        this.requestURL = Objects.requireNonNull(requestURL, "requestURL cannot be null");
        this.headers = headers;
        this.agentName = agentName;
        this.connections = new ArrayList<HttpURLConnection>();
    }

    protected static void ensureUID(Attributes attrs, int tag) {
        if (!attrs.containsValue(tag)) {
            attrs.setString(tag, VR.UI, UID.createUID());
        }
    }

    protected static void setEncapsulatedDocumentAttributes(Path bulkDataFile, Attributes metadata, String mimeType) {
        metadata.setInt(2097171, VR.IS, 1);
        metadata.setString(524323, VR.DA, AbstractStowrs.formatDA(null, new Date(bulkDataFile.toFile().lastModified())));
        metadata.setString(524339, VR.TM, AbstractStowrs.formatTM(null, new Date(bulkDataFile.toFile().lastModified())));
        metadata.setString(524330, VR.DT, AbstractStowrs.formatTM(null, new Date(bulkDataFile.toFile().lastModified())));
        metadata.setString(2622209, VR.CS, "YES");
        metadata.setNull(4325392, VR.ST);
        metadata.setNull(4235331, VR.SQ);
        metadata.setString(4325394, VR.LO, mimeType);
    }

    public static String formatDA(TimeZone tz, Date date) {
        return AbstractStowrs.formatDA(tz, date, new StringBuilder(8)).toString();
    }

    public static StringBuilder formatDA(TimeZone tz, Date date, StringBuilder toAppendTo) {
        return AbstractStowrs.formatDT(AbstractStowrs.cal(tz, date), toAppendTo, 5);
    }

    private static StringBuilder formatDT(Calendar cal, StringBuilder toAppendTo, int lastField) {
        AbstractStowrs.appendXXXX(cal.get(1), toAppendTo);
        if (lastField > 1) {
            AbstractStowrs.appendXX(cal.get(2) + 1, toAppendTo);
            if (lastField > 2) {
                AbstractStowrs.appendXX(cal.get(5), toAppendTo);
                if (lastField > 5) {
                    AbstractStowrs.formatTM(cal, toAppendTo, lastField);
                }
            }
        }
        return toAppendTo;
    }

    public static String formatTM(TimeZone tz, Date date) {
        return AbstractStowrs.formatTM(tz, date, new DatePrecision());
    }

    public static String formatTM(TimeZone tz, Date date, DatePrecision precision) {
        return AbstractStowrs.formatTM(AbstractStowrs.cal(tz, date), new StringBuilder(10), precision.lastField).toString();
    }

    private static StringBuilder formatTM(Calendar cal, StringBuilder toAppendTo, int lastField) {
        AbstractStowrs.appendXX(cal.get(11), toAppendTo);
        if (lastField > 11) {
            AbstractStowrs.appendXX(cal.get(12), toAppendTo);
            if (lastField > 12) {
                AbstractStowrs.appendXX(cal.get(13), toAppendTo);
                if (lastField > 13) {
                    toAppendTo.append('.');
                    AbstractStowrs.appendXXX(cal.get(14), toAppendTo);
                }
            }
        }
        return toAppendTo;
    }

    private static Calendar cal(TimeZone tz, Date date) {
        GregorianCalendar cal = null != tz ? new GregorianCalendar(tz) : new GregorianCalendar();
        cal.setTime(date);
        return cal;
    }

    private static void appendXXXX(int i, StringBuilder toAppendTo) {
        if (i < 1000) {
            toAppendTo.append('0');
        }
        AbstractStowrs.appendXXX(i, toAppendTo);
    }

    private static void appendXXX(int i, StringBuilder toAppendTo) {
        if (i < 100) {
            toAppendTo.append('0');
        }
        AbstractStowrs.appendXX(i, toAppendTo);
    }

    private static void appendXX(int i, StringBuilder toAppendTo) {
        if (i < 10) {
            toAppendTo.append('0');
        }
        toAppendTo.append(i);
    }

    protected HttpURLConnection buildConnection() throws IOException {
        try {
            URL url = new URL(this.requestURL);
            HttpURLConnection httpPost = (HttpURLConnection)url.openConnection();
            httpPost.setUseCaches(false);
            httpPost.setDoOutput(true);
            httpPost.setDoInput(true);
            httpPost.setRequestMethod("POST");
            httpPost.setConnectTimeout(10000);
            httpPost.setReadTimeout(60000);
            httpPost.setRequestProperty("Content-Type", "multipart/related; type=\"" + this.contentType + "\"; boundary=" + MULTIPART_BOUNDARY);
            httpPost.setRequestProperty("User-Agent", null == this.agentName ? "STOWRS" : this.agentName);
            httpPost.setRequestProperty("Accept", this.contentType == "application/dicom+json" ? "application/dicom+json" : "application/dicom+xml");
            if (null != this.headers && !this.headers.isEmpty()) {
                for (Map.Entry<String, String> element : this.headers.entrySet()) {
                    httpPost.setRequestProperty(element.getKey(), element.getValue());
                }
            }
            this.connections.add(httpPost);
            return httpPost;
        }
        catch (IOException e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    private void endMarkers(DataOutputStream out) throws IOException {
        out.write(MultipartParser.Separator.BOUNDARY.getType());
        out.writeBytes(MULTIPART_BOUNDARY);
        out.write(MultipartParser.Separator.STREAM.getType());
        out.flush();
        out.close();
    }

    protected void writeContentMarkers(DataOutputStream out) throws IOException {
        out.write(MultipartParser.Separator.BOUNDARY.getType());
        out.writeBytes(MULTIPART_BOUNDARY);
        out.write(MultipartParser.Separator.FIELD.getType());
        out.writeBytes("Content-Type: ");
        out.writeBytes(this.contentType);
        out.write(MultipartParser.Separator.HEADER.getType());
    }

    protected void writeEndMarkers(HttpURLConnection httpPost, DataOutputStream out, String iuid) throws IOException {
        this.endMarkers(out);
        int code = httpPost.getResponseCode();
        if (code != 200) {
            throw new InstrumentException(String.format("STOWRS server response message: %s", httpPost.getResponseMessage()));
        }
        Logger.info((String)"STOWRS server response message: HTTP Status-Code 200: OK for {}", (Object[])new Object[]{iuid});
    }

    protected Attributes writeEndMarkers(HttpURLConnection httpPost, DataOutputStream out) throws IOException, ParserConfigurationException, SAXException {
        this.endMarkers(out);
        int code = httpPost.getResponseCode();
        if (code != 200) {
            if (code == 202 || code == 409) {
                Logger.warn((String)"STOWRS server response message: HTTP Status-Code {}: {}", (Object[])new Object[]{code, httpPost.getResponseMessage()});
                return SAXReader.parse(httpPost.getInputStream());
            }
            throw new InstrumentException(String.format("STOWRS server response message: HTTP Status-Code %d: %s", code, httpPost.getResponseMessage()));
        }
        Logger.info((String)"STOWRS server response message: HTTP Status-Code 200: OK for all the image set", (Object[])new Object[0]);
        return null;
    }

    protected String getContentLocation(Attributes metadata) {
        BulkData data = (BulkData)metadata.getValue(4325393);
        if (null != data) {
            return data.getURI();
        }
        data = (BulkData)metadata.getValue(2145386512);
        if (null != data) {
            return data.getURI();
        }
        return null;
    }

    protected void removeConnection(HttpURLConnection httpPost) {
        this.connections.remove(httpPost);
    }

    @Override
    public void close() {
        this.connections.forEach(HttpURLConnection::disconnect);
        this.connections.clear();
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getRequestURL() {
        return this.requestURL;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }
}

