/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.metric;

import java.awt.Color;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamReader;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.image.metric.Readable;
import org.aoju.bus.image.metric.TagValue;
import org.aoju.bus.image.metric.Tagable;
import org.aoju.bus.image.metric.Thumbnail;
import org.aoju.bus.logger.Logger;

public class TagCamel
implements Serializable {
    public static final String NO_VALUE = "UNKNOWN";
    public static final TagCamel UnknownTag = new TagCamel(0, "UnknownTag", "Unknown Tag", TagType.STRING);
    public static final TagCamel Group = new TagCamel("Group", "Group", TagType.STRING);
    public static final TagCamel PatientPseudoUID = new TagCamel("PatientPseudoUID", "Patient UID", TagType.STRING);
    public static final TagCamel SeriesLoading = new TagCamel("SeriesLoading", "Loading", TagType.INTEGER);
    public static final TagCamel Thumbnail = new TagCamel("Thumbnail", "Thumbnail", TagType.THUMBNAIL);
    public static final TagCamel ThumbnailPath = new TagCamel("ThumbnailPath", TagType.STRING);
    public static final TagCamel ExplorerModel = new TagCamel("ExplorerModel", "Explorer Model", TagType.OBJECT);
    public static final TagCamel PresentationModel = new TagCamel("PesentationModel", TagType.OBJECT);
    public static final TagCamel PresentationModelBirary = new TagCamel("PesentationModelBinary", TagType.BYTE);
    public static final TagCamel SplitSeriesNumber = new TagCamel("SplitSeriesNumber", "Split Number", TagType.INTEGER);
    public static final TagCamel SeriesSelected = new TagCamel("SeriesSelected", "Selected", TagType.BOOLEAN);
    public static final TagCamel SeriesOpen = new TagCamel("SeriesOpen", "Open", TagType.BOOLEAN);
    public static final TagCamel SeriesFocused = new TagCamel("SeriesFocused", TagType.BOOLEAN);
    public static final TagCamel ImageWidth = new TagCamel("ImageWidth", "=Image Width", TagType.INTEGER);
    public static final TagCamel ImageHeight = new TagCamel("ImageHeight", "Image Height", TagType.INTEGER);
    public static final TagCamel ImageDepth = new TagCamel("ImageDepth", "Image Depth", TagType.INTEGER);
    public static final TagCamel ImageOrientationPlane = new TagCamel("ImageOrientationPlane", "Image Orientation", TagType.STRING);
    public static final TagCamel ImageBitsPerPixel = new TagCamel("ImageBitsPerPixel", "Image Bits Per Pixel", TagType.INTEGER);
    public static final TagCamel ImageCache = new TagCamel("ImageCache", TagType.BOOLEAN);
    public static final TagCamel ShutterFinalShape = new TagCamel("ShutterFinalShape", TagType.OBJECT);
    public static final TagCamel ShutterRGBColor = new TagCamel("ShutterRGBColor", TagType.COLOR);
    public static final TagCamel ShutterPSValue = new TagCamel("ShutterPSValue", TagType.INTEGER);
    public static final TagCamel OverlayBitMask = new TagCamel("OverlayBitMask", TagType.INTEGER);
    public static final TagCamel OverlayBurninDataPath = new TagCamel("OverlayBurninDataPath", TagType.STRING);
    public static final TagCamel HasOverlay = new TagCamel("HasOverlay", TagType.BOOLEAN);
    public static final TagCamel ObjectToSave = new TagCamel("ObjectToSave", TagType.BOOLEAN);
    public static final TagCamel WadoCompressionRate = new TagCamel("WadoCompressionRate", TagType.INTEGER);
    public static final TagCamel WadoTransferSyntaxUID = new TagCamel("WadoTransferSyntaxUID", TagType.STRING);
    public static final TagCamel DirectDownloadFile = new TagCamel("DirectDownloadFile", TagType.STRING);
    public static final TagCamel DirectDownloadThumbnail = new TagCamel("DirectDownloadThumbnail", TagType.STRING);
    public static final TagCamel ReadFromDicomdir = new TagCamel("ReadFromDicomdir", TagType.BOOLEAN);
    public static final TagCamel WadoParameters = new TagCamel("WadoParameters", TagType.OBJECT);
    public static final TagCamel WadoInstanceReferenceList = new TagCamel("WadoInstanceReferenceList", TagType.LIST);
    public static final TagCamel DicomSpecialElementList = new TagCamel("DicomSpecialElementList", TagType.LIST);
    public static final TagCamel SlicePosition = new TagCamel("SlicePosition", TagType.DOUBLE, 3, 3);
    public static final TagCamel SuvFactor = new TagCamel("SUVFactor", TagType.DOUBLE);
    public static final TagCamel RootElement = new TagCamel("RootElement", TagType.STRING);
    public static final TagCamel FilePath = new TagCamel("FilePath", TagType.STRING);
    public static final TagCamel FileName = new TagCamel("FileName", TagType.STRING);
    public static final TagCamel CurrentFolder = new TagCamel("CurrentFolder", "Current Folder", TagType.STRING);
    public static final TagCamel Checked = new TagCamel("Checked", TagType.BOOLEAN);
    public static final TagCamel SubseriesInstanceUID = new TagCamel("SubseriesInstanceUID", TagType.STRING);
    public static final TagCamel VOILUTsExplanation = new TagCamel("VOILUTsExplanation", TagType.STRING, 1, Integer.MAX_VALUE);
    public static final TagCamel VOILUTsData = new TagCamel("VOILUTsData", TagType.OBJECT);
    public static final TagCamel ModalityLUTExplanation = new TagCamel("ModalityLUTExplanation", TagType.STRING);
    public static final TagCamel ModalityLUTType = new TagCamel("ModalityLUTType", TagType.STRING);
    public static final TagCamel ModalityLUTData = new TagCamel("ModalityLUTData", TagType.OBJECT);
    public static final TagCamel PRLUTsExplanation = new TagCamel("PRLUTsExplanation", TagType.STRING);
    public static final TagCamel PRLUTsData = new TagCamel("PRLUTsData", TagType.OBJECT);
    public static final TagCamel MonoChrome = new TagCamel("MonoChrome", TagType.BOOLEAN);
    protected static final Map<String, TagCamel> tags = Collections.synchronizedMap(new HashMap());
    private static final long serialVersionUID = -7914330824854199622L;
    private static final AtomicInteger idCounter = new AtomicInteger(Integer.MAX_VALUE);
    protected final int id;
    protected final String keyword;
    protected final String displayedName;
    protected final TagType type;
    protected final int vmMin;
    protected final int vmMax;
    protected final transient Object defaultValue;
    protected int anonymizationType;

    public TagCamel(int id, String keyword, String displayedName, TagType type, int vmMin, int vmMax, Object defaultValue) {
        this.id = id;
        this.keyword = keyword;
        this.displayedName = displayedName;
        this.type = null == type ? TagType.STRING : type;
        this.anonymizationType = 0;
        this.defaultValue = defaultValue;
        this.vmMax = vmMax < 1 ? 1 : vmMax;
        int n = this.vmMin = vmMin < 1 ? 1 : vmMin;
        if (!this.isTypeCompliant(defaultValue)) {
            throw new IllegalArgumentException("defaultValue is not compliant to the tag type");
        }
    }

    public TagCamel(int id, String keyword, TagType type, int vmMin, int vmMax) {
        this(id, keyword, null, type, vmMin, vmMax, null);
    }

    public TagCamel(int id, String keyword, String displayedName, TagType type) {
        this(id, keyword, displayedName, type, 1, 1, null);
    }

    public TagCamel(int id, String keyword, TagType type) {
        this(id, keyword, null, type, 1, 1, null);
    }

    public TagCamel(String name, TagType type, int vmMin, int vmMax) {
        this(idCounter.getAndDecrement(), name, null, type, vmMin, vmMax, null);
    }

    public TagCamel(String keyword, String displayedName, TagType type) {
        this(idCounter.getAndDecrement(), keyword, displayedName, type, 1, 1, null);
    }

    public TagCamel(String keyword, TagType type) {
        this(idCounter.getAndDecrement(), keyword, null, type);
    }

    public static int getValueMultiplicity(Object value) {
        if (null == value) {
            return 0;
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value);
        }
        return 1;
    }

    public static Object getValueFromIndex(Object value, int index) {
        if (null == value || !value.getClass().isArray()) {
            return value;
        }
        if (index >= 0 && index < Array.getLength(value)) {
            return Array.get(value, index);
        }
        return null;
    }

    protected static String getFormattedText(Object value, String format) {
        String str;
        if (null == value) {
            return "";
        }
        if (value instanceof String) {
            str = (String)value;
        } else if (value instanceof String[]) {
            str = Arrays.asList((String[])value).stream().collect(Collectors.joining("\\"));
        } else if (value instanceof TemporalAccessor) {
            str = TagValue.formatDateTime((TemporalAccessor)value);
        } else if (value instanceof TemporalAccessor[]) {
            str = Stream.of((TemporalAccessor[])value).map(TagValue::formatDateTime).collect(Collectors.joining(", "));
        } else if (value instanceof float[]) {
            float[] array = (float[])value;
            str = IntStream.range(0, array.length).mapToObj(i -> String.valueOf(array[i])).collect(Collectors.joining(", "));
        } else {
            str = value instanceof double[] ? DoubleStream.of((double[])value).mapToObj(String::valueOf).collect(Collectors.joining(", ")) : (value instanceof int[] ? IntStream.of((int[])value).mapToObj(String::valueOf).collect(Collectors.joining(", ")) : value.toString());
        }
        if (StringKit.hasText((String)format) && !"$V".equals(format.trim())) {
            return TagCamel.formatValue(str, value instanceof Float || value instanceof Double, format);
        }
        return null == str ? "" : str;
    }

    protected static String formatValue(String value, boolean decimal, String format) {
        String str = value;
        int index = format.indexOf("$V");
        int fmLength = 2;
        if (index != -1) {
            boolean suffix;
            boolean bl = suffix = format.length() > index + fmLength;
            if (suffix && format.charAt(index + fmLength) == ':') {
                String pattern;
                if (format.charAt(index + ++fmLength) == 'f' && decimal) {
                    String pattern2;
                    if (null != (pattern2 = TagCamel.getPattern(index + ++fmLength, format))) {
                        fmLength += pattern2.length() + 2;
                        try {
                            str = new DecimalFormat(pattern2, DecimalFormatSymbols.getInstance(Locale.getDefault())).format(Double.parseDouble(str));
                        }
                        catch (NumberFormatException e) {
                            Logger.warn((String)"Cannot apply pattern to decimal value", (Object[])new Object[]{e});
                        }
                    }
                } else if (format.charAt(index + fmLength) == 'l' && null != (pattern = TagCamel.getPattern(index + ++fmLength, format))) {
                    fmLength += pattern.length() + 2;
                    try {
                        int limit = Integer.parseInt(pattern);
                        int size = str.length();
                        if (size > limit) {
                            str = str.substring(0, limit) + "...";
                        }
                    }
                    catch (NumberFormatException e) {
                        Logger.warn((String)"Cannot apply pattern to decimal value", (Object[])new Object[]{e});
                    }
                }
            }
            str = format.substring(0, index) + str;
            if (format.length() > index + fmLength) {
                str = str + format.substring(index + fmLength);
            }
        }
        return str;
    }

    private static String getPattern(int startIndex, String format) {
        int beginIndex = format.indexOf(36, startIndex);
        int endIndex = format.indexOf(36, startIndex + 2);
        if (beginIndex == -1 || endIndex == -1) {
            return null;
        }
        return format.substring(beginIndex + 1, endIndex);
    }

    public static void addTag(TagCamel tag) {
        if (null != tag) {
            tags.put(tag.getKeyword(), tag);
        }
    }

    public static TagCamel get(String keyword) {
        return tags.get(keyword);
    }

    public static <T> T getTagValue(Readable tagable, TagCamel tag, Class<T> type) {
        if (null != tagable && null != tag) {
            try {
                return type.cast(tagable.getTagValue(tag));
            }
            catch (ClassCastException e) {
                Logger.error((String)"Cannot cast the value of \"{}\" into {}", (Object[])new Object[]{tag.getKeyword(), type, e});
            }
        }
        return null;
    }

    public static String splitCamelCaseString(String s) {
        StringBuilder builder = new StringBuilder();
        for (String w : s.split("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])")) {
            builder.append(w);
            builder.append(' ');
        }
        return builder.toString().trim();
    }

    public int getId() {
        return this.id;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getDisplayedName() {
        if (null == this.displayedName) {
            return TagCamel.splitCamelCaseString(this.getKeyword());
        }
        return this.displayedName;
    }

    public TagType getType() {
        return this.type;
    }

    public int getValueMultiplicity() {
        return this.vmMax;
    }

    public boolean isTypeCompliant(Object value) {
        if (null == value) {
            return true;
        }
        if (value.getClass().isArray()) {
            if (this.vmMax == 1) {
                return false;
            }
            Class<?> clazz = value.getClass().getComponentType();
            int vmValue = Array.getLength(value);
            if (this.vmMax != Integer.MAX_VALUE && this.vmMax != vmValue) {
                return false;
            }
            return this.type.getClazz().isAssignableFrom(clazz);
        }
        Object clazz = value;
        return this.type.isInstanceOf(clazz);
    }

    public String toString() {
        return this.getDisplayedName();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TagCamel other = (TagCamel)obj;
        if (this.id != other.id) {
            return false;
        }
        if (null == this.keyword) {
            return null == other.keyword;
        }
        return this.keyword.equals(other.keyword);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        result = 31 * result + (null == this.keyword ? 0 : this.keyword.hashCode());
        return result;
    }

    public void readValue(Object data, Tagable tagable) {
        tagable.setTagNoNull(this, this.getValue(data));
    }

    public Object getValue(Object data) {
        Object value = null;
        if (data instanceof XMLStreamReader) {
            XMLStreamReader xmler = (XMLStreamReader)data;
            value = this.isStringFamilyType() ? (this.vmMax > 1 ? TagValue.getStringArrayTagAttribute(xmler, this.keyword, (String[])this.defaultValue) : TagValue.getTagAttribute(xmler, this.keyword, (String)this.defaultValue)) : (TagType.DATE.equals((Object)this.type) || TagType.TIME.equals((Object)this.type) || TagType.DATETIME.equals((Object)this.type) ? (this.vmMax > 1 ? TagValue.getDatesFromElement(xmler, this.keyword, this.type, (TemporalAccessor[])this.defaultValue) : TagValue.getDateFromElement(xmler, this.keyword, this.type, (TemporalAccessor)this.defaultValue)) : (TagType.INTEGER.equals((Object)this.type) ? (this.vmMax > 1 ? (Object)TagValue.getIntArrayTagAttribute(xmler, this.keyword, (int[])this.defaultValue) : TagValue.getIntegerTagAttribute(xmler, this.keyword, (Integer)this.defaultValue)) : (TagType.FLOAT.equals((Object)this.type) ? (this.vmMax > 1 ? (Object)TagValue.getFloatArrayTagAttribute(xmler, this.keyword, (float[])this.defaultValue) : TagValue.getFloatTagAttribute(xmler, this.keyword, (Float)this.defaultValue)) : (TagType.DOUBLE.equals((Object)this.type) ? (this.vmMax > 1 ? (Object)TagValue.getDoubleArrayTagAttribute(xmler, this.keyword, (double[])this.defaultValue) : TagValue.getDoubleTagAttribute(xmler, this.keyword, (Double)this.defaultValue)) : (this.vmMax > 1 ? TagValue.getStringArrayTagAttribute(xmler, this.keyword, (String[])this.defaultValue) : TagValue.getTagAttribute(xmler, this.keyword, (String)this.defaultValue))))));
        }
        return value;
    }

    public boolean isStringFamilyType() {
        return TagType.STRING.equals((Object)this.type) || TagType.TEXT.equals((Object)this.type) || TagType.URI.equals((Object)this.type);
    }

    public synchronized int getAnonymizationType() {
        return this.anonymizationType;
    }

    public synchronized void setAnonymizationType(int anonymizationType) {
        this.anonymizationType = anonymizationType;
    }

    public String getFormattedTagValue(Object value, String format) {
        return TagCamel.getFormattedText(value, format);
    }

    static {
        TagCamel.addTag(ImageBitsPerPixel);
        TagCamel.addTag(ImageCache);
        TagCamel.addTag(ImageDepth);
        TagCamel.addTag(ImageHeight);
        TagCamel.addTag(ImageOrientationPlane);
        TagCamel.addTag(ImageWidth);
        TagCamel.addTag(SeriesFocused);
        TagCamel.addTag(SeriesLoading);
        TagCamel.addTag(SeriesOpen);
        TagCamel.addTag(SeriesSelected);
        TagCamel.addTag(SlicePosition);
        TagCamel.addTag(SuvFactor);
        TagCamel.addTag(DirectDownloadFile);
        TagCamel.addTag(DirectDownloadThumbnail);
        TagCamel.addTag(RootElement);
        TagCamel.addTag(FileName);
        TagCamel.addTag(FilePath);
        TagCamel.addTag(CurrentFolder);
        TagCamel.addTag(SubseriesInstanceUID);
        TagCamel.addTag(VOILUTsExplanation);
        TagCamel.addTag(VOILUTsData);
        TagCamel.addTag(ModalityLUTExplanation);
        TagCamel.addTag(ModalityLUTType);
        TagCamel.addTag(ModalityLUTData);
        TagCamel.addTag(PRLUTsExplanation);
        TagCamel.addTag(PRLUTsData);
        TagCamel.addTag(MonoChrome);
    }

    public static enum TagType {
        STRING(String.class),
        TEXT(String.class),
        URI(String.class),
        DATE(LocalDate.class),
        DATETIME(LocalDateTime.class),
        TIME(LocalTime.class),
        BOOLEAN(Boolean.class),
        BYTE(Byte.class),
        INTEGER(Integer.class),
        FLOAT(Float.class),
        DOUBLE(Double.class),
        COLOR(Color.class),
        THUMBNAIL(Thumbnail.class),
        LIST(List.class),
        OBJECT(Object.class),
        DICOM_DATE(LocalDate.class),
        DICOM_DATETIME(LocalDateTime.class),
        DICOM_TIME(LocalTime.class),
        DICOM_PERIOD(String.class),
        DICOM_PERSON_NAME(String.class),
        DICOM_SEQUENCE(Object.class),
        DICOM_SEX(String.class);

        private final Class<?> clazz;

        private TagType(Class<?> clazz) {
            this.clazz = clazz;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public boolean isInstanceOf(Object value) {
            if (null == value) {
                return true;
            }
            return this.clazz.isAssignableFrom(value.getClass());
        }
    }
}

