/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.galaxy.data;

import java.util.Map;
import org.aoju.bus.image.UID;
import org.aoju.bus.image.galaxy.Property;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.data.AttributesCoercion;

public class RemapUIDAttributesCoercion
implements AttributesCoercion {
    private final Map<String, String> uidMap;
    private final AttributesCoercion next;

    public RemapUIDAttributesCoercion(Map<String, String> uidMap, AttributesCoercion next) {
        this.uidMap = uidMap;
        this.next = next;
    }

    @Override
    public String remapUID(String uid) {
        String remappedUID = null != this.uidMap ? Property.maskNull(this.uidMap.get(uid), uid) : uid;
        return null != this.next ? this.next.remapUID(remappedUID) : remappedUID;
    }

    @Override
    public void coerce(Attributes attrs, Attributes modified) {
        if (null != this.uidMap && !this.uidMap.isEmpty()) {
            UID.remapUIDs(attrs, this.uidMap);
        }
        if (null != this.next) {
            this.next.coerce(attrs, modified);
        }
    }
}

