/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.plugin;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;
import javax.activation.FileTypeMap;
import org.aoju.bus.core.toolkit.StreamKit;
import org.aoju.bus.image.UID;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.data.ElementDictionary;
import org.aoju.bus.image.galaxy.data.VR;
import org.aoju.bus.image.galaxy.io.ImageOutputStream;
import org.aoju.bus.image.nimble.codec.jpeg.JPEGHeader;
import org.aoju.bus.image.nimble.codec.mpeg.MPEGHeader;

public class Jpg2Dcm {
    private static final ElementDictionary DICT = ElementDictionary.getStandardElementDictionary();
    private static final int INIT_BUFFER_SIZE = 8192;
    private static final int MAX_BUFFER_SIZE = 0xA00008;
    private static final long MAX_FILE_SIZE = 0x7FFFFFFEL;
    private static final int[] IUID_TAGS = new int[]{0x20000D, 0x20000E, 524312};
    private static final long[] DA_TM_TAGS = new long[]{2251950138064947L, 2251877123620883L};
    private static final int[] TYPE2_TAGS = new int[]{0x200010, 524320, 524336, 524368, 524400, 524432, 0x100020, 0x100010, 0x100030, 0x100040};
    private Attributes metadata;
    private boolean noAPPn;
    private JPEGHeader jpegHeader;
    private byte[] buffer = new byte[0];
    private int headerLength;
    private long fileLength;
    private FileType inFileType;

    private static void supplementMissingUIDs(Attributes metadata) {
        for (int tag : IUID_TAGS) {
            if (metadata.containsValue(tag)) continue;
            metadata.setString(tag, VR.UI, UID.createUID());
        }
    }

    private static void supplementMissingValue(Attributes metadata, int tag, String value) {
        if (!metadata.containsValue(tag)) {
            metadata.setString(tag, DICT.vrOf(tag), value);
        }
    }

    private static void supplementMissingDateTime(Attributes metadata) {
        Date now = new Date();
        for (long tag : DA_TM_TAGS) {
            if (metadata.containsValue((int)(tag >>> 32))) continue;
            metadata.setDate(tag, now);
        }
    }

    private static void supplementMissingType2(Attributes metadata) {
        for (int tag : TYPE2_TAGS) {
            if (metadata.contains(tag)) continue;
            metadata.setNull(tag, DICT.vrOf(tag));
        }
    }

    private void setMetadata(Attributes metadata) {
        this.metadata = metadata;
    }

    private void setNoAPPn(boolean noAPPn) {
        this.noAPPn = noAPPn;
    }

    private void toFileType(File infile) {
        try {
            this.inFileType = FileType.valueOf(infile);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(MessageFormat.format("invalid-file-ext", infile));
        }
    }

    private void convert(File infile, File outfile) throws IOException {
        this.fileLength = infile.length();
        if (this.fileLength > 0x7FFFFFFEL) {
            throw new IllegalArgumentException(infile.getName());
        }
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(infile));){
            if (!this.parseHeader(this.inFileType, bis)) {
                throw new IOException(MessageFormat.format("failed-to-parse", new Object[]{this.inFileType, infile}));
            }
            int itemLen = (int)this.fileLength;
            try (ImageOutputStream dos = new ImageOutputStream(outfile);){
                dos.writeDataset(this.metadata.createFileMetaInformation(this.inFileType.getTransferSyntaxUID()), this.metadata);
                dos.writeHeader(2145386512, VR.OB, -1);
                dos.writeHeader(-73728, null, 0);
                if (null != this.jpegHeader && this.noAPPn) {
                    int offset = this.jpegHeader.offsetAfterAPP();
                    dos.writeHeader(-73728, null, (itemLen -= offset - 3) + 1 & 0xFFFFFFFE);
                    dos.write(-1);
                    dos.write(-40);
                    dos.write(-1);
                    dos.write(this.buffer, offset, this.headerLength - offset);
                } else {
                    dos.writeHeader(-73728, null, itemLen + 1 & 0xFFFFFFFE);
                    dos.write(this.buffer, 0, this.headerLength);
                }
                StreamKit.copy((InputStream)bis, (OutputStream)dos, (byte[])this.buffer);
                if ((itemLen & 1) != 0) {
                    dos.write(0);
                }
                dos.writeHeader(-73507, null, 0);
            }
        }
    }

    private boolean parseHeader(FileType fileType, InputStream in) throws IOException {
        int grow = 8192;
        while (this.headerLength == this.buffer.length && this.headerLength < 0xA00008) {
            this.buffer = Arrays.copyOf(this.buffer, grow += this.headerLength);
            this.headerLength += StreamKit.readAvailable((InputStream)in, (byte[])this.buffer, (int)this.headerLength, (int)(this.buffer.length - this.headerLength));
            if (!fileType.parseHeader(this)) continue;
            Jpg2Dcm.supplementMissingValue(this.metadata, 524310, fileType.getSOPClassUID());
            return true;
        }
        return false;
    }

    private static enum FileType {
        jpeg("1.2.840.10008.5.1.4.1.1.7", "1.2.840.10008.1.2.4.50"){

            @Override
            boolean parseHeader(Jpg2Dcm main) {
                return null != (main.jpegHeader = new JPEGHeader(main.buffer, 218)).toAttributes(main.metadata);
            }
        }
        ,
        mpeg("1.2.840.10008.5.1.4.1.1.77.1.4.1", "1.2.840.10008.1.2.4.100"){

            @Override
            boolean parseHeader(Jpg2Dcm main) {
                return null != new MPEGHeader(main.buffer).toAttributes(main.metadata, main.fileLength);
            }
        };

        private final String cuid;
        private final String tsuid;

        private FileType(String cuid, String tsuid) {
            this.cuid = cuid;
            this.tsuid = tsuid;
        }

        static FileType valueOf(File file) {
            String contentType = FileTypeMap.getDefaultFileTypeMap().getContentType(file);
            return FileType.valueOf(contentType.substring(contentType.lastIndexOf("/") + 1));
        }

        public String getSOPClassUID() {
            return this.cuid;
        }

        public String getTransferSyntaxUID() {
            return this.tsuid;
        }

        abstract boolean parseHeader(Jpg2Dcm var1);
    }
}

