/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.metric.internal.pdu;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.aoju.bus.image.UID;
import org.aoju.bus.image.galaxy.Capacity;
import org.aoju.bus.image.galaxy.Property;
import org.aoju.bus.image.galaxy.data.Implementation;
import org.aoju.bus.image.metric.internal.pdu.CommonExtended;
import org.aoju.bus.image.metric.internal.pdu.ExtendedNegotiate;
import org.aoju.bus.image.metric.internal.pdu.IdentityAC;
import org.aoju.bus.image.metric.internal.pdu.IdentityRQ;
import org.aoju.bus.image.metric.internal.pdu.Presentation;
import org.aoju.bus.image.metric.internal.pdu.RoleSelection;

public abstract class AAssociateRQAC {
    protected final ArrayList<Presentation> pcs = new ArrayList();
    protected final Capacity<Presentation> pcidMap = new Capacity();
    protected final LinkedHashMap<String, RoleSelection> roleSelMap = new LinkedHashMap();
    protected final LinkedHashMap<String, ExtendedNegotiate> extNegMap = new LinkedHashMap();
    protected final LinkedHashMap<String, CommonExtended> commonExtNegMap = new LinkedHashMap();
    protected byte[] reservedBytes = new byte[32];
    protected int protocolVersion = 1;
    protected int maxPDULength = 16378;
    protected int maxOpsInvoked = 1;
    protected int maxOpsPerformed = 1;
    protected String calledAET;
    protected String callingAET;
    protected String applicationContext = "1.2.840.10008.3.1.1.1";
    protected String implClassUID = Implementation.getClassUID();
    protected String implVersionName = Implementation.getVersionName();
    protected IdentityRQ identityRQ;
    protected IdentityAC identityAC;

    public void checkCallingAET() {
        if (null == this.callingAET) {
            throw new IllegalStateException("Calling AET not initalized");
        }
    }

    public void checkCalledAET() {
        if (null == this.calledAET) {
            throw new IllegalStateException("Called AET not initalized");
        }
    }

    public final int getProtocolVersion() {
        return this.protocolVersion;
    }

    public final void setProtocolVersion(int protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public final byte[] getReservedBytes() {
        return (byte[])this.reservedBytes.clone();
    }

    public final void setReservedBytes(byte[] reservedBytes) {
        if (reservedBytes.length != 32) {
            throw new IllegalArgumentException("reservedBytes.length: " + reservedBytes.length);
        }
        System.arraycopy(reservedBytes, 0, this.reservedBytes, 0, 32);
    }

    public final String getCalledAET() {
        return this.calledAET;
    }

    public final void setCalledAET(String calledAET) {
        if (calledAET.length() > 16) {
            throw new IllegalArgumentException("calledAET: " + calledAET);
        }
        this.calledAET = calledAET;
    }

    public final String getCallingAET() {
        return this.callingAET;
    }

    public final void setCallingAET(String callingAET) {
        if (callingAET.length() > 16) {
            throw new IllegalArgumentException("callingAET: " + callingAET);
        }
        this.callingAET = callingAET;
    }

    public final String getApplicationContext() {
        return this.applicationContext;
    }

    public final void setApplicationContext(String applicationContext) {
        if (null == applicationContext) {
            throw new NullPointerException();
        }
        this.applicationContext = applicationContext;
    }

    public final int getMaxPDULength() {
        return this.maxPDULength;
    }

    public final void setMaxPDULength(int maxPDULength) {
        this.maxPDULength = maxPDULength;
    }

    public final int getMaxOpsInvoked() {
        return this.maxOpsInvoked;
    }

    public final void setMaxOpsInvoked(int maxOpsInvoked) {
        this.maxOpsInvoked = maxOpsInvoked;
    }

    public final int getMaxOpsPerformed() {
        return this.maxOpsPerformed;
    }

    public final void setMaxOpsPerformed(int maxOpsPerformed) {
        this.maxOpsPerformed = maxOpsPerformed;
    }

    public final boolean isAsyncOps() {
        return this.maxOpsInvoked != 1 || this.maxOpsPerformed != 1;
    }

    public final String getImplClassUID() {
        return this.implClassUID;
    }

    public final void setImplClassUID(String implClassUID) {
        if (null == implClassUID) {
            throw new NullPointerException();
        }
        this.implClassUID = implClassUID;
    }

    public final String getImplVersionName() {
        return this.implVersionName;
    }

    public final void setImplVersionName(String implVersionName) {
        this.implVersionName = implVersionName;
    }

    public final IdentityRQ getIdentityRQ() {
        return this.identityRQ;
    }

    public void setIdentityRQ(IdentityRQ identityRQ) {
        this.identityRQ = identityRQ;
    }

    public final IdentityAC getIdentityAC() {
        return this.identityAC;
    }

    public void setIdentityAC(IdentityAC identityAC) {
        this.identityAC = identityAC;
    }

    public List<Presentation> getPresentationContexts() {
        return Collections.unmodifiableList(this.pcs);
    }

    public int getNumberOfPresentationContexts() {
        return this.pcs.size();
    }

    public Presentation getPresentationContext(int pcid) {
        return this.pcidMap.get(pcid);
    }

    public void addPresentationContext(Presentation pc) {
        int pcid = pc.getPCID();
        if (this.pcidMap.containsKey(pcid)) {
            throw new IllegalStateException("Already contains Presentation Context with pid: " + pcid);
        }
        this.pcidMap.put(pcid, pc);
        this.pcs.add(pc);
    }

    public boolean removePresentationContext(Presentation pc) {
        if (!this.pcs.remove(pc)) {
            return false;
        }
        this.pcidMap.remove(pc.getPCID());
        return true;
    }

    public Collection<RoleSelection> getRoleSelections() {
        return Collections.unmodifiableCollection(this.roleSelMap.values());
    }

    public RoleSelection getRoleSelectionFor(String cuid) {
        return this.roleSelMap.get(cuid);
    }

    public RoleSelection addRoleSelection(RoleSelection rs) {
        return this.roleSelMap.put(rs.getSOPClassUID(), rs);
    }

    public RoleSelection removeRoleSelectionFor(String cuid) {
        return (RoleSelection)this.roleSelMap.remove(cuid);
    }

    public Collection<ExtendedNegotiate> getExtendedNegotiations() {
        return Collections.unmodifiableCollection(this.extNegMap.values());
    }

    public ExtendedNegotiate getExtNegotiationFor(String cuid) {
        return this.extNegMap.get(cuid);
    }

    public ExtendedNegotiate addExtendedNegotiate(ExtendedNegotiate extNeg) {
        return this.extNegMap.put(extNeg.getSOPClassUID(), extNeg);
    }

    public ExtendedNegotiate removeExtendedNegotiationFor(String cuid) {
        return (ExtendedNegotiate)this.extNegMap.remove(cuid);
    }

    public Collection<CommonExtended> getCommonExtendedNegotiations() {
        return Collections.unmodifiableCollection(this.commonExtNegMap.values());
    }

    public CommonExtended getCommonExtendedNegotiationFor(String cuid) {
        return this.commonExtNegMap.get(cuid);
    }

    public CommonExtended addCommonExtendedNegotiation(CommonExtended extNeg) {
        return this.commonExtNegMap.put(extNeg.getSOPClassUID(), extNeg);
    }

    public CommonExtended removeCommonExtendedNegotiationFor(String cuid) {
        return (CommonExtended)this.commonExtNegMap.remove(cuid);
    }

    public int length() {
        int len = 68;
        len += 4 + this.applicationContext.length();
        for (Presentation pc : this.pcs) {
            len += 4 + pc.length();
        }
        return len += 4 + this.userInfoLength();
    }

    public int userInfoLength() {
        int len = 8;
        len += 4 + this.implClassUID.length();
        if (this.isAsyncOps()) {
            len += 8;
        }
        for (RoleSelection rs : this.roleSelMap.values()) {
            len += 4 + rs.length();
        }
        if (null != this.implVersionName) {
            len += 4 + this.implVersionName.length();
        }
        for (ExtendedNegotiate en : this.extNegMap.values()) {
            len += 4 + en.length();
        }
        for (CommonExtended cen : this.commonExtNegMap.values()) {
            len += 4 + cen.length();
        }
        if (null != this.identityRQ) {
            len += 4 + this.identityRQ.length();
        }
        if (null != this.identityAC) {
            len += 4 + this.identityAC.length();
        }
        return len;
    }

    protected StringBuilder promptTo(String header, StringBuilder sb) {
        sb.append(header).append(Property.LINE_SEPARATOR).append("  calledAET: ").append(this.calledAET).append(Property.LINE_SEPARATOR).append("  callingAET: ").append(this.callingAET).append(Property.LINE_SEPARATOR).append("  applicationContext: ");
        UID.promptTo(this.applicationContext, sb).append(Property.LINE_SEPARATOR).append("  implClassUID: ").append(this.implClassUID).append(Property.LINE_SEPARATOR).append("  implVersionName: ").append(this.implVersionName).append(Property.LINE_SEPARATOR).append("  maxPDULength: ").append(this.maxPDULength).append(Property.LINE_SEPARATOR).append("  maxOpsInvoked/maxOpsPerformed: ").append(this.maxOpsInvoked).append("/").append(this.maxOpsPerformed).append(Property.LINE_SEPARATOR);
        if (null != this.identityRQ) {
            this.identityRQ.promptTo(sb).append(Property.LINE_SEPARATOR);
        }
        if (null != this.identityAC) {
            this.identityAC.promptTo(sb).append(Property.LINE_SEPARATOR);
        }
        for (Presentation presentation : this.pcs) {
            presentation.promptTo(sb).append(Property.LINE_SEPARATOR);
        }
        for (RoleSelection roleSelection : this.roleSelMap.values()) {
            roleSelection.promptTo(sb).append(Property.LINE_SEPARATOR);
        }
        for (ExtendedNegotiate extendedNegotiate : this.extNegMap.values()) {
            extendedNegotiate.promptTo(sb).append(Property.LINE_SEPARATOR);
        }
        for (CommonExtended commonExtended : this.commonExtNegMap.values()) {
            commonExtended.promptTo(sb).append(Property.LINE_SEPARATOR);
        }
        return sb.append("]");
    }
}

