/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.nimble.codec;

import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import javax.imageio.IIOImage;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.ByteKit;
import org.aoju.bus.image.galaxy.Property;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.data.BulkData;
import org.aoju.bus.image.galaxy.data.Fragments;
import org.aoju.bus.image.galaxy.data.VR;
import org.aoju.bus.image.galaxy.data.Value;
import org.aoju.bus.image.galaxy.io.ImageEncodingOptions;
import org.aoju.bus.image.galaxy.io.ImageOutputStream;
import org.aoju.bus.image.nimble.Overlays;
import org.aoju.bus.image.nimble.codec.BytesWithImageDescriptor;
import org.aoju.bus.image.nimble.codec.Decompressor;
import org.aoju.bus.image.nimble.codec.ImageDescriptor;
import org.aoju.bus.image.nimble.codec.ImageReaderFactory;
import org.aoju.bus.image.nimble.codec.ImageWriterFactory;
import org.aoju.bus.image.nimble.codec.TransferSyntaxType;
import org.aoju.bus.image.nimble.codec.jpeg.PatchJPEGLS;
import org.aoju.bus.image.nimble.codec.jpeg.PatchJPEGLSImageOutputStream;
import org.aoju.bus.logger.Logger;

public class Compressor
extends Decompressor
implements Closeable {
    private final VR.Holder pixeldataVR = new VR.Holder();
    private BulkData pixeldata;
    private ImageWriter compressor;
    private ImageReader verifier;
    private PatchJPEGLS patchJPEGLS;
    private ImageWriteParam compressParam;
    private ImageInputStream iis;
    private IOException ex;
    private int[] embeddedOverlays;
    private int maxPixelValueError = -1;
    private int avgPixelValueBlockSize = 1;
    private BufferedImage bi2;
    private ImageReadParam verifyParam;

    public Compressor(Attributes dataset, String from) {
        super(dataset, from);
        Object pixeldata = dataset.getValue(2145386512, this.pixeldataVR);
        if (null == pixeldata) {
            return;
        }
        if (pixeldata instanceof BulkData) {
            this.pixeldata = (BulkData)pixeldata;
            if (this.pmi.isSubSampled()) {
                throw new UnsupportedOperationException("Unsupported Photometric Interpretation: " + (Object)((Object)this.pmi));
            }
            if (this.pixeldata.length() < this.length) {
                throw new IllegalArgumentException("Pixel data too short: " + this.pixeldata.length() + " instead " + this.length + " bytes");
            }
        }
        this.embeddedOverlays = Overlays.getEmbeddedOverlayGroupOffsets(dataset);
    }

    public boolean compress(String tsuid, Property ... params) throws IOException {
        if (null == tsuid) {
            throw new NullPointerException("desttsuid");
        }
        if (this.frames == 0) {
            return false;
        }
        ImageWriterFactory.ImageWriterParam param = ImageWriterFactory.getImageWriterParam(tsuid);
        if (null == param) {
            throw new UnsupportedOperationException("Unsupported Transfer Syntax: " + tsuid);
        }
        this.compressor = ImageWriterFactory.getImageWriter(param);
        Logger.debug((String)"Compressor: {}", (Object[])new Object[]{this.compressor.getClass().getName()});
        this.patchJPEGLS = param.patchJPEGLS;
        this.compressParam = this.compressor.getDefaultWriteParam();
        int count = 0;
        for (Property property : this.cat(param.getImageWriteParams(), params)) {
            String name = property.getName();
            if (name.equals("maxPixelValueError")) {
                this.maxPixelValueError = ((Number)property.getValue()).intValue();
                continue;
            }
            if (name.equals("avgPixelValueBlockSize")) {
                this.avgPixelValueBlockSize = ((Number)property.getValue()).intValue();
                continue;
            }
            if (count++ == 0) {
                this.compressParam.setCompressionMode(2);
            }
            property.setAt(this.compressParam);
        }
        if (this.maxPixelValueError >= 0) {
            ImageReaderFactory.ImageReaderParam readerParam = ImageReaderFactory.getImageReaderParam(tsuid);
            if (null == readerParam) {
                throw new UnsupportedOperationException("Unsupported Transfer Syntax: " + tsuid);
            }
            this.verifier = ImageReaderFactory.getImageReader(readerParam);
            this.verifyParam = this.verifier.getDefaultReadParam();
            Logger.debug((String)"Verifier: {}", (Object[])new Object[]{this.verifier.getClass().getName()});
        }
        TransferSyntaxType tstype = TransferSyntaxType.forUID(tsuid);
        if (null == this.decompressor || this.tstype == TransferSyntaxType.RLE) {
            this.bi = this.createBufferedImage(Math.min(this.bitsStored, tstype.getMaxBitsStored()), this.tstype == TransferSyntaxType.RLE || this.banded, this.signed && tstype.canEncodeSigned());
        }
        Fragments compressedPixeldata = this.dataset.newFragments(2145386512, VR.OB, this.frames + 1);
        compressedPixeldata.add(Value.NULL);
        for (int i = 0; i < this.frames; ++i) {
            CompressedFrame frame = new CompressedFrame(i);
            if (this.embeddedOverlays.length != 0) {
                frame.compress();
            }
            compressedPixeldata.add(frame);
        }
        if (this.samples > 1) {
            this.dataset.setString(2621444, VR.CS, this.pmiAfterDecompression.compress(tsuid).toString());
            this.dataset.setInt(2621446, VR.US, tstype.getPlanarConfiguration());
        }
        for (int gg0000 : this.embeddedOverlays) {
            this.dataset.setInt(0x60000100 | gg0000, VR.US, 1);
            this.dataset.setInt(0x60000102 | gg0000, VR.US, 0);
        }
        return true;
    }

    private Property[] cat(Property[] a, Property[] b) {
        if (a.length == 0) {
            return b;
        }
        if (b.length == 0) {
            return a;
        }
        Property[] c = new Property[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    @Override
    public void close() {
        if (null != this.iis) {
            try {
                this.iis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.dispose();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (null != this.compressor) {
            this.compressor.dispose();
        }
        if (null != this.verifier) {
            this.verifier.dispose();
        }
        this.compressor = null;
        this.verifier = null;
    }

    public BufferedImage readFrame(int frameIndex) throws IOException {
        if (null == this.iis) {
            this.iis = new FileImageInputStream(this.file);
        }
        if (null != this.decompressor) {
            return this.decompressFrame(this.iis, frameIndex);
        }
        this.iis.setByteOrder(this.pixeldata.bigEndian() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        this.iis.seek(this.pixeldata.offset() + (long)(this.frameLength * frameIndex));
        DataBuffer db = this.bi.getRaster().getDataBuffer();
        switch (db.getDataType()) {
            case 0: {
                byte[][] data;
                for (byte[] bs : data = ((DataBufferByte)db).getBankData()) {
                    this.iis.readFully(bs);
                }
                if (!this.pixeldata.bigEndian() || this.pixeldataVR.vr != VR.OW) break;
                ByteKit.swapShorts((byte[][])data);
                break;
            }
            case 1: {
                this.readFully(((DataBufferUShort)db).getData());
                break;
            }
            case 2: {
                this.readFully(((DataBufferShort)db).getData());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported Datatype: " + db.getDataType());
            }
        }
        return this.bi;
    }

    private void verify(MemoryCacheImageOutputStream cache, int index) throws IOException {
        if (null == this.verifier) {
            return;
        }
        cache.seek(0L);
        this.verifier.setInput(cache);
        this.verifyParam.setDestination(this.bi2);
        long start = System.currentTimeMillis();
        this.bi2 = this.verifier.read(0, this.verifyParam);
        int maxDiff = this.maxDiff(this.bi.getRaster(), this.bi2.getRaster());
        long end = System.currentTimeMillis();
        Logger.debug((String)"Verified compressed frame #{} in {} ms - max pixel value error: {}", (Object[])new Object[]{index + 1, end - start, maxDiff});
        if (maxDiff > this.maxPixelValueError) {
            throw new InstrumentException("Decompressed pixel data differs up to " + maxDiff + " from original pixel data" + maxDiff);
        }
    }

    private int maxDiff(WritableRaster raster, WritableRaster raster2) {
        ComponentSampleModel csm = (ComponentSampleModel)raster.getSampleModel();
        ComponentSampleModel csm2 = (ComponentSampleModel)raster2.getSampleModel();
        DataBuffer db = raster.getDataBuffer();
        DataBuffer db2 = raster2.getDataBuffer();
        int blockSize = this.avgPixelValueBlockSize;
        if (blockSize > 1) {
            int w = csm.getWidth();
            int h = csm.getHeight();
            int maxY = (h / blockSize - 1) * blockSize;
            int maxX = (w / blockSize - 1) * blockSize;
            int[] samples = new int[blockSize * blockSize];
            int maxDiff = 0;
            for (int b = 0; b < csm.getNumBands(); ++b) {
                for (int y = 0; y < maxY; y += blockSize) {
                    for (int x = 0; x < maxX; x += blockSize) {
                        int diff = Math.abs(this.sum(csm.getSamples(x, y, blockSize, blockSize, b, samples, db)) - this.sum(csm2.getSamples(x, y, blockSize, blockSize, b, samples, db2)));
                        if (maxDiff >= diff) continue;
                        maxDiff = diff;
                    }
                }
            }
            return maxDiff / samples.length;
        }
        switch (db.getDataType()) {
            case 0: {
                return this.maxDiff(csm, ((DataBufferByte)db).getBankData(), csm2, ((DataBufferByte)db2).getBankData());
            }
            case 1: {
                return this.maxDiff(csm, ((DataBufferUShort)db).getData(), csm2, ((DataBufferUShort)db2).getData());
            }
            case 2: {
                return this.maxDiff(csm, ((DataBufferShort)db).getData(), csm2, ((DataBufferShort)db2).getData());
            }
        }
        throw new UnsupportedOperationException("Unsupported Datatype: " + db.getDataType());
    }

    private int sum(int[] samples) {
        int sum = 0;
        for (int sample : samples) {
            sum += sample;
        }
        return sum;
    }

    private int maxDiff(ComponentSampleModel csm, short[] data, ComponentSampleModel csm2, short[] data2) {
        int w = csm.getWidth() * csm.getPixelStride();
        int h = csm.getHeight();
        int stride = csm.getScanlineStride();
        int stride2 = csm2.getScanlineStride();
        int maxDiff = 0;
        for (int y = 0; y < h; ++y) {
            int j = w;
            int i = y * stride;
            int i2 = y * stride2;
            while (j-- > 0) {
                int diff = Math.abs(data[i] - data2[i2]);
                if (maxDiff < diff) {
                    maxDiff = diff;
                }
                ++i;
                ++i2;
            }
        }
        return maxDiff;
    }

    private int maxDiff(ComponentSampleModel csm, byte[][] banks, ComponentSampleModel csm2, byte[][] banks2) {
        int w = csm.getWidth();
        int h = csm.getHeight();
        int bands = csm.getNumBands();
        int stride = csm.getScanlineStride();
        int pixelStride = csm.getPixelStride();
        int[] bankIndices = csm.getBankIndices();
        int[] bandOffsets = csm.getBandOffsets();
        int stride2 = csm2.getScanlineStride();
        int pixelStride2 = csm2.getPixelStride();
        int[] bankIndices2 = csm2.getBankIndices();
        int[] bandOffsets2 = csm2.getBandOffsets();
        int maxDiff = 0;
        for (int b = 0; b < bands; ++b) {
            byte[] bank = banks[bankIndices[b]];
            byte[] bank2 = banks2[bankIndices2[b]];
            int off = bandOffsets[b];
            int off2 = bandOffsets2[b];
            for (int y = 0; y < h; ++y) {
                int x = w;
                int i = y * stride + off;
                int i2 = y * stride2 + off2;
                while (x-- > 0) {
                    int diff = Math.abs(bank[i] - bank2[i2]);
                    if (maxDiff < diff) {
                        maxDiff = diff;
                    }
                    i += pixelStride;
                    i2 += pixelStride2;
                }
            }
        }
        return maxDiff;
    }

    private void nullifyUnusedBits(int bitsStored, BufferedImage bi) {
        DataBuffer db = bi.getRaster().getDataBuffer();
        switch (db.getDataType()) {
            case 1: {
                this.nullifyUnusedBits(bitsStored, ((DataBufferUShort)db).getData());
                break;
            }
            case 2: {
                this.nullifyUnusedBits(bitsStored, ((DataBufferShort)db).getData());
            }
        }
    }

    private void nullifyUnusedBits(int bitsStored, short[] data) {
        int mask = (1 << bitsStored) - 1;
        int i = 0;
        while (i < data.length) {
            int n = i++;
            data[n] = (short)(data[n] & mask);
        }
    }

    private void extractEmbeddedOverlays(int frameIndex, BufferedImage bi) {
        for (int gg0000 : this.embeddedOverlays) {
            int ovlyRow = this.dataset.getInt(0x60000010 | gg0000, 0);
            int ovlyColumns = this.dataset.getInt(0x60000011 | gg0000, 0);
            int ovlyBitPosition = this.dataset.getInt(0x60000102 | gg0000, 0);
            int mask = 1 << ovlyBitPosition;
            int ovlyLength = ovlyRow * ovlyColumns;
            byte[] ovlyData = this.dataset.getSafeBytes(0x60003000 | gg0000);
            if (null == ovlyData) {
                ovlyData = new byte[(ovlyLength * this.frames + 7 >>> 3) + 1 & 0xFFFFFFFE];
                this.dataset.setBytes(0x60003000 | gg0000, VR.OB, ovlyData);
            }
            Overlays.extractFromPixeldata(bi.getRaster(), mask, ovlyData, ovlyLength * frameIndex, ovlyLength);
            Logger.debug((String)"Extracted embedded overlay #{} from bit #{} of frame #{}", (Object[])new Object[]{(gg0000 >>> 17) + 1, ovlyBitPosition, frameIndex + 1});
        }
    }

    private void readFully(short[] data) throws IOException {
        this.iis.readFully(data, 0, data.length);
    }

    private class CompressedFrame
    implements Value {
        private final int frameIndex;
        private final CacheOutputStream cacheout = new CacheOutputStream();
        private int streamLength;
        private MemoryCacheImageOutputStream cache;

        public CompressedFrame(int frameIndex) throws IOException {
            this.frameIndex = frameIndex;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public byte[] toBytes(VR vr, boolean bigEndian) throws IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.writeTo(out);
            return out.toByteArray();
        }

        @Override
        public void writeTo(ImageOutputStream out, VR vr) throws IOException {
            this.writeTo(out);
        }

        @Override
        public int calcLength(ImageEncodingOptions encOpts, boolean explicitVR, VR vr) {
            return this.getEncodedLength(encOpts, explicitVR, vr);
        }

        @Override
        public int getEncodedLength(ImageEncodingOptions encOpts, boolean explicitVR, VR vr) {
            try {
                this.compress();
            }
            catch (IOException e) {
                return -1;
            }
            return this.streamLength + 1 & 0xFFFFFFFE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeTo(OutputStream out) throws IOException {
            this.compress();
            try {
                this.cacheout.set(out);
                long start = System.currentTimeMillis();
                this.cache.seek(this.streamLength);
                this.cache.flushBefore(this.streamLength);
                if ((this.streamLength & 1) != 0) {
                    out.write(0);
                }
                long end = System.currentTimeMillis();
                Logger.debug((String)"Flushed frame #{} from memory in {} ms", (Object[])new Object[]{this.frameIndex + 1, end - start});
            }
            finally {
                try {
                    this.cache.close();
                }
                catch (IOException iOException) {}
                this.cache = null;
            }
        }

        private void compress() throws IOException {
            if (null != this.cache) {
                return;
            }
            if (null != Compressor.this.ex) {
                throw Compressor.this.ex;
            }
            try {
                BufferedImage bi = Compressor.this.readFrame(this.frameIndex);
                Compressor.this.extractEmbeddedOverlays(this.frameIndex, bi);
                if (Compressor.this.bitsStored < Compressor.this.bitsAllocated) {
                    Compressor.this.nullifyUnusedBits(Compressor.this.bitsStored, bi);
                }
                this.cache = new FlushlessMemoryCacheImageOutputStream(this.cacheout, Compressor.this.imageDescriptor);
                Compressor.this.compressor.setOutput(null != Compressor.this.patchJPEGLS ? new PatchJPEGLSImageOutputStream(this.cache, Compressor.this.patchJPEGLS) : this.cache);
                long start = System.currentTimeMillis();
                Compressor.this.compressor.write(null, new IIOImage(bi, null, null), Compressor.this.compressParam);
                long end = System.currentTimeMillis();
                this.streamLength = (int)this.cache.getStreamPosition();
                Logger.debug((String)"Compressed frame #{} {}:1 in {} ms", (Object[])new Object[]{this.frameIndex + 1, Float.valueOf((float)Decompressor.sizeOf(bi) / (float)this.streamLength), end - start});
                Compressor.this.verify(this.cache, this.frameIndex);
            }
            catch (IOException ex) {
                this.cache = null;
                Compressor.this.ex = ex;
                throw ex;
            }
        }
    }

    private static class FlushlessMemoryCacheImageOutputStream
    extends MemoryCacheImageOutputStream
    implements BytesWithImageDescriptor {
        private final ImageDescriptor imageDescriptor;

        public FlushlessMemoryCacheImageOutputStream(OutputStream stream, ImageDescriptor imageDescriptor) {
            super(stream);
            this.imageDescriptor = imageDescriptor;
        }

        @Override
        public void flush() throws IOException {
            Logger.debug((String)"Ignore invoke of MemoryCacheImageOutputStream.flush()", (Object[])new Object[0]);
        }

        @Override
        public ByteBuffer getBytes() throws IOException {
            int read;
            byte[] array = new byte[8192];
            int length = 0;
            while ((read = this.read(array, length, array.length - length)) > 0) {
                if ((length += read) != array.length) continue;
                array = Arrays.copyOf(array, array.length << 1);
            }
            return ByteBuffer.wrap(array, 0, length);
        }

        @Override
        public ImageDescriptor getImageDescriptor() {
            return this.imageDescriptor;
        }
    }

    private static class CacheOutputStream
    extends FilterOutputStream {
        public CacheOutputStream() {
            super(null);
        }

        public void set(OutputStream out) {
            this.out = out;
        }
    }
}

