/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.nimble.opencv;

import java.io.File;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.FileImageOutputStream;
import org.aoju.bus.image.nimble.codec.ImageDescriptor;
import org.aoju.bus.image.nimble.opencv.ExtendInputImageStream;
import org.aoju.bus.image.nimble.opencv.StreamSegment;
import org.aoju.bus.logger.Logger;

public class FileStreamSegment
extends StreamSegment {
    private final String filePath;

    FileStreamSegment(File file, long[] startPos, long[] length, ImageDescriptor imageDescriptor) {
        super(startPos, length, imageDescriptor);
        this.filePath = file.getAbsolutePath();
    }

    FileStreamSegment(RandomAccessFile fdes, long[] startPos, long[] length, ImageDescriptor imageDescriptor) {
        super(startPos, length, imageDescriptor);
        this.filePath = FileStreamSegment.getFilePath(fdes);
    }

    FileStreamSegment(ExtendInputImageStream stream) {
        super(stream.getSegmentPositions(), stream.getSegmentLengths(), stream.getImageDescriptor());
        this.filePath = stream.getFile().getAbsolutePath();
    }

    public static String getFilePath(RandomAccessFile file) {
        try {
            Field fpath = RandomAccessFile.class.getDeclaredField("path");
            if (null != fpath) {
                fpath.setAccessible(true);
                return (String)fpath.get(file);
            }
        }
        catch (Exception e) {
            Logger.error((String)"get path from RandomAccessFile", (Object[])new Object[]{e});
        }
        return null;
    }

    public static RandomAccessFile getRandomAccessFile(FileImageInputStream fstream) {
        try {
            Field fRaf = FileImageInputStream.class.getDeclaredField("raf");
            if (null != fRaf) {
                fRaf.setAccessible(true);
                return (RandomAccessFile)fRaf.get(fstream);
            }
        }
        catch (Exception e) {
            Logger.error((String)"getFileDescriptor from FileImageInputStream", (Object[])new Object[]{e});
        }
        return null;
    }

    public static RandomAccessFile getRandomAccessFile(FileImageOutputStream fstream) {
        try {
            Field fRaf = FileImageOutputStream.class.getDeclaredField("raf");
            if (null != fRaf) {
                fRaf.setAccessible(true);
                return (RandomAccessFile)fRaf.get(fstream);
            }
        }
        catch (Exception e) {
            Logger.error((String)"getFileDescriptor from FileImageOutputStream", (Object[])new Object[]{e});
        }
        return null;
    }

    public String getFilePath() {
        return this.filePath;
    }
}

