/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.plugin;

import java.io.IOException;
import java.net.Socket;
import java.security.GeneralSecurityException;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.image.Device;
import org.aoju.bus.image.metric.Connection;
import org.aoju.bus.image.metric.internal.hl7.HL7Message;
import org.aoju.bus.image.metric.internal.hl7.HL7Segment;
import org.aoju.bus.image.metric.internal.hl7.MLLPConnection;

public class HL7Pix
extends Device {
    private final Connection conn = new Connection();
    private final Connection remote = new Connection();
    private String sendingApplication = "hl7pix^aoju";
    private String receivingApplication = "";
    private String charset;
    private Socket sock;
    private MLLPConnection mllp;

    public HL7Pix() {
        super("hl7pix");
        this.addConnection(this.conn);
    }

    public String getSendingApplication() {
        return this.sendingApplication;
    }

    public void setSendingApplication(String sendingApplication) {
        this.sendingApplication = sendingApplication;
    }

    public String getReceivingApplication() {
        return this.receivingApplication;
    }

    public void setReceivingApplication(String receivingApplication) {
        this.receivingApplication = receivingApplication;
    }

    public void setCharacterSet(String charset) {
        this.charset = charset;
    }

    public void open() throws IOException, InstrumentException, GeneralSecurityException {
        this.sock = this.conn.connect(this.remote);
        this.sock.setSoTimeout(this.conn.getResponseTimeout());
        this.mllp = new MLLPConnection(this.sock);
    }

    public void close() {
        this.conn.close(this.sock);
    }

    public void query(String pid, String[] domains) throws IOException {
        HL7Message qbp = HL7Message.makePixQuery(pid, domains);
        HL7Segment msh = (HL7Segment)qbp.get(0);
        msh.setSendingApplicationWithFacility(this.sendingApplication);
        msh.setReceivingApplicationWithFacility(this.receivingApplication);
        msh.setField(17, this.charset);
        this.mllp.writeMessage(qbp.getBytes(this.charset));
        if (null == this.mllp.readMessage()) {
            throw new IOException("Connection closed by receiver");
        }
    }
}

