/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.metric.internal.xdsi;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.TimeZone;
import org.aoju.bus.image.Format;
import org.aoju.bus.image.galaxy.data.DatePrecision;
import org.aoju.bus.image.metric.internal.xdsi.SlotType;
import org.aoju.bus.image.metric.internal.xdsi.ValueListType;

public class SlotBuilder {
    private final SlotType result = new SlotType();

    public SlotBuilder(String name) {
        this.result.setName(name);
    }

    public SlotType build() {
        return this.result;
    }

    public SlotBuilder valueList(String value) {
        return this.valueList(Collections.singletonList(value));
    }

    public SlotBuilder valueList(Collection<String> values) {
        ValueListType valueList = new ValueListType();
        for (String value : values) {
            valueList.getValue().add(value);
        }
        this.result.setValueList(valueList);
        return this;
    }

    public SlotBuilder valueDTM(Date date) {
        return this.valueList(Format.formatDT(TimeZone.getTimeZone("UTC"), date, new DatePrecision(13)));
    }

    public SlotBuilder slotType(String value) {
        this.result.setSlotType(value);
        return this;
    }
}

