/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.galaxy.data;

import java.io.Serializable;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.data.VR;

public class Code
implements Serializable {
    private final transient Key key = new Key();
    private String codeValue;
    private String codingSchemeDesignator;
    private String codingSchemeVersion;
    private String codeMeaning;
    private transient int hashCode;

    public Code() {
    }

    public Code(String s) {
        int len = s.length();
        if (len < 9 || s.charAt(0) != '(' || s.charAt(len - 2) != '\"' || s.charAt(len - 1) != ')') {
            throw new IllegalArgumentException(s);
        }
        int endVal = s.indexOf(44);
        int endScheme = s.indexOf(44, endVal + 1);
        int startMeaning = s.indexOf(34, endScheme + 1) + 1;
        this.codeValue = this.trimsubstring(s, 1, endVal);
        this.codingSchemeDesignator = this.trimsubstring(s, endVal + 1, endScheme);
        this.codeMeaning = this.trimsubstring(s, startMeaning, len - 2);
        if (this.codingSchemeDesignator.endsWith("]")) {
            int endVersion = s.lastIndexOf(93, endScheme - 1);
            endScheme = s.lastIndexOf(91, endVersion - 1);
            this.codingSchemeDesignator = this.trimsubstring(s, endVal + 1, endScheme);
            this.codingSchemeVersion = this.nullifyDCM01(this.trimsubstring(s, endScheme + 1, endVersion));
        }
    }

    public Code(Attributes item) {
        this(item.getString(524544, null), item.getString(524546, null), item.getString(524547, null), item.getString(524548, "<none>"));
    }

    public Code(String codeValue, String codingSchemeDesignator, String codingSchemeVersion, String codeMeaning) {
        if (null == codeValue) {
            throw new NullPointerException("Missing Code Value");
        }
        if (null == codingSchemeDesignator) {
            throw new NullPointerException("Missing Coding Scheme Designator");
        }
        if (null == codeMeaning) {
            throw new NullPointerException("Missing Code Meaning");
        }
        this.codeValue = codeValue;
        this.codingSchemeDesignator = codingSchemeDesignator;
        this.codingSchemeVersion = this.nullifyDCM01(codingSchemeVersion);
        this.codeMeaning = codeMeaning;
    }

    private String nullifyDCM01(String codingSchemeVersion) {
        return "01".equals(codingSchemeVersion) && "DCM".equals(this.codingSchemeDesignator) ? null : codingSchemeVersion;
    }

    private String trimsubstring(String s, int start, int end) {
        try {
            String trim = s.substring(start, end).trim();
            if (!trim.isEmpty()) {
                return trim;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        throw new IllegalArgumentException(s);
    }

    public final String getCodeValue() {
        return this.codeValue;
    }

    public final String getCodingSchemeDesignator() {
        return this.codingSchemeDesignator;
    }

    public final String getCodingSchemeVersion() {
        return this.codingSchemeVersion;
    }

    public final String getCodeMeaning() {
        return this.codeMeaning;
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            result = 17;
            result = 31 * result + this.codeValue.hashCode();
            result = 31 * result + this.codingSchemeDesignator.hashCode();
            this.hashCode = result = 31 * result + (null != this.codingSchemeVersion ? this.codingSchemeVersion.hashCode() : 0);
        }
        return result;
    }

    public boolean equals(Object o) {
        return this.equals(o, false);
    }

    public boolean equalsIgnoreMeaning(Code o) {
        return this.equals(o, true);
    }

    private boolean equals(Object o, boolean ignoreMeaning) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Code)) {
            return false;
        }
        Code other = (Code)o;
        return this.codeValue.equals(other.codeValue) && this.codingSchemeDesignator.equals(other.codingSchemeDesignator) && this.equals(this.codingSchemeVersion, other.codingSchemeVersion) && (ignoreMeaning || this.codeMeaning.equals(other.codeMeaning));
    }

    private boolean equals(String s1, String s2) {
        return s1 == s2 || null != s1 && s1.equals(s2);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('(').append(this.codeValue).append(", ").append(this.codingSchemeDesignator);
        if (null != this.codingSchemeVersion) {
            sb.append(" [").append(this.codingSchemeVersion).append(']');
        }
        sb.append(", \"").append(this.codeMeaning).append("\")");
        return sb.toString();
    }

    public Attributes toItem() {
        Attributes codeItem = new Attributes(null != this.codingSchemeVersion ? 4 : 3);
        codeItem.setString(524544, VR.SH, this.codeValue);
        codeItem.setString(524546, VR.SH, this.codingSchemeDesignator);
        if (null != this.codingSchemeVersion) {
            codeItem.setString(524547, VR.SH, this.codingSchemeVersion);
        }
        codeItem.setString(524548, VR.LO, this.codeMeaning);
        return codeItem;
    }

    public final Key key() {
        return this.key;
    }

    public final class Key {
        private Key() {
        }

        public int hashCode() {
            return this.outer().hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key other = (Key)o;
            return this.outer().equalsIgnoreMeaning(other.outer());
        }

        private Code outer() {
            return Code.this;
        }
    }
}

