/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.metric;

import org.aoju.bus.core.lang.exception.RelevantException;
import org.aoju.bus.image.galaxy.Property;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.data.VR;
import org.aoju.bus.image.galaxy.data.ValidationResult;

public class ImageException
extends RelevantException {
    private final Attributes rsp = new Attributes();
    private Attributes data;

    public ImageException(int status) {
        this.rsp.setInt(2304, VR.US, status);
    }

    public ImageException(int status, String message) {
        super(message);
        this.rsp.setInt(2304, VR.US, status);
        this.setErrorComment(this.getMessage());
    }

    public ImageException(int status, Throwable cause) {
        super(cause);
        this.rsp.setInt(2304, VR.US, status);
        this.setErrorComment(this.getMessage());
    }

    public static ImageException valueOf(ValidationResult result, Attributes attrs) {
        if (result.hasNotAllowedAttributes()) {
            return new ImageException(261).setAttributeIdentifierList(result.tagsOfNotAllowedAttributes());
        }
        if (result.hasMissingAttributes()) {
            return new ImageException(288).setAttributeIdentifierList(result.tagsOfMissingAttributes());
        }
        if (result.hasMissingAttributeValues()) {
            return new ImageException(289).setDataset(new Attributes(attrs, result.tagsOfMissingAttributeValues()));
        }
        if (result.hasInvalidAttributeValues()) {
            return new ImageException(262).setDataset(new Attributes(attrs, result.tagsOfInvalidAttributeValues()));
        }
        return null;
    }

    public ImageException setErrorComment(String val) {
        if (null != val) {
            this.rsp.setString(2306, VR.LO, Property.truncate(val, 64));
        }
        return this;
    }

    public ImageException setErrorID(int val) {
        this.rsp.setInt(2307, VR.US, val);
        return this;
    }

    public ImageException setEventTypeID(int val) {
        this.rsp.setInt(4098, VR.US, val);
        return this;
    }

    public ImageException setActionTypeID(int val) {
        this.rsp.setInt(4104, VR.US, val);
        return this;
    }

    public ImageException setOffendingElements(int ... tags) {
        this.rsp.setInt(2305, VR.AT, tags);
        return this;
    }

    public ImageException setAttributeIdentifierList(int ... tags) {
        this.rsp.setInt(4101, VR.AT, tags);
        return this;
    }

    public ImageException setUID(int tag, String value) {
        this.rsp.setString(tag, VR.UI, value);
        return this;
    }

    public final Attributes getDataset() {
        return this.data;
    }

    public final ImageException setDataset(Attributes data) {
        this.data = data;
        return this;
    }

    public Attributes mkRSP(int cmdField, int msgId) {
        this.rsp.setInt(256, VR.US, cmdField);
        this.rsp.setInt(288, VR.US, msgId);
        return this.rsp;
    }
}

