/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.galaxy.data;

import java.io.Serializable;
import org.aoju.bus.image.galaxy.Property;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.data.VR;

public class Issuer
implements Serializable {
    private String localNamespaceEntityID;
    private String universalEntityID;
    private String universalEntityIDType;

    public Issuer(String localNamespaceEntityID, String universalEntityID, String universalEntityIDType) {
        this.localNamespaceEntityID = localNamespaceEntityID;
        this.universalEntityID = universalEntityID;
        this.universalEntityIDType = universalEntityIDType;
        this.validate();
    }

    protected Issuer() {
    }

    public Issuer(String s) {
        this(s, '&');
    }

    public Issuer(String s, char delim) {
        String[] ss = Property.split(s, delim);
        if (ss.length > 3) {
            throw new IllegalArgumentException(s);
        }
        this.localNamespaceEntityID = this.emptyToNull(ss[0]);
        this.universalEntityID = ss.length > 1 ? this.emptyToNull(ss[1]) : null;
        this.universalEntityIDType = ss.length > 2 ? this.emptyToNull(ss[2]) : null;
        this.validate();
    }

    public Issuer(String issuerOfPatientID, Attributes qualifiers) {
        this(issuerOfPatientID, null != qualifiers ? qualifiers.getString(4194354) : null, null != qualifiers ? qualifiers.getString(0x400033) : null);
    }

    public Issuer(Attributes issuerItem) {
        this(issuerItem.getString(4194353), issuerItem.getString(4194354), issuerItem.getString(0x400033));
    }

    public Issuer(Issuer other) {
        this(other.getLocalNamespaceEntityID(), other.getUniversalEntityID(), other.getUniversalEntityIDType());
    }

    public static Issuer fromIssuerOfPatientID(Attributes attrs) {
        String issuerOfPatientID = attrs.getString(0x100021);
        Attributes qualifiers = attrs.getNestedDataset(1048612);
        if (null != qualifiers) {
            String universalEntityID = qualifiers.getString(4194354);
            String universalEntityIDType = qualifiers.getString(0x400033);
            if (null != universalEntityID && null != universalEntityIDType) {
                return new Issuer(issuerOfPatientID, universalEntityID, universalEntityIDType);
            }
        }
        return null != issuerOfPatientID ? new Issuer(issuerOfPatientID, null, null) : null;
    }

    public static Issuer valueOf(Attributes issuerItem) {
        if (null == issuerItem) {
            return null;
        }
        String localNamespaceEntityID = issuerItem.getString(4194353);
        String universalEntityID = issuerItem.getString(4194354);
        String universalEntityIDType = issuerItem.getString(0x400033);
        return null != universalEntityID && null != universalEntityIDType ? new Issuer(localNamespaceEntityID, universalEntityID, universalEntityIDType) : (null != localNamespaceEntityID ? new Issuer(localNamespaceEntityID, null, null) : null);
    }

    private void validate() {
        if (null == this.localNamespaceEntityID && null == this.universalEntityID) {
            throw new IllegalArgumentException("Missing Local Namespace Entity ID or Universal Entity ID");
        }
        if (null != this.universalEntityID && null == this.universalEntityIDType) {
            throw new IllegalArgumentException("Missing Universal Entity ID Type");
        }
    }

    private String emptyToNull(String s) {
        return s.isEmpty() ? null : s;
    }

    public final String getLocalNamespaceEntityID() {
        return this.localNamespaceEntityID;
    }

    public final String getUniversalEntityID() {
        return this.universalEntityID;
    }

    public final String getUniversalEntityIDType() {
        return this.universalEntityIDType;
    }

    public boolean merge(Issuer other) {
        boolean mergeUniversal;
        if (!this.matches(other)) {
            throw new IllegalArgumentException("other=" + other);
        }
        boolean mergeLocalNamespace = null == this.localNamespaceEntityID && null != other.localNamespaceEntityID;
        if (mergeLocalNamespace) {
            this.localNamespaceEntityID = other.localNamespaceEntityID;
        }
        if (mergeUniversal = null == this.universalEntityID && null != other.universalEntityID) {
            this.universalEntityID = other.universalEntityID;
            this.universalEntityIDType = other.universalEntityIDType;
        }
        return mergeLocalNamespace || mergeUniversal;
    }

    public int hashCode() {
        return 37 * (37 * this.hashCode(this.localNamespaceEntityID) + this.hashCode(this.universalEntityID)) + this.hashCode(this.universalEntityIDType);
    }

    private int hashCode(String s) {
        return null == s ? 0 : s.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Issuer)) {
            return false;
        }
        Issuer other = (Issuer)o;
        return this.equals(this.localNamespaceEntityID, other.localNamespaceEntityID) && this.equals(this.universalEntityID, other.universalEntityID) && this.equals(this.universalEntityIDType, other.universalEntityIDType);
    }

    private boolean equals(String s1, String s2) {
        return s1 == s2 || null != s1 && s1.equals(s2);
    }

    public boolean matches(Issuer other) {
        if (this == other || null == other) {
            return true;
        }
        boolean matchLocal = null != this.localNamespaceEntityID && null != other.localNamespaceEntityID;
        boolean matchUniversal = null != this.universalEntityID && null != other.universalEntityID;
        return !(!matchLocal && !matchUniversal || matchLocal && !this.localNamespaceEntityID.equals(other.localNamespaceEntityID) || matchUniversal && (!this.universalEntityID.equals(other.universalEntityID) || !this.universalEntityIDType.equals(other.universalEntityIDType)));
    }

    public String toString() {
        return this.toString('&');
    }

    public String toString(char delim) {
        if (null == this.universalEntityID) {
            return this.localNamespaceEntityID;
        }
        StringBuilder sb = new StringBuilder();
        if (null != this.localNamespaceEntityID) {
            sb.append(this.localNamespaceEntityID);
        }
        sb.append(delim);
        sb.append(this.universalEntityID);
        sb.append(delim);
        sb.append(this.universalEntityIDType);
        return sb.toString();
    }

    public Attributes toItem() {
        int size = 0;
        if (null != this.localNamespaceEntityID) {
            ++size;
        }
        if (null != this.universalEntityID) {
            ++size;
        }
        if (null != this.universalEntityIDType) {
            ++size;
        }
        Attributes item = new Attributes(size);
        if (null != this.localNamespaceEntityID) {
            item.setString(4194353, VR.UT, this.localNamespaceEntityID);
        }
        if (null != this.universalEntityID) {
            item.setString(4194354, VR.UT, this.universalEntityID);
        }
        if (null != this.universalEntityIDType) {
            item.setString(0x400033, VR.CS, this.universalEntityIDType);
        }
        return item;
    }

    public Attributes toIssuerOfPatientID(Attributes attrs) {
        if (null == attrs) {
            attrs = new Attributes(2);
        }
        if (null != this.localNamespaceEntityID) {
            attrs.setString(0x100021, VR.LO, this.localNamespaceEntityID);
        }
        if (null != this.universalEntityID) {
            Attributes item = new Attributes(2);
            item.setString(4194354, VR.UT, this.universalEntityID);
            item.setString(0x400033, VR.CS, this.universalEntityIDType);
            attrs.newSequence(1048612, 1).add(item);
        }
        return attrs;
    }
}

