/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.nimble.codec.jpeg;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;
import org.aoju.bus.image.nimble.codec.BytesWithImageDescriptor;
import org.aoju.bus.image.nimble.codec.ImageDescriptor;
import org.aoju.bus.image.nimble.codec.jpeg.JPEGLSCodingParam;
import org.aoju.bus.image.nimble.codec.jpeg.PatchJPEGLS;
import org.aoju.bus.image.nimble.stream.ImagePixelInputStream;
import org.aoju.bus.image.nimble.stream.SegmentedImageStream;
import org.aoju.bus.logger.Logger;

public class PatchJPEGLSImageInputStream
extends ImageInputStreamImpl
implements BytesWithImageDescriptor {
    private final ImageInputStream iis;
    private long patchPos;
    private byte[] patch;

    public PatchJPEGLSImageInputStream(ImageInputStream iis, PatchJPEGLS patchJPEGLS) throws IOException {
        if (null == iis) {
            throw new NullPointerException("iis");
        }
        this.streamPos = iis.getStreamPosition();
        this.flushedPos = iis.getFlushedPosition();
        this.iis = iis;
        if (null == patchJPEGLS) {
            return;
        }
        JPEGLSCodingParam param = patchJPEGLS.createJPEGLSCodingParam(this.firstBytesOf(iis));
        if (null != param) {
            Logger.debug((String)"Patch JPEG-LS with {}", (Object[])new Object[]{param});
            this.patchPos = this.streamPos + (long)param.getOffset();
            this.patch = param.getBytes();
        }
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return this.iis instanceof ImagePixelInputStream ? ((ImagePixelInputStream)this.iis).getImageDescriptor() : (this.iis instanceof SegmentedImageStream ? ((SegmentedImageStream)this.iis).getImageDescriptor() : null);
    }

    private byte[] firstBytesOf(ImageInputStream iis) throws IOException {
        int len;
        int n;
        byte[] b = new byte[256];
        int off = 0;
        iis.mark();
        for (len = b.length; len > 0 && (n = iis.read(b, off, len)) > 0; len -= n) {
            off += n;
        }
        iis.reset();
        return len > 0 ? Arrays.copyOf(b, b.length - len) : b;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.iis.close();
    }

    @Override
    public void flushBefore(long pos) throws IOException {
        super.flushBefore(pos);
        this.iis.flushBefore(this.adjustStreamPosition(pos));
    }

    private long adjustStreamPosition(long pos) {
        if (null == this.patch) {
            return pos;
        }
        long index = pos - this.patchPos;
        return index < 0L ? pos : (index < (long)this.patch.length ? this.patchPos : pos - (long)this.patch.length);
    }

    @Override
    public boolean isCached() {
        return this.iis.isCached();
    }

    @Override
    public boolean isCachedFile() {
        return this.iis.isCachedFile();
    }

    @Override
    public boolean isCachedMemory() {
        return this.iis.isCachedMemory();
    }

    @Override
    public long length() {
        try {
            long len = this.iis.length();
            return null == this.patch || len < 0L ? len : len + (long)this.patch.length;
        }
        catch (IOException e) {
            return -1L;
        }
    }

    @Override
    public int read() throws IOException {
        long index;
        int ch = null != this.patch && (index = this.streamPos - this.patchPos) >= 0L && index < (long)this.patch.length ? this.patch[(int)index] : this.iis.read();
        if (ch >= 0) {
            ++this.streamPos;
        }
        return ch;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int r = 0;
        if (null != this.patch && this.streamPos < this.patchPos + (long)this.patch.length) {
            if (this.streamPos < this.patchPos) {
                r = this.iis.read(b, off, (int)Math.min(this.patchPos - this.streamPos, (long)len));
                if (r < 0) {
                    return r;
                }
                this.streamPos += (long)r;
                if (this.streamPos < this.patchPos) {
                    return r;
                }
                off += r;
                len -= r;
            }
            int index = (int)(this.patchPos - this.streamPos);
            int r2 = Math.min(this.patch.length - index, len);
            System.arraycopy(this.patch, index, b, off, r2);
            this.streamPos += (long)r2;
            r += r2;
            off += r2;
            len -= r2;
        }
        if (len > 0) {
            int r3 = this.iis.read(b, off, len);
            if (r3 < 0) {
                return r3;
            }
            this.streamPos += (long)r3;
            r += r3;
        }
        return r;
    }

    @Override
    public void mark() {
        super.mark();
        this.iis.mark();
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.iis.reset();
    }

    @Override
    public void seek(long pos) throws IOException {
        super.seek(pos);
        this.iis.seek(this.adjustStreamPosition(pos));
    }

    @Override
    public ByteBuffer getBytes() throws IOException {
        int read;
        byte[] array = new byte[8192];
        int length = 0;
        while ((read = this.read(array, length, array.length - length)) > 0) {
            if ((length += read) != array.length) continue;
            array = Arrays.copyOf(array, array.length << 1);
        }
        return ByteBuffer.wrap(array, 0, length);
    }

    @Override
    protected void finalize() {
    }
}

