/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.plugin;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.GeneralSecurityException;
import java.util.List;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.StreamKit;
import org.aoju.bus.image.Device;
import org.aoju.bus.image.metric.Connection;
import org.aoju.bus.image.metric.internal.hl7.MLLPConnection;

public class HL7Snd
extends Device {
    private final Connection conn = new Connection();
    private final Connection remote = new Connection();
    private Socket sock;
    private MLLPConnection mllp;

    public HL7Snd() {
        super("hl7snd");
        this.addConnection(this.conn);
    }

    public void open() throws IOException, InstrumentException, GeneralSecurityException {
        this.sock = this.conn.connect(this.remote);
        this.sock.setSoTimeout(this.conn.getResponseTimeout());
        this.mllp = new MLLPConnection(this.sock);
    }

    public void close() {
        this.conn.close(this.sock);
    }

    public void sendFiles(List<String> pathnames) throws IOException {
        for (String pathname : pathnames) {
            if (pathname.equals("-")) {
                this.send(this.readFromStdIn());
                continue;
            }
            Path path = Paths.get(pathname, new String[0]);
            if (Files.isDirectory(path, new LinkOption[0])) {
                Files.walkFileTree(path, new HL7Send());
                continue;
            }
            this.send(this.readFromFile(path));
        }
    }

    private void send(byte[] data) throws IOException {
        this.mllp.writeMessage(data);
        if (null == this.mllp.readMessage()) {
            throw new IOException("Connection closed by receiver");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFromStdIn() throws IOException {
        byte[] byArray;
        FileInputStream in = null;
        try {
            in = new FileInputStream(FileDescriptor.in);
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            StreamKit.copy((InputStream)in, (OutputStream)buf);
            byArray = buf.toByteArray();
        }
        catch (Throwable throwable) {
            IoKit.close(in);
            throw throwable;
        }
        IoKit.close((Closeable)in);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFromFile(Path path) throws IOException {
        byte[] byArray;
        FileInputStream in = null;
        try {
            File f = path.toFile();
            in = new FileInputStream(f);
            byte[] b = new byte[(int)f.length()];
            StreamKit.readFully((InputStream)in, (byte[])b, (int)0, (int)b.length);
            byArray = b;
        }
        catch (Throwable throwable) {
            IoKit.close(in);
            throw throwable;
        }
        IoKit.close((Closeable)in);
        return byArray;
    }

    class HL7Send
    extends SimpleFileVisitor<Path> {
        HL7Send() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            HL7Snd.this.send(HL7Snd.this.readFromFile(file));
            return FileVisitResult.CONTINUE;
        }
    }
}

