/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.metric.internal.net;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import org.aoju.bus.image.metric.Connection;
import org.aoju.bus.image.metric.Monitoring;
import org.aoju.bus.image.metric.SocketListener;
import org.aoju.bus.image.metric.internal.net.TCPHandler;
import org.aoju.bus.logger.Logger;

public class TCPListener
implements SocketListener {
    private final Connection conn;
    private final TCPHandler handler;
    private final ServerSocket ss;

    public TCPListener(Connection conn, TCPHandler handler) throws IOException, GeneralSecurityException {
        try {
            this.conn = conn;
            this.handler = handler;
            this.ss = conn.isTls() ? this.createTLSServerSocket(conn) : new ServerSocket();
            conn.setReceiveBufferSize(this.ss);
            this.ss.bind(conn.getBindPoint(), conn.getBacklog());
            conn.getDevice().execute(() -> this.listen());
        }
        catch (IOException e) {
            throw new IOException("Unable to start TCPListener on " + conn.getHostname() + ":" + conn.getPort(), e);
        }
    }

    private ServerSocket createTLSServerSocket(Connection conn) throws IOException, GeneralSecurityException {
        SSLContext sslContext = conn.getDevice().sslContext();
        SSLServerSocketFactory ssf = sslContext.getServerSocketFactory();
        SSLServerSocket ss = (SSLServerSocket)ssf.createServerSocket();
        ss.setEnabledProtocols(conn.getTlsProtocols());
        ss.setEnabledCipherSuites(conn.getTlsCipherSuites());
        ss.setNeedClientAuth(conn.isTlsNeedClientAuth());
        return ss;
    }

    private void listen() {
        SocketAddress sockAddr = this.ss.getLocalSocketAddress();
        Logger.info((String)"Start TCP Listener on {}", (Object[])new Object[]{sockAddr});
        block6: while (true) {
            try {
                while (!this.ss.isClosed()) {
                    Monitoring monitor;
                    Socket s;
                    block12: {
                        Logger.debug((String)"Wait for connection on {}", (Object[])new Object[]{sockAddr});
                        s = this.ss.accept();
                        Monitoring monitoring = monitor = null != this.conn.getDevice() ? this.conn.getDevice().getMonitoring() : null;
                        if (this.conn.isBlackListed(s.getInetAddress())) {
                            if (null != monitor) {
                                monitor.onConnectionRejectedBlacklisted(this.conn, s);
                            }
                            Logger.info((String)"Reject blacklisted connection {}", (Object[])new Object[]{s});
                            this.conn.close(s);
                            continue;
                        }
                        try {
                            this.conn.setSocketSendOptions(s);
                            if (!(s instanceof SSLSocket)) break block12;
                            ((SSLSocket)s).startHandshake();
                        }
                        catch (Throwable e) {
                            if (null != monitor) {
                                monitor.onConnectionRejected(this.conn, s, e);
                            }
                            Logger.warn((String)"Reject connection {}:", (Object[])new Object[]{s, e});
                            this.conn.close(s);
                            continue;
                        }
                    }
                    if (null != monitor) {
                        monitor.onConnectionAccepted(this.conn, s);
                    }
                    Logger.info((String)"Accept connection {}", (Object[])new Object[]{s});
                    try {
                        this.handler.onAccept(this.conn, s);
                        continue block6;
                    }
                    catch (Throwable e) {
                        Logger.warn((String)"Exception on accepted connection {}:", (Object[])new Object[]{s, e});
                        this.conn.close(s);
                    }
                }
                break;
            }
            catch (Throwable e) {
                if (this.ss.isClosed()) break;
                Logger.error((String)"Exception on listing on {}:", (Object[])new Object[]{sockAddr, e});
                break;
            }
        }
        Logger.info((String)"Stop TCP Listener on {}", (Object[])new Object[]{sockAddr});
    }

    @Override
    public SocketAddress getEndPoint() {
        return this.ss.getLocalSocketAddress();
    }

    @Override
    public void close() {
        try {
            this.ss.close();
        }
        catch (Throwable e) {
            Logger.error((String)e.getMessage(), (Object[])new Object[0]);
        }
    }
}

