/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.plugin;

import java.text.MessageFormat;
import org.aoju.bus.image.Args;
import org.aoju.bus.image.Builder;
import org.aoju.bus.image.Centre;
import org.aoju.bus.image.Node;
import org.aoju.bus.image.Option;
import org.aoju.bus.image.Status;
import org.aoju.bus.image.metric.Connection;
import org.aoju.bus.image.metric.Progress;
import org.aoju.bus.image.plugin.MoveSCU;
import org.aoju.bus.logger.Logger;

public class CMove {
    public static Status process(Node callingNode, Node calledNode, String destinationAet, Progress progress, Args ... keys) {
        return CMove.process(new Args(), callingNode, calledNode, destinationAet, progress, keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public static Status process(Args args, Node callingNode, Node calledNode, String destinationAet, Progress progress, Args ... keys) {
        if (null == callingNode || null == calledNode || null == destinationAet) {
            throw new IllegalArgumentException("callingNode, calledNode or destinationAet cannot be null!");
        }
        try {
            Throwable throwable = null;
            try (MoveSCU moveSCU = new MoveSCU(progress);){
                Status status;
                Connection remote = moveSCU.getRemoteConnection();
                Connection conn = moveSCU.getConnection();
                args.configureBind(moveSCU.getAAssociateRQ(), remote, calledNode);
                args.configureBind(moveSCU.getApplicationEntity(), conn, callingNode);
                Centre centre = new Centre(moveSCU);
                args.configure(conn);
                args.configureTLS(conn, remote);
                moveSCU.setInformationModel(CMove.getInformationModel(args), args.getTsuidOrder(), args.getTypes().contains((Object)Option.Type.RELATIONAL));
                for (Args p : keys) {
                    moveSCU.addKey(p.getTag(), p.getValues());
                }
                moveSCU.setDestination(destinationAet);
                centre.start(true);
                try {
                    Status dcmState = moveSCU.getState();
                    long t1 = System.currentTimeMillis();
                    moveSCU.open();
                    long t2 = System.currentTimeMillis();
                    moveSCU.retrieve();
                    Builder.forceGettingAttributes(dcmState, moveSCU);
                    long t3 = System.currentTimeMillis();
                    String timeMsg = MessageFormat.format("DICOM C-MOVE connected in {2}ms from {0} to {1}. Sent files in {3}ms.", moveSCU.getAAssociateRQ().getCallingAET(), moveSCU.getAAssociateRQ().getCalledAET(), t2 - t1, t3 - t2);
                    status = Status.build(dcmState, timeMsg, null);
                }
                catch (Exception e) {
                    Status status2;
                    block24: {
                        block25: {
                            Logger.error((String)"movescu", (Object[])new Object[]{e});
                            Builder.forceGettingAttributes(moveSCU.getState(), moveSCU);
                            status2 = Status.build(moveSCU.getState(), null, e);
                            Builder.close(moveSCU);
                            centre.stop();
                            if (moveSCU == null) break block24;
                            if (throwable == null) break block25;
                            try {
                                moveSCU.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            break block24;
                        }
                        moveSCU.close();
                    }
                    return status2;
                    {
                        catch (Throwable throwable3) {
                            try {
                                Builder.close(moveSCU);
                                centre.stop();
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                throwable = throwable4;
                                throw throwable4;
                            }
                        }
                    }
                }
                Builder.close(moveSCU);
                centre.stop();
                return status;
            }
        }
        catch (Exception e) {
            Logger.error((String)"movescu", (Object[])new Object[]{e});
            return new Status(49152, "DICOM Move failed : " + e.getMessage(), null);
        }
    }

    private static MoveSCU.InformationModel getInformationModel(Args options) {
        Object model = options.getInformationModel();
        if (model instanceof MoveSCU.InformationModel) {
            return (MoveSCU.InformationModel)((Object)model);
        }
        return MoveSCU.InformationModel.StudyRoot;
    }
}

