/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.galaxy;

import org.aoju.bus.core.exception.InstrumentException;
import org.aoju.bus.image.Device;
import org.aoju.bus.image.galaxy.Configuration;
import org.aoju.bus.image.galaxy.ConfigurationCache;
import org.aoju.bus.image.galaxy.IDeviceCache;

public class DeviceCache
extends ConfigurationCache<Configuration, Device>
implements IDeviceCache {
    public DeviceCache(Configuration conf) {
        super(conf);
    }

    @Override
    protected Device find(Configuration conf, String key) throws InstrumentException {
        return conf.findDevice(key);
    }

    @Override
    public Device findDevice(String deviceName) throws InstrumentException {
        Device device = (Device)this.get(deviceName);
        if (null == device) {
            throw new InstrumentException("Unknown Device: " + deviceName);
        }
        if (!device.isInstalled()) {
            throw new InstrumentException("Device: " + deviceName + " not installed");
        }
        return device;
    }
}

