/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.metric;

import org.aoju.bus.image.Device;

public class KeycloakClient {
    private Device device;
    private String keycloakClientID;
    private String keycloakServerURL;
    private String keycloakRealm;
    private String keycloakClientSecret;
    private String userID;
    private String password;
    private GrantType keycloakGrantType = GrantType.client_credentials;
    private boolean tlsAllowAnyHostname;
    private boolean tlsDisableTrustManager;

    public KeycloakClient() {
    }

    public KeycloakClient(String keycloakClientID) {
        this.setKeycloakClientID(keycloakClientID);
    }

    public Device getDevice() {
        return this.device;
    }

    public void setDevice(Device device) {
        if (null != device && null != this.device) {
            throw new IllegalStateException("already owned by " + this.device.getDeviceName());
        }
        this.device = device;
    }

    public String getKeycloakClientID() {
        return this.keycloakClientID;
    }

    public void setKeycloakClientID(String keycloakClientID) {
        this.keycloakClientID = keycloakClientID;
    }

    public String getKeycloakServerURL() {
        return this.keycloakServerURL;
    }

    public void setKeycloakServerURL(String keycloakServerURL) {
        this.keycloakServerURL = keycloakServerURL;
    }

    public String getKeycloakRealm() {
        return this.keycloakRealm;
    }

    public void setKeycloakRealm(String keycloakRealm) {
        this.keycloakRealm = keycloakRealm;
    }

    public GrantType getKeycloakGrantType() {
        return this.keycloakGrantType;
    }

    public void setKeycloakGrantType(GrantType keycloakGrantType) {
        this.keycloakGrantType = keycloakGrantType;
    }

    public String getKeycloakClientSecret() {
        return this.keycloakClientSecret;
    }

    public void setKeycloakClientSecret(String keycloakClientSecret) {
        this.keycloakClientSecret = keycloakClientSecret;
    }

    public String getUserID() {
        return this.userID;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isTLSAllowAnyHostname() {
        return this.tlsAllowAnyHostname;
    }

    public void setTLSAllowAnyHostname(boolean tlsAllowAnyHostname) {
        this.tlsAllowAnyHostname = tlsAllowAnyHostname;
    }

    public boolean isTLSDisableTrustManager() {
        return this.tlsDisableTrustManager;
    }

    public void setTLSDisableTrustManager(boolean tlsDisableTrustManager) {
        this.tlsDisableTrustManager = tlsDisableTrustManager;
    }

    public void reconfigure(KeycloakClient src) {
        this.keycloakServerURL = src.keycloakServerURL;
        this.keycloakRealm = src.keycloakRealm;
        this.keycloakGrantType = src.keycloakGrantType;
        this.keycloakClientSecret = src.keycloakClientSecret;
        this.userID = src.userID;
        this.password = src.password;
        this.tlsAllowAnyHostname = src.tlsAllowAnyHostname;
        this.tlsDisableTrustManager = src.tlsDisableTrustManager;
    }

    public static enum GrantType {
        client_credentials,
        password;

    }
}

