/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.metric.internal.hl7;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;
import org.aoju.bus.image.metric.internal.hl7.MLLPInputStream;
import org.aoju.bus.image.metric.internal.hl7.MLLPOutputStream;
import org.aoju.bus.logger.Logger;

public class MLLPConnection
implements Closeable {
    private final Socket sock;
    private final MLLPInputStream mllpIn;
    private final MLLPOutputStream mllpOut;

    public MLLPConnection(Socket sock) throws IOException {
        this.sock = sock;
        this.mllpIn = new MLLPInputStream(sock.getInputStream());
        this.mllpOut = new MLLPOutputStream(sock.getOutputStream());
    }

    public MLLPConnection(Socket sock, int bufferSize) throws IOException {
        this.sock = sock;
        this.mllpIn = new MLLPInputStream(sock.getInputStream());
        this.mllpOut = new MLLPOutputStream(new BufferedOutputStream(sock.getOutputStream(), bufferSize));
    }

    public final Socket getSocket() {
        return this.sock;
    }

    public void writeMessage(byte[] b) throws IOException {
        this.writeMessage(b, 0, b.length);
    }

    public void writeMessage(byte[] b, int off, int len) throws IOException {
        this.log("{} << {}", b, off, len);
        this.mllpOut.writeMessage(b, off, len);
    }

    public byte[] readMessage() throws IOException {
        byte[] b = this.mllpIn.readMessage();
        if (null != b) {
            this.log("{} >> {}", b, 0, b.length);
        }
        return b;
    }

    private void log(String format, byte[] b, int off, int len) {
        int mshlen;
        for (mshlen = 0; mshlen < len && b[off + mshlen] != 13; ++mshlen) {
        }
        Logger.info((String)format, (Object[])new Object[]{this.sock, new String(b, off, mshlen)});
    }

    @Override
    public void close() throws IOException {
        this.sock.close();
    }
}

