/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.plugin;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import org.aoju.bus.core.exception.InstrumentException;
import org.aoju.bus.image.Builder;
import org.aoju.bus.image.Device;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.data.Sequence;
import org.aoju.bus.image.galaxy.data.VR;
import org.aoju.bus.image.metric.ApplicationEntity;
import org.aoju.bus.image.metric.Association;
import org.aoju.bus.image.metric.Connection;
import org.aoju.bus.image.metric.DimseRSPHandler;
import org.aoju.bus.image.metric.internal.pdu.AAssociateRQ;
import org.aoju.bus.image.metric.internal.pdu.Presentation;

public class IanSCU {
    private final Device device = new Device("ianscu");
    private final ApplicationEntity ae = new ApplicationEntity("IANSCU");
    private final Connection conn = new Connection();
    private final Connection remote = new Connection();
    private final AAssociateRQ rq = new AAssociateRQ();
    private final Attributes attrs = new Attributes();
    private final HashMap<String, Attributes> map = new HashMap();
    private String uidSuffix;
    private String refPpsIUID;
    private String refPpsCUID = "1.2.840.10008.3.1.2.3.3";
    private String availability = "ONLINE";
    private String retrieveAET;
    private String retrieveURI;
    private String retrieveURL;
    private String retrieveUID;
    private Association as;

    public IanSCU() {
        this.device.addConnection(this.conn);
        this.device.addApplicationEntity(this.ae);
        this.ae.addConnection(this.conn);
    }

    public final void setUIDSuffix(String uidSuffix) {
        this.uidSuffix = uidSuffix;
    }

    public void setTransferSyntaxes(String[] tss) {
        this.rq.addPresentationContext(new Presentation(1, "1.2.840.10008.1.1", "1.2.840.10008.1.2"));
        this.rq.addPresentationContext(new Presentation(3, "1.2.840.10008.5.1.4.33", tss));
    }

    public void setRefPpsIUID(String refPpsIUID) {
        this.refPpsIUID = refPpsIUID;
    }

    public void setRefPpsCUID(String refPpsCUID) {
        this.refPpsCUID = refPpsCUID;
    }

    public void setAvailability(String availability) {
        this.availability = availability;
    }

    public String getRetrieveAET() {
        return null != this.retrieveAET ? this.retrieveAET : this.ae.getAETitle();
    }

    public void setRetrieveAET(String retrieveAET) {
        this.retrieveAET = retrieveAET;
    }

    public void setRetrieveURL(String retrieveURL) {
        this.retrieveURL = retrieveURL;
    }

    public void setRetrieveURI(String retrieveURI) {
        this.retrieveURI = retrieveURI;
    }

    public void setRetrieveUID(String retrieveUID) {
        this.retrieveUID = retrieveUID;
    }

    public void open() throws IOException, InterruptedException, InstrumentException, GeneralSecurityException {
        this.as = this.ae.connect(this.conn, this.remote, this.rq);
    }

    public void close() throws IOException {
        if (null != this.as) {
            this.as.release();
        }
    }

    public void echo() throws IOException, InterruptedException {
        this.as.cecho().next();
    }

    public void sendIans() throws IOException, InterruptedException {
        for (Attributes ian : this.map.values()) {
            this.sendIan(ian);
        }
    }

    private void sendIan(Attributes ian) throws IOException, InterruptedException {
        this.as.ncreate("1.2.840.10008.5.1.4.33", null, ian, null, new DimseRSPHandler(this.as.nextMessageID()));
    }

    public boolean addInstance(Attributes inst) {
        Builder.updateAttributes(inst, this.attrs, this.uidSuffix);
        String suid = inst.getString(0x20000D);
        if (null == suid) {
            return false;
        }
        Attributes ian = this.map.get(suid);
        if (null == ian) {
            ian = this.createIAN(inst);
            this.map.put(suid, ian);
        }
        this.updateIAN(ian, inst);
        return true;
    }

    public boolean addIAN(String iuid, Attributes ian) {
        this.map.put(iuid, ian);
        return true;
    }

    private Attributes createIAN(Attributes inst) {
        Attributes ian = new Attributes(3);
        Sequence refPpsSeq = ian.newSequence(528657, 1);
        if (null != this.refPpsIUID) {
            Attributes refPps = new Attributes(3);
            refPps.setString(528720, VR.UI, this.refPpsCUID);
            refPps.setString(528725, VR.UI, this.refPpsIUID);
            refPps.setNull(4210713, VR.SQ);
            refPpsSeq.add(refPps);
        }
        ian.newSequence(528661, 1);
        ian.setString(0x20000D, VR.UI, inst.getString(0x20000D));
        return ian;
    }

    private void updateIAN(Attributes mpps, Attributes inst) {
        Sequence refSeriesSeq = mpps.getSequence(528661);
        Attributes refSeries = this.getRefSeries(refSeriesSeq, inst);
        Sequence refSOPSeq = refSeries.getSequence(528793);
        Attributes refSOP = new Attributes(6);
        refSOP.setString(524372, VR.AE, this.getRetrieveAET());
        refSOP.setString(524374, VR.CS, this.availability);
        refSOP.setString(528720, VR.UI, inst.getString(524310));
        refSOP.setString(528725, VR.UI, inst.getString(524312));
        if (null != this.retrieveURL) {
            refSOP.setString(528784, VR.UR, this.retrieveURL);
        }
        if (null != this.retrieveURI) {
            refSOP.setString(4251664, VR.UR, this.retrieveURI);
        }
        if (null != this.retrieveUID) {
            refSOP.setString(4251665, VR.UI, this.retrieveUID);
        }
        refSOPSeq.add(refSOP);
    }

    private Attributes getRefSeries(Sequence refSeriesSeq, Attributes inst) {
        String suid = inst.getString(0x20000E);
        for (Attributes refSeries : refSeriesSeq) {
            if (!suid.equals(refSeries.getString(0x20000E))) continue;
            return refSeries;
        }
        Attributes refSeries = new Attributes(2);
        refSeries.newSequence(528793, 10);
        refSeries.setString(0x20000E, VR.CS, suid);
        refSeriesSeq.add(refSeries);
        return refSeries;
    }
}

