/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.plugin;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.image.Builder;
import org.aoju.bus.image.Device;
import org.aoju.bus.image.Efforts;
import org.aoju.bus.image.Node;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.data.VR;
import org.aoju.bus.image.galaxy.io.ImageInputStream;
import org.aoju.bus.image.galaxy.io.ImageOutputStream;
import org.aoju.bus.image.metric.ApplicationEntity;
import org.aoju.bus.image.metric.Association;
import org.aoju.bus.image.metric.Connection;
import org.aoju.bus.image.metric.ImageException;
import org.aoju.bus.image.metric.PDVInputStream;
import org.aoju.bus.image.metric.TransferCapability;
import org.aoju.bus.image.metric.internal.pdu.Presentation;
import org.aoju.bus.image.metric.service.BasicCEchoSCP;
import org.aoju.bus.image.metric.service.BasicCStoreSCP;
import org.aoju.bus.image.metric.service.ServiceHandler;
import org.aoju.bus.logger.Logger;

public class StoreSCP
extends BasicCStoreSCP {
    public final Device device = new Device("storescp");
    public final ApplicationEntity ae = new ApplicationEntity("*");
    public final Connection conn = new Connection();
    public final String storageDir;
    public final List<Node> authorizedCallingNodes;
    public Efforts efforts;
    private volatile int status = 0;

    public StoreSCP(String storageDir) {
        this(storageDir, (List<Node>)null);
    }

    public StoreSCP(String storageDir, List<Node> authorizedCallingNodes) {
        this.storageDir = Objects.requireNonNull(storageDir);
        this.device.setDimseRQHandler(this.createServiceRegistry());
        this.device.addConnection(this.conn);
        this.device.addApplicationEntity(this.ae);
        this.ae.setAssociationAcceptor(true);
        this.ae.addConnection(this.conn);
        this.authorizedCallingNodes = authorizedCallingNodes;
    }

    private static void renameTo(Association as, File from, File dest) throws IOException {
        Logger.info((String)"{}: M-RENAME {} to {}", (Object[])new Object[]{as, from, dest});
        Builder.prepareToWriteFile(dest);
        if (!from.renameTo(dest)) {
            throw new IOException("Failed to rename " + from + " to " + dest);
        }
    }

    private static Attributes parse(File file) throws IOException {
        ImageInputStream in = new ImageInputStream(file);
        try {
            in.setIncludeBulkData(ImageInputStream.IncludeBulkData.NO);
            Attributes attributes = in.readDataset(-1, 2145386512);
            return attributes;
        }
        finally {
            IoKit.close((Closeable)in);
        }
    }

    private static void deleteFile(Association as, File file) {
        if (file.delete()) {
            Logger.info((String)"{}: M-DELETE {}", (Object[])new Object[]{as, file});
        } else {
            Logger.warn((String)"{}: M-DELETE {} failed!", (Object[])new Object[]{as, file});
        }
    }

    @Override
    protected void store(Association as, Presentation pc, Attributes rq, PDVInputStream data, Attributes rsp) throws IOException {
        if (null != this.authorizedCallingNodes && !this.authorizedCallingNodes.isEmpty()) {
            Node sourceNode = Node.buildRemoteDicomNode(as);
            boolean valid = this.authorizedCallingNodes.stream().anyMatch(n -> n.getAet().equals(sourceNode.getAet()) && (!n.isValidate() || n.equalsHostname(sourceNode.getHostname())));
            if (!valid) {
                rsp.setInt(2304, VR.US, 292);
                Logger.error((String)"Refused: not authorized (124H). Source node: {}. SopUID: {}", (Object[])new Object[]{sourceNode, rq.getString(4096)});
                return;
            }
        }
        rsp.setInt(2304, VR.US, this.status);
        String cuid = rq.getString(2);
        String iuid = rq.getString(4096);
        String tsuid = pc.getTransferSyntax();
        File file = new File(this.storageDir, File.separator + iuid + ".dcm");
        try {
            Attributes fmi = as.createFileMetaInformation(iuid, cuid, tsuid);
            this.storeTo(as, fmi, data, file);
            if (ObjectKit.isNotEmpty((Object)this.efforts)) {
                this.efforts.supports(fmi, file, this.getClass());
            }
        }
        catch (Exception e) {
            throw new ImageException(272, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeTo(Association as, Attributes fmi, PDVInputStream data, File file) throws IOException {
        Logger.debug((String)"{}: M-WRITE {}", (Object[])new Object[]{as, file});
        file.getParentFile().mkdirs();
        ImageOutputStream out = new ImageOutputStream(file);
        try {
            out.writeFileMetaInformation(fmi);
            data.copyTo(out);
        }
        finally {
            IoKit.close((Closeable)out);
        }
    }

    private ServiceHandler createServiceRegistry() {
        ServiceHandler serviceHandler = new ServiceHandler();
        serviceHandler.addService(new BasicCEchoSCP());
        serviceHandler.addService(this);
        return serviceHandler;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void loadDefaultTransferCapability(URL url) {
        Properties p;
        block10: {
            p = new Properties();
            try {
                if (url != null) {
                    try (InputStream in = url.openStream();){
                        p.load(in);
                        break block10;
                    }
                }
                p.load(this.getClass().getResourceAsStream("sop-classes.properties"));
            }
            catch (IOException e) {
                Logger.error((String)"Cannot read sop-classes", (Object[])new Object[]{e});
            }
        }
        for (String cuid : p.stringPropertyNames()) {
            String ts = p.getProperty(cuid);
            TransferCapability tc = new TransferCapability(null, Builder.toUID(cuid), TransferCapability.Role.SCP, Builder.toUIDs(ts));
            this.ae.addTransferCapability(tc);
        }
    }

    public ApplicationEntity getApplicationEntity() {
        return this.ae;
    }

    public Connection getConnection() {
        return this.conn;
    }

    public Device getDevice() {
        return this.device;
    }

    public Efforts getEfforts() {
        return this.efforts;
    }

    public void setEfforts(Efforts efforts) {
        this.efforts = efforts;
    }
}

