/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.nimble.opencv;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import org.aoju.bus.image.nimble.opencv.ImageCV;
import org.aoju.bus.image.nimble.opencv.PlanarImage;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.imgproc.Imgproc;

public class ImageConversion {
    public static BufferedImage toBufferedImage(Mat matrix) {
        ComponentColorModel colorModel;
        if (null == matrix) {
            return null;
        }
        int cols = matrix.cols();
        int rows = matrix.rows();
        int type = matrix.type();
        int elemSize = CvType.ELEM_SIZE((int)type);
        int channels = CvType.channels((int)type);
        int bpp = elemSize * 8 / channels;
        int dataType = ImageConversion.convertToDataType(type);
        WritableRaster raster = switch (channels) {
            case 1 -> {
                ColorSpace cs = ColorSpace.getInstance(1003);
                colorModel = new ComponentColorModel(cs, new int[]{bpp}, false, true, 1, dataType);
                yield colorModel.createCompatibleWritableRaster(cols, rows);
            }
            case 3 -> {
                ColorSpace cs = ColorSpace.getInstance(1000);
                colorModel = new ComponentColorModel(cs, new int[]{bpp, bpp, bpp}, false, false, 1, dataType);
                yield Raster.createInterleavedRaster(dataType, cols, rows, cols * channels, channels, new int[]{2, 1, 0}, null);
            }
            default -> throw new UnsupportedOperationException("No implementation to handle " + channels + " channels");
        };
        DataBuffer buf = raster.getDataBuffer();
        if (buf instanceof DataBufferByte) {
            matrix.get(0, 0, ((DataBufferByte)buf).getData());
        } else if (buf instanceof DataBufferUShort) {
            matrix.get(0, 0, ((DataBufferUShort)buf).getData());
        } else if (buf instanceof DataBufferShort) {
            matrix.get(0, 0, ((DataBufferShort)buf).getData());
        } else if (buf instanceof DataBufferInt) {
            matrix.get(0, 0, ((DataBufferInt)buf).getData());
        } else if (buf instanceof DataBufferFloat) {
            matrix.get(0, 0, ((DataBufferFloat)buf).getData());
        } else if (buf instanceof DataBufferDouble) {
            matrix.get(0, 0, ((DataBufferDouble)buf).getData());
        }
        return new BufferedImage(colorModel, raster, false, null);
    }

    public static BufferedImage toBufferedImage(PlanarImage matrix) {
        if (null == matrix) {
            return null;
        }
        return ImageConversion.toBufferedImage(matrix.toMat());
    }

    public static void releaseMat(Mat mat) {
        if (null != mat) {
            mat.release();
        }
    }

    public static void releasePlanarImage(PlanarImage img) {
        if (null != img) {
            img.release();
        }
    }

    public static int convertToDataType(int cvType) {
        switch (CvType.depth((int)cvType)) {
            case 0: 
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 5;
            }
        }
        throw new UnsupportedOperationException("Unsupported CvType value: " + cvType);
    }

    public static ImageCV toMat(RenderedImage img) {
        return ImageConversion.toMat(img, null);
    }

    public static ImageCV toMat(RenderedImage img, Rectangle region) {
        return ImageConversion.toMat(img, region, true);
    }

    public static ImageCV toMat(RenderedImage img, Rectangle region, boolean toBGR) {
        int[] offsets;
        Raster raster = null == region ? img.getData() : img.getData(region);
        DataBuffer buf = raster.getDataBuffer();
        int[] samples = raster.getSampleModel().getSampleSize();
        if (raster.getSampleModel() instanceof ComponentSampleModel) {
            offsets = ((ComponentSampleModel)raster.getSampleModel()).getBandOffsets();
        } else {
            offsets = new int[samples.length];
            for (int i = 0; i < offsets.length; ++i) {
                offsets[i] = i;
            }
        }
        if (ImageConversion.isBinary(raster.getSampleModel())) {
            ImageCV mat = new ImageCV(raster.getHeight(), raster.getWidth(), CvType.CV_8UC1);
            mat.put(0, 0, ImageConversion.getUnpackedBinaryData(raster, raster.getBounds()));
            return mat;
        }
        if (buf instanceof DataBufferByte) {
            if (Arrays.equals(offsets, new int[]{0, 0, 0})) {
                Mat b = new Mat(raster.getHeight(), raster.getWidth(), CvType.CV_8UC1);
                b.put(0, 0, ((DataBufferByte)buf).getData(2));
                Mat g = new Mat(raster.getHeight(), raster.getWidth(), CvType.CV_8UC1);
                g.put(0, 0, ((DataBufferByte)buf).getData(1));
                ImageCV r = new ImageCV(raster.getHeight(), raster.getWidth(), CvType.CV_8UC1);
                r.put(0, 0, ((DataBufferByte)buf).getData(0));
                List<Mat> mv = toBGR ? Arrays.asList(b, g, r) : Arrays.asList(r, g, b);
                ImageCV dstImg = new ImageCV(raster.getHeight(), raster.getWidth(), CvType.CV_8UC3);
                Core.merge(mv, (Mat)dstImg);
                return dstImg;
            }
            ImageCV mat = new ImageCV(raster.getHeight(), raster.getWidth(), CvType.CV_8UC((int)samples.length));
            mat.put(0, 0, ((DataBufferByte)buf).getData());
            if (toBGR && Arrays.equals(offsets, new int[]{0, 1, 2})) {
                ImageCV dstImg = new ImageCV();
                Imgproc.cvtColor((Mat)mat, (Mat)dstImg, (int)4);
                return dstImg;
            }
            if (!toBGR && Arrays.equals(offsets, new int[]{2, 1, 0})) {
                ImageCV dstImg = new ImageCV();
                Imgproc.cvtColor((Mat)mat, (Mat)dstImg, (int)4);
                return dstImg;
            }
            return mat;
        }
        if (buf instanceof DataBufferUShort) {
            ImageCV mat = new ImageCV(raster.getHeight(), raster.getWidth(), CvType.CV_16UC((int)samples.length));
            mat.put(0, 0, ((DataBufferUShort)buf).getData());
            return mat;
        }
        if (buf instanceof DataBufferShort) {
            ImageCV mat = new ImageCV(raster.getHeight(), raster.getWidth(), CvType.CV_16SC((int)samples.length));
            mat.put(0, 0, ((DataBufferShort)buf).getData());
            return mat;
        }
        if (buf instanceof DataBufferInt) {
            ImageCV mat = new ImageCV(raster.getHeight(), raster.getWidth(), CvType.CV_32SC((int)samples.length));
            mat.put(0, 0, ((DataBufferInt)buf).getData());
            return mat;
        }
        if (buf instanceof DataBufferFloat) {
            ImageCV mat = new ImageCV(raster.getHeight(), raster.getWidth(), CvType.CV_32FC((int)samples.length));
            mat.put(0, 0, ((DataBufferFloat)buf).getData());
            return mat;
        }
        if (buf instanceof DataBufferDouble) {
            ImageCV mat = new ImageCV(raster.getHeight(), raster.getWidth(), CvType.CV_64FC((int)samples.length));
            mat.put(0, 0, ((DataBufferDouble)buf).getData());
            return mat;
        }
        return null;
    }

    public static Rectangle getBounds(PlanarImage img) {
        return new Rectangle(0, 0, img.width(), img.height());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage convertTo(RenderedImage src, int imageType) {
        BufferedImage dst = new BufferedImage(src.getWidth(), src.getHeight(), imageType);
        Graphics2D big = dst.createGraphics();
        try {
            big.drawRenderedImage(src, AffineTransform.getTranslateInstance(0.0, 0.0));
        }
        finally {
            big.dispose();
        }
        return dst;
    }

    public static boolean isBinary(SampleModel sm) {
        return sm instanceof MultiPixelPackedSampleModel && ((MultiPixelPackedSampleModel)sm).getPixelBitStride() == 1 && sm.getNumBands() == 1;
    }

    public static byte[] getPackedBinaryData(Raster raster, Rectangle rect) {
        byte[] binaryDataArray;
        block29: {
            int numBytesPerRow;
            int bitOffset;
            int eltOffset;
            int lineStride;
            DataBuffer dataBuffer;
            int rectHeight;
            int rectWidth;
            block27: {
                block30: {
                    block28: {
                        SampleModel sm = raster.getSampleModel();
                        if (!ImageConversion.isBinary(sm)) {
                            throw new IllegalArgumentException("Not a binary raster!");
                        }
                        int rectX = rect.x;
                        int rectY = rect.y;
                        rectWidth = rect.width;
                        rectHeight = rect.height;
                        dataBuffer = raster.getDataBuffer();
                        int dx = rectX - raster.getSampleModelTranslateX();
                        int dy = rectY - raster.getSampleModelTranslateY();
                        MultiPixelPackedSampleModel mpp = (MultiPixelPackedSampleModel)sm;
                        lineStride = mpp.getScanlineStride();
                        eltOffset = dataBuffer.getOffset() + mpp.getOffset(dx, dy);
                        bitOffset = mpp.getBitOffset(dx);
                        numBytesPerRow = (rectWidth + 7) / 8;
                        if (dataBuffer instanceof DataBufferByte && eltOffset == 0 && bitOffset == 0 && numBytesPerRow == lineStride && ((DataBufferByte)dataBuffer).getData().length == numBytesPerRow * rectHeight) {
                            return ((DataBufferByte)dataBuffer).getData();
                        }
                        binaryDataArray = new byte[numBytesPerRow * rectHeight];
                        int b = 0;
                        if (bitOffset != 0) break block27;
                        if (!(dataBuffer instanceof DataBufferByte)) break block28;
                        byte[] data = ((DataBufferByte)dataBuffer).getData();
                        int stride = numBytesPerRow;
                        int offset = 0;
                        for (int y = 0; y < rectHeight; ++y) {
                            System.arraycopy(data, eltOffset, binaryDataArray, offset, stride);
                            offset += stride;
                            eltOffset += lineStride;
                        }
                        break block29;
                    }
                    if (!(dataBuffer instanceof DataBufferShort) && !(dataBuffer instanceof DataBufferUShort)) break block30;
                    short[] data = dataBuffer instanceof DataBufferShort ? ((DataBufferShort)dataBuffer).getData() : ((DataBufferUShort)dataBuffer).getData();
                    for (int y = 0; y < rectHeight; ++y) {
                        int xRemaining;
                        int i = eltOffset;
                        for (xRemaining = rectWidth; xRemaining > 8; xRemaining -= 16) {
                            short datum = data[i++];
                            binaryDataArray[b++] = (byte)(datum >>> 8 & 0xFF);
                            binaryDataArray[b++] = (byte)(datum & 0xFF);
                        }
                        if (xRemaining > 0) {
                            binaryDataArray[b++] = (byte)(data[i] >>> 8 & 0xFF);
                        }
                        eltOffset += lineStride;
                    }
                    break block29;
                }
                if (!(dataBuffer instanceof DataBufferInt)) break block29;
                int[] data = ((DataBufferInt)dataBuffer).getData();
                for (int y = 0; y < rectHeight; ++y) {
                    int xRemaining;
                    int i = eltOffset;
                    for (xRemaining = rectWidth; xRemaining > 24; xRemaining -= 32) {
                        int datum = data[i++];
                        binaryDataArray[b++] = (byte)(datum >>> 24 & 0xFF);
                        binaryDataArray[b++] = (byte)(datum >>> 16 & 0xFF);
                        binaryDataArray[b++] = (byte)(datum >>> 8 & 0xFF);
                        binaryDataArray[b++] = (byte)(datum & 0xFF);
                    }
                    int shift = 24;
                    while (xRemaining > 0) {
                        binaryDataArray[b++] = (byte)(data[i] >>> shift & 0xFF);
                        shift -= 8;
                        xRemaining -= 8;
                    }
                    eltOffset += lineStride;
                }
                break block29;
            }
            if (dataBuffer instanceof DataBufferByte) {
                byte[] data = ((DataBufferByte)dataBuffer).getData();
                if ((bitOffset & 7) == 0) {
                    int stride = numBytesPerRow;
                    int offset = 0;
                    for (int y = 0; y < rectHeight; ++y) {
                        System.arraycopy(data, eltOffset, binaryDataArray, offset, stride);
                        offset += stride;
                        eltOffset += lineStride;
                    }
                } else {
                    int leftShift = bitOffset & 7;
                    int rightShift = 8 - leftShift;
                    for (int y = 0; y < rectHeight; ++y) {
                        int i = eltOffset;
                        for (int xRemaining = rectWidth; xRemaining > 0; xRemaining -= 8) {
                            binaryDataArray[b++] = xRemaining > rightShift ? (byte)((data[i++] & 0xFF) << leftShift | (data[i] & 0xFF) >>> rightShift) : (byte)((data[i] & 0xFF) << leftShift);
                        }
                        eltOffset += lineStride;
                    }
                }
            } else if (dataBuffer instanceof DataBufferShort || dataBuffer instanceof DataBufferUShort) {
                short[] data = dataBuffer instanceof DataBufferShort ? ((DataBufferShort)dataBuffer).getData() : ((DataBufferUShort)dataBuffer).getData();
                for (int y = 0; y < rectHeight; ++y) {
                    int bOffset = bitOffset;
                    int x = 0;
                    while (x < rectWidth) {
                        int i = eltOffset + bOffset / 16;
                        int mod = bOffset % 16;
                        int left = data[i] & 0xFFFF;
                        if (mod <= 8) {
                            binaryDataArray[b++] = (byte)(left >>> 8 - mod);
                        } else {
                            int delta = mod - 8;
                            int right = data[i + 1] & 0xFFFF;
                            binaryDataArray[b++] = (byte)(left << delta | right >>> 16 - delta);
                        }
                        x += 8;
                        bOffset += 8;
                    }
                    eltOffset += lineStride;
                }
            } else if (dataBuffer instanceof DataBufferInt) {
                int[] data = ((DataBufferInt)dataBuffer).getData();
                for (int y = 0; y < rectHeight; ++y) {
                    int bOffset = bitOffset;
                    int x = 0;
                    while (x < rectWidth) {
                        int i = eltOffset + bOffset / 32;
                        int mod = bOffset % 32;
                        int left = data[i];
                        if (mod <= 24) {
                            binaryDataArray[b++] = (byte)(left >>> 24 - mod);
                        } else {
                            int delta = mod - 24;
                            int right = data[i + 1];
                            binaryDataArray[b++] = (byte)(left << delta | right >>> 32 - delta);
                        }
                        x += 8;
                        bOffset += 8;
                    }
                    eltOffset += lineStride;
                }
            }
        }
        return binaryDataArray;
    }

    public static byte[] getUnpackedBinaryData(Raster raster, Rectangle rect) {
        byte[] bdata;
        block8: {
            int maxX;
            int maxY;
            int bitOffset;
            int eltOffset;
            int lineStride;
            DataBuffer dataBuffer;
            block9: {
                block7: {
                    SampleModel sm = raster.getSampleModel();
                    if (!ImageConversion.isBinary(sm)) {
                        throw new IllegalArgumentException("Not a binary raster!");
                    }
                    int rectX = rect.x;
                    int rectY = rect.y;
                    int rectWidth = rect.width;
                    int rectHeight = rect.height;
                    dataBuffer = raster.getDataBuffer();
                    int dx = rectX - raster.getSampleModelTranslateX();
                    int dy = rectY - raster.getSampleModelTranslateY();
                    MultiPixelPackedSampleModel mpp = (MultiPixelPackedSampleModel)sm;
                    lineStride = mpp.getScanlineStride();
                    eltOffset = dataBuffer.getOffset() + mpp.getOffset(dx, dy);
                    bitOffset = mpp.getBitOffset(dx);
                    bdata = new byte[rectWidth * rectHeight];
                    maxY = rectY + rectHeight;
                    maxX = rectX + rectWidth;
                    int k = 0;
                    if (!(dataBuffer instanceof DataBufferByte)) break block7;
                    byte[] data = ((DataBufferByte)dataBuffer).getData();
                    for (int y = rectY; y < maxY; ++y) {
                        int bOffset = eltOffset * 8 + bitOffset;
                        for (int x = rectX; x < maxX; ++x) {
                            byte b = data[bOffset / 8];
                            bdata[k++] = (byte)(b >>> (7 - bOffset & 7) & 1);
                            ++bOffset;
                        }
                        eltOffset += lineStride;
                    }
                    break block8;
                }
                if (!(dataBuffer instanceof DataBufferShort) && !(dataBuffer instanceof DataBufferUShort)) break block9;
                short[] data = dataBuffer instanceof DataBufferShort ? ((DataBufferShort)dataBuffer).getData() : ((DataBufferUShort)dataBuffer).getData();
                for (int y = rectY; y < maxY; ++y) {
                    int bOffset = eltOffset * 16 + bitOffset;
                    for (int x = rectX; x < maxX; ++x) {
                        short s = data[bOffset / 16];
                        bdata[k++] = (byte)(s >>> 15 - bOffset % 16 & 1);
                        ++bOffset;
                    }
                    eltOffset += lineStride;
                }
                break block8;
            }
            if (!(dataBuffer instanceof DataBufferInt)) break block8;
            int[] data = ((DataBufferInt)dataBuffer).getData();
            for (int y = rectY; y < maxY; ++y) {
                int bOffset = eltOffset * 32 + bitOffset;
                for (int x = rectX; x < maxX; ++x) {
                    int i = data[bOffset / 32];
                    bdata[k++] = (byte)(i >>> 31 - bOffset % 32 & 1);
                    ++bOffset;
                }
                eltOffset += lineStride;
            }
        }
        return bdata;
    }

    public static void setPackedBinaryData(byte[] binaryDataArray, WritableRaster raster, Rectangle rect) {
        block41: {
            int b;
            int bitOffset;
            int eltOffset;
            int lineStride;
            DataBuffer dataBuffer;
            int rectHeight;
            int rectWidth;
            block39: {
                block42: {
                    block40: {
                        SampleModel sm = raster.getSampleModel();
                        if (!ImageConversion.isBinary(sm)) {
                            throw new IllegalArgumentException("Not a binary raster!");
                        }
                        int rectX = rect.x;
                        int rectY = rect.y;
                        rectWidth = rect.width;
                        rectHeight = rect.height;
                        dataBuffer = raster.getDataBuffer();
                        int dx = rectX - raster.getSampleModelTranslateX();
                        int dy = rectY - raster.getSampleModelTranslateY();
                        MultiPixelPackedSampleModel mpp = (MultiPixelPackedSampleModel)sm;
                        lineStride = mpp.getScanlineStride();
                        eltOffset = dataBuffer.getOffset() + mpp.getOffset(dx, dy);
                        bitOffset = mpp.getBitOffset(dx);
                        b = 0;
                        if (bitOffset != 0) break block39;
                        if (!(dataBuffer instanceof DataBufferByte)) break block40;
                        byte[] data = ((DataBufferByte)dataBuffer).getData();
                        if (data == binaryDataArray) {
                            return;
                        }
                        int stride = (rectWidth + 7) / 8;
                        int offset = 0;
                        for (int y = 0; y < rectHeight; ++y) {
                            System.arraycopy(binaryDataArray, offset, data, eltOffset, stride);
                            offset += stride;
                            eltOffset += lineStride;
                        }
                        break block41;
                    }
                    if (!(dataBuffer instanceof DataBufferShort) && !(dataBuffer instanceof DataBufferUShort)) break block42;
                    short[] data = dataBuffer instanceof DataBufferShort ? ((DataBufferShort)dataBuffer).getData() : ((DataBufferUShort)dataBuffer).getData();
                    for (int y = 0; y < rectHeight; ++y) {
                        int xRemaining;
                        int i = eltOffset;
                        for (xRemaining = rectWidth; xRemaining > 8; xRemaining -= 16) {
                            data[i++] = (short)((binaryDataArray[b++] & 0xFF) << 8 | binaryDataArray[b++] & 0xFF);
                        }
                        if (xRemaining > 0) {
                            data[i++] = (short)((binaryDataArray[b++] & 0xFF) << 8);
                        }
                        eltOffset += lineStride;
                    }
                    break block41;
                }
                if (!(dataBuffer instanceof DataBufferInt)) break block41;
                int[] data = ((DataBufferInt)dataBuffer).getData();
                for (int y = 0; y < rectHeight; ++y) {
                    int xRemaining;
                    int i = eltOffset;
                    for (xRemaining = rectWidth; xRemaining > 24; xRemaining -= 32) {
                        data[i++] = (binaryDataArray[b++] & 0xFF) << 24 | (binaryDataArray[b++] & 0xFF) << 16 | (binaryDataArray[b++] & 0xFF) << 8 | binaryDataArray[b++] & 0xFF;
                    }
                    int shift = 24;
                    while (xRemaining > 0) {
                        int n = i;
                        data[n] = data[n] | (binaryDataArray[b++] & 0xFF) << shift;
                        shift -= 8;
                        xRemaining -= 8;
                    }
                    eltOffset += lineStride;
                }
                break block41;
            }
            int stride = (rectWidth + 7) / 8;
            int offset = 0;
            if (dataBuffer instanceof DataBufferByte) {
                byte[] data = ((DataBufferByte)dataBuffer).getData();
                if ((bitOffset & 7) == 0) {
                    for (int y = 0; y < rectHeight; ++y) {
                        System.arraycopy(binaryDataArray, offset, data, eltOffset, stride);
                        offset += stride;
                        eltOffset += lineStride;
                    }
                } else {
                    int rightShift = bitOffset & 7;
                    int leftShift = 8 - rightShift;
                    int leftShift8 = 8 + leftShift;
                    byte mask = (byte)(255 << leftShift);
                    byte mask1 = ~mask;
                    for (int y = 0; y < rectHeight; ++y) {
                        int i = eltOffset;
                        for (int xRemaining = rectWidth; xRemaining > 0; xRemaining -= 8) {
                            byte datum = binaryDataArray[b++];
                            if (xRemaining > leftShift8) {
                                data[i] = (byte)(data[i] & mask | (datum & 0xFF) >>> rightShift);
                                data[++i] = (byte)((datum & 0xFF) << leftShift);
                                continue;
                            }
                            if (xRemaining > leftShift) {
                                data[i] = (byte)(data[i] & mask | (datum & 0xFF) >>> rightShift);
                                data[++i] = (byte)(data[i] & mask1 | (datum & 0xFF) << leftShift);
                                continue;
                            }
                            int remainMask = (1 << leftShift - xRemaining) - 1;
                            data[i] = (byte)(data[i] & (mask | remainMask) | (datum & 0xFF) >>> rightShift & ~remainMask);
                        }
                        eltOffset += lineStride;
                    }
                }
            } else if (dataBuffer instanceof DataBufferShort || dataBuffer instanceof DataBufferUShort) {
                short[] data = dataBuffer instanceof DataBufferShort ? ((DataBufferShort)dataBuffer).getData() : ((DataBufferUShort)dataBuffer).getData();
                int rightShift = bitOffset & 7;
                int leftShift = 8 - rightShift;
                int leftShift16 = 16 + leftShift;
                short mask = (short)(~(255 << leftShift));
                short mask1 = (short)(65535 << leftShift);
                short mask2 = ~mask1;
                for (int y = 0; y < rectHeight; ++y) {
                    int bOffset = bitOffset;
                    int xRemaining = rectWidth;
                    int x = 0;
                    while (x < rectWidth) {
                        int i = eltOffset + (bOffset >> 4);
                        int mod = bOffset & 0xF;
                        int datum = binaryDataArray[b++] & 0xFF;
                        if (mod <= 8) {
                            if (xRemaining < 8) {
                                datum &= 255 << 8 - xRemaining;
                            }
                            data[i] = (short)(data[i] & mask | datum << leftShift);
                        } else if (xRemaining > leftShift16) {
                            data[i] = (short)(data[i] & mask1 | datum >>> rightShift & 0xFFFF);
                            data[++i] = (short)(datum << leftShift & 0xFFFF);
                        } else if (xRemaining > leftShift) {
                            data[i] = (short)(data[i] & mask1 | datum >>> rightShift & 0xFFFF);
                            data[++i] = (short)(data[i] & mask2 | datum << leftShift & 0xFFFF);
                        } else {
                            int remainMask = (1 << leftShift - xRemaining) - 1;
                            data[i] = (short)(data[i] & (mask1 | remainMask) | datum >>> rightShift & 0xFFFF & ~remainMask);
                        }
                        x += 8;
                        bOffset += 8;
                        xRemaining -= 8;
                    }
                    eltOffset += lineStride;
                }
            } else if (dataBuffer instanceof DataBufferInt) {
                int[] data = ((DataBufferInt)dataBuffer).getData();
                int rightShift = bitOffset & 7;
                int leftShift = 8 - rightShift;
                int leftShift32 = 32 + leftShift;
                int mask = -1 << leftShift;
                int mask1 = ~mask;
                for (int y = 0; y < rectHeight; ++y) {
                    int bOffset = bitOffset;
                    int xRemaining = rectWidth;
                    int x = 0;
                    while (x < rectWidth) {
                        int i = eltOffset + (bOffset >> 5);
                        int mod = bOffset & 0x1F;
                        int datum = binaryDataArray[b++] & 0xFF;
                        if (mod <= 24) {
                            int shift = 24 - mod;
                            if (xRemaining < 8) {
                                datum &= 255 << 8 - xRemaining;
                            }
                            data[i] = data[i] & ~(255 << shift) | datum << shift;
                        } else if (xRemaining > leftShift32) {
                            data[i] = data[i] & mask | datum >>> rightShift;
                            data[++i] = datum << leftShift;
                        } else if (xRemaining > leftShift) {
                            data[i] = data[i] & mask | datum >>> rightShift;
                            data[++i] = data[i] & mask1 | datum << leftShift;
                        } else {
                            int remainMask = (1 << leftShift - xRemaining) - 1;
                            data[i] = data[i] & (mask | remainMask) | datum >>> rightShift & ~remainMask;
                        }
                        x += 8;
                        bOffset += 8;
                        xRemaining -= 8;
                    }
                    eltOffset += lineStride;
                }
            }
        }
    }

    public static void setUnpackedBinaryData(byte[] bdata, WritableRaster raster, Rectangle rect) {
        block11: {
            int k;
            int bitOffset;
            int eltOffset;
            int lineStride;
            DataBuffer dataBuffer;
            int rectHeight;
            int rectWidth;
            block12: {
                block10: {
                    SampleModel sm = raster.getSampleModel();
                    if (!ImageConversion.isBinary(sm)) {
                        throw new IllegalArgumentException("Not a binary raster!");
                    }
                    int rectX = rect.x;
                    int rectY = rect.y;
                    rectWidth = rect.width;
                    rectHeight = rect.height;
                    dataBuffer = raster.getDataBuffer();
                    int dx = rectX - raster.getSampleModelTranslateX();
                    int dy = rectY - raster.getSampleModelTranslateY();
                    MultiPixelPackedSampleModel mpp = (MultiPixelPackedSampleModel)sm;
                    lineStride = mpp.getScanlineStride();
                    eltOffset = dataBuffer.getOffset() + mpp.getOffset(dx, dy);
                    bitOffset = mpp.getBitOffset(dx);
                    k = 0;
                    if (!(dataBuffer instanceof DataBufferByte)) break block10;
                    byte[] data = ((DataBufferByte)dataBuffer).getData();
                    for (int y = 0; y < rectHeight; ++y) {
                        int bOffset = eltOffset * 8 + bitOffset;
                        for (int x = 0; x < rectWidth; ++x) {
                            if (bdata[k++] != 0) {
                                int n = bOffset / 8;
                                data[n] = (byte)(data[n] | (byte)(1 << (7 - bOffset & 7)));
                            }
                            ++bOffset;
                        }
                        eltOffset += lineStride;
                    }
                    break block11;
                }
                if (!(dataBuffer instanceof DataBufferShort) && !(dataBuffer instanceof DataBufferUShort)) break block12;
                short[] data = dataBuffer instanceof DataBufferShort ? ((DataBufferShort)dataBuffer).getData() : ((DataBufferUShort)dataBuffer).getData();
                for (int y = 0; y < rectHeight; ++y) {
                    int bOffset = eltOffset * 16 + bitOffset;
                    for (int x = 0; x < rectWidth; ++x) {
                        if (bdata[k++] != 0) {
                            int n = bOffset / 16;
                            data[n] = (short)(data[n] | (short)(1 << 15 - bOffset % 16));
                        }
                        ++bOffset;
                    }
                    eltOffset += lineStride;
                }
                break block11;
            }
            if (!(dataBuffer instanceof DataBufferInt)) break block11;
            int[] data = ((DataBufferInt)dataBuffer).getData();
            for (int y = 0; y < rectHeight; ++y) {
                int bOffset = eltOffset * 32 + bitOffset;
                for (int x = 0; x < rectWidth; ++x) {
                    if (bdata[k++] != 0) {
                        int n = bOffset / 32;
                        data[n] = data[n] | 1 << 31 - bOffset % 32;
                    }
                    ++bOffset;
                }
                eltOffset += lineStride;
            }
        }
    }

    public static RenderedImage fixSignedShortDataBuffer(RenderedImage source) {
        Raster raster;
        if (null != source && source.getSampleModel().getDataType() == 1 && (raster = source.getData()).getDataBuffer() instanceof DataBufferUShort) {
            short[] s = ((DataBufferUShort)raster.getDataBuffer()).getData();
            DataBufferShort db = new DataBufferShort(s, s.length);
            ColorModel cm = source.getColorModel();
            WritableRaster wr = Raster.createWritableRaster(source.getSampleModel(), db, null);
            return new BufferedImage(cm, wr, cm.isAlphaPremultiplied(), null);
        }
        return source;
    }

    public static BufferedImage convertRenderedImage(RenderedImage img) {
        if (null == img) {
            return null;
        }
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        ColorModel cm = img.getColorModel();
        int width = img.getWidth();
        int height = img.getHeight();
        WritableRaster raster = cm.createCompatibleWritableRaster(width, height);
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        String[] keys = img.getPropertyNames();
        if (null != keys) {
            for (int i = 0; i < keys.length; ++i) {
                properties.put(keys[i], img.getProperty(keys[i]));
            }
        }
        BufferedImage result = new BufferedImage(cm, raster, isAlphaPremultiplied, properties);
        img.copyData(raster);
        return result;
    }
}

